/*****************************************************************************
 *
 * File ..................: mbftpd/logwtmp.c
 * Purpose ...............: MBSE BBS Ftp Daemon
 * Last modification date : 21-Feb-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include <utmp.h>
#include "../config.h"
#include "../lib/libs.h"
#include "../lib/clcomm.h"
#include "logwtmp.h"


/* Copyright (c) 1988 The Regents of the University of California. All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution. 3. All advertising
 * materials mentioning features or use of this software must display the
 * following acknowledgement: This product includes software developed by the
 * University of California, Berkeley and its contributors. 4. Neither the
 * name of the University nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


static int fd = -1;

/*
 *  Modified version of logwtmp that holds wtmp file open after first call,
 *  for use with ftp (which may chroot after login, but before logout).
 */
void Logwtmp(char *line, char *name, char *host)
{
	struct utmp	ut;
	struct stat	buf;
	time_t		time(time_t *);

	if (fd < 0 && (fd = open(_PATH_WTMP, O_WRONLY | O_APPEND, 0)) < 0) {
		WriteError("wtmp %s %m", _PATH_WTMP);
		return;
	}

	if (fstat(fd, &buf) == 0) {
		memset((void *)&ut, 0, sizeof(ut));

		(void) strncpy(ut.ut_user, name, sizeof(ut.ut_user));
		(void) strncpy(ut.ut_id, "ftp", sizeof(ut.ut_id));
		(void) strncpy(ut.ut_line, line, sizeof(ut.ut_line));
		ut.ut_pid = getpid();
		if (name && *name)
			ut.ut_type = USER_PROCESS;
		else
			ut.ut_type = DEAD_PROCESS;
		(void) strncpy(ut.ut_host, host, sizeof(ut.ut_host));
		(void) time(&ut.ut_time);

		if (write(fd, (char *) &ut, sizeof(struct utmp)) != sizeof(struct utmp))
			(void) ftruncate(fd, buf.st_size);
	}
}


