/*****************************************************************************
 *
 * File ..................: mbftpd/ftpcmd.y
 * Purpose ...............: MBSE BBS Ftp Daemon
 * Last modification date : 10-Sep-2000
 * Original author .......: See copyright below
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/
/*
 * Copyright (c) 1985, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)ftpcmd.y	5.23 (Berkeley) 6/1/90
 */

/*
 * Grammar for FTP commands.
 * See RFC 959.
 */

%{

#include "../config.h"
#include "../lib/libs.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/clcomm.h"
#include "ftw.h"
#include "extensions.h"
#include "ftpd.h"
#include "ftpcmd.h"
#include "glob.h"

#ifndef NBBY
#define	NBBY 8
#endif


extern	struct tab sitetab[], cmdtab[];
extern	struct sockaddr_in data_dest;
extern	int logged_in;
extern	struct passwd *pw;
extern	int anonymous;
extern	int logging;
extern	int type;
extern	int form;
extern	int debug;
extern	int timeout;
extern	int maxtimeout;
extern  int pdata;
extern	char hostname[], remotehost[];
extern	char proctitle[];
extern	char *globerr;
extern	int usedefault;
extern  int transflag;
extern  char tmpline[];
extern	int data;
off_t	restart_point;

extern	char	*strunames[];
extern	char	*typenames[];
extern	char	*modenames[];
extern	char	*formnames[];

static	int cmd_type;
static	int cmd_form;
static	int cmd_bytesz;
char	cbuf[512];
char	*fromname;

%}

%token
	A	B	C	E	F	I
	L	N	P	R	S	T

	SP	CRLF	COMMA	STRING	NUMBER

	USER	PASS	ACCT	REIN	QUIT	PORT
	PASV	TYPE	STRU	MODE	RETR	STOR
	APPE	MLFL	MAIL	MSND	MSOM	MSAM
	MRSQ	MRCP	ALLO	REST	RNFR	RNTO
	ABOR	DELE	CWD		LIST	NLST	SITE
	STAT	HELP	NOOP	MKD		RMD		PWD
	CDUP	STOU	SMNT	SYST	SIZE	MDTM

	UMASK	IDLE	CHMOD	GROUP	GPASS	NEWER
	MINFO

	LEXERR

%union {
    char	*String;
    int		Number;
}

%type <String>	STRING password pathname pathstring username
%type <Number>	NUMBER byte_size check_login form_code mode_code octal_number
%type <Number>	struct_code

%start	cmd_list

%%

cmd_list:	/* empty */
	|	cmd_list cmd
		= {
			fromname = 0;
			restart_point = 0;
		}
	|	cmd_list rcmd
	;

cmd:		USER SP username CRLF
		= {
			user($3);
			if (CFG.ftp_log_cmds)
				Syslog('+', "USER %s", $3);
			free($3);
		}
	|	PASS SP password CRLF
		= {
			if (CFG.ftp_log_cmds) {
				if (anonymous)
					Syslog('+', "PASS %s", $3);
				else
					Syslog('+', "PASS password");
			}

			pass($3);
			free($3);
		}
	|	PORT SP host_port CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "PORT");
			usedefault = 0;
			if (pdata >= 0) {
				(void) close(pdata);
				pdata = -1;
			}
			reply(200, "PORT command successful.");
		}
	|	PASV CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "PASV");
			passive();
		}
	|	TYPE SP type_code CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "TYPE %s", typenames[cmd_type]);
			switch (cmd_type) {

			case TYPE_A:
				if (cmd_form == FORM_N) {
					reply(200, "Type set to A.");
					type = cmd_type;
					form = cmd_form;
				} else
					reply(504, "Form must be N.");
				break;

			case TYPE_E:
				reply(504, "Type E not implemented.");
				break;

			case TYPE_I:
				reply(200, "Type set to I.");
				type = cmd_type;
				break;

			case TYPE_L:
#if NBBY == 8
				if (cmd_bytesz == 8) {
					reply(200,
					    "Type set to L (byte size 8).");
					type = cmd_type;
				} else
					reply(504, "Byte size must be 8.");
#else /* NBBY == 8 */
				UNIMPLEMENTED for NBBY != 8
#endif /* NBBY == 8 */
			}
		}
	|	STRU SP struct_code CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "STRU %s", strunames[$3]);
			switch ($3) {

			case STRU_F:
				reply(200, "STRU F ok.");
				break;

			default:
				reply(504, "Unimplemented STRU type.");
			}
		}
	|	MODE SP mode_code CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "MODE %s", modenames[$3]);
			switch ($3) {

			case MODE_S:
				reply(200, "MODE S ok.");
				break;

			default:
				reply(502, "Unimplemented MODE type.");
			}
		}
	|	ALLO SP NUMBER CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "ALLO %d", $3);
			reply(202, "ALLO command ignored.");
		}
	|	ALLO SP NUMBER SP R SP NUMBER CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "ALLO %d R %d", $3, $7);
			reply(202, "ALLO command ignored.");
		}
	|	RETR check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "RETR %s", $4);
			if ($2 && $4 != NULL)
				retrieve((char *) NULL, $4);
			if ($4 != NULL)
				free($4);
		}
	|	STOR check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "STOR %s", $4);
			if ($2 && $4 != NULL)
				store($4, (char *)"w", 0);
			if ($4 != NULL)
				free($4);
		}
	|	APPE check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "APPE %s", $4);
			if ($2 && $4 != NULL)
				store($4, (char *)"a", 0);
			if ($4 != NULL)
				free($4);
		}
	|	NLST check_login CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "NLST");
			if ($2)
				send_file_list((char *)".");
		}
	|	NLST check_login SP STRING CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "NLST %s", $4);
			if ($2 && $4) {
				send_file_list($4);
				free($4);
			}
		}
	|	LIST check_login CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "LIST");
			if ($2)
				retrieve((char *)"/bin/ls -lgA", (char *)"");
		}
	|	LIST check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "LIST %s", $4);
			if ($2 && $4 != NULL)
				retrieve((char *)"/bin/ls -lgA %s", $4);
			if ($4 != NULL)
				free($4);
		}
	|	STAT check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "STAT %s", $4);
			if ($2 && $4 != NULL)
				statfilecmd($4);
			if ($4 != NULL)
				free($4);
		}
	|	STAT CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "STAT");
			statcmd();
		}
	|	DELE check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "DELE %s", $4);
			if ($2 && $4 != NULL)
				delete($4);
			if ($4 != NULL)
				free($4);
		}
	|	RNTO SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "RNTO %s", $3);
			if (fromname) {
				renamecmd(fromname, $3);
				free(fromname);
				fromname = (char *) NULL;
			} else {
				reply(503, "Bad sequence of commands.");
			}
			free($3);
		}
	|	ABOR CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "ABOR");
			reply(225, "ABOR command successful.");
		}
	|	CWD check_login CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "CWD");
			if ($2)
				cwd(pw->pw_dir);
		}
	|	CWD check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "CWD %s", $4);
			if ($2 && $4 != NULL)
				cwd($4);
			if ($4 != NULL)
				free($4);
		}
	|	HELP CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "HELP");
			help(cmdtab, (char *) NULL);
		}
	|	HELP SP STRING CRLF
		= {
			register char *cp = (char *)$3;

			if (CFG.ftp_log_cmds)
				Syslog('+', "HELP %s", $3);
			if (strncasecmp(cp, "SITE", 4) == 0) {
				cp = (char *)$3 + 4;
				if (*cp == ' ')
					cp++;
				if (*cp)
					help(sitetab, cp);
				else
					help(sitetab, (char *) NULL);
			} else
				help(cmdtab, $3);
		}
	|	NOOP CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "NOOP");
			reply(200, "NOOP command successful.");
		}
	|	MKD check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "MKD %s", $4);
			if ($2 && $4 != NULL)
				makedir($4);
			if ($4 != NULL)
				free($4);
		}
	|	RMD check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "RMD %s", $4);
			if ($2 && $4 != NULL)
				removedir($4);
			if ($4 != NULL)
				free($4);
		}
	|	PWD check_login CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "PWD");
			if ($2)
				pwd();
		}
	|	CDUP check_login CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "CDUP");
			if ($2)
				cwd((char *)"..");
		}
	|	SITE SP HELP CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE HELP");
			help(sitetab, (char *)NULL);
		}
	|	SITE SP HELP SP STRING CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE HELP %s", $5);
			help(sitetab, $5);
		}
	|	SITE SP UMASK check_login CRLF
		= {
			int oldmask;

			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE UMASK");
			if ($4) {
				oldmask = umask(0);
				(void) umask(oldmask);
				reply(200, "Current UMASK is %03o", oldmask);
			}
		}
	|	SITE SP UMASK check_login SP octal_number CRLF
		= {
			int oldmask;

			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE UMASK %d", $6);
			if ($4) {
				if (($6 == -1) || ($6 > 0777)) {
					reply(501, "Bad UMASK value");
				} else {
					oldmask = umask($6);
					reply(200, "UMASK set to %03o (was %03o)", $6, oldmask);
				}
			}
		}
	|	SITE SP CHMOD check_login SP octal_number SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE CHMOD %s %s", $6, $8);
			if ($4 && $6 && $8) {
				if ($6 > 0777)
					reply(501, "CHMOD: Mode value must be between 0 and 0777");
				else if (chmod($8, $6) < 0)
					perror_reply(550, $8);
				else
					reply(200, "CHMOD command successful.");
				free($8);
			}
		}
	|	SITE SP IDLE CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE IDLE");
			reply(200, "Current IDLE time limit is %d seconds; max %d", timeout, maxtimeout);
		}
	|	SITE SP IDLE SP NUMBER CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SITE IDLE %d", $5);
			if ($5 < 30 || $5 > maxtimeout) {
				reply(501, "Maximum IDLE time must be between 30 and %d seconds", maxtimeout);
			} else {
				timeout = $5;
				(void) alarm((unsigned) timeout);
				Altime(timeout + 60);
				reply(200, "Maximum IDLE time set to %d seconds", timeout);
			}
		}
/*	|	SITE SP GROUP check_login SP username CRLF
		= {
			Syslog('f', "SITE GROUP %s", $6);
			if ($4 && $6) priv_group($6);
			free($6);
		}
	|	SITE SP GPASS check_login SP password CRLF
		= {
			Syslog('f', "SITE GPASS password");
			if ($4 && $6) priv_gpass($6);
			free($6);
		}  
*/
	|	SITE SP NEWER check_login SP STRING CRLF
		= {
			if ($4 && $6) newer($6, (char *)".", 0);
			free($6);
		}
	|	SITE SP NEWER check_login SP STRING SP pathname CRLF
		= {
			if ($4 && $6 && $8) newer($6, $8, 0);
			free($6);
			free($8);
		}
	|	SITE SP MINFO check_login SP STRING SP pathname CRLF
		= {
			if ($4 && $6 && $8) newer($6, $8, 1);
			free($6);
			free($8);
		}
	|	STOU check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "STOU %s", $4);
			if ($2 && $4) {
				store($4, (char *)"w", 1);
				free($4);
			}
		}
	|	SYST CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SYST");
#ifdef unix
			reply(215, "UNIX Type: L%d", NBBY);
#else /* unix */
			reply(215, "UNKNOWN Type: L%d", NBBY);
#endif /* unix */
		}

		/*
		 * SIZE is not in RFC959, but Postel has blessed it and
		 * it will be in the updated RFC.
		 *
		 * Return size of file in a format suitable for
		 * using with RESTART (we just count bytes).
		 */
	|	SIZE check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "SIZE %s", $4);
			if ($2 && $4) {
				sizecmd($4);
				free($4);
			}
		}

		/*
		 * MDTM is not in RFC959, but Postel has blessed it and
		 * it will be in the updated RFC.
		 *
		 * Return modification time of file as an ISO 3307
		 * style time. E.g. YYYYMMDDHHMMSS or YYYYMMDDHHMMSS.xxx
		 * where xxx is the fractional second (of any precision,
		 * not necessarily 3 digits)
		 */
	|	MDTM check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "MDTM %s", $4);
			if ($2 && $4) {
				struct stat stbuf;

				if (stat($4, &stbuf) < 0)
					perror_reply(550, $4);
				else if ((stbuf.st_mode&S_IFMT) != S_IFREG) {
					reply(550, "%s: not a plain file.", $4);
				} else {
					register struct tm *t;
					t = gmtime(&stbuf.st_mtime);
					reply(213, "%04d%02d%02d%02d%02d%02d",
					    t->tm_year+1900, t->tm_mon+1, t->tm_mday,
					    t->tm_hour, t->tm_min, t->tm_sec);
				}
				free($4);
			}
		}
	|	QUIT CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "QUIT");
			reply(221, "Goodbye.");
			die(0);
		}
	|	error CRLF
		= {
			yyerrok;
		}
	;
rcmd:		RNFR check_login SP pathname CRLF
		= {
			if (CFG.ftp_log_cmds)
				Syslog('+', "RNFR %s", $4);
			restart_point = (off_t) 0;
			if ($2 && $4) {
				fromname = renamefrom($4);
				if (fromname == 0 && $4) {
					free($4);
				}
			}
		}
	|	REST SP byte_size CRLF
		= {
			fromname = 0;
			restart_point = $3;
			if (CFG.ftp_log_cmds)
				Syslog('+', "REST %d", restart_point);
			reply(350, "Restarting at %ld. Send STORE or RETRIEVE to initiate transfer.", restart_point);
		}
	;
		
username:	STRING
	;

password:	/* empty */
		= {
			$$ = malloc(1);
			$$[0] = '\0';
		}
	|	STRING
	;

byte_size:	NUMBER
	;

host_port:	NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA 
		NUMBER COMMA NUMBER
		= {
			register char *a, *p;

			a = (char *)&data_dest.sin_addr;
			a[0] = $1; a[1] = $3; a[2] = $5; a[3] = $7;
			p = (char *)&data_dest.sin_port;
			p[0] = $9; p[1] = $11;
			data_dest.sin_family = AF_INET;
		}
	;

form_code:	N
	= {
		$$ = FORM_N;
	}
	|	T
	= {
		$$ = FORM_T;
	}
	|	C
	= {
		$$ = FORM_C;
	}
	;

type_code:	A
	= {
		cmd_type = TYPE_A;
		cmd_form = FORM_N;
	}
	|	A SP form_code
	= {
		cmd_type = TYPE_A;
		cmd_form = $3;
	}
	|	E
	= {
		cmd_type = TYPE_E;
		cmd_form = FORM_N;
	}
	|	E SP form_code
	= {
		cmd_type = TYPE_E;
		cmd_form = $3;
	}
	|	I
	= {
		cmd_type = TYPE_I;
	}
	|	L
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = NBBY;
	}
	|	L SP byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = $3;
	}
	/* this is for a bug in the BBN ftp */
	|	L byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = $2;
	}
	;

struct_code:	F
	= {
		$$ = STRU_F;
	}
	|	R
	= {
		$$ = STRU_R;
	}
	|	P
	= {
		$$ = STRU_P;
	}
	;

mode_code:	S
	= {
		$$ = MODE_S;
	}
	|	B
	= {
		$$ = MODE_B;
	}
	|	C
	= {
		$$ = MODE_C;
	}
	;

pathname:	pathstring
	= {
		/*
		 * Problem: this production is used for all pathname
		 * processing, but only gives a 550 error reply.
		 * This is a valid reply in some cases but not in others.
		 */
		if (logged_in && $1 && strncmp($1, "~", 1) == 0) {
			$$ = *glob($1);
			if (globerr) {
				reply(550, globerr);
				$$ = NULL;
			}
			free($1);
		} else
			$$ = $1;
	}
	;

pathstring:	STRING
	;

octal_number:	NUMBER
	= {
		register int ret, dec, multby, digit;

		/*
		 * Convert a number that was read as decimal number
		 * to what it would be if it had been read as octal.
		 */
		dec = $1;
		multby = 1;
		ret = 0;
		while (dec) {
			digit = dec%10;
			if (digit > 7) {
				ret = -1;
				break;
			}
			ret += digit * multby;
			multby *= 8;
			dec /= 10;
		}
		$$ = ret;
	}
	;

check_login:	/* empty */
	= {
		if (logged_in) {
			$$ = 1;
		} else {
			if (CFG.ftp_log_cmds)
				Syslog('+', "cmd failure - not logged in");
			reply(530, "Please login with USER and PASS.");
			$$ = 0;
		}
	}
	;

%%

extern jmp_buf errcatch;

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING */
#define	OSTR	4	/* optional SP then STRING */
#define	ZSTR1	5	/* SP then optional STRING */
#define	ZSTR2	6	/* optional STRING after SP */
#define	SITECMD	7	/* SITE command */
#define	NSTR	8	/* Number followed by a string */
#define	STR3	9	/* expect STRING followed by optional SP then STRING */

struct tab {
	char	*name;
	short	token;
	short	state;
 	short	implemented;	/* 1 if command is implemented */
	char	*help;
};

struct tab cmdtab[] = {		/* In order defined in RFC 765 */
	{ (char *)"USER", USER, STR1, 1,	(char *)"<sp> username" },
	{ (char *)"PASS", PASS, ZSTR1, 1,	(char *)"<sp> password" },
	{ (char *)"ACCT", ACCT, STR1, 0,	(char *)"(specify account)" },
	{ (char *)"SMNT", SMNT, ARGS, 0,	(char *)"(structure mount)" },
	{ (char *)"REIN", REIN, ARGS, 0,	(char *)"(reinitialize server state)" },
	{ (char *)"QUIT", QUIT, ARGS, 1,	(char *)"(terminate service)", },
	{ (char *)"PORT", PORT, ARGS, 1,	(char *)"<sp> b0, b1, b2, b3, b4" },
	{ (char *)"PASV", PASV, ARGS, 1,	(char *)"(set server in passive mode)" },
	{ (char *)"TYPE", TYPE, ARGS, 1,	(char *)"<sp> [ A | E | I | L ]" },
	{ (char *)"STRU", STRU, ARGS, 1,	(char *)"(specify file structure)" },
	{ (char *)"MODE", MODE, ARGS, 1,	(char *)"(specify transfer mode)" },
	{ (char *)"RETR", RETR, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"STOR", STOR, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"APPE", APPE, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"MLFL", MLFL, OSTR, 0,	(char *)"(mail file)" },
	{ (char *)"MAIL", MAIL, OSTR, 0,	(char *)"(mail to user)" },
	{ (char *)"MSND", MSND, OSTR, 0,	(char *)"(mail send to terminal)" },
	{ (char *)"MSOM", MSOM, OSTR, 0,	(char *)"(mail send to terminal or mailbox)" },
	{ (char *)"MSAM", MSAM, OSTR, 0,	(char *)"(mail send to terminal and mailbox)" },
	{ (char *)"MRSQ", MRSQ, OSTR, 0,	(char *)"(mail recipient scheme question)" },
	{ (char *)"MRCP", MRCP, STR1, 0,	(char *)"(mail recipient)" },
	{ (char *)"ALLO", ALLO, ARGS, 1,	(char *)"allocate storage (vacuously)" },
	{ (char *)"REST", REST, ARGS, 1,	(char *)"(restart command)" },
	{ (char *)"RNFR", RNFR, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"RNTO", RNTO, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"ABOR", ABOR, ARGS, 1,	(char *)"(abort operation)" },
	{ (char *)"DELE", DELE, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"CWD",  CWD,  OSTR, 1,	(char *)"[ <sp> directory-name ]" },
	{ (char *)"XCWD", CWD,	OSTR, 1,	(char *)"[ <sp> directory-name ]" },
	{ (char *)"LIST", LIST, OSTR, 1,	(char *)"[ <sp> path-name ]" },
	{ (char *)"NLST", NLST, OSTR, 1,	(char *)"[ <sp> path-name ]" },
	{ (char *)"SITE", SITE, SITECMD, 1,	(char *)"site-cmd [ <sp> arguments ]" },
	{ (char *)"SYST", SYST, ARGS, 1,	(char *)"(get type of operating system)" },
	{ (char *)"STAT", STAT, OSTR, 1,	(char *)"[ <sp> path-name ]" },
	{ (char *)"HELP", HELP, OSTR, 1,	(char *)"[ <sp> <string> ]" },
	{ (char *)"NOOP", NOOP, ARGS, 1,	(char *)"" },
	{ (char *)"MKD",  MKD,  STR1, 1,	(char *)"<sp> path-name" },
	{ (char *)"XMKD", MKD,  STR1, 1,	(char *)"<sp> path-name" },
	{ (char *)"RMD",  RMD,  STR1, 1,	(char *)"<sp> path-name" },
	{ (char *)"XRMD", RMD,  STR1, 1,	(char *)"<sp> path-name" },
	{ (char *)"PWD",  PWD,  ARGS, 1,	(char *)"(return current directory)" },
	{ (char *)"XPWD", PWD,  ARGS, 1,	(char *)"(return current directory)" },
	{ (char *)"CDUP", CDUP, ARGS, 1,	(char *)"(change to parent directory)" },
	{ (char *)"XCUP", CDUP, ARGS, 1,	(char *)"(change to parent directory)" },
	{ (char *)"STOU", STOU, STR1, 1,	(char *)"<sp> file-name" },
	{ (char *)"SIZE", SIZE, OSTR, 1,	(char *)"<sp> path-name" },
	{ (char *)"MDTM", MDTM, OSTR, 1,	(char *)"<sp> path-name" },
	{ NULL,   0,    0,    0,	0 }
};

struct tab sitetab[] = {
	{ (char *)"UMASK", UMASK, ARGS, 1,	(char *)"[ <sp> umask ]" },
	{ (char *)"IDLE", IDLE, ARGS, 1,	(char *)"[ <sp> maximum-idle-time ]" },
	{ (char *)"CHMOD", CHMOD, NSTR, 1,	(char *)"<sp> mode <sp> file-name" },
	{ (char *)"HELP", HELP, OSTR, 1,	(char *)"[ <sp> <string> ]" },
	{ (char *)"GROUP", GROUP, STR1, 1,	(char *)"<sp> access-group" },
	{ (char *)"GPASS", GPASS, STR1, 1,	(char *)"<sp> access-password" },
	{ (char *)"NEWER", NEWER, STR3, 1,	(char *)"<sp> YYYYMMDDHHMMSS [ <sp> path-name ]" },
	{ (char *)"MINFO", MINFO, STR3, 1,	(char *)"<sp> YYYYMMDDHHMMSS [ <sp> path-name ]" },
	{ NULL,   0,    0,    0,	0 }
};



struct tab *flookup(struct tab *p, char *cmd)
{
	for (; p->name != NULL; p++)
		if (strcmp(cmd, p->name) == 0)
			return (p);
	return (0);
}



#include <arpa/telnet.h>

/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */
char *Getline(char *s, int n, FILE *iop)
{
	int	c;
	char	*cs;

	cs = s;
	/*
	 * tmpline may contain saved command from urgent mode interruption
	 */
	for (c = 0; ((tmpline[c] != '\0') && --n) > 0; ++c) {
		*cs++ = tmpline[c];
		if (tmpline[c] == '\n') {
			*cs++ = '\0';
			tmpline[0] = '\0';
			return(s);
		}
		if (c == 0)
			tmpline[0] = '\0';
	}
	while ((c = getc(iop)) != EOF) {
		c &= 0377;
		if (c == IAC) {
		    if ((c = getc(iop)) != EOF) {
			c &= 0377;
			switch (c) {
			case WILL:
			case WONT:
				c = getc(iop);
				printf("%c%c%c", IAC, DONT, 0377&c);
				(void) fflush(stdout);
				continue;
			case DO:
			case DONT:
				c = getc(iop);
				printf("%c%c%c", IAC, WONT, 0377&c);
				(void) fflush(stdout);
				continue;
			case IAC:
				break;
			default:
				continue;	/* ignore command */
			}
		    }
		}
		*cs++ = c;
		if (--n <= 0 || c == '\n')
			break;
	}
	if (c == EOF && cs == s)
		return (NULL);
	*cs++ = '\0';
	return (s);
}



void toolong()
{
	time_t	now;

	reply(421, "Timeout (%d seconds): closing control connection.", timeout);
	(void)time(&now);
	Syslog('+', "User %s timed out after %d seconds", (pw ? pw -> pw_name : "unknown"), timeout);
	die(0);
}



int yylex()
{
	static int	cpos, state;
	register char	*cp, *cp2;
	register struct	tab *p;
	int		n;
	char		c = 0;

	for (;;) {
		switch (state) {

		case CMD:
			signal(SIGALRM, (void (*))toolong);
			(void)alarm((unsigned) timeout);
			Altime(timeout + 60);
			if (is_shutdown() != 0) {
				reply(221, "Server shutting down.");
				die(0);
			}
			if (Getline(cbuf, sizeof(cbuf)-1, stdin) == NULL) {
				reply(221, "You could at least say goodbye.");
				die(0);
			}
			(void) alarm(0);
			Nopper();
#ifdef SETPROCTITLE
			if (strncasecmp(cbuf, "PASS", 4) != 0 &&
				strncasecmp(cbuf, "GPASS", 5) != 0)
				setproctitle("%s: %s", proctitle, cbuf);
#endif /* SETPROCTITLE */
			if ((cp = strchr(cbuf, '\r'))) {
				*cp++ = '\n';
				*cp = '\0';
			}
			if ((cp = strpbrk(cbuf, " \n")))
				cpos = cp - cbuf;
			if (cpos == 0)
				cpos = 4;
			c = cbuf[cpos];
			cbuf[cpos] = '\0';
			upper(cbuf);
			p = flookup(cmdtab, cbuf);
			cbuf[cpos] = c;
			if (p != 0) {
				if (p->implemented == 0) {
					nack(p->name);
					longjmp(errcatch,0);
					/* NOTREACHED */
				}
				state = p->state;
				yylval.String = p->name;
				return (p->token);
			}
			break;

		case SITECMD:
			if (cbuf[cpos] == ' ') {
				cpos++;
				return (SP);
			}
			cp = &cbuf[cpos];
			if ((cp2 = strpbrk(cp, " \n")))
				cpos = cp2 - cbuf;
			c = cbuf[cpos];
			cbuf[cpos] = '\0';
			upper(cp);
			p = flookup(sitetab, cp);
			cbuf[cpos] = c;
			if (p != 0) {
				if (p->implemented == 0) {
					state = CMD;
					nack(p->name);
					longjmp(errcatch,0);
					/* NOTREACHED */
				}
				state = p->state;
				yylval.String = p->name;
				return (p->token);
			}
			state = CMD;
			break;

		case OSTR:
			if (cbuf[cpos] == '\n') {
				state = CMD;
				return (CRLF);
			}
			/* FALLTHROUGH */

		case STR1:
		case ZSTR1:
		dostr1:
			if (cbuf[cpos] == ' ') {
				cpos++;
				state = state == OSTR ? STR2 : ++state;
				return (SP);
			}
			break;

		case ZSTR2:
			if (cbuf[cpos] == '\n') {
				state = CMD;
				return (CRLF);
			}
			/* FALLTHROUGH */

		case STR2:
			cp = &cbuf[cpos];
			n = strlen(cp);
			cpos += n - 1;
			/*
			 * Make sure the string is nonempty and \n terminated.
			 */
			if (n > 1 && cbuf[cpos] == '\n') {
				cbuf[cpos] = '\0';
				yylval.String = copy(cp);
				cbuf[cpos] = '\n';
				state = ARGS;
				return (STRING);
			}
			break;

		case NSTR:
			if (cbuf[cpos] == ' ') {
				cpos++;
				return (SP);
			}
			if (isdigit(cbuf[cpos])) {
				cp = &cbuf[cpos];
				while (isdigit(cbuf[++cpos]))
					;
				c = cbuf[cpos];
				cbuf[cpos] = '\0';
				yylval.Number = atoi(cp);
				cbuf[cpos] = c;
				state = STR1;
				return (NUMBER);
			}
			state = STR1;
			goto dostr1;

		case STR3:
			if (cbuf[cpos] == ' ') {
				cpos++;
				return (SP);
			}

			cp = &cbuf[cpos];
			cp2 = strpbrk(cp, " \n");
			if (cp2 != NULL) {
				c = *cp2;
				*cp2 = '\0';
			}
			n = strlen(cp);
			cpos += n;
			/*
			 * Make sure the string is nonempty and SP terminated.
			 */
			if ((cp2 - cp) > 1) {
				yylval.String = copy(cp);
				cbuf[cpos] = c;
				state = OSTR;
				return (STRING);
			}
			break;

		case ARGS:
			if (isdigit(cbuf[cpos])) {
				cp = &cbuf[cpos];
				while (isdigit(cbuf[++cpos]))
					;
				c = cbuf[cpos];
				cbuf[cpos] = '\0';
				yylval.Number = atoi(cp);
				cbuf[cpos] = c;
				return (NUMBER);
			}
			switch (cbuf[cpos++]) {

			case '\n':
				state = CMD;
				return (CRLF);

			case ' ':
				return (SP);

			case ',':
				return (COMMA);

			case 'A':
			case 'a':
				return (A);

			case 'B':
			case 'b':
				return (B);

			case 'C':
			case 'c':
				return (C);

			case 'E':
			case 'e':
				return (E);

			case 'F':
			case 'f':
				return (F);

			case 'I':
			case 'i':
				return (I);

			case 'L':
			case 'l':
				return (L);

			case 'N':
			case 'n':
				return (N);

			case 'P':
			case 'p':
				return (P);

			case 'R':
			case 'r':
				return (R);

			case 'S':
			case 's':
				return (S);

			case 'T':
			case 't':
				return (T);

			}
			break;

		default:
			fatal((char *)"Unknown state in scanner.");
		}
		yyerror((char *)NULL);
		state = CMD;
		longjmp(errcatch,0);
	}
}



void upper(char *s)
{
	while (*s != '\0') {
		if (islower(*s))
			*s = toupper(*s);
		s++;
	}
}



char *copy(char *s)
{
	char *p;

	p = malloc((unsigned) strlen(s) + 1);
	if (p == NULL)
		fatal((char *)"Ran out of memory.");
	(void) strcpy(p, s);
	return (p);
}



void help(struct tab *ctab, char *s)
{
	struct tab	*c;
	int		width, NCMDS;
	char		*Type;

	if (ctab == sitetab)
		Type = (char *)"SITE ";
	else
		Type = (char *)"";
	width = 0, NCMDS = 0;
	for (c = ctab; c->name != NULL; c++) {
		int len = strlen(c->name);

		if (len > width)
			width = len;
		NCMDS++;
	}
	width = (width + 8) &~ 7;
	if (s == 0) {
		register int i, j, w;
		int columns, lines;

		lreply(214, "The following %scommands are recognized %s.", Type, "(* =>'s unimplemented)");
		columns = 76 / width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			printf("   ");
			for (j = 0; j < columns; j++) {
				c = ctab + j * lines + i;
				printf("%s%c", c->name, c->implemented ? ' ' : '*');
				if (c + lines >= &ctab[NCMDS])
					break;
				w = strlen(c->name) + 1;
				while (w < width) {
					putchar(' ');
					w++;
				}
			}
			printf("\r\n");
		}
		(void) fflush(stdout);
		reply(214, "Direct comments to %s@%s.", CFG.sysop, hostname);
		return;
	}
	upper(s);
	c = flookup(ctab, s);
	if (c == (struct tab *)NULL) {
		reply(502, "Unknown command %s.", s);
		return;
	}
	if (c->implemented)
		reply(214, "Syntax: %s%s %s", Type, c->name, c->help);
	else
		reply(214, "%s%-*s\t%s; unimplemented.", Type, width, c->name, c->help);
}



void sizecmd(char *filename)
{
	switch (type) {
	case TYPE_L:
	case TYPE_I: {
		struct stat stbuf;
		if (stat(filename, &stbuf) < 0 ||
		    (stbuf.st_mode&S_IFMT) != S_IFREG)
			reply(550, "%s: not a plain file.", filename);
		else
			reply(213, "%lu", stbuf.st_size);
		break;}
	case TYPE_A: {
		FILE *fin;
		register int c;
		register long count;
		struct stat stbuf;
		fin = fopen(filename, "r");
		if (fin == NULL) {
			perror_reply(550, filename);
			return;
		}
		if (fstat(fileno(fin), &stbuf) < 0 ||
		    (stbuf.st_mode&S_IFMT) != S_IFREG) {
			reply(550, "%s: not a plain file.", filename);
			(void) fclose(fin);
			return;
		}

		count = 0;
		while((c=getc(fin)) != EOF) {
			if (c == '\n')	/* will get expanded to \r\n */
				count++;
			count++;
		}
		(void) fclose(fin);

		reply(213, "%ld", count);
		break;}
	default:
		reply(504, "SIZE not implemented for Type %c.", "?AEIL"[type]);
	}
}


