/*****************************************************************************
 *
 * File ..................: mbftpd/extensions.c
 * Purpose ...............: MBSE BBS Ftp Daemon
 * Last modification date : 21-Feb-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../config.h"
#include "../lib/libs.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/clcomm.h"
#include "../lib/common.h"
#include "extensions.h"
#include "ftpd.h"
#include "ftw.h"
#include "access.h"
#include "glob.h"
#include "fnmatch.h"


extern	int	type,
		transflag,
		autospout_free,
		data;
extern	char	*globerr,
		remotehost[],
		hostname[],
		*autospout;

FILE		*dout;

time_t		newer_time;
int		show_fullinfo;


/*************************************************************************/
/* FUNCTION  : msg_massage                                               */
/* PURPOSE   : Scan a message line for magic cookies, replacing them as  */
/*             needed.                                                   */
/* ARGUMENTS : pointer input and output buffers                          */
/*************************************************************************/

void msg_massage(char *inbuf, char *outbuf)
{
	char		*inptr = inbuf;
	char		*outptr = outbuf;
	char		*dir = NULL;
	time_t		curtime;
	extern struct	passwd	*pw;
	struct statfs	sfs;

//	u RFC931 username
//	B absolute limit on disk blocks allocated
//	b preffered limit on disk blocks
//	Q current block count
//	I maximum number of allocated inodes (+1)
//	i preffered inode limit
//	q current number of allocated inodes

	while (*inptr) {
		if (*inptr != '%')
			*outptr++ = *inptr;
		else {
			switch (*++inptr) {
			case 'F':
				dir = calloc(PATH_MAX, sizeof(char));
				getcwd(dir, PATH_MAX);
				if (statfs(dir, &sfs) == 0)
					sprintf(outptr, "%lu", (sfs.f_bfree * sfs.f_bsize) / 1024L);
				else
					sprintf(outptr, "N/A");
				free(dir);
				dir = NULL;
				break;

			case 'E':
				sprintf(outptr, "%s", CFG.ftp_email);
				break;

			case 'M':
				sprintf(outptr, "%d", CFG.ftp_limit);
				break;

			case 'N':
				sprintf(outptr, "%d", acl_countusers());
				break;

			case 'T':
				(void)time(&curtime);
				strncpy(outptr, ctime(&curtime), 24);
				*(outptr + 24) = '\0';
				break;

			case 'C':
				(void)getcwd(outptr, PATH_MAX);
//				(void)getwd(outptr);
				break;

			case 'R':
				strcpy(outptr, remotehost);
				break;

			case 'L':
				strcpy(outptr, hostname);
				break;

			case 'U':
				strcpy(outptr, pw->pw_name);
				break;

			case '%':
				*outptr++ = '%';
				*outptr = '\0';
				break;

			default:
				*outptr++ = '%';
				*outptr++ = '?';
				*outptr = '\0';
				break;
			}
			while (*outptr) 
				outptr++;
		}
		inptr++;
	}

	*outptr = '\0';
}



/*************************************************************************/
/* FUNCTION  : cwd_beenhere                                              */
/* PURPOSE   : Return 1 if the user has already visited this directory   */
/*             via CWD.                                                  */
/* ARGUMENTS : a power-of-two directory function code (README, MESSAGE)  */
/*************************************************************************/

int cwd_beenhere(int dircode)
{
	struct	dirlist {
		struct dirlist	*next;
		int		dircode;
		char		dirname[1];
	};
	static struct	dirlist	*head = NULL;
	struct dirlist	*curptr;
	char		Cwd[MAXPATHLEN];

	(void) getcwd(Cwd, MAXPATHLEN);
	for (curptr = head; curptr != NULL; curptr = curptr->next)
		if (strcmp(curptr->dirname, Cwd) == 0) {
			if (!(curptr->dircode & dircode)) {
				curptr->dircode |= dircode;
				return(0);
			}
			return(1);
		}
   
	curptr = (struct dirlist *) malloc(strlen(Cwd)+1+sizeof(struct dirlist));

	if (curptr != NULL) {
		curptr->next = head;
		head = curptr;
		curptr->dircode = dircode;
		strcpy(curptr->dirname, Cwd);
	}

	return(0);
}



/*************************************************************************/
/* FUNCTION  : show_banner                                               */
/* PURPOSE   : Display a banner on the user's terminal before login      */
/* ARGUMENTS : reply code to use                                         */
/*************************************************************************/

void show_banner(int msgcode)
{
	char	*crptr, linebuf[1024], outbuf[1024];
	FILE	*infile;

	if (strlen(CFG.ftp_banner) > 0) {
		if ((infile = fopen(CFG.ftp_banner, "r")) != NULL) {
			while (fgets(linebuf, 255, infile) != NULL) {
				if ((crptr = strchr(linebuf, '\n')) != NULL) 
					*crptr = '\0';
				msg_massage(linebuf, outbuf);
				lreply(msgcode, "%s", outbuf);
			}
			fclose(infile);
			lreply(msgcode, "");
		}
	}
}



/*************************************************************************/
/* FUNCTION  : show_message                                              */
/* PURPOSE   : Display a message on the user's terminal if the current   */
/*             conditions are right                                      */
/* ARGUMENTS : reply code to use, LOGIN|CMD                              */
/*************************************************************************/

void show_message(int msgcode, int mode)
{
	char	*crptr, linebuf[1024], outbuf[1024], Cwd[MAXPATHLEN], filename[81];
	int	show;
	FILE	*infile;

	if (cwd_beenhere(1) != 0) 
		return;

	(void)getcwd(Cwd, MAXPATHLEN);
	show = 0;

	if (mode == E_LOGIN && strlen(CFG.ftp_msg_login)) {
		show++;
		sprintf(filename, "%s", CFG.ftp_msg_login);
	}
	if (mode == E_CWD && strlen(CFG.ftp_msg_cwd)) {
		show++;
		sprintf(filename, "%s", CFG.ftp_msg_cwd);
	}

	if (show) {
		if ((infile = fopen(filename, "r")) != NULL) {
			while (fgets(linebuf, 255, infile) != NULL) {
				if ((crptr = strchr(linebuf, '\n')) != NULL) 
					*crptr = '\0';
				msg_massage(linebuf, outbuf);
				lreply(msgcode, "%s", outbuf);
			}
			fclose(infile);
			lreply(msgcode, "");
		}
	}
}



/*************************************************************************/
/* FUNCTION  : show_readme                                               */
/* PURPOSE   : Display a message about a README file to the user if the  */
/*             current conditions are right                              */
/* ARGUMENTS : pointer to ACL buffer, reply code, LOGIN|CWD              */
/*************************************************************************/

void show_readme(int code, int mode)
{
	char		**filelist, Cwd[MAXPATHLEN], filemask[81];
	int		show, days;
	time_t		Clock;
	struct stat	buf;
	struct tm	*tp;

	if (cwd_beenhere(2) != 0) 
		return;

	(void)getcwd(Cwd, MAXPATHLEN);
	show = 0;

	if (mode == E_LOGIN && strlen(CFG.ftp_readme_login)) {
		show++;
		sprintf(filemask, "%s", CFG.ftp_readme_login);
	}
	if (mode == E_CWD && strlen(CFG.ftp_readme_cwd)) {
		show++;
		sprintf(filemask, "%s", CFG.ftp_readme_cwd);
	}

	if (show) {
		globerr = NULL;
		filelist = glob(filemask);
		if (!globerr) {
			while (filelist && *filelist) {
				errno = 0;
				if (!stat(*filelist, &buf)) {
					lreply(code, "Please read the file %s", *filelist);
					(void) time(&Clock);
					tp = localtime(&Clock);
					days = 365 * tp->tm_year + tp->tm_yday;
					tp = localtime(&buf.st_mtime);
					days -= 365 * tp->tm_year + tp->tm_yday;
					lreply(code, "  it was last modified on %.24s - %d days ago",
						ctime(&buf.st_mtime), days);
				}
				filelist++;
			}
		}
	}
}



/*************************************************************************/
/* FUNCTION  : deny_badxfertype                                          */
/* PURPOSE   : If user is in ASCII transfer mode and tries to retrieve a */
/*             binary file, abort transfer and display appropriate error */
/* ARGUMENTS : message code to use for denial, path of file to check for */
/*             binary contents or NULL to assume binary file             */
/*************************************************************************/

int deny_badasciixfer(int msgcode, char *filepath)
{
	if (type == TYPE_A && !*filepath) {
		reply(msgcode, "This is a BINARY file, using ASCII mode to transfer will corrupt it.");
		return(1);
	}
	/* 
	 * The hooks are here to prevent transfers of actual binary files, not
	 * just TAR or COMPRESS mode files...
	 */
	return(0);
}



/*************************************************************************/
/* FUNCTION  : is_shutdown                                               */
/* PURPOSE   : Check if MBSE BBS is open or closed.                      */
/* ARGUMENTS : None                                                      */
/*************************************************************************/

int is_shutdown()
{
	static char	text[2048];
	struct stat	s_cur;
	FILE		*fp;
	char		buf[1024], linebuf[1024];

	/*
	 * Check BBS open/closed status
	 */
	sprintf(buf, "SBBS:0;");
	if (socket_send(buf) == 0) {
		strcpy(buf, socket_receive());
		if (strncmp(buf, "100:2,1", 7))
			return 0;
	}

	/*
	 * Get default shutdown text
	 */
	buf[strlen(buf) -1] = '\0';
	sprintf(text, "*** %s *** \n", buf+8);

	/*
	 * If there is an extra shutdown message, display it.
	 */
	if (CFG.ftp_msg_shutmsg[0] != '\0' && !stat(CFG.ftp_msg_shutmsg, &s_cur)) {
		if ((fp = fopen(CFG.ftp_msg_shutmsg, "r")) != NULL) {
			while (fgets(buf, sizeof(buf), fp) != NULL) {
				msg_massage(buf, linebuf);
				if ((strlen(text) + strlen(linebuf)) < sizeof(text))
					strcat(text, linebuf);
			}
			(void)fclose(fp);
		}
	}

	autospout = text;
	autospout_free = 0;
	return 1;
}



void newer(char *date, char *path, int showlots)
{
	struct	tm tm;

	if (sscanf(date, "%04d%02d%02d%02d%02d%02d",
		&tm.tm_year, &tm.tm_mon, &tm.tm_mday,
		&tm.tm_hour, &tm.tm_min, &tm.tm_sec) == 6) {

		tm.tm_year -= 1900;
		tm.tm_mon--;
		tm.tm_isdst = -1;
		newer_time = mktime(&tm);
		dout = dataconn((char *)"file list", (off_t)-1, (char *)"w");
		transflag++;
		if (dout != NULL) {
			show_fullinfo = showlots;
			treewalk(path, check_newer, -1, 0);

			if (ferror(dout) != 0)
				perror_reply(550, (char *)"Data connection");
			else
				reply(226, "Transfer complete.");

			(void) fclose(dout);
			data = -1;
		}
	} else
		reply(501, "Bad DATE format");
	transflag = 0;
}



int check_newer(char *path, struct stat *st, int flag)
{
	if (st->st_mtime > newer_time) {
		if (show_fullinfo != 0) {
			if (flag == FTW_F || flag == FTW_D) {
				fprintf(dout, "%s %ld %ld %s", flag == FTW_F ? (char *)"F" : (char *)"D", st->st_size, st->st_mtime, path);
			}
		} else if (flag == FTW_F) 
			fprintf(dout, "%s", path);
	}
	return 0;
}



int fn_check(char *name)
{
  /* check to see if this is a valid file name... path-filter <type>
   * <message_file> <allowed_charset> <disallowed> */

//	int		j;
	char		*sp;
	char		*path;
#ifdef M_UNIX
# ifdef REGEX
	char		*regp;
# endif
#endif

#ifdef REGEXEC
	regex_t		regexbuf;
	regmatch_t	regmatchbuf;
#endif

	/*
	 * check *only* the basename
	 */

	if ((path = strrchr(name, '/')))  
		++path;
	else  
		path = name;

	/* is it in the allowed character set? */
#if defined(REGEXEC)
	if (regcomp(&regexbuf, CFG.ftp_pth_filter, REG_EXTENDED|REG_ICASE) != 0) {
		reply(553, "REGEX error");
#elif defined(REGEX)
	if ((sp = regcmp(CFG.ftp_pth_filter, (char *) 0)) == NULL) {
		reply(553, "REGEX error");
#else
	if ((sp = re_comp(CFG.ftp_pth_filter)) != 0) {
		perror_reply(553, sp);
#endif
		return(0);
	}
#if defined(REGEXEC)
	if (regexec(&regexbuf, path, 1, &regmatchbuf, 0) != 0) {
#elif defined(REGEX)
# ifdef M_UNIX
	regp = regex(sp, path);
	free(sp);
	if (regp == NULL) {
# else
	if ((regex(sp, path)) == NULL) {
# endif
#else
	if ((re_exec(path)) != 1) {
#endif
//		pr_mesg(553, CFG.ftp_pth_message);
		reply(553, "%s: Permission denied. (Filename (accept))", name);
		return(0);
	}

	/* is it in any of the disallowed regexps */

//	for (j = 3; j < MAXARGS; ++j) {
//		/* ARGj == entry->arg[j] */
//		if (entry->arg[j]) {
#if defined(REGEXEC)
//			if (regcomp(&regexbuf, entry->arg[j], REG_EXTENDED|REG_ICASE) !=0) {
//				reply(553, "REGEX error");
#elif defined(REGEX)
//			if ((sp = regcmp(entry->arg[j], (char *) 0)) == NULL) {
//				reply(553, "REGEX error");
#else
//			if ((sp = re_comp(entry->arg[j])) != 0) {
//				perror_reply(553, sp);
#endif
//			return(0);
//		}
#if defined(REGEXEC)
//		if (regexec(&regexbuf, path, 1, &regmatchbuf, 0) == 0) {
#elif defined(REGEX)
# ifdef M_UNIX
//		regp = regex(sp, path);
//		free(sp);
//		if (regp != NULL) {
# else
//		if ((regex(sp, path)) != NULL) {
# endif
#else
//		if ((re_exec(path)) == 1) {
#endif
//			pr_mesg(553, ARG1);
//			reply(553, "%s: Permission denied. (Filename (deny))", name);
//			return(0);
//		}
//	}
	return(1);
}



int dir_check(char *name, uid_t *uid, gid_t *gid, int *valid)
{
//	int		i, match_value = -1;
	char		cwdir[BUFSIZ];
	char		path[BUFSIZ];
	char		*sp;
//	extern struct	passwd *pw;

	*valid = 0;

	strcpy(path, name);
	if ((sp = strrchr(path, '/')))  
		*sp = '\0';
	else 
		strcpy(path, ".");

	if ((realpath(path, cwdir)) == (char) NULL) {
		perror_reply(553, (char *)"Could not determine cwdir");
		return(0);
	}

	return(1);
}



int upl_check(char *name, uid_t *uid, gid_t *gid, int *f_mode, int *valid)
{
	int	match_value = -1;
	char	cwdir[BUFSIZ];
	char	path[BUFSIZ];
	char	*sp;
	int	i;

//	extern struct passwd *pw;

	*valid = 0;

	/* what's our current directory? */

	strcpy(path, name);
	if ((sp = strrchr(path, '/')))
		*sp = '\0';
	else 
		strcpy(path, ".");

	if ((realpath(path, cwdir)) == (char) NULL) {
		perror_reply(553, (char *)"Could not determine cwdir");
		return(-1);
	}

	/*
	 * we are doing a "best match"... ..so we keep track of what "match
	 * value" we have received so far...
	 */

//	entry = NULL;
	match_value = -1;
	i = match_value;

	return(match_value);
}



/*
 * Allways deny delete
 */
int del_check(char *name)
{
	reply(553, "%s: Permission denied. (Delete)", name);
	return(0);
}


