/*****************************************************************************
 *
 * File ..................: mbftpd/access.c
 * Purpose ...............: MBSE BBS Ftp Daemon
 * Last modification date : 29-Jul-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../config.h"
#include "../lib/libs.h"
#include "../lib/mbse.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/clcomm.h"
#include "access.h"



/*************************************************************************/
/* FUNCTION  : acl_countusers                                            */
/* PURPOSE   : Count the total of mbftpd users				 */
/* ARGUMENTS : none                                                      */
/*************************************************************************/

int acl_countusers()
{
	int	count = 0, NotDone = TRUE;
	char	buf[128], *cnt;

	sprintf(buf, "GMON:1,1;");
	while (NotDone) {
		if (socket_send(buf) == 0) {
			strcpy(buf, socket_receive());
			if (strncmp(buf, "100:0;", 6) == 0) {
				NotDone = FALSE;
			} else {
				cnt = strtok(buf, ",");
				cnt = strtok(NULL, ",");
				cnt = strtok(NULL, ",");
				cnt = strtok(NULL, ",");
				cnt = strtok(NULL, ",");
				if (strncmp(cnt, "mbftpd", 6) == 0)
					count++;
				sprintf(buf, "GMON:1,0;");
			}
		} else {
			return -1;
		}
	}

	return(count);
}



/*************************************************************************/
/* FUNCTION  : access_ok                                                 */
/* PURPOSE   : Check the user access					 */
/* ARGUMENTS : none                                                      */
/*************************************************************************/

int access_ok(char *name)
{
	FILE		*fp;
	struct userhdr	ushdr;
	struct userrec	us;
	char		*temp;

	if ((strcmp(name, "mbse") == 0) && CFG.ftp_mbseok) 
		return 1;

	/*
	 * Count userlimit, the "mbse" administrator doesn't have
	 * count access limits.
	 */
	if (CFG.ftp_limit) {
		if (acl_countusers() > CFG.ftp_limit) {
			return -1;
		}
	}

	if ((strcmp(name, "ftp") == 0) && CFG.ftp_anonymousok)
		return 1;

	temp = calloc(128, sizeof(char));

	sprintf(temp, "%s/etc/users.data", getenv("MBSE_ROOT"));
	if ((fp = fopen(temp, "rb")) != NULL) {
		fread(&ushdr, sizeof(ushdr), 1, fp);

		while (fread(&us, ushdr.recsize, 1, fp) == 1) {
			if (strcmp(name, us.Name) == 0) {
				fclose(fp);
				free(temp);
				return 1;
			}
		}
		fclose(fp);
	} else
		WriteError("$Can't open %s", temp);

	free(temp);
	return 0;
}


