/*****************************************************************************
 *
 * File ..................: mbcico/filetime.c
 * Purpose ...............: Fidonet mailer 
 * Last modification date : 18-Dec-1999
 * Y2K check .............: Passed.
 *
 *****************************************************************************
 * Copyright (C) 1997-1999
 *   
 * Michiel Broek		FIDO:	2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


#include "../lib/libs.h"
#include "filetime.h"



time_t gmtoff(time_t);
time_t gmtoff(time_t tt)
{
	struct tm	lt;
	struct tm	gt;
	time_t		offset;

	lt = *localtime(&tt);
	gt = *gmtime(&tt);
	offset = gt.tm_yday - lt.tm_yday;
	if (offset > 1) 
		offset =- 24;
	else 
		if (offset < -1) 
			offset = 24;
		else 
			offset *= 24;

	offset += gt.tm_hour - lt.tm_hour;
	offset *= 60;
	offset += gt.tm_min - lt.tm_min;
	offset *= 60;
	offset += gt.tm_sec - lt.tm_sec;
	return offset;
}



time_t mtime2sl(time_t tt)
{
	return tt - gmtoff(tt);
}



time_t sl2mtime(time_t tt)
{
	return tt + gmtoff(tt);
}



time_t tl2mtime(time_t tt)
{
	struct tm	tm;

	tm.tm_year = ((tt >> 25) & 0x7f) + 1980;
	tm.tm_mon  =  (tt >> 21) & 0x0f;
	tm.tm_mday =  (tt >> 16) & 0x1f;
	tm.tm_hour =  (tt >> 11) & 0x1f;
	tm.tm_min  =  (tt >> 5 ) & 0x3f;
	tm.tm_sec =  ((tt      ) & 0x1f) * 2;

	return mktime(&tm);
}

