/*****************************************************************************
 *
 * File ..................: semafore.c
 * Purpose ...............: Create, test and remove semafore's
 * Last modification date : 18-Mar-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:	2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "libs.h"
#include "structs.h"
#include "clcomm.h"
#include "common.h"


void CreateSema(char *sem)
{
	char	*temp;
	int	fd;

	if (IsSema(sem))
		return;

	temp = calloc(PATH_MAX, sizeof(char));
	sprintf(temp, "%s/sema/%s", getenv("MBSE_ROOT"), sem);
	if ((fd = open(temp, O_CREAT|O_TRUNC,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP)) >= 0) {
		fsync(fd);
		close(fd);
		Syslog('l', "Created semafore \"%s\"", sem);
	} else
		WriteError("$Can't create semafore %s", temp);

	free(temp);
}



void RemoveSema(char *sem)
{
	char	*temp;

	if (!IsSema(sem))
		return;

	temp = calloc(PATH_MAX, sizeof(char));

	sprintf(temp, "%s/sema/%s", getenv("MBSE_ROOT"), sem);
	if (unlink(temp) == -1)
		WriteError("$Can't remove %s", temp);
	else
		Syslog('l', "Removed semafore \"%s\"", sem);

	free(temp);
}



int IsSema(char *sem)
{
	char	*temp;

	temp = calloc(PATH_MAX, sizeof(char));

	sprintf(temp, "%s/sema/%s", getenv("MBSE_ROOT"), sem);
	if (access(temp, F_OK) == 0) {
		free(temp);
		return TRUE;
	} else {
		free(temp);
		return FALSE;
	}
}


