/*****************************************************************************
 *
 * File ..................: nntp.c
 * Purpose ...............: MBSE BBS Internet Library
 * Last modification date : 10-Sep-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "libs.h"
#include "structs.h"
#include "records.h"
#include "clcomm.h"
#include "mbinet.h"


static int		nntpsock = -1;	/* TCP/IP socket		*/
struct hostent		*nhp;		/* Host info remote		*/
struct servent		*nsp;		/* Service information		*/
struct sockaddr_in	nntp_loc;	/* For local socket address	*/
struct sockaddr_in	nntp_rem;	/* For remote socket address	*/



int nntp_connect(void)
{
	int	addrlen;
	char	*p;

	if (nntpsock != -1)
		return nntpsock;

	if (!strlen(CFG.nntpnode)) {
		WriteError("NNTP: host not configured");
		return -1;
	}

	memset(&nntp_loc, 0, sizeof(struct sockaddr_in));
	memset(&nntp_rem, 0, sizeof(struct sockaddr_in));

	nntp_rem.sin_family = AF_INET;

	if ((nhp = gethostbyname(CFG.nntpnode)) == NULL) {
		WriteError("$NNTP: can't find host %s", CFG.nntpnode);
		return -1;
	}

	nntp_rem.sin_addr.s_addr = ((struct in_addr *)(nhp->h_addr))->s_addr;

	if ((nsp = getservbyname("nntp", "tcp")) == NULL) {
		WriteError("$NNTP: can't find service port for nntp/tcp");
		return -1;
	}
	nntp_rem.sin_port = nsp->s_port;

	if ((nntpsock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		WriteError("$NNTP: unable to create tcp socket");
		return -1;
	}

	if (connect(nntpsock, (struct sockaddr *)&nntp_rem, sizeof(struct sockaddr_in)) == -1) {
		WriteError("$Cannot connect tcp socket");
		return -1;
	}

	addrlen = sizeof(struct sockaddr_in);

	if (getsockname(nntpsock, (struct sockaddr *)&nntp_loc, &addrlen) == -1) {
		WriteError("$NNTP: unable to read socket address");
		return -1;
	}

	p = nntp_receive();
	if (strlen(p) == 0) {
		WriteError("NNTP: no response");
		nntp_close();
		return -1;
	}

	if (strncmp(p, "200", 3)) {
		WriteError("NNTP: bad response: %s", p);
		nntp_close();
		return -1;
	}

	Syslog('+', "NNTP: %s", p);
	
	return nntpsock;
}



int nntp_send(char *buf)
{
	if (nntpsock == -1)
		return -1;

	Syslog('m', "NNTP> %s", printable(buf, 0));
	if (send(nntpsock, buf, strlen(buf), 0) != strlen(buf)) {
		WriteError("$Socket send failed");
		return -1;
	}
	return 0;
}



/*
 *  Return empty buffer if something went wrong, else the complete
 *  dataline is returned
 */
char *nntp_receive(void)
{
	static char	buf[SS_BUFSIZE];
	int		i, j;

	memset((char *)&buf, 0, SS_BUFSIZE);
	i = 0;
	while ((strchr(buf, '\n')) == NULL) {
		j = recv(nntpsock, &buf[i], SS_BUFSIZE-i, 0);
		if (j == -1) {
			WriteError("$Error reading socket");
			memset((char *)&buf, 0, SS_BUFSIZE);
			return buf;
		}
		i += j;
	}

	for (i = 0; i < strlen(buf); i++) {
		if (buf[i] == '\n')
			buf[i] = '\0';
		if (buf[i] == '\r')
			buf[i] = '\0';
	}

	Syslog('m', "NNTP< %s", printable(buf, 0));
	return buf;
}



int nntp_close(void)
{
	if (nntpsock == -1)
		return 0;

	nntp_cmd((char *)"QUIT\r\n", 205);

	if (shutdown(nntpsock, 1) == -1) {
		WriteError("$Can't close socket");
		return -1;
	}

	nntpsock = -1;
	return 0;
}



int nntp_cmd(char *cmd, int resp)
{
	char	*p, rsp[6];

	if (nntp_send(cmd) == -1)
		return -1;

	sprintf(rsp, "%d", resp);
	p = nntp_receive();

	if (strncmp(p, rsp, strlen(rsp))) {
		WriteError("NNTP> %s", cmd);
		WriteError("NNTP< %s", p);
		return -1;
	}
	return 0;
}



