/*****************************************************************************
 *
 * File ..................: ifdbm.c
 * Purpose ...............: MBSE BBS Mail Gate
 * Last modification date : 25-Sep-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

/* ### Modified by P.Saratxaga on 19 Sep 1995 ###
 * - added FORCE_REPLYTO to force return 1 even if we use 
 *   an alias database
 */

#include "../config.h"
#include "libs.h"
#include "structs.h"
#include "clcomm.h"
#include "common.h"

#ifdef DBM_IN_GDBM
#ifdef HAS_NDBM_H
#include <gdbm/ndbm.h>
#else
#include <gdbm/dbm.h>
#endif
#else
#ifdef HAS_NDBM_H
#include <ndbm.h>
#else
#include <dbm.h>
#endif
#endif

#ifndef IF_DBM_SUFFIX
#ifdef HAS_BSD_DB
#define IF_DBM_SUFFIX	".db"
#else
#define IF_DBM_SUFFIX	".dir"
#endif
#endif

static int	opened = 0;
#ifdef HAS_NDBM_H
static DBM	*alias_db = NULL;
#endif
char		*database=NULL;



int init(void)
{
#ifndef HAS_BSD_DB
	char		buf[128];
	struct stat	stbuf;
	FILE		*fp;
#endif
	int		tries;

	database = xstrcpy(getenv("MBSE_ROOT"));
	database = xstrcat(database, (char *)"/var/dbm");
	if (opened == -1) 
		return -1;
	if (opened) 
		return 0;
#ifndef HAS_BSD_DB
	sprintf(buf,"%s" IF_DBM_SUFFIX, database);
	if (stat(buf,&stbuf) != 0) {
		fp=fopen(buf,"a");
		if (fp) 
			fclose(fp);
		sprintf(buf,"%s.pag", database);
		fp=fopen(buf,"a");
		if (fp) 
			fclose(fp);
	}
#endif
	for (tries=0;(1);tries++) {
#ifdef HAS_NDBM_H
		if ((alias_db=dbm_open(database,O_RDWR | O_CREAT,0600)) != NULL)
#else
		if (dbminit(database) == 0)
#endif
		{
			opened = 1;
			return 0;
		} else if ((tries > 5) || (errno != EAGAIN)) {
			WriteError("$could not open alias database");
			opened = -1;
			return -1;
		} else
			sleep(2);
	}
}



int registrate(char *freename, char *address)
{
	datum	key,val;
	char	buf[128],*p,*q;
	int	first;

	if (init()) 
		return 1;

	if (strlen(freename) > MAXNAME)
		freename[MAXNAME]='\0';
	strncpy(buf,freename,sizeof(buf)-1);
	first=1;
	for (p=buf,q=buf;*p;p++) 
		switch (*p) {
		case '.':	*p=' '; /* fallthrough */
		case ' ':	if (first) {
					*(q++)=*p;
					first=0;
				}
				break;
		default:	*(q++)=*p;
				first=1;
				break;
		}
	*q='\0';
	Syslog('m', "registrate \"%s\" \"%s\"",SS(buf),SS(address));
	key.dptr=buf;
	key.dsize=strlen(buf);
#ifdef HAS_NDBM_H
	val=dbm_fetch(alias_db,key);
#else
	val=fetch(key);
#endif
	if (val.dptr) 		/* already present */
#ifdef FORCE_REPLYTO
		return 1;
#else
		return 0;
#endif
	else {
		val.dptr=address;
		val.dsize=strlen(address);
#ifdef HAS_NDBM_H
		if (dbm_store(alias_db,key,val,0) < 0)
#else
		if (store(key,val) != 0)
#endif
		{
			WriteError("$cannot store: \"%s\" \"%s\"",
				SS(buf),SS(address));
			return 1;
		} else {
			Syslog('+', "registered \"%s\" as \"%s\"",SS(buf),SS(address));
#ifdef FORCE_REPLYTO
			return 1;
#else
			return 0;
#endif
		}
	}
}



char *lookup(char *freename)
{
	datum		key,val;
	static char	buf[128],*p,*q;
	int		sz,first;

	if (init()) 
		return NULL;

	strncpy(buf,freename,sizeof(buf)-1);
	first=1;
	for (p=buf,q=buf;*p;p++) 
		switch (*p) {
		case '.':	*p=' '; /* fallthrough */
		case ' ':	if (first) {
					*(q++)=*p;
					first=0;
				}
				break;
		default:	*(q++)=*p;
				first=1;
				break;
		}
	*q='\0';
	Syslog('m', "lookup \"%s\"",SS(freename));
	key.dptr=buf;
	key.dsize=strlen(buf);
#ifdef HAS_NDBM_H
	val=dbm_fetch(alias_db,key);
#else
	val=fetch(key);
#endif
	if (val.dptr) {
		sz=val.dsize;
		if (sz > (sizeof(buf)-1)) 
			sz=sizeof(buf)-1;
		strncpy(buf,val.dptr,sz);
		buf[sz]='\0';
		Syslog('m', "found: \"%s\"",buf);
		return(buf);
	} else 
		return NULL;
}



void close_alias_db(void)
{
	if (opened != 1) 
		return;
#ifndef DONT_HAVE_DBMCLOSE
#ifdef HAS_NDBM_H
	dbm_close(alias_db);
#else
	dbmclose();
#endif
#endif
	opened=0;
}


