/*****************************************************************************
 *
 * File ..................: execute.c
 * Purpose ...............: Execute subprogram
 * Last modification date : 18-Mar-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:	2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "libs.h"
#include "structs.h"
#include "clcomm.h"
#include "common.h"


int	e_pid = 0;		/* Execute child pid	*/



int execute(char *cmd, char *file, char *pkt, char *in, char *out, char *err)
{
	char	buf[512];
	char	*vector[16];
	int	i;
	int	pid, status, rc, sverr;

	if (pkt == NULL)
		sprintf(buf, "%s %s", cmd, file);
	else
		sprintf(buf, "%s %s %s", cmd, file, pkt);
	Syslog('+', "Execute: %s",buf);

	i = 0;
	vector[i++] = strtok(buf," \t\n");
	while ((vector[i++] = strtok(NULL," \t\n")) && (i<16));
	vector[15] = NULL;
	fflush(stdout);
	fflush(stderr);

	if ((pid = fork()) == 0) {
		if (in) {
			close(0);
			if (open(in,O_RDONLY) != 0) {
				WriteError("$Reopen of stdin to %s failed", SS(in));
				exit(-1);
			}
		}
		if (out) {
			close(1);
			if (open(out,O_WRONLY | O_APPEND | O_CREAT,0600) != 1) {
				WriteError("$Reopen of stdout to %s failed", SS(out));
				exit(-1);
			}
		}
		if (err) {
			close(2);
			if (open(err,O_WRONLY | O_APPEND | O_CREAT,0600) != 2) {
				WriteError("$Reopen of stderr to %s failed", SS(err));
				exit(-1);
			}
		}
		errno = 0;
		rc = getpriority(PRIO_PROCESS, 0);
		if (errno == 0) {
			rc = setpriority(PRIO_PROCESS, 0, 15);
			if (rc)
				WriteError("$execv can't set priority to 15");
		}
		rc = execv(vector[0],vector);
		WriteError("$execv \"%s\" returned %d", SS(vector[0]), rc);
		setpriority(PRIO_PROCESS, 0, 0);
		exit(-1);
	}

	e_pid = pid;

	do {
		rc = wait(&status);
		e_pid = 0;
		sverr = errno;
		if (status)
			WriteError("$Wait returned %d, status %d,%d",
				rc, status >> 8, status&0xff);
	} while (((rc > 0) && (rc != pid)) || ((rc == -1) && (sverr == EINTR)));

	setpriority(PRIO_PROCESS, 0, 0);
	if (rc == -1) {
		WriteError("$Wait returned %d, status %d,%d",
			rc,status>>8,status&0xff);
		return -1;
	}

	return status;
}


#define SHELL "/bin/sh"


int execsh(char *cmd, char *in, char *out, char *err)
{
	int	pid, status, rc, sverr;

	Syslog('+', "Execute shell: %s", SS(cmd));
	fflush(stdout);
	fflush(stderr);

	if ((pid = fork()) == 0) {
		if (in) {
			close(0);
			if (open(in, O_RDONLY) != 0) {
				WriteError("$Reopen of stdin to %s failed",SS(in));
				exit(-1);
			}
		}
		if (out) {
			close(1);
			if (open(out, O_WRONLY | O_APPEND | O_CREAT,0600) != 1) {
				WriteError("$Reopen of stdout to %s failed",SS(out));
				exit(-1);
			}
		}
		if (err) {
			close(2);
			if (open(err, O_WRONLY | O_APPEND | O_CREAT,0600) != 2) {
				WriteError("$Reopen of stderr to %s failed",SS(err));
				exit(-1);
			}
		}

		rc = execl(SHELL, "sh", "-c", cmd, NULL);
		WriteError("$execl \"%s\" returned %d", SS(cmd), rc);
		exit(-1);
	}

	e_pid = pid;

	do {
		rc = wait(&status);
		e_pid = 0;
		sverr = errno;
		if (status)
			WriteError("$Wait returned %d, status %d,%d",
				rc, status >> 8, status & 0xff);
	}

	while (((rc > 0) && (rc != pid)) || ((rc == -1) && (sverr == EINTR))); 
	if (rc == -1) {
		WriteError("$Wait returned %d, status %d,%d",
			rc, status >> 8, status & 0xff);
		return -1;
	}

	return status;
}


