/*****************************************************************************
 *
 * File ..................: import/import.c
 * Purpose ...............: Import databases from textfiles.
 * Last modification date : 10-Sep-2000
 *
 *****************************************************************************
 * Copyright (C) 1997-2000
 *   
 * Michiel Broek		FIDO:		2:280/2802
 * Beekmansbos 10
 * 1971 BV IJmuiden
 * the Netherlands
 *
 * This file is part of MBSE BBS.
 *
 * This BBS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * MBSE BBS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MBSE BBS; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "../lib/libs.h"
#include "../lib/structs.h"
#include "../lib/records.h"
#include "../lib/common.h"
#include "../lib/dbcfg.h"
#include "../lib/dbftn.h"
#include "import.h"


char	*BBSPath;			/* MBSE_ROOT path		   */
int	PMiy;


#define	GT	fgets(Temp, 80, Imp); Striplf(Temp);


void HelpMsg()
{
	colour(3, 0);
	printf("  Commandline parameters:\n\n");
	printf("        -fdb     Import fdb##.txt into fdb##.data files\n");
	printf("        -fareas  Import fareas.txt into fareas.data\n");
	printf("        -fgroups Import fgroups.txt into fgroups.data\n");
	printf("        -mareas  Import mareas.txt into mareas.data\n");
	printf("        -nodes   Import nodes.txt into nodes.data\n");
	printf("        -users   Import users.txt into users.data\n");
	printf("\n  eg. import -u\n\n");
	colour(7, 0);
#ifdef MEMWATCH
	mwTerm();
#endif
	exit(0);
}



void ImportUser()
{
	FILE	*Imp, *Exp;
	char	*ExpFile;
	char	*Temp;
	int	Area;

	ExpFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import Users Database ...\n\n");
	sprintf(ExpFile, "%s/etc/users.data", BBSPath);

	if ((Imp = fopen("users.txt", "r")) == NULL) 
		if ((Imp = fopen("USERS.TXT", "r")) == NULL) {
			perror("FATAL ERROR: Can't open users.txt");
#ifdef MEMWATCH
			mwTerm();
#endif
			exit(1);
	} 

	if ((Exp = fopen(ExpFile, "w")) == NULL) {
		perror("FATAL ERROR: Can't open users.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}

	usrconfighdr.hdrsize = sizeof(usrconfighdr);
	usrconfighdr.recsize = sizeof(usrconfig);
	fwrite(&usrconfighdr, sizeof(usrconfighdr), 1, Exp);

	Area = 0;
	while ((fgets(Temp, 80, Imp)) != NULL) {
		/* UserName */
		Area++;
		Striplf(Temp);
		printf("%4d %s\r", Area, Temp);
		fflush(stdout);
		memset(&usrconfig, 0, usrconfighdr.recsize);
		strncpy(usrconfig.sUserName, Temp, 35);

		/* Password */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iPassword = atoi(Temp);

		/* VoicePhone */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sVoicePhone, Temp, 19);

		/* DataPhone*/
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sDataPhone, Temp, 19);

		/* Location */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sLocation, Temp, 27);

		/* Address 1 */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.address[0], Temp, 40);

		/* Address 2 */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.address[1], Temp, 40);

		/* Address 3 */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.address[2], Temp, 40);

		/* Date of birth */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sDateOfBirth, Temp, 11);

		/* First LoginDate */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.tFirstLoginDate = atoi(Temp);

		/* Last Logindate */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.tLastLoginDate = atoi(Temp);

		/* Security Level */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Security.level = atoi(Temp);

		/* Security Flags */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Security.flags = atoi(Temp);

		/* Comment */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sComment, Temp, 80);

		/* ExpiryDate */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sExpiryDate, Temp, 11);

		/* Sex */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sSex, Temp, 7);

		/* Hidden */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Hidden = atoi(Temp);

		/* HotKeys */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.HotKeys = atoi(Temp);

		/* GraphMode */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.GraphMode = atoi(Temp);

		/* Deleted */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Deleted = atoi(Temp);

		/* NeverDelete */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.NeverDelete = atoi(Temp);

		/* DoNotDisturb */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.DoNotDisturb = atoi(Temp);

		/* Cls */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Cls = atoi(Temp);

		/* More */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.More = atoi(Temp);

		/* FsMsgEd */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.FsMsged = atoi(Temp);

		/* NoEcho */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.MailScan = atoi(Temp);

		/* Guest */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Guest = atoi(Temp);

		/* TotalCalls */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iTotalCalls = atoi(Temp);

		/* TimeUsed */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iTimeUsed = atoi(Temp);

		/* ScreenLength */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iScreenLen = atoi(Temp);

		/* LastPwdChange */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.tLastPwdChange = atoi(Temp);

		/* Credit */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Credit = atoi(Temp);

		/* Last Filearea */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iLastFileArea = atoi(Temp);

		/* Protocol */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(usrconfig.sProtocol, Temp, 20);

		/* DownLoads */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Downloads = atoi(Temp);

		/* Uploads */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.Uploads = atoi(Temp);

		/* UploadK */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.UploadK = atoi(Temp);

		/* DownloadK */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.DownloadK = atoi(Temp);

		/* DownloadKToday */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.DownloadKToday = atoi(Temp);

		/* LastMsgAreas */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iLastMsgArea = atoi(Temp) - 1;

		/* Posted */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		usrconfig.iPosted = atoi(Temp);

		/* Handle */
		fgets(Temp, 80, Imp);
		Striplf(Temp); 
		strncpy(usrconfig.sHandle, Temp, 35);

		/* English language */
		usrconfig.iLanguage = 69;

		usrconfig.Cls = TRUE;
		usrconfig.ieFILE = TRUE;
		usrconfig.ieNEWS = TRUE;
		usrconfig.ieASCII8 = TRUE;

		fwrite(&usrconfig, usrconfighdr.recsize, 1, Exp);
		printf("                                             \r");
		fflush(stdout);
	}
	fclose(Imp);
	fclose(Exp);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



void ImportMsgs()
{
	FILE	*Imp, *Exp;
	char	*ExpFile;
	char	*Temp;
	int	Area, i;
	struct	_sysconnect syscon;

	ExpFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import Message Database ...\n\n");
	sprintf(ExpFile, "%s/etc/mareas.data", BBSPath);

	if ((Imp = fopen("mareas.txt", "r")) == NULL) 
		if ((Imp = fopen("MAREAS.TXT", "r")) == NULL) {
			perror("FATAL ERROR: Can't open mareas.txt");
#ifdef MEMWATCH
                        mwTerm();
#endif
			exit(1);
	} 

	if ((Exp = fopen(ExpFile, "w")) == NULL) {
		perror("FATAL ERROR: Can't open mareas.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}

	msgshdr.hdrsize = sizeof(msgshdr);
	msgshdr.recsize = sizeof(msgs);
	msgshdr.syssize = CFG.toss_systems * sizeof(syscon);
	fwrite(&msgshdr, sizeof(msgshdr), 1, Exp);
	memset(&syscon, 0, sizeof(syscon));

	Area = 0;
	while ((fgets(Temp, 80, Imp)) != NULL) {
		/* Name */
		Area++;
		Striplf(Temp);
		printf("%4d %s\r", Area, Temp);
		fflush(stdout);
		memset(&msgs, 0, sizeof(msgs));
		strncpy(msgs.Name, Temp, 40);

		/* Base */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(msgs.Base, Dos2Unix(Temp), 80);

		/* Type */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		switch(Temp[0]) {
		case 'L':
			msgs.Type = LOCALMAIL;
			break;

		case 'N':
			msgs.Type = NETMAIL;
			break;

		case 'E':
			msgs.Type = ECHOMAIL;
			break;

		case 'G':
			msgs.Type = NEWS;
			break;
		}

		/* MsgKinds */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		switch(atoi(Temp)) {
		case 0:
			msgs.MsgKinds = BOTH;
			break;

		case 1:
			msgs.MsgKinds = PRIVATE;
			break;

		case 2:
			msgs.MsgKinds = PUBLIC;
			break;

		case 3:
			msgs.MsgKinds = RONLY;
			break;

		case 4:
			msgs.MsgKinds = RONLY;
			break;	
		}

		/* DaysOld */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.DaysOld = atoi(Temp);

		/* MaxMsgs */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.MaxMsgs = atoi(Temp);

		/* UsrDelete */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.UsrDelete = atoi(Temp);

		/* RDsec */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.RDSec.level = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.RDSec.flags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.RDSec.notflags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Age = atoi(Temp);

		/* WRsec */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.WRSec.level = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.WRSec.flags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.WRSec.notflags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp); /* Age again */

		/* SYsec */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.SYSec.level = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.SYSec.flags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.SYSec.notflags = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp); /* Age again */

		/* Aka */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Aka.zone = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Aka.net = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Aka.node = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Aka.point = atoi(Temp);
		if (SearchFidonet(msgs.Aka.zone) == FALSE) {
			fclose(Imp);
			fclose(Exp);
			printf("PANIC: Fidonet zone %d not in fidonet.data\n\n", msgs.Aka.zone);
#ifdef MEMWATCH
                        mwTerm();
#endif
			exit(1);
		} else
			strcpy(msgs.Aka.domain, fidonet.domain);

		/* Origin */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(msgs.Origin, Temp, 64);

		/* Aliases */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Aliases = atoi(Temp);

		/* NetReply */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.NetReply = atoi(Temp);

		/* Active */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		msgs.Active = atoi(Temp);

		/* EchoInfo - not used */
		fgets(Temp, 80, Imp);
		Striplf(Temp);

		/* FileAttach */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
//		msgs.FileAtt = atoi(Temp);
		fwrite(&msgs, sizeof(msgs), 1, Exp);
		for (i = 1; i <= CFG.toss_systems; i++)
			fwrite(&syscon, sizeof(syscon), 1, Exp);
		printf("                                             \r");		
		fflush(stdout);
	}
	fclose(Imp);
	fclose(Exp);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



void ImportFAreas(void)
{
	FILE	*Imp, *Exp;
	char	*ExpFile;
	char	*Temp;
	int	Area;

	ExpFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import FileArea Database ...\n\n");
	sprintf(ExpFile, "%s/etc/fareas.data", BBSPath);

	if ((Imp = fopen("fareas.txt", "r")) == NULL) 
		if ((Imp = fopen("FAREAS.TXT", "r")) == NULL) {
			perror("FATAL ERROR: Can't open fareas.txt");
#ifdef MEMWATCH
                        mwTerm();
#endif
			exit(1);
	} 

	if ((Exp = fopen(ExpFile, "w")) == NULL) {
		perror("FATAL ERROR: Can't open mareas.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}

	areahdr.hdrsize = sizeof(areahdr);
	areahdr.recsize = sizeof(area);
	fwrite(&areahdr, sizeof(areahdr), 1, Exp);

	Area = 0;
	while ((fgets(Temp, 80, Imp)) != NULL) {
		/* Name */
		Area++;
		Striplf(Temp);
		printf("%4d %s\r", Area, Temp);
		fflush(stdout);
		memset(&area, 0, sizeof(area));
		strncpy(area.Name, Temp, 44);

		GT 
		strncpy(area.Path, Dos2Unix(Temp), 80);

		GT area.DLSec.level    = atoi(Temp);
		GT area.DLSec.flags    = atoi(Temp);
		GT area.DLSec.notflags = atoi(Temp);
		GT

		GT area.UPSec.level    = atoi(Temp);
		GT area.UPSec.flags    = atoi(Temp);
		GT area.UPSec.notflags = atoi(Temp);
		GT

		GT area.LTSec.level    = atoi(Temp);
		GT area.LTSec.flags    = atoi(Temp);
		GT area.LTSec.notflags = atoi(Temp);
		GT area.Age = atoi(Temp);

		GT area.New       = atoi(Temp);
		GT area.Dupes     = atoi(Temp);
		GT area.Free      = atoi(Temp);
		GT area.DirectDL  = atoi(Temp);
		GT area.PwdUP     = atoi(Temp);
		GT area.FileFind  = atoi(Temp);
		GT area.AddAlpha  = atoi(Temp);
		GT area.Available = atoi(Temp);
		GT area.CDrom     = atoi(Temp);
		GT area.FileReq   = atoi(Temp);

		GT strncpy(area.BbsGroup, Temp, 12);
		GT strncpy(area.Password, Temp, 20);
	
		GT area.DLdays   = atoi(Temp);
		GT area.FDdays   = atoi(Temp);
		GT area.MoveArea = atoi(Temp);
		GT area.Cost     = atoi(Temp);

		GT /* FilesBbs       */
		GT /* NewGroup       */
		GT /* Archiver       */

		GT area.Upload = atoi(Temp);

		if (!strlen(area.Name))
			memset(&area, 0, sizeof(area));
		fwrite(&area, sizeof(area), 1, Exp);
		printf("                                             \r");		
		fflush(stdout);
	}
	fclose(Imp);
	fclose(Exp);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



void ImportFDB(void)
{
	FILE	*Imp, *Exp, *Are;
	char	*ImpFile, *ExpFile, *AreFile;
	char	*Temp;
	int	i, Area = 0;
	struct	FILERecord fdb;

	ImpFile = calloc(81, sizeof(char));
	ExpFile = calloc(81, sizeof(char));
	AreFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import Files Databases ...\n\n");
	sprintf(AreFile, "%s/etc/fareas.data", BBSPath);

	if ((Are = fopen(AreFile, "r")) == NULL) {
		perror("FATAL ERROR: Can't open fareas.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}
	fread(&areahdr, sizeof(areahdr), 1, Are);

	while ((fread(&area, areahdr.recsize, 1, Are)) == 1) {
		Area++;
		printf("%4d\r", Area);
		fflush(stdout);
		if (area.Available) {
			printf("%4d %s\r", Area, area.Name);
			fflush(stdout);
			sprintf(ExpFile, "%s/fdb/fdb%d.data", getenv("MBSE_ROOT"), Area);
			if ((Exp = fopen(ExpFile, "w")) == NULL) {
				perror("");
				printf("Can't open %s", ExpFile);
#ifdef MEMWATCH
                        	mwTerm();
#endif
				exit(1);
			}

			sprintf(ImpFile, "FDB%d.TXT", Area);
			if ((Imp = fopen(ImpFile, "r")) == 0) {
				sprintf(ImpFile, "fdb%d.txt", Area);
				if ((Imp = fopen(ImpFile, "r")) == NULL) {
					printf("Can't open %s", ImpFile);
#ifdef MEMWATCH
                        		mwTerm();
#endif
					exit(1);
				}
			}

			while ((fgets(Temp, 80, Imp)) != NULL) {
				/* Name */
				Striplf(Temp);
				memset(&fdb, 0, sizeof(fdb));
				strncpy(fdb.Name, tl(Temp), 12);
				strncpy(fdb.LName, tl(Temp), 80);
				GT fdb.Size    = atoi(Temp);
				GT fdb.Crc32   = atoi(Temp);

				GT strncpy(fdb.Uploader, Temp, 35);

				GT fdb.UploadDate = atoi(Temp);
				GT fdb.FileDate   = atoi(Temp);
				GT fdb.LastDL     = atoi(Temp);
				GT fdb.TimesDL    = atoi(Temp);
				GT fdb.TimesFTP   = atoi(Temp);
				GT fdb.TimesReq   = atoi(Temp);

				GT strncpy(fdb.Password, Temp, 15);

				for (i = 0; i < 25; i++) {
					GT  strncpy(fdb.Desc[i], Temp, 48);
				}

				GT fdb.Cost         = atoi(Temp);
				GT fdb.Free         = atoi(Temp);
				GT fdb.Deleted      = atoi(Temp);
				GT /* Unlisted */
				GT /* Unavailable */
				GT fdb.Missing      = atoi(Temp);
				GT fdb.NoKill       = atoi(Temp);
				GT fdb.Announced    = atoi(Temp);

				fwrite(&fdb, sizeof(fdb), 1, Exp);
			}
			fclose(Exp);
			fclose(Imp);
			printf("                                             \r");
			fflush(stdout);
		}
	}
	fclose(Are);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



void ImportFGroups(void)
{
	FILE	*Imp, *Exp;
	char	*ExpFile;
	char	*Temp;
	int	Area;

	ExpFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import File Groups...\n\n");
	sprintf(ExpFile, "%s/etc/fgroups.data", BBSPath);

	if ((Imp = fopen("fgroups.txt", "r")) == NULL) 
		if ((Imp = fopen("FGROUPS.TXT", "r")) == NULL) {
			perror("FATAL ERROR: Can't open fgroups.txt");
#ifdef MEMWATCH
                        mwTerm();
#endif
			exit(1);
	} 

	if ((Exp = fopen(ExpFile, "w")) == NULL) {
		perror("FATAL ERROR: Can't open fgroups.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}

	fgrouphdr.hdrsize = sizeof(fgrouphdr);
	fgrouphdr.recsize = sizeof(fgroup);
	fwrite(&fgrouphdr, sizeof(fgrouphdr), 1, Exp);

	Area = 0;
	while ((fgets(Temp, 80, Imp)) != NULL) {
		/* Name */
		Area++;
		Striplf(Temp);
		printf("%4d %s\r", Area, Temp);
		fflush(stdout);
		memset(&fgroup, 0, fgrouphdr.recsize);
		strncpy(fgroup.Name, Temp, 12);

		/* Comment */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(fgroup.Comment, Temp, 55);

		/* Active */
		fgroup.Active = TRUE;

		/* Aka to use */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UseAka.zone = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UseAka.net = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UseAka.node = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);

		if (fgroup.UseAka.zone) {
			fgroup.UseAka.point = atoi(Temp);
			if (SearchFidonet(fgroup.UseAka.zone))
				strcpy(fgroup.UseAka.domain, fidonet.domain);
			else {
				fclose(Imp);
				fclose(Exp);
				printf("PANIC: Fidonet zone %d not in fidonet.data\n\n", msgs.Aka.zone);
#ifdef MEMWATCH
                        	mwTerm();
#endif
				exit(1);
			}
		}

		/* UpLink */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UpLink.zone = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UpLink.net = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UpLink.node = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.UpLink.point = atoi(Temp);
		if (fgroup.UpLink.zone) {
			if (SearchFidonet(fgroup.UpLink.zone))
				strcpy(fgroup.UpLink.domain, fidonet.domain);
			else {
				fclose(Imp);
				fclose(Exp);
				printf("PANIC: Fidonet zone %d not in fidonet.data\n\n", msgs.Aka.zone);
#ifdef MEMWATCH
                        	mwTerm();
#endif
				exit(1);
			}
		}

		/* Statistics */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.Files.total = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.KBytes.total = atoi(Temp);

		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.Files.month[Miy] = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.KBytes.month[Miy] = atoi(Temp);

		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.Files.month[PMiy] = atoi(Temp);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.KBytes.month[PMiy] = atoi(Temp);

		/* Startdate */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.StartDate = atoi(Temp);

		/* Last active date */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		fgroup.LastDate = atoi(Temp);

		fwrite(&fgroup, fgrouphdr.recsize, 1, Exp);
		printf("                                             \r");
		fflush(stdout);
	}
	fclose(Imp);
	fclose(Exp);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



void ImportNodes(void)
{
	FILE	*Imp, *Exp;
	char	*ExpFile;
	char	*Temp;
	int	Area, i, j;
	char	group[13];

	ExpFile = calloc(81, sizeof(char));
	Temp    = calloc(81, sizeof(char));

	printf("Import Nodes...\n\n");
	sprintf(ExpFile, "%s/etc/nodes.data", BBSPath);

	if ((Imp = fopen("nodes.txt", "r")) == NULL) 
		if ((Imp = fopen("NODES.TXT", "r")) == NULL) {
			perror("FATAL ERROR: Can't open nodes.txt");
#ifdef MEMWATCH
                        mwTerm();
#endif
			exit(1);
	} 

	if ((Exp = fopen(ExpFile, "w")) == NULL) {
		perror("FATAL ERROR: Can't open nodes.data");
#ifdef MEMWATCH
                mwTerm();
#endif
		exit(1);
	}

	nodeshdr.hdrsize = sizeof(nodeshdr);
	nodeshdr.recsize = sizeof(nodes);
	nodeshdr.filegrp = CFG.tic_groups * 13;
	nodeshdr.mailgrp = CFG.toss_groups * 13;
	fwrite(&nodeshdr, sizeof(nodeshdr), 1, Exp);

	Area = 0;
	while ((fgets(Temp, 80, Imp)) != NULL) {
		/* Sysop */
		Area++;
		Striplf(Temp);
		printf("%4d %s\r", Area, Temp);
		fflush(stdout);
		memset(&nodes, 0, sizeof(nodes));
		strncpy(nodes.Sysop, Temp, 35);

		/* Aka's */
		for (j = 0; j <= 20; j++) {
			fgets(Temp, 80, Imp);
			Striplf(Temp);
			nodes.Aka[j].zone = atoi(Temp);
			fgets(Temp, 80, Imp);
			Striplf(Temp);
			nodes.Aka[j].net = atoi(Temp);
			fgets(Temp, 80, Imp);
			Striplf(Temp);
			nodes.Aka[j].node = atoi(Temp);
			fgets(Temp, 80, Imp);
			Striplf(Temp);
			nodes.Aka[j].point = atoi(Temp);
			if (nodes.Aka[j].zone != 0) {
				if (SearchFidonet(nodes.Aka[j].zone))
					strcpy(nodes.Aka[j].domain, fidonet.domain);
				else {
					fclose(Imp);
					fclose(Exp);
					printf("PANIC: Fidonet zone %d not in fidonet.data\n\n", nodes.Aka[j].zone);
#ifdef MEMWATCH
                        		mwTerm();
#endif
					exit(1);
				}
			}
		}

		/* Passwords and uplink */
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(nodes.Fpasswd, Temp, 15);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(nodes.Apasswd, Temp, 15);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(nodes.UplFmgrPgm, Temp, 8);
		fgets(Temp, 80, Imp);
		Striplf(Temp);
		strncpy(nodes.UplFmgrPass, Temp, 15);

		/* When I was this far I remembered something about Macro's... */
		/* Flags */
		GT
		nodes.Direct = atoi(Temp);
		GT
		nodes.Message = atoi(Temp);
		GT
		nodes.Tic = atoi(Temp);
		GT
		nodes.Notify = atoi(Temp);
		GT
		nodes.FileFwd = atoi(Temp);
		GT
		nodes.AdvTic = atoi(Temp);
		GT
		nodes.Billing = atoi(Temp);
		GT
		nodes.BillDirect = atoi(Temp);
		GT
		nodes.Crash = atoi(Temp);
		GT
		nodes.Hold = atoi(Temp);
		nodes.AddPlus = TRUE;
		
		/* Skip archiver */
		GT

		/* Statistics */
		GT
//		nodes.TotalSend.kbytes = atoi(Temp);
		GT
//		nodes.TotalRcvd.kbytes = atoi(Temp);
		GT
//		nodes.TmSend.kbytes = atoi(Temp);
		GT
//		nodes.TmRcvd.kbytes = atoi(Temp);
		GT
//		nodes.LmSend.kbytes = atoi(Temp);
		GT
//		nodes.LmRcvd.kbytes = atoi(Temp);

		/* Dates */
		GT
		nodes.StartDate = atoi(Temp);
		GT
		nodes.Credit = atoi(Temp);
		GT
		nodes.Debet = atoi(Temp);
		GT
		nodes.AddPerc = atoi(Temp);
		GT
		nodes.WarnLevel = atoi(Temp);
		GT
		nodes.StopLevel = atoi(Temp);

		GT
		nodes.RouteVia.zone = atoi(Temp);
		GT
		nodes.RouteVia.net = atoi(Temp);
		GT
		nodes.RouteVia.node = atoi(Temp);
		GT
		nodes.RouteVia.point = atoi(Temp);
		if (nodes.RouteVia.zone != 0) {
			if (SearchFidonet(nodes.RouteVia.zone))
				strcpy(nodes.RouteVia.domain, fidonet.domain);
			else {
				fclose(Imp);
				fclose(Exp);
				printf("PANIC: Fidonet zone %d not in fidonet.data\n\n", nodes.RouteVia.zone);
#ifdef MEMWATCH
                        	mwTerm();
#endif
				exit(1);
			}
		}

		fwrite(&nodes, nodeshdr.recsize, 1, Exp);

		for (i = 1; i <= (nodeshdr.filegrp / 13); i++) {
			memset(&group, 0, 13);
			GT
			strcpy(group, Temp);
			fwrite(&group, 13, 1, Exp);
		}

		memset(&group, 0, 13);
		for (i = 1; i <= (nodeshdr.mailgrp / 13); i++)
			fwrite(&group, 13, 1, Exp);

		printf("                                             \r");		
		fflush(stdout);
	}
	fclose(Imp);
	fclose(Exp);
	printf("\n\nDone.\n");
#ifdef MEMWATCH
        mwTerm();
#endif
	exit(0);
}



int main(int argc, char **argv)
{
	time_t	Now;
	struct  tm *t;

#ifdef MEMWATCH
	mwInit();
#endif

	Now = time(NULL);
	t = localtime(&Now);
	Diw = t->tm_wday;
	Miy = t->tm_mon;
	if (Miy == 0)
		PMiy = 11;
	else
		PMiy = Miy - 1;

	TermInit(1);

	clear();
	colour(15, 0);
	printf("\nIMPORT: MBSE BBS %s Database Import utility\n", MBSEVersion);
	colour(14, 0);
	printf("        %s\n\n", Copyright);
	colour(7, 0);
	
	if (argc != 2)
		HelpMsg();

	InitConfig();
	InitFidonet();
	umask(007);

	if (strcmp(*(argv +1), "-users") == 0) 
		ImportUser();

	if (strcmp(*(argv +1), "-mareas") == 0)
		ImportMsgs();

	if (strcmp(*(argv +1), "-nodes") == 0)
		ImportNodes();

	if (strcmp(*(argv +1), "-fgroups") == 0)
		ImportFGroups();

	if (strcmp(*(argv +1), "-fareas") == 0)
		ImportFAreas();

	if (strcmp(*(argv +1), "-fdb") == 0)
		ImportFDB();

	HelpMsg();
	return 0;
}



