#!/bin/sh
#
# Basic setup script for MBSE BBS
#
# (C) Michiel Broek, v0.11 08-Oct-2000
#
# Customisation section, change the next variables to your need.
# However, all docs refer to the setup below.
#
# Basic bbs root directory.
clear
MHOME=/opt/mbse
PATH=/bin:/sbin:/usr/bin:/usr/sbin:

echo "MBSE BBS for Linux first time setup. Checking your system..."

# Basic checks.
if [ `whoami` != "root" ]; then
cat << EOF
*** Run $0 as root only! ***

  Because some of the system files must be changed, you must be root
  to use this script.

*** SETUP aborted ***
EOF
	exit 2
fi

if [ "$MBSE_ROOT" != "" ]; then
	echo "*** The MBSE_ROOT variable exists: $MBSE_ROOT ***"
	echo "*** SETUP aborted ***"
	exit 2
fi

if [ "`grep mbse: /etc/passwd`" != "" ]; then
	echo "*** User 'mbse' already exists on this system ***"
	echo "*** SETUP aborted ***"
	exit 2
fi

if [ "`grep bbs: /etc/group`" != "" ]; then
	echo "*** Group 'bbs' already exists on this system ***"
	echo "*** SETUP aborted ***"
	exit 2
fi

if [ -f /etc/passwd.lock ]; then
	echo "*** The password file is locked, make sure that nobody"
	echo "    is using any password utilities. ***"
	echo "*** SETUP aborted ***"
	exit 2
fi

if [ -d /opt ]; then
	echo " Directory /opt already present."
else
	mkdir /opt
	echo " Directory /opt created."
fi

cat << EOF
Basic checks done.

    Everything looks allright to start the installation now.
    Next the script will install a new group 'bbs' and two new
    users, 'mbse' which is the bbs system account, and 'bbs' which
    is the login account for bbs users. This account will have no
    password! The shell for this account is the main bbs program.

    One final important note: This script will make changes to some
    of your system files. Because I don't have access to all kinds of
    distributions and configurations there is no garantee that this
    script is perfect. Please make sure you have a recent system backup.
    Also make sure you have resque boot disks and know how to repair
    your system. It might also be wise to login as root on another
    virtual console incase something goes wrong with system login.

    If you are not sure, or forgot something, hit Control-C now or
    press Enter to start the installation.

EOF
read junk

echo "Installing MBSE BBS for the first time..."
echo ""
echo -n "Adding group 'bbs'"
groupadd bbs
echo -n ", user 'mbse'"
useradd -c "MBSE BBS Admin" -d $MHOME -g bbs -G uucp -m -s /bin/bash mbse
chmod 770 $MHOME

echo -n " writing '$MHOME/.profile'"
cat << EOF >$MHOME/.profile
# profile for mbse
#
export PATH=\$HOME/bin:\$PATH
export MBSE_ROOT=\$HOME
export GOLDED=\$HOME/etc
EOF
echo ""

# On some systems there is a .bashrc file in the users homedir.
# It must be removed.
if [ -f $MHOME/.bashrc ] || [ -f $MHOME/.bash_profile ]; then
      echo "Removing '$MHOME/.bash*'"
      rm -f $MHOME/.bash*
fi

echo ""
echo "Now set the login password for 'mbse'"
passwd mbse

echo -n "Adding user 'bbs'"
mkdir $MHOME/home
chown mbse.bbs $MHOME/home
chmod 775 $MHOME/home
useradd -c "MBSE BBS Login" -d $MHOME/home/bbs -g bbs -s $MHOME/bin/mbsebbs bbs
# Some systems (RedHat and Mandrake) insist on creating a users homedir.
# These are full of garbage we don't need. Kill it first.
if [ -d $MHOME/home/bbs ]; then
	rm -Rf $MHOME/home/bbs
fi
mkdir $MHOME/home/bbs
chmod 770 $MHOME/home/bbs
chown mbse.bbs $MHOME/home/bbs
touch $MHOME/home/bbs/.hushlogin

echo ", removing password:"
echo -n "$$" >/etc/passwd.lock
if [ -f /etc/shadow ]; then
	# Not all systems are the same...
	if [ "`grep bbs:\!\!: /etc/shadow`" != "" ]; then
		sed /bbs:\!\!:/s/bbs:\!\!:/bbs::/ /etc/shadow >/etc/shadow.bbs
	else
		sed /bbs:\!:/s/bbs:\!:/bbs::/ /etc/shadow >/etc/shadow.bbs
	fi
	mv /etc/shadow /etc/shadow.mbse
	mv /etc/shadow.bbs /etc/shadow
	if [ -d /etc/rc.6 ]; then
		# Debian uses other ownership of /etc/shadow
		chmod 640 /etc/shadow
		chgrp shadow /etc/shadow
	else
		chmod 600 /etc/shadow
	fi
	echo " File /etc/shadow.mbse is your backup of /etc/shadow"
else
        if [ grep bbs:\!\!: /etc/passwd != "" ]; then
                sed /bbs:\!\!:/s/bbs:\!\!:/bbs::/ /etc/passwd >/etc/passwd.bbs
        else
                sed /bbs:\!:/s/bbs:\!:/bbs::/ /etc/passwd >/etc/passwd.bbs
        fi
	mv /etc/passwd /etc/passwd.mbse
	mv /etc/passwd.bbs /etc/passwd
        chmod 644 /etc/passwd
	echo " File /etc/passwd.mbse is your backup of /etc/passwd"
fi
rm /etc/passwd.lock
echo ""

if [ "`grep binkd /etc/services`" = "" ]; then
        BINKD=TRUE
else
        BINKD=FALSE
fi
if [ "`grep fido /etc/services`" = "" ]; then
	FIDO=TRUE
else
	FIDO=FALSE
fi
if [ "`grep mbse /etc/services`" = "" ]; then
	MBSE=TRUE
else
	MBSE=FALSE
fi
if [ "$FIDO" = "TRUE" ] || [ "$MBSE" = "TRUE" ] || [ "$BINKD" = "TRUE" ]; then
	echo -n "Modifying /etc/services"
	mv /etc/services /etc/services.mbse
	cat /etc/services.mbse >/etc/services
	echo "#" >>/etc/services
	echo "# Unofficial for MBSE BBS" >>/etc/services
	echo "#" >>/etc/services
	if [ "$BINKD" = "TRUE" ]; then
		echo -n ", binkd at port 24554"
		echo "binkd		24554/tcp		# mbcico IBN mode">>/etc/services
	fi
	if [ "$FIDO" = "TRUE" ]; then
		echo -n ", fido at port 60179"
		echo "tfido		60177/tcp		# mbcico ITN mode">>/etc/services
		echo "fido		60179/tcp		# mbcico IFC mode">>/etc/services
	fi
	if [ "$MBSE" = "TRUE" ]; then
		echo -n ", mbse at port 60180"
		echo "mbse		60180/tcp		# MBSE BBS deamon">>/etc/services
	fi
	chmod 644 /etc/services
	echo ", done."
fi


if [ "`grep mbcico /etc/inetd.conf`" = "" ]; then
	echo -n "Modifying /etc/inetd.conf"
	mv /etc/inetd.conf /etc/inetd.conf.mbse
	cat /etc/inetd.conf.mbse >/etc/inetd.conf
cat << EOF >>/etc/inetd.conf

#:MBSE-BBS: bbs service
binkd	stream	tcp	nowait	mbse	$MHOME/bin/mbcico	mbcico -t ibn
tfido	stream	tcp	nowait	mbse	$MHOME/bin/mbcico	mbcico -t itn
fido	stream	tcp	nowait	mbse	$MHOME/bin/mbcico	mbcico -t ifc

EOF
	chmod 644 /etc/inetd.conf
	if [ -f /var/run/inetd.pid ]; then
		echo -n ", restarting inetd"
		kill -HUP `cat /var/run/inetd.pid`
	fi
	echo ", done."
fi



# Add startup scripts, Slackware:
if [ -f /etc/rc.d/rc.0 ]; then
    if [ -f /etc/rc.d/rc.local ]; then
	echo "You are running Slackware Linux."
	echo "Adding MBSE BBS start/stop scripts:"
	mv /etc/rc.d/rc.local /etc/rc.d/rc.local.mbse
	cat /etc/rc.d/rc.local.mbse >/etc/rc.d/rc.local
	echo "# Start MBSE BBS" >>/etc/rc.d/rc.local
	echo "/opt/mbse/etc/rc" >>/etc/rc.d/rc.local
	chmod 755 /etc/rc.d/rc.local
	echo "  /etc/rc.d/rc.local.mbse is a backup file."
	echo ""
	echo "   You must manualy insert the lines '$MHOME/etc/rc.shutdown'"
	echo "   into /etc/rc.d/rc.0 and /etc/rc.d/rc.K If you don't do it"
	echo "   everything will work also, but MBSE BBS isn't proper closed"
	echo "   if you halt or reboot your system."
    fi
fi


# Add startup scripts, RedHat and Mandrake, but not SuSE:
if [ -d /etc/profile.d ]; then
    if [ ! -f /etc/rc.config ]; then

	SU="su"
	if [ -f /etc/redhat-release ]; then
		RHR=`cat /etc/redhat-release | awk '{ print $5 }' | tr -d .`
		if [ $RHR -gt 60 ]; then
			echo "You are running RedHat v6.1 or newer"
			SU="su -"
		else
			echo "You are running RedHat v6.0 or older"
		fi
	else
		echo "You are running Mandrake."
	fi
	echo "Adding startup file /etc/rc.d/init.d/mbsed"

cat << EOF >/etc/rc.d/init.d/mbsed
#!/bin/sh
#
# chkconfig: 345 99 05
# description: Starts and stops the MBSE BBS.
#
# For RedHat and Mandrake SYSV init style.
# 23-Jan-2000 M. Broek
#
# Source function library.
. /etc/rc.d/init.d/functions

# Source networking configuration.
. /etc/sysconfig/network

# Check that networking is up.
[ \${NETWORKING} = "no" ] && exit 1

# Find the MBSE_ROOT from the /etc/passwd file.
MBSE_ROOT=\`cat /etc/passwd | grep mbse: | awk -F ':' '{ print \$6}'\`

if [ "\$MBSE_ROOT" = "" ]
then
	echo "MBSE BBS: No 'mbse' user in the password file."
	exit 1
fi

if [ ! -d \$MBSE_ROOT ]
then
	echo "MBSE BBS: Home directory '\$MBSE_ROOT' not found."
	exit 1
fi

# Check that mbsed.conf exists.
if [ ! -f \$MBSE_ROOT/etc/mbsed.conf ]; then
   echo "MBSE BBS: \$MBSE_ROOT/etc/mbsed.conf not found."
   exit 1
fi

export MBSE_ROOT

# See how we were called.
case "\$1" in
  start)
	echo -n "Starting MBSE BBS: "
	rm -f \$MBSE_ROOT/sema/*
	rm -f \$MBSE_ROOT/var/reginfo.LCK
	$SU mbse -c '\$MBSE_ROOT/bin/mbsed' >/dev/null
	echo -n "mbsed "
	if [ -f \$MBSE_ROOT/etc/config.data ]; then
		$SU mbse -c '\$MBSE_ROOT/bin/mbstat open -quiet'
		echo "opened"
	fi
	touch /var/lock/subsys/mbsed
	;;
  stop)
	echo -n "Shutting down MBSE BBS: "
	if [ -f \$MBSE_ROOT/etc/config.data ]; then
		echo -n "logoff users "
		$SU mbse -c '\$MBSE_ROOT/bin/mbstat close wait -quiet' >/dev/null
		echo -n "done, "
	fi
	echo -n "stop mbsed: "
	killproc mbsed -9
	rm -f /var/lock/subsys/mbsed
	echo "done."
	;;
  status)
	status mbsed
	;;
  restart)
	echo "Restarting MBSE BBS: just kidding!"
	;;
  *)
	echo "Usage: mbsed {start|stop|restart|status}"
	exit 1
esac

exit 0
EOF
	chmod 755 /etc/rc.d/init.d/mbsed
	echo "With the runlevel editor, 'tksysv' if you are running X,"
	echo "or 'ntsysv' if you are running virtual consoles, you must"
	echo "now add 'mbsed' start to the default runlevel, and 'mbsed'"
	echo "stop to runlevels 0 and 6"
   fi
fi



# Startup script for Debian Linux. According to Petric Frank this should
# also work on SuSE systems.
#
if [ -d /etc/rc6.d ] || [ -f /etc/rc.config ]; then
	echo "You are running Debian Linux or SuSE."
cat << EOF >/etc/init.d/mbsebbs
#!/bin/sh
#
# Note: this is not 100% Debian style, at least it works for now.
# 10-Sep-1999 Michiel Broek.
#  
# description: Starts and stops the MBSE BBS.

# For Debian/SuSE SYSV init style.

# Find the MBSE_ROOT from the /etc/passwd file.
MBSE_ROOT=\`cat /etc/passwd | grep mbse: | awk -F ':' '{ print \$6}'\`

if [ "\$MBSE_ROOT" = "" ]; then
	echo "MBSE BBS: No 'mbse' user in the password file."
	exit 1
fi

if [ ! -d \$MBSE_ROOT ]; then 
	echo "MBSE BBS: Home directory '\$MBSE_ROOT' not found."
	exit 1
fi

PATH=/sbin:/bin:/usr/sbin:/usr/bin:\$MBSE_ROOT/bin
DAEMON=\$MBSE_ROOT/bin/mbsed
NAME=mbsed
DESC="MBSE BBS"


# Check that mbsed.conf exists.
if [ ! -f \$MBSE_ROOT/etc/mbsed.conf ]; then
   echo "MBSE BBS: \$MBSE_ROOT/etc/mbsed.conf not found."
   exit 1
fi

export MBSE_ROOT

# See how we were called.
case "\$1" in
  start)
	echo -n "Starting \$DESC: "
	rm -f \$MBSE_ROOT/sema/*
	su mbse -c '\$MBSE_ROOT/bin/mbsed' >/dev/null
	echo -n "\$NAME"
	if [ -f \$MBSE_ROOT/etc/config.data ]; then
		su mbse -c '\$MBSE_ROOT/bin/mbstat open -quiet'
		echo -n "opened "
	fi
	echo "done."
	;;
  stop)
	echo -n "Stopping \$DESC: "
	if [ -f \$MBSE_ROOT/etc/config.data ]; then
		echo -n "logoff users "
		su mbse -c '\$MBSE_ROOT/bin/mbstat close wait -quiet' >/dev/null
	fi
        start-stop-daemon --stop --signal 9 --user mbse
	echo "\$NAME done."
	;;
  force-reload|restart)
	echo "Restarting \$DESC: is not possible, done."
	;;
  *)
	N=/etc/init.d/\$NAME
	echo "Usage: \$N {start|stop|restart|force-reload}" >&2
	exit 1
esac

exit 0
EOF
	chmod 755 /etc/init.d/mbsebbs
	update-rc.d mbsebbs defaults
	echo "Debian install ready."
fi

echo ""
echo "Press Enter to continue"
read junk

cat << EOF
     The script made it to the end, that looks good. Before you logout do some
     sanity checks;

     1. Can you still login as a normal user.

     2. Login on another virtual console, network or whatever as user 'mbse'.
        Then type 'echo \$MBSE_ROOT'. Does this show the path to
        '$MHOME' or nothing. 

     3. Login on another virtual console as user 'bbs'. It should not ask for
        a password, but should direct try to start the bbs. This is not
        installed yet but you should see error messages and then be logged out.

     If these three tests weren't successfull, restore /etc/passwd and
     or /etc/shadow, the backup copies have the extension '.mbse'.
     Then issue (as root of course) the following commands:

       userdel bbs
       userdel -r mbse
       groupdel bbs
EOF

