Program FSE;
Uses Crt,extense;

Const
 Up     = 1;Down   = 2;Left   = 3;Right  = 04;Enter  = 05;Home   = 6;
 EndKey = 7;PageUp = 8;PageDn = 9;Escape = 10;BackSp = 11;

Type BufType = Array[1..100,0..159] of Byte;

Var Buffer  : ^BufType;
    Width   : Byte;  { Width of Window in Spaces     }
    Top     : Byte;  { ScrollDown Marker             }
    XPos    : Byte;  { X Position in Window          }
    YPos    : Byte;  { Y Position in Window          }
    Attrib  : Byte;  { Current Color                 }
    CH      : Char;  { Dummy Character               }
    Key     : Byte;  { Dummy Byte                    }
    X,Y,Z   : Byte;  { Dummy Counters                }
    Done    : Boolean; { End Fullscreen Editor?      }
    Console : Text;
    WorkColor : Byte;

    StartX,StartY       : Byte;
    EndX,EndY           : Byte;
    QuickPalX,QuickPalY : Byte;
    ColorBarX,ColorBarY : Byte;
    InputX,InputY       : Byte;

Procedure GotoXy(X,Y : Byte);
Begin
 Write(Console,#27+'['+Strr(Y)+';'+Strr(X)+'H');
End;

Procedure Redraw;
Begin
 For Y := 1 to (EndY-StartY+1) do
 Begin
  GotoXy(StartX,StartY+Y-1);
  For X := 0 to Width do
   Begin
    TextAttr := Buffer^[Y+Top-1,X*2+1];
    Write  (Chr(Buffer^[Y+Top-1,X*2]));
   End;
 End;
 GotoXy(StartX+Xpos-1,StartY+Ypos-1);
End;

Procedure Ansi_Up;
Begin
 Write(Console,#27+'[A');
End;

Procedure Ansi_Down;
Begin
 Write(Console,#27+'[B');
End;

Procedure Ansi_Left(N : Byte);
Begin
 Write(Console,#27+'['+Strr(N)+'D');
End;

Procedure Ansi_Right(N : Byte);
Begin
 Write(Console,#27+'['+Strr(N)+'C');
End;

Procedure ScrollDown;
Begin
 If Top+(EndY-StartY) < 100 then
  Begin
   Inc(Top);
   Redraw;
  End;
End;

Procedure MoveDown;
Begin
 If YPos < (EndY - StartY+1) then
  Begin
   Inc(Ypos);
   Ansi_Down;
  End else ScrollDown;
End;

Procedure ScrollUp;
Begin
 If Top > 1 then
  Begin
   Dec(Top,1);
   Redraw;
  End;
End;

Procedure MoveUp;
Begin
 If YPos > 1 then
  Begin
   Dec(YPos,1);
   Ansi_Up;
  End else ScrollUp;
End;

Procedure ChangeColor(Attribute : Byte);
Const AnsiFG : Array[0..7] of Byte = (30,34,32,36,31,35,33,37);
      AnsiBG : Array[0..7] of Byte = (40,44,42,46,41,45,43,47);
Var FG,BG : Byte;
    High  : Byte;
Begin
 FG := Attribute and $0f;
 BG := (Attribute and $f0) shr 4;
 If FG > 7 then High := 1 else High := 0;
 If High = 1 then Dec(FG,8);
 Write(Console,#27+'['+Strr(High)+';'+Strr(AnsiFG[FG])+';'+Strr(AnsiBG[BG])+'m');
End;

Procedure ShowAnsi;
Var TFile : Text;
Begin
Assign(TFile,'FSE.ANS');
{$I-} Reset(TFile); {$I+}
If IOResult <> 0 then Exit;
Assign(Console,'');
Rewrite(Console);
Repeat
 Read(TFile,CH);
 If CH <> '^' then Write(Console,CH) else
  Begin
   Read(TFile,CH);
   Case CH of
    '1' : Begin
           StartX := WhereX;
           StartY := WhereY;
           Ansi_Right(2);
          End;
    '2' : Begin
           EndX := WhereX;
           EndY := WhereY;
           Ansi_Right(2);
          End;
    '3' : Begin
           QuickPalX := WhereX;
           QuickPalY := WhereY;
           Ansi_Right(2);
          End;
     else Write(Console,'^'+CH);
   End;
  End;
Until Eof(TFile);
Width := EndX - StartX;
Close(TFile);
Close(Console);
End;

Function GrabKey : Byte;
Var C1,C2 : Char;
Begin
 C1 := Readkey;If C1 = #0 then C2 := Readkey;
   Case C1 of
    #13 : GrabKey := Enter;
    #27 : GrabKey := Escape;
    #8  : GrabKey := BackSp;
     else GrabKey := Ord(C1);
   Case C2 of
    #72 : GrabKey := Up;
    #80 : GrabKey := Down;
    #75 : GrabKey := Left;
    #77 : GrabKey := Right;
    #71 : GrabKey := Home;
    #79 : GrabKey := EndKey;
    #73 : GrabKey := PageUp;
    #81 : GrabKey := PageDn;
     else GrabKey := Ord(C1);
   End;
   End;
End;

Procedure QuickPallette;
Var TFile : Text;
    Y : Byte;
    Line : String;
    Donewithquickpallette : boolean;
 Foreground,background : Byte;
Begin
 Assign(TFile,'FSEQP.ANS');
 {$I-} Reset(TFile); {$I+}
 If IOResult <> 0 then Exit;
 Y := 0;
 Repeat
  Inc(Y);
  Readln(TFile,Line);
  GotoXy(QuickPalX,QuickPalY+Y-1);
  For X := 1 to Length(Line) do
   Begin
     Case Line[X] of
      '|' : Begin
             If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
              Begin
               ColorBarX := WhereX;
               ColorBarY := WhereY;
               Ansi_Right(3);
               Inc(X,2);
              End;
            End;
      '&' : Begin
             InputX := WhereX;
             InputY := WhereY;
             Ansi_Right(1);
            End;
         Else Write(Console,Line[X]);
     End;
{    If Line[X] = '|' then
     Begin
      If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
       Begin
        ColorBarX := WhereX;
        ColorBarY := WhereY;
       End;
     End;
    If Line[X] = '&' then
     Begin
      InputX := WhereX;
      InputY := WhereY;
     End;
    Write(Console,Line[X]);}
   End;
 Until Eof(TFile);
 Close(TFile);
 GotoXy(ColorBarX,ColorBarY);
 PipeWrite('|07 |01 |02 |03 |04 |05 |06 |07 |08 |09 |10 |11 |12 |13 |14 |15');
 DoneWithQuickPallette := False;
 Foreground := (Attrib and $0f);
 Background := (Attrib and $f0) shr 4;
 GotoXy(InputX,InputY);Write(Console,' ');Ansi_Left(1);
 Repeat
  GotoXy(ColorBarX+(Foreground*2),ColorBarY-1); Write(Console,'');
  GotoXy(ColorBarX+(Background*2),ColorBarY+1); Write(Console,'');
  GotoXy(InputX,InputY);
  Key := Grabkey;
  Case Key of
   Ord('A'),Ord('a'),Ord('S'),Ord('s'),Ord('Q'),Ord('q') : Write(Console,Chr(Key));
  End;
  Case Key of
   Ord('a'),
   Ord('A') : Begin
               Done := True;
               doneWithQuickpallette := True;
              End;
   Enter,Escape : DoneWithQuickpallette := True;
   Left   : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             Write(Console,' ');
             If Foreground > 0 then Dec(Foreground) else Foreground := 15;
            End;
   Right  : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             Write(Console,' ');
             If Foreground < 15 then Inc(Foreground) else Foreground := 0;
            End;
    Up    : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             Write(Console,' ');
             If Background < 7 then Inc(Background) else Background := 0;
            End;
    Down  : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             Write(Console,' ');
             If Background > 0 then Dec(Background) else Background := 7;
            End;
  End;
 until DoneWithQuickPallette;
 Key := 0;
 Redraw;
 Attrib := Background shl 4 + foreground;
End;

Begin
 ShowAnsi;
 Assign(Console,'');
 REwrite(Console);
 Top := 1;CH := #0;X := 0;Y := 0;Z := 0;XPos := 1;YPos := 1;Done := False;
 Textcolor(7);Textbackground(0);
 Attrib := 7;
 Getmem(Buffer,SizeOf(Buffer));
 FillWord(Buffer^,SizeOf(buffer^) div 2,$0720);
 GotoXy(StartX,StartY);
 WorkColor := 7;
 ChangeColor(WorkColor);
 Repeat
  Key := 0;
  Key := Grabkey;
  If (XPos = 1) and (Key = Ord('/')) then QuickPallette;
  Case Key of
   Escape : QuickPallette;
   BackSp : If XPos > 1 then
            Begin
             Dec(Xpos);
             Buffer^[YPos+Top-1,XPos*2-2] := 32;
             Buffer^[YPos+Top-1,XPos*2-1] := 7;
             Ansi_Left(1);
             Write(Console,' ');
             Ansi_Left(1);
            End;
   Left   : If XPos > 1 then
             Begin
              Dec(Xpos);
              Ansi_left(1);
             End;
   PageUp : Inc(WorkColor);
   PageDn : Dec(WorkColor);
   Right  : If XPos < (EndX-StartX) then
            Begin
             Inc(XPos);
             Ansi_Right(1);
            End;
   Home   : Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   EndKey : Begin
             XPos := Width;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   Down   : MoveDown;
   Up     : MoveUp;
   Enter  : Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
             MoveDown;
            End;
  30..254 : Begin
             Buffer^[YPos+Top-1,XPos*2-2] := Key;
             Buffer^[YPos+Top-1,XPos*2-1] := Attrib;
             ChangeColor(Attrib);
             Write(Console,Chr(key));
             If XPos < (EndX-StartX) then Inc(XPos) else
              Begin
               XPos := 1;
               GotoXy(StartX+Xpos-1,StartY+Ypos-1);
               MoveDown;
              End;
            End;
  End;
 Until Done;
 Close(Console);
 Freemem(Buffer,Sizeof(Buffer));
End.