{$A+,B+,D-,E+,F+,I+,L-,N-,O+,R-,S+,V-}
UNIT MENUS;
INTERFACE
USES DOS,CRT,TOTLINK,STRINGS,PULLMENU,SUBS1,GENTYPES,IO,PROMPT,FILEXFER,
BCHAT,USER,LASTCALL,GENERAL,DATAAREA,fse,MESSAGE;
  PROCEDURE KILLIT;
  PROCEDURE RUNMENU;
  procedure loadmenu(name:String);
  PROCEDURE NEWIT;
  CONST LOGOFF       : BOOLEAN = FALSE;
IMPLEMENTATION

TYPE

  menurec =                        { *.Mnu : Menu records }
  Record
    Name: String [8];              { used to specify which menu to load }
    prompt: String;                { menu prompt if script or name }
    helpfile: PathStr;             { help or pulldown display file }
    acs: STRING;                   { minimum acs requirements }
    password: STRING;              { password required }
    Special: String [2];           { menu type }
    FallBack: String [8];          { menu to set as fallback }
  End;

  pullinfo=
  Record
    ON:STRING;
    OFF:STRING;
    X:1..80;
    Y:1..25;
    END;

  commandrec =                { *.Cmd : Command records }
  Record
    desc: string[30];              { description for generics and reference only }
    keys: string[30];              { command-execution keys }
    acs: string[30];               { minimum acs requirements }
    data: String [2];              { the actual command }
    param: String;                 { command data }
    pull: PULLINFO;            { for pulldown menus }
    hidden: boolean;               { should command show up in generic menus? }
    pause: boolean;                { wait for enter after command? }
  End;

  var menu:Menurec;
  var cmdlist: pDllobj;
  VAR command:commandrec;
  Const
  FailFlag     : Boolean = False;
  NewMenu      : Boolean = False;
  RunFirstCmd  : Boolean = True;
  BadMenu      : Boolean = False;
  MaxInLen     : Byte = 80;
  TopMenu      : String[8] = '';
  CurMenu      : String[8] = '';
  BadCommandStr: String = '';
  InputStr     : String = '';
  WildCardStr  : String = '';

  PROCEDURE NEWIT;
  BEGIN
  NEW(CMDLIST,INIT);
  END;

  PROCEDURE PROCESS(C:COMMANDREC);
  BEGIN
  IF C.DATA='-L' THEN BEGIN
  LOGINBBS;
  IF LOGINGOOD THEN BEGIN
  CMDLIST^.EMPTYLIST;
  NEWMENU:=TRUE;
  LOADMENU('STARTUP');
  END;
  END
  ELSE
  IF C.DATA='-G' THEN BEGIN
  LOGOFF:=TRUE;
{  CMDLIST^.EMPTYLIST;
  CMDLIST^.DONE;}
  END
  ELSE
  IF C.DATA='LM' THEN BEGIN
  CMDLIST^.EMPTYLIST;
  NEWMENU:=TRUE;
  LOADMENU(COMMAND.PARAM);
  currentAREA:=MENU.NAME;
  END
  ELSE
  if c.data='AP' THEN APPLY
  ELSE
  IF C.DATA='AA' THEN ADDAREA
  ELSE
  IF C.DATA='PF' THEN PRINTFILE(C.PARAM,BASICMCI,FALSE) ELSE
  IF C.DATA='LF' THEN LISTFILES
  ELSE
  IF C.DATA='LC' THEN LASTCALLERS ELSE
  IF C.DATA='UC' THEN USERCFG ELSE
  IF C.DATA='RC' THEN PAGE ELSE
  IF C.DATA='DL' THEN LOADIT(VALU(C.PARAM)) ELSE
  IF C.DATA='DA' THEN RUNADD ELSE
  IF C.DATA='DI' THEN RUNIT ELSE
  IF C.DATA='DR' THEN RANDOMPICK(VALU(C.PARAM)) ELSE
  IF C.DATA='OA' THEN ONELINERS(TRUE) ELSE
  IF C.DATA='OL' THEN ONELINERS(FALSE) ELSE
  IF C.DATA='UL' THEN USERLIST ELSE
  {}
  IF C.DATA='FA' THEN ADDAREA ELSE
  IF C.DATA='FL' THEN LISTFILES ELSE
  IF C.DATA='FD' THEN DOWNLOAD ELSE
  IF C.DATA='FU' THEN upload else
  IF C.DATA='FR' THEN LISTAREAS ELSE
  IF C.DATA='FM' THEN MASSUPLOAd ELSE
  {}
  END;

  procedure loadmenu(name:String);
  var f:FILE OF MENUREC;
  VAR    G:FILE OF COMMANDREC;
  VAR    X:INTEGER;
  begin
  assign(f,name+'.DAT');
  reset(f);
  FILLCHAR(MENU,SIZEOF(MENU),#0);
  READ(F,MENU);
  CLOSE(F);
  assign(G,name+'.MNU');
  reset(G);
  X:=0;
  REPEAT
  SEEK(G,X);
  FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
  READ(G,COMMAND);
  IF COMMAND.KEYS='!ONCE' THEN PROCESS(COMMAND) ELSE
  IF COMMAND.KEYS='!EVERY' THEN BEGIN;
{  PROCESS(COMMAND);}
  CMDLIST^. Add (Command, Sizeof (Command));
  END ELSE CMDLIST^. Add (Command, Sizeof (Command));
  INC(X);
  UNTIL EOF(G);
  CLOSE(G);
  end;

  PROCEDURE ADDCOMMAND(NAME:STRING;A:COMMANDREC);
  VAR F:FILE OF COMMANDREC;
  BEGIN
  ASSIGN(F,NAME+'.MNU');
  {$I-} RESET(F); {$I+}
  IF IORESULT<>0 THEN REWRITE(F);
  SEEK(F,FILESIZE(f));
  WRITE(F,A);
  CLOSE(f);
  END;

  PROCEDURE KILLIT;
  BEGIN
  IF CMDLIST<>NIL THEN DISPOSE(CMDLIST);
  END;


  PROCEDURE RUNMENU;
  VAR E:INTEGER;
  VAR CHOICE:INTEGER;
  VAR INPUT:STRING[80];
  MAX:INTEGER;
  C:MCIS;
  Tx:INTEGER;
  LABEL START,START2;
  BEGIN
  START:
  SUBS1.PRINTFILE(MENU.HELPFILE,C,FALSE);
  START2:
  MAX:=CMDLIST^.TOTALNODES;
  IF MENU.SPECIAL='PD' THEN BEGIN
  FOR E:=1 TO MAX DO BEGIN
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (E), Command);
  PM.UNHIGHLIGHT[E]:=COMMAND.PULL.OFF;
  PM.HIGHLIGHT[E]  :=COMMAND.PULL.ON;
  PM.CX[E]         :=COMMAND.PULL.X;
  PM.CY[E]         :=COMMAND.PULL.Y;
  PM.MAXC:=CMDLIST^.TOTALNODES;
  PM.CURRENTCHOICE:=1;
  END;
  CHOICE:=PMENU;
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (CHOICE), Command);
  PROCESS(COMMAND);
  END ELSE
  IF MENU.SPECIAL='LI' THEN BEGIN
  SHOWPROMPT;
  INPUT:='';
  SREAD(INPUT);
  INPUT:=UPSTRING(INPUT);

  IF INPUT='' THEN BEGIN
                FOR E:=1 TO MAX DO BEGIN
                FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
                CMDLIST^. GetNodeData (CMDLIST^. NodePtr (E), Command);
                IF COMMAND.KEYS='!EVERY' THEN BEGIN
                                              WRITE('RAN2');
                                              READKEY;
                                              PROCESS(COMMAND);
                                              END;
                END;
                GOTO START2;
                END;
  FOR E:=1 TO MAX DO BEGIN
  FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (E), Command);
  IF COMMAND.KEYS='!EVERY' THEN PROCESS(COMMAND);
  IF INPUT=COMMAND.KEYS THEN PROCESS(COMMAND);
  END;
  END;
  END;

  BEGIN
  END.

