Unit totMISC;
{$I Sys75.Inc}

Interface

Uses
  spuds, DOS, TotFast, TotSys;

Procedure CloseTot;
Procedure iDelay (MS: Word);
Function  EnterFileName (Var F: String): Boolean;
Function  YesNo (Prompt1, Prompt2: String): Boolean;
Function  GetFileCrc (Var F: File; Minus: LongInt): Word;
Function  ValidPhone (ph: Str20): Boolean;
Function  ratio (L1, L2: LongInt): LongInt;
Function  ratiostr (L1, L2: LongInt): String;
Function  OpenFile (N: PathStr; Var F: File): Boolean;
Function  OpenText (N: PathStr; Var T: Text): Boolean;
Function  RandomFile (wc: PathStr): PathStr;
Function  ExistDir (Fname: DirStr): Boolean;
Function  CopyFile (SourceFile, TargetFile: String): ShortInt;
Function  DeleteFile (Filename: String): ShortInt;
Function  RenameFile (Oldname, NewName: String): ShortInt;
Function  FSize (Filename: String): LongInt;
Function  FTime (Filename: String): LongInt;
Procedure removerec (Var f: File; s, rs: LongInt);
Procedure insertrec (Var f: File; s, rs: LongInt);
Function  FileDrive (Full: String): Str2;
Function  FileDirectory (Full: String): pathStr;
Function  FileName (Full: String): nameStr;
Function  FileExt (Full: String): extstr;
Function  SlashedDirectory (Dir: String): pathStr;
Function  PrinterStatus: Byte;
Function  AlternatePrinterStatus: Byte;
Function  PrinterReady : Boolean;
Procedure ResetPrinter;
Function  ValidFileName (FN: String): ShortInt;
Procedure Beep;
Function  diskready (drive: Char): Boolean;
Function  AnsiSysInstalled: Boolean;
Function  GetFileCnt (W: PathStr): LongInt;
Function  HasWildcards (FName: String): Boolean;
procedure cleanpathname (var path: pathstr; allowdir: boolean);
function  fitswildcard (test, wc: str12): boolean;
function  getfileattr (p: pathstr): word;
procedure setfileattr (p: pathstr; w: word);
function  getfiletime (p: pathstr): longint;
procedure setfiletime (p: pathstr; l: longint);

(* APMISC *)
function  AddBackSlash(DirName : string) : string;
function  HasExtension(Name : string; var DotPos : Word) : Boolean;
function  DefaultExtension(Name : string; Ext : ExtStr) : string;
function  Exist(FName : string) : Boolean;

Var
  LPTport: Byte;

Implementation

Uses
  Crt, Crc,
  TotLook, TotStr, TotMsg, TotInput, TotIo1, TotKey, TotList, TotWin, TotLink;

const
  DosDelimSet : set of Char = ['\', ':', #0];
  Digits : array[0..$F] of Char = '0123456789ABCDEF';

Function ExistDir (Fname: DirStr): Boolean;
Var Inf: SearchRec;
Begin
  FindFirst (Fname, Directory + VolumeID, Inf);
  ExistDir := (DosError = 0) and ((inf. attr = directory) or (inf. attr = volumeid));
End;

Function CopyFile (SourceFile, TargetFile: String): ShortInt;
{return codes:  0 successful
                1 source and target the same
                2 cannot open source
                3 unable to create target
                4 error during copy
}
type
  tfilebuf = Array [0..16383] of byte;
Var
  Source,
  Target: File;
  BRead,
  Bwrite: Word;
  FileBuf: ^tfilebuf;
Begin
  getmem (filebuf, sizeof (tfilebuf));
  If SourceFile = TargetFile Then
    CopyFile := 1
  Else
  Begin
    Assign (Source, SourceFile);
    {$I-}
    Reset (Source, 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IOResult <> 0 Then
      CopyFile := 2
    Else
    Begin
      Assign (Target, TargetFile);
      {$I-}
      Rewrite (Target, 1);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IOResult <> 0 Then
        CopyFile := 3
      Else
      Begin
        Repeat
          BlockRead (Source, FileBuf^, sizeof (tfilebuf), BRead);
          BlockWrite (Target, FileBuf^, Bread, Bwrite);
        Until (Bread = 0) Or (Bread <> BWrite);
        Close (Source);
        Close (Target);
        If Bread <> Bwrite Then
          CopyFile := 4
        Else
          CopyFile := 0;
      End;
    End;
  End;
  freemem (filebuf, sizeof (tfilebuf));
End;

Function FSize (Filename: String): LongInt;                 {1.00c}
{returns  -1   if file not found}
Var FileInfo: SearchRec;
Begin
  FindFirst (Filename, AnyFile, FileInfo);
  If DosError = 0 Then
    FSize := FileInfo. Size
  Else
    FSize := - 1;
End;

Function  FTime (Filename: String): LongInt;
{returns  -1   if file not found}
Var FileInfo: SearchRec;
Begin
  FindFirst (Filename, AnyFile, FileInfo);
  If DosError = 0 Then
    FTime := FileInfo. Time
  Else
    FTime := - 1;
End;

Function FileSplit (Part: Byte; Full: String): String;
Var
  D : DirStr;
  N : NameStr;
  E : ExtStr;
Begin
  FSplit (Full, D, N, E);
  Case Part Of
    1 : FileSplit := D;
    2 : FileSplit := N;
    3 : FileSplit := E;
  End;
End;

Function FileDrive (Full: String): Str2;
Var
  Temp : String;
  P : Byte;
Begin
  Temp := FileSplit (1, Full);
  P := Pos (':', Temp);
  If P <> 2 Then
    FileDrive := ''
  Else
    FileDrive := UpCase (Temp [1] );
End;

Function FileDirectory (Full: String): pathStr;
Var
  Temp : String;
  P : Byte;
Begin
  Temp := FileSplit (1, Full);
  P := Pos (':', Temp);
  If P = 2 Then
    Delete (Temp, 1, 2);                 {remove drive}
  If (Temp [Length (Temp)]  = '\') And (temp <> '\') Then
    Delete (temp, Length (Temp), 1);      {remove last backslash}
  FileDirectory := Temp;
End;

Function FileName (Full: String): nameStr;
Begin
  FileName := FileSplit (2, Full);
End;

Function FileExt (Full: String): extStr;
Var
  Temp : String;
Begin
  Temp := FileSplit (3, Full);
  If (Temp = '') Or (Temp = '.') Then
    FileExt := ''
  Else
    FileExt := Copy (Temp, 2, 3);
End;

Function SlashedDirectory (Dir: String): pathStr;
Begin
  If (Dir = '') Or (Dir [Length (Dir)] In [':', '\'] ) Then
    SlashedDirectory := Dir
  Else
    SlashedDirectory := Dir + '\';
End;

Function PrinterStatus: Byte;
Var
  Recpack : Registers;
Begin
  With Recpack Do
  Begin
    AH := 2;
    DX := LPTport;
    Intr ($17, recpack);
    If (AH And $B8) = $90 Then
      PrinterStatus := 0        {all's well}
    Else If (AH And $20) = $20 Then
      PrinterStatus := 1        {no Paper}
    Else If (AH And $10) = $00 Then
      PrinterStatus := 2        {off line}
    Else If (AH And $80) = $00 Then
      PrinterStatus := 3        {busy}
    Else If (AH And $08) = $08 Then
      PrinterStatus := 4;       {undetermined error}
  End;
End;

Function AlternatePrinterStatus: Byte;
Var
  Recpack : Registers;
Begin
  With recpack Do
  Begin
    AH := 2;
    DX := LPTport;
    Intr ($17, recpack);
    If (AH And $20) = $20 Then
      AlternatePrinterStatus := 1  {no Paper}
    Else If (AH And $10) = $00 Then
      AlternatePrinterStatus := 2  {off line}
    Else If (AH And $80) = $00 Then
      AlternatePrinterStatus := 3  {busy}
    Else If (AH And $08) = $08 Then
      AlternatePrinterStatus := 4  {undetermined error}
    Else
      AlternatePrinterStatus := 0    {all's well}
  End;
End;

Function PrinterReady : Boolean;
Begin
  PrinterReady := (PrinterStatus = 0);
End;

Procedure ResetPrinter;
Var
  address: ^Integer;
  portno, Delay : Integer;
Begin
  {$IFDEF DPMI}
  address := Ptr (Seg0040, $0008);
  {$ELSE}
  address := Ptr ($0040, $0008);
  {$ENDIF}
  portno := address^ + 2;
  port [portno] := 232;
  For Delay := 1 To 2000 Do ;
  port [portno] := 236;
End;

procedure cleanpathname (var path: pathstr; allowdir: boolean);
begin
  path := remchars (' +=/[]":;,?*<>|.', path);
  if not allowdir then path := strip ('A', '\', path);
end;

function fitswildcard (test, wc: str12): boolean;
var
  te, we: extstr;
  tn, wn: namestr;
  b: byte;
begin
  test := setupper (test);
  wc := setupper (wc);
  te := fileext (test);
  tn := filename (test);
  we := fileext (wc);
  wn := filename (wc);
  repeat
    b := pos ('?', wn);
    if b = 0 then break;
    delete (tn, b, 1);
    delete (wn, b, 1);
  until false;

  b := pos ('*', wn);
  if b <> 0 then begin
    delete (tn, b, 255);
    delete (wn, b, 255);
  end;

  repeat
    b := pos ('?', we);
    if b = 0 then break;
    delete (te, b, 1);
    delete (we, b, 1);
  until false;

  b := pos ('*', we);
  if b <> 0 then begin
    delete (te, b, 255);
    delete (we, b, 255);
  end;

  fitswildcard := (tn = wn) and (te = we);
end;

Function ValidFileName (FN: String): ShortInt;
{ codes:
          -2     Valid path, but no file specified
          -1     Path and name OK but file does not exist
           0     Path and name OK and file exists
           1     Illegal drive specifier
           2     Illegal characters in path
           3     Invalid Path
           4     No file specified
           5     Illegal Characters in name
           6     Name longer than eight characters
           7     Extension longer than three characters
}
Const
  Illegal: String [16] = ' +=/[]":;,?*<>|.';
Var
  ECode: ShortInt;
  OldDIR, D, P, F, E: String;
  Loc: Byte;
  Inf: SearchRec;                                {1.00b}

  Function Legal (Str: String; AllowSlash: Boolean): Boolean;
  Var I : Integer;
  Begin
    Legal := True;
    For I := 1 To 16 Do
      If Pos (Illegal [I], Str) <> 0 Then
      Begin
        Legal := False;
        Exit;
      End;
    If Not AllowSlash Then
      If Pos ('\', Str) > 0 Then
        legal := False;
End;

Begin
  ECode := 0;
  Loc := Pos (':', FN);
  If Loc = 0 Then
  Begin
    D := '';
    P := FN;
  End
  Else
  Begin
    D := SetUpper (Copy (FN, 1, Loc) );
    P := Copy (FN, Succ (Loc), 255);
    If (Loc <> 2) Or ( (D [1] In ['A'..'Z'] ) = False) Then
    Begin
      ValidFileName := 1;
      Exit;
    End;
  End;
  Loc := LastPos ('\', P);
  If Loc = 0 Then
  Begin
    F := P;
    P := '';
  End
  Else
  Begin
    F := Copy (P, Succ (Loc), 255);
    P := Copy (P, 1, Pred (Loc) );
  End;
  Loc := Pos ('.', F);
  If Loc = 0 Then
    E := ''
  Else
  Begin
    E := Copy (F, Succ (Loc), 255);
    F := Copy (F, 1, Pred (Loc) );
  End;
  If Not legal (P, True) Then
    Ecode := 2
  Else
  Begin
    If D + P <> '' Then
    Begin
      GetDir (0, OldDir);
      {$I-}
      ChDir (D + P);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IOResult <> 0 Then
      Begin
        ValidFileName := 3;
        ChDir (OldDir);  {1.00d}
        Exit;
      End
      Else
        ChDir (OldDir);
    End;
    If (F = '') And (E = '') Then
      Ecode := 4
    Else
    Begin
      If Not Legal (F + E, False) Then
        Ecode := 5
      Else
      Begin
        If Length (F) > 8 Then
          Ecode := 6
        Else If Length (E) > 3 Then
          Ecode := 7;
      End;
    End;
  End;
  If Ecode = 0 Then
  Begin
    If Not Exist (FN) Then
      ECode := - 1
    Else
    Begin                                {1.00b}
      FindFirst (FN, Directory, Inf);
      If (DosError <> 0) Or ( (DosError = 0) And (Inf. Attr = Directory) ) Then
        ECode := - 2;
    End
  End;
  ValidFileName := Ecode;
End;

Function DeleteFile (Filename: String): ShortInt;
{Return codes:   -1    File not found
                  0    File deleted
                  1    Error - file not deleted.

}
Var
  sr: searchrec;
  F: File;
Begin
  filename := fexpand (filename);
  DeleteFile := 0;

  If Not Exist (Filename) Then
    DeleteFile := - 1
  Else Begin
    findfirst (filename, anyfile - directory - volumeid, sr);
    while doserror = 0 do begin
      Assign (F, filedrive (Filename) + ':' + filedirectory (Filename) + '\' + sr. name);
      {$I-}
      Erase (F);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IOResult <> 0 Then begin
        DeleteFile := 1;
        break;
      end;
      findnext (sr);
    end;
  End;
End;

Function RenameFile (Oldname, NewName: String): ShortInt;
{Retcodes:     0 file renamed
               1 file not found
               2 rename failed
}
Var F: File;
Begin
  If Not exist (OldName) Then
    RenameFile := 1
  Else
  Begin
    Assign (F, Oldname);
    {$I-}
    Rename (F, Newname);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IOResult = 0 Then
      RenameFile := 0
    Else
      RenameFile := 2;
  End;
End;

function getfileattr (p: pathstr): word;
var
  f: file;
  w: word;
begin
  getfileattr := 65535;
  assign (f, p);
  {$I-}
  getfattr (f, w);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then getfileattr := w;
end;

procedure setfileattr (p: pathstr; w: word);
var
  f: file;
begin
  assign (f, p);
  {$I-}
  setfattr (f, w);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
end;

function getfiletime (p: pathstr): longint;
var
  f: file;
  l: longint;
begin
  getfiletime := $FFFFFFFF;
  assign (f, p);
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    getftime (f, l);
    close (f);
  end;
  if ioresult = 0 then getfiletime := l;
end;

procedure setfiletime (p: pathstr; l: longint);
var
  f: file;
begin
  assign (f, p);
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    setftime (f, l);
    close (f);
  end;
end;

Function AnsiSysInstalled: Boolean;
Var
  Dummy : Byte;
Begin
  Asm
    MOV AH, 1AH
    MOV AL, 00h
    Int 2Fh
    MOV Dummy, AL
  End;
  AnsiSysInstalled := Dummy = $FF;
End;

Procedure Beep;
Begin
  if vtoggles and 4 <> 4 then exit;
  Sound (1000); Delay (150);
  Sound (800); Delay (100);
  NoSound;
End;

Var
  Buf : Array [0..512] Of Byte;  { Buffer MUST be outside }

  Function diskready (drive: Char): Boolean; Assembler;
  Asm
    cmp  drive, 'a'
    jb   @isupcase  { make it UPPER case }
    sub  drive, 20H
    @isupcase:
    cmp  drive, 'Z'
    jb   @driveok
    mov  drive, 'A'  { if drive isn't between 'A' and 'Z', make it A) }
    @driveok:
    mov  AX, Seg buf
    mov  ES, AX
    mov  BX, Offset buf

    mov  AH, 02  { read disk sectors }
    mov  AL, 1   { number of sectors to transfer }
    mov  CH, 1   { track number }
    mov  CL, 1   { sector number }
    mov  DH, 1   { head number }

    mov        DL, drive
    sub        DL, 'A'     { subtract ORD of 'A' }

    {mov  dl, drive   { drive number (0=A, 3=C, or 80h=C, 81h=D) }
    Int  13h

    mov  BL, True { assume drive is ready }
    And  AH, $80
    jz   @done   { error was something other than disk not ready }
    mov  BL, False{ disk wasn't ready. store result }
    @done:

    mov  AX, $0000  { reset drive }
    Int  13H

    XOr  AX, AX   { shut off disk drive quickly }
    mov  ES, AX
    mov  AX, 440h
    mov  DI, AX
    mov  Byte Ptr ES: [DI], 01h

    mov  AL, BL   { retrieve result }
  End;  { diskready }

Function OpenFile;
Begin
  OpenFile := False;

  Assign (F, N);
  {$I-}
  Reset (F, 1);
  {$IFDEF Debug} {$I+} {$ENDIF}

  If IOResult <> 0 Then
    OpenFile := False
  Else
    OpenFile := True;
End;

Function OpenText (N: PathStr; Var T: Text): Boolean;
Begin
  Assign (T, N);
  {$I-}
  Reset (T);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then OpenText := False Else OpenText := True;
End;

Function GetFileCrc (Var F: File; Minus: LongInt): Word;
Type
  BufType = Array [0..16383] Of Byte;
Var
  P1: LongInt;
  Crc, ReadIn: Word;
  Buf:^BufType;
Begin
  GetFileCrc := 0;
  Crc := 0;
  GetMem (Buf, SizeOf (BufType));
  If Buf = Nil Then Exit;
  P1 := FilePos (F);

  Repeat
    BlockRead (F, Buf^, SizeOf (Buf^), ReadIn);
    If (FilePos (F) = FileSize (F) ) Then Dec (ReadIn, Minus);
    Crc := Crc16 (Buf^, ReadIn, Crc);
  Until ReadIn <> SizeOf (Buf^);

  Seek (F, P1);
  FreeMem (Buf, SizeOf (BufType) );
  GetFileCrc := Crc;
End;

Procedure iDelay (MS: Word);
Var
  W: Word;
Begin
  For W := 1 To MS Do Begin
    If W mod 10 = 0 then Key^. vIdleHook;
    Crt. Delay (1);
  End;
End;

Function HasWildcards (FName: String): Boolean;
Var
  P1, P2 : Byte;
Begin
  P1 := Pos ('*', FName);
  P2 := Pos ('?', FName);
  HasWildcards := (P1 + P2 > 0)
End;

Function EnterFileName (Var F: String): Boolean;
Var
  C: Char;
  W: pWinObj;
  A: Byte;
  O: Word;
  B: Boolean;
Begin
  A := TextAttr;
  Screen^. EnableHighBgd;
  New (W, Init);
  If W = Nil Then Halt (8);
  W^. SetSize (29, 10, 50, 15, 2);
  W^. SetClose (False);
  W^. Draw;
  Screen^. WritePlain (3, 2, 'Enter file name:');
  Screen^. CursOn;
  TextAttr := $8F;
  EnterFileName := False;

  Repeat
    Key^. FlushBuffer;
    F := '';
    Screen^. GotoXY (34, 13);
    Screen^. WritePlain (5, 3, '            ');
    Repeat
      O := Key^. GetKey;
      If O > 255 Then Continue;
      C := Key^. LastChar;
      If C = #27 Then Break;
      If C = #8 Then Begin
        If Length (F) = 0 Then Continue;
        Dec (F [0] );
        Write (#8' '#8);
        Continue;
      End Else
        If C = #13 Then
          Break
        Else
          If Length (F) = 12 Then Continue;
      F := F + C;
      Write (C);
    Until C = #13;

    If C = #27 Then Break;
    B := ((ValidFileName (F) = 0) Or (ValidFileName (F) = - 1)) And Not HasWildCards (F);

    If Not B Then Begin
      Screen^. WriteAt (2, 4, $8C, 'Invalid file name!');
      Beep;
      iDelay (1000);
      Screen^. WritePlain (3, 4, '                  ');
    End;
  Until B;

  Screen^. DisableHighBgd;
  TextAttr := A;

  If C <> #27 Then Begin
    EnterFileName := True;
    Screen^. CursOff;
  End;
  Dispose (W, Done);
  Screen^. DisableHighBgd;
End;

Function YesNo (Prompt1, Prompt2: String): Boolean;
Var
  MsgWin: ^PromptOBJ;
  ActionCode: tAction;
Begin
  Key^. FlushBuffer;
  with screen^ do begin
    Curssave;
    CursOff;
    EnableHighBgd;
  end;
  New (MsgWin, Init (1, ' Confirmation ') );
  With MsgWin^ Do
  Begin
    vManager. Win^. vAllowMove := False;
    vManager. Win^. SetClose (False);
    AddLine ('');
    AddLine (' ' + Prompt1 + ' ');
    If Prompt2 <> '' Then
      AddLine (' ' + Prompt2 + ' ');
    AddLine ('');
    vWidth := Length (Prompt1) + 2;
    ActionCode := Show;
  End;
  Dispose (MsgWin, Done);
  If ActionCode = Finished Then
    YesNo := True
  Else
    YesNo := False;
  with screen^ do begin
    DisableHighBgd;
    CursReset;
  end;
End;

Procedure CloseTot;
Begin
  If IoTot <> Nil Then Dispose (IoTot, Done);
  If Key <> Nil Then Dispose (Key, Done);
  If Screen <> Nil Then Dispose (Screen, Done);
  If Monitor <> Nil Then Dispose (Monitor, Done);
  If LookTot <> Nil Then Dispose (LookTot, Done);
End;

Function ratio (L1, L2: LongInt): LongInt;
Begin
  If l2 <> 0 Then
    Ratio := Trunc (l1 / l2 * 100)
  Else
    ratio := 0;
End;

Function ratiostr (L1, L2: LongInt): String;
Begin
  If l2 <> 0 Then
    Ratiostr := IntToStr (Trunc (l1 / l2 * 100) )
  Else
    ratiostr := '0';
End;

Function GetFileCnt (W: PathStr): LongInt;
Var
  DirInfo: SearchRec;
  Num: LongInt;
Begin
  Num := 0;
  FindFirst (W, AnyFile - Directory - VolumeID, DirInfo);
  While DosError = 0 Do
  Begin
    Inc (Num);
    FindNext (DirInfo);
  End;
  GetFileCnt := Num;
End;

Function validphone (ph: Str20): Boolean;
Begin
  validphone := False;

  if ph [1] <> '+' then begin
    If Length (ph) <> 12 Then Exit;

    If ((ph [2] In ['2'..'9']) Or (ph [1] In ['0', '1'])
       Or (ph [5] In ['0', '1'])) Then Exit;
  end;

  validphone := True;
End;

Function RandomFile (wc: PathStr): PathStr;
Var
  DirInfo: SearchRec;
  list: pdllobj;
  s: String [12];
Begin
  New (list, init);
  FindFirst (wc, AnyFile, DirInfo);
  While DosError = 0 Do
  Begin
    list^. add (DirInfo. Name [0], 13);
    FindNext (DirInfo);
  End;
  With list^ Do
    If totalnodes <> 0 Then
      getnodedata (nodeptr (Succ (Random (totalnodes))), s [0])
    else
      s := '';
  Dispose (list, done);
  randomfile := FExpand (FileSplit (1, wc) + s);
End;

Procedure removerec (Var f: File; s, rs: LongInt);
var
  t, z: longint;
  n: pointer;
Begin
  getmem (n, rs);
  t := FileSize (f) div rs - 2;
  if s <= t then For z := s To t Do Begin
    seek (f, succ (z) * rs);
    blockRead (f, n^, rs);
    Seek (f, z * rs);
    blockWrite (f, n^, rs);
  End else
    seek (f, s * rs);
  Truncate (f);
  freemem (n, rs);
End;

Procedure insertrec (Var f: File; s, rs: LongInt);
var
  z, t: longint;
  n: pointer;
Begin
  getmem (n, rs);
  t := filesize (f);
  if s * rs = t then begin
    seek (f, t);
    fillchar (n^, rs, 0);
    blockwrite (f, n^, rs);
  end else begin
    for z := pred (t div rs) downto s do begin
      seek (f, z * rs);
      blockread (f, n^, rs);
      blockwrite (f, n^, rs);
    end;
    seek (f, s * rs);
    fillchar (n^, rs, 0);
    blockwrite (f, n^, rs);
  end;
  freemem (n, rs);
End;

  function AddBackSlash(DirName : string) : string;
    {-Add a default backslash to a directory name}
  begin
    if DirName[Length(DirName)] in DosDelimSet then
      AddBackSlash := DirName
    else
      AddBackSlash := DirName+'\';
  end;

  function JustPathname(PathName : string) : string;
    {-Return just the drive:directory portion of a pathname}
  var
    I : Word;
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);

    if I = 0 then
      {Had no drive or directory name}
      JustPathname[0] := #0
    else if I = 1 then
      {Either the root directory of default drive or invalid pathname}
      JustPathname := PathName[1]
    else if (PathName[I] = '\') then begin
      if PathName[Pred(I)] = ':' then
        {Root directory of a drive, leave trailing backslash}
        JustPathname := Copy(PathName, 1, I)
      else
        {Subdirectory, remove the trailing backslash}
        JustPathname := Copy(PathName, 1, Pred(I));
    end
    else
      {Either the default directory of a drive or invalid pathname}
      JustPathname := Copy(PathName, 1, I);
  end;

  function HasExtension(Name : string; var DotPos : Word) : Boolean;
    {-Return whether and position of extension separator dot in a pathname}
  var
    I : Word;
  begin
    DotPos := 0;
    for I := Length(Name) downto 1 do
      if (Name[I] = '.') and (DotPos = 0) then
        DotPos := I;
    HasExtension := (DotPos > 0) and (Pos('\', Copy(Name, Succ(DotPos), 64)) = 0);
  end;

  function DefaultExtension(Name : string; Ext : ExtStr) : string;
    {-Return a pathname with the specified extension attached}
  var
    DotPos : Word;
  begin
    if HasExtension(Name, DotPos) then
      DefaultExtension := Name
    else if Name = '' then
      DefaultExtension := ''
    else
      DefaultExtension := Name+'.'+Ext;
  end;

  function JustFilename(PathName : string) : string;
    {-Return just the filename of a pathname}
  const
    DosDelimSet : set of Char = ['\', ':', #0];
  var
    I : Word;
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);
    JustFilename := Copy(PathName, Succ(I), 64);
  end;

  {!!.02}
  function Exist(FName : string) : Boolean;
  var
    sr: searchrec;
  begin
    FindFirst (FName, AnyFile - Directory - VolumeID, sr);
    Exist := DosError = 0;
  end;

End.
