Unit totIO1;
{$I Sys75.INC}

Interface

Uses DOS, CRT,
  totSYS, totLOOK, totFAST, totWIN, totSTR, totINPUT, TotMisc;

Const
  NoRules      = $00;
  AllowNull    = $01;
  SuppressZero = $02;
  EraseDefault = $08;
  JumpIfFull   = $10;
  MaxButtonWidth = 25;  {alter as necessary}
  HelpID = 65535;
  StayPut = 65534;  {1.00h}
Type
  
  tCursPos = (CursLeft, CursRight, CursPrev);
  tStatus = (HiStatus, Norm, Off);
  tAction = (None, NextField, PrevField, Finished, Escaped,
             Refresh, Signal, Enter, Help, Stop1, Stop2, Stop3, Stop4,
             Stop5, Stop6, Stop7, Stop8, Stop9, Broke);
  tColor = Array [1..4] Of Byte;
  
  StringBut = String [MaxButtonWidth];
  
  LeaveFieldfunc = Function (Var FieldID: Word): tAction;
  EnterFieldfunc = Function (Var NewID: Word; OldID: Word): tAction;
  CharFunc =       Function (Var K: Word; Var X, Y: Byte; Var FieldID: Word): tAction;
  HelpProc =       Procedure (ID: Word);

  tSignal = Record
            ID: Word;
            MsgType: Word;
            Case Word Of           {variant record}
              0: (MsgPtr: Pointer);
              1: (MsgLong: LongInt);
              2: (MsgWord: Word);
              3: (MsgInt: Integer);
              4: (MsgByte: Byte);
              5: (MsgChar: Char);
          End;

  InputOBJ = Object  {defines the default attributes for the fields}
             vLabel: tColor;
             vButton: tColor;
             vGroup: tColor;
             vList: tColor;
             vField: tColor;  {Off, On, Mask, Inactive}
             vMessage: Byte;
             vInputPad: Char;
             vCase: tCase;
             vForceCase: Boolean;     {adjust case of characters during input}
             vInputJust: tJust;
             vCursorLoc: tCursPos;
             vInsert: Boolean;      {is field initially in insert mode}
             vRules: Byte;          {erasedefault, jumpiffull..... etc.}
             {methods...}
             Constructor Init;
             Procedure   SetDefaults;
             Procedure   SetColLabel (Off, OffHot, On, OnHot: Byte);
             Procedure   SetColButton (Off, OffHot, On, OnHot: Byte);
             Procedure   SetColGroup (Off, OffHot, On, OnHot: Byte);
             Procedure   SetColList (Off, OffHot, On, OnHot: Byte);
             Procedure   SetColField (Off, On, Mask, Inactive: Byte);
             Procedure   SetColMsg (Col: Byte);
             Procedure   SetIns (InsOn: Boolean);
             Procedure   SetRules (Rules: Byte);
             Procedure   SetPadChar (Pad: Char);
             Procedure   SetJust (Just: tJust);
             Procedure   SetCursor (Curs: tCursPos);
             Procedure   SetCase (Cas: tCase);
             Procedure   SetForceCase (On: Boolean);
             Function    LabelCol (Element: Byte): Byte;
             Function    ButtonCol (Element: Byte): Byte;
             Function    GroupCol (Element: Byte): Byte;
             Function    ListCol (Element: Byte): Byte;
             Function    FieldCol (Element: Byte): Byte;
             Function    MessageCol: Byte;
             Function    InputPad: Char;
             Function    InputIns: Boolean;
             Function    InputRules: Byte;
             Function    InputPadChar: Char;
             Function    InputJust: tJust;
             Function    InputCursorLoc: tCursPos;
             Function    InputCase: tCase;
             Function    InputForceCase: Boolean;
             Destructor  Done;
           End; {InputOBJ}

  pItemIOOBJ = ^ItemIOOBJ;
  ItemIOOBJ = Object
              vBoundary: tCoords;
              vHotKey: Word;
              vID: Word;
              vActive: Boolean;
              {methods ...}
              Constructor Init;
              Procedure   SetActiveStatus (Selectable: Boolean);
              Function    Active: Boolean;
              Function    GetHotKey: Word;
              Procedure   SetHotkey (HK: Word);
              Function    GetID: Word;
              Procedure   SetID (ID: Word);
              Function    Ontarget (X, Y: Byte): Boolean;                           Virtual;
              Function    Visible: Boolean;                                       Virtual;
              Procedure   RaiseSignal (Var TheSig: tSignal);                        Virtual;
              Procedure   HandleSignal (Var BaseSig: tSignal; Var NewSig: tSignal);  Virtual;
              Procedure   ShutdownSignal (Var BaseSig: tSignal);                    Virtual;
              Function    IsHotkey (HK: Word): Boolean;                              Virtual;
              Procedure   WriteLabel (Status: tStatus);                             Virtual;
              Procedure   Display (Status: tStatus);                                Virtual;
              Function    Select (K: Word; X, Y: Byte): tAction;                       Virtual;
              Function    ProcessKey (InKey: Word; X, Y: Byte): tAction;                Virtual;
              Function    Suspend: Boolean;                                        Virtual;
              Destructor  Done;                                                   Virtual;
            End; {ItemIOOBJ}

  pHotkeyIOOBJ = ^HotkeyIOOBJ;
  HotkeyIOOBJ = Object (ItemIOOBJ)
                vActionCode: tAction;
                {methods ...}
                Constructor Init (HK: Word; Act: tAction);
                Function    IsHotkey (HK: Word): Boolean;                              Virtual;
                Function    Select (K: Word; X, Y: Byte): tAction;                       Virtual;
                Destructor  Done;                                                   Virtual;
              End; {HotkeyIOOBJ}

  pControlKeysIOOBJ = ^ControlKeysIOOBJ;
  ControlKeysIOOBJ = Object (ItemIOOBJ)
                     vFinKey: Word;
                     vNexkey: Word;
                     vPreKey: Word;
                     vEscKey: Word;
                     {methods ...}
                     Constructor Init;
                     Procedure   SetKeys (Next, Prev, Fin, Esc: Word);
                     Function    IsHotkey (HK: Word): Boolean;                              Virtual;
                     Function    Select (K: Word; X, Y: Byte): tAction;                       Virtual;
                     Destructor  Done;                                                   Virtual;
                   End; {ControlKeysIOOBJ}

  pVisibleIOOBJ = ^VisibleIOOBJ;
  VisibleIOOBJ = Object (ItemIOOBJ)
                 vLblPtr: Pointer;
                 vMsgPtr: Pointer;
                 vMsgX: Byte;
                 vMsgY: Byte;
                 {methods ...}
                 Constructor Init;
                 Procedure   SetLabel (Lbl: String);
                 Procedure   SetMessage (X, Y: Byte; Msg: String);
                 Procedure   WriteMessage;
                 Function    Ontarget (X, Y: Byte): Boolean;             Virtual;
                 Function    Visible: Boolean;                         Virtual;
                 Procedure   WriteLabel (Status: tStatus);               Virtual;
                 Function    Suspend: Boolean;                          Virtual;
                 Destructor  Done;                                     Virtual;
               End; {VisibleIOOBJ}

  pStripIOOBJ = ^StripIOOBJ;
  StripIOOBJ = Object (VisibleIOOBJ)
               vTitle: StringBut;
               vActionCode: tAction;
               {methods ...}
               Constructor Init (X1, Y1: Byte; Tit: String; Act: tAction);
               Function    Ontarget (X, Y: Byte): Boolean;            Virtual;
               Function    IsHotkey (HK: Word): Boolean;               Virtual;
               Procedure   Display (Status: tStatus);                 Virtual;
               Function    Select (K: Word; X, Y: Byte): tAction;        Virtual;
               Function    ProcessKey (InKey: Word; X, Y: Byte): tAction; Virtual;
               Destructor  Done;                                    Virtual;
             End; {StripIOOBJ}

  pStrip3dIOOBJ = ^Strip3dIOOBJ;
  Strip3dIOOBJ = Object (StripIOOBJ)
                 {methods ...}
                 Constructor Init (X1, Y1: Byte; Tit: String; Act: tAction);
                 Procedure   Display (Status: tStatus);                 Virtual;
                 Destructor  Done;                                    Virtual;
               End; {Strip3dIOOBJ}

  pButtonIOOBJ = ^ButtonIOOBJ;
  ButtonIOOBJ = Object (StripIOOBJ)
                {methods ...}
                Constructor Init (X1, Y1: Byte; Tit: String; Act: tAction);
                Procedure   Display (Status: tStatus);                 Virtual;
                Destructor  Done;                                    Virtual;
              End; {ButtonIOOBJ}

  pMultiLineIOOBJ = ^MultiLineIOOBJ;
  MultiLineIOOBJ = Object (VisibleIOOBJ)
                   vBorder: tCoords;
                   vTitle: StrVisible;
                   vRows: Byte;
                   {methods ...}
                   Constructor Init (X1, Y1, width, depth: Byte; Title: String);
                   Procedure   SetBoxOn (On: Boolean);
                   Procedure   Display (Status: tStatus);                  Virtual;
                   Procedure   Activate;                                 Virtual;
                   Destructor  Done;                                     Virtual;
                 End; {MultiLineIOOBJ}

  GroupItemPtr = ^GroupItem;
  GroupItem = Record
              NextNode: GroupItemPtr;
              PrevNode: GroupItemPtr;
              StrPtr: Pointer;
              HK: Word;
              Selected: Boolean;
            End;

  pGroupIOOBJ = ^GroupIOOBJ;
  GroupIOOBJ = Object (MultiLineIOOBJ)
               vItemStack: GroupItemPtr;
               vTotalItems: Byte;
               vActiveItem: Byte;
               vOnStr: String [3];
               vOffStr: String [3];
               vSubHotkeysActive : Boolean;
               {methods ...}
               Constructor Init (X1, Y1, width, depth: Byte; Title: String);
               Procedure   SetSubHotkeysActive (On: Boolean);
               Function    EndNode: GroupItemPtr;
               Function    NodePtr (Item: Byte): GroupItemPtr;
               Procedure   AddItem (Str: String; HK: Word; Selected: Boolean);
               Function    HotKeyItem (HK: Word): Integer;
               Function    HitItem (X, Y: Byte): Byte;
               Procedure   WriteItem (Item: Byte; IsActive: Boolean);
               Function    Select (K: Word; X, Y: Byte): tAction;                     Virtual;
               Function    IsHotkey (HK: Word): Boolean;                            Virtual;
               Procedure   Display (Status: tStatus);                              Virtual;
               Destructor  Done;                                                 Virtual;
             End;  {GroupIOOBJ}

  pCheckIOOBJ = ^CheckIOOBJ;
  CheckIOOBJ = Object (GroupIOOBJ)
               {methods ...}
               Constructor Init (X1, Y1, width, depth: Byte; Title: String);
               Procedure   SetValue (Item: Byte; Selected: Boolean);
               Function    GetValue (Item: Byte): Boolean;
               Function    ProcessKey (InKey: Word; X, Y: Byte): tAction;              Virtual;
               Function    Select (K: Word; X, Y: Byte): tAction;                     Virtual;
               Destructor  Done;                                                 Virtual;
             End; {CheckIOOBJ}

  pRadioIOOBJ = ^RadioIOOBJ;
  RadioIOOBJ = Object (GroupIOOBJ)
               {methods ...}
               Constructor Init (X1, Y1, width, depth: Byte; Title: String);
               Procedure   SetValue (Item: Byte);
               Function    GetValue: Byte;
               Function    ProcessKey (InKey: Word; X, Y: Byte): tAction;              Virtual;
               Function    Select (K: Word; X, Y: Byte): tAction;                     Virtual;
               Destructor  Done;                                                 Virtual;
             End; {RadioIOOBJ}

  pItemNode = ^ItemNode;
  ItemNode = Record
             Item: pItemIOOBJ;
             NextNode: pItemNode;
             PrevNode: pItemNode;
           End; {ItemList}

  pFormOBJ = ^FormOBJ;
  FormOBJ = Object
            vItemStack: pItemNode;
            vActiveItem: pItemNode;
            vCharHook: CharFunc;
            vLeaveHook: LeaveFieldFunc;
            vEnterHook: EnterFieldFunc;
            vHelpHook:  HelpProc;
            {methods ...}
            Constructor Init;
            Procedure   AddItem (Var NewItem: ItemIOOBJ);
            Procedure   SetCharHook (Func: CharFunc);
            Procedure   SetLeaveHook (Func: LeaveFieldFunc);
            Procedure   SetEnterHook (Func: EnterFieldFunc);
            Procedure   SetHelpHook (Proc: HelpProc);
            Function    EndNode: pItemNode;
            Procedure   SetActiveItem (ID: Word);
            Function    HotKeyItemPtr (HotKey: Word): pItemNode;
            Function    IDItemPtr (ID: Word): pItemNode;
            Function    HotSpotItemPtr (X, Y: Byte): pItemNode;
            Function    Go: tAction;
            Procedure   BroadcastSignal (TheSig: tSignal; SignalSource: pItemNode);
            Procedure   DisplayItems;
            Function    StopID: Word;
            Procedure   AdjustKey (Var Key: Word; Var X, Y: Byte);    Virtual;
            Procedure   HelpTask (ID: Word);                          Virtual;
            Function    CharTask (Var K: Word; Var X, Y: Byte;
            Var FieldID: Word): tAction;             Virtual;
            Function    EnterTask (Var NewID: Word; OldID: Word): tAction; Virtual;
            Function    LeaveTask (Var FieldID: Word): tAction;       Virtual;
            Destructor  Done;                                         Virtual;
          End; {FormOBJ}

  WinFormPtr = ^WinFormOBJ;
  pWinFormOBJ = WinFormPtr;
  WinFormOBJ = Object (FormOBJ)
               vWinPtr: MoveWinPtr;
               {methods ...}
               Constructor Init;
               Function    Win: MoveWinPtr;
               Procedure   Draw;
               Procedure   AdjustKey (Var Key: Word; Var X, Y: Byte); Virtual;
               Destructor  Done;                                      Virtual;
             End; {WinFormOBJ}

Procedure IO1Init;
Function NoCharHook (Var K: Word; Var X, Y: Byte; Var FieldID: Word): tAction;
Function NoEnterHook (Var FieldID: Word; OtherID: Word): tAction;
Function NoLeaveHook (Var ID: Word): tAction;
Procedure NoHelpHook (ID: Word);
Procedure AssignColors (Main, Inactive: tColor; Status: tStatus; Var High, Nor: Byte);

Var
  IOTOT: ^InputOBJ;

Implementation
Var
  FormHelpCalled,
  EscapingForm: Boolean;
  {|||||||||||||||||||||||||||||||||||||||||||||}
  {                                             }
  {     M i s c.  P r o c s   &   F u n c s     }
  {                                             }
  {|||||||||||||||||||||||||||||||||||||||||||||}
Function NoCharHook (Var K: Word; Var X, Y: Byte; Var FieldID: Word): tAction;
{}
Begin
  NoCharHook := None;
End; {NoCharHook}

Function NoEnterHook (Var FieldID: Word; OtherID: Word): tAction;
{}
Begin
  NoEnterHook := none;
End; {NoEnterHook}

Function NoLeaveHook (Var ID: Word): tAction;
{}
Begin
  NoLeaveHook := none;
End; {NoLeaveHook}

Procedure NoHelpHook (ID: Word);
{}
Begin
  Beep;
End; {NoHelpHook}

Procedure AssignColors (Main, Inactive: tColor; Status: tStatus; Var High, Nor: Byte);
{}
Begin
  Case Status Of
    HiStatus: Begin
      High := Main [4];
      Nor := Main [3];
    End;
    Norm:
          Begin
            High := Main [2];
            Nor := Main [1];
          End;
    Off:
         Begin
           High := Inactive [4];
           Nor := Inactive [4];
         End;
  End; {case}
End; {AssignColors}
{|||||||||||||||||||||||||||||||||||||||||}
{                                         }
{     I n p u t O B J   M E T H O D S     }
{                                         }
{|||||||||||||||||||||||||||||||||||||||||}
Constructor InputOBJ. Init;
{}
Begin
  SetDefaults;
End; {InputlOBJ.Init}

Procedure InputOBJ. SetDefaults;
{}
Begin
  If Monitor^. ColorOn Then {color System}
  Begin
    SetColLabel (78, 76, 79, 76);
    SetColButton (32, 46, 47, 46);
    SetColGroup (48, 62, 63, 62);
    SetColList (48, 62, 31, 30);
    SetColField (48, 31, 23, 71);
  End
  Else
  Begin
    SetColLabel (7, 15, 15, 15);
    SetColButton (7, 15, 15, 15);
    SetColGroup (7, 15, 15, 15);
    SetColList (7, 15, 15, 15);
    SetColField (7, 15, 15, 15);
  End;
  SetColMsg (0);
  vInputPad := Chr (250);
  vCase := Leave;
  vForceCase := False;
  vInputJust :=  JustLeft;
  vCursorLoc := CursPrev;
  vInsert := False;
  vRules :=  AllowNull;
End; {InputOBJ.SetDefaults}

Procedure InputOBJ. SetColLabel (Off, OffHot, On, OnHot: Byte);
{}
Begin
  vLabel [1] := Off;
  vLabel [2] := OffHot;
  vLabel [3] := On;
  vLabel [4] := OnHot;
End; {InputOBJ.SetColLabel}

Procedure InputOBJ. SetColButton (Off, OffHot, On, OnHot: Byte);
{}
Begin
  vButton [1] := Off;
  vButton [2] := OffHot;
  vButton [3] := On;
  vButton [4] := OnHot;
End; {InputOBJ.SetColButton}

Procedure InputOBJ. SetColGroup (Off, OffHot, On, OnHot: Byte);
{}
Begin
  vGroup [1] := Off;
  vGroup [2] := OffHot;
  vGroup [3] := On;
  vGroup [4] := OnHot;
End; {InputOBJ.SetColGroup}

Procedure InputOBJ. SetColList (Off, OffHot, On, OnHot: Byte);
{}
Begin
  vList [1] := Off;
  vList [2] := OffHot;
  vList [3] := On;
  vList [4] := OnHot;
End; {InputOBJ.SetColList}

Procedure InputOBJ. SetColField (Off, On, Mask, Inactive: Byte);
{}
Begin
  vField [1] := Off;
  vField [2] := On;
  vField [3] := Mask;
  vField [4] := InActive;
End; {InputOBJ.SetColField}

Procedure InputOBJ. SetColMsg (Col: Byte);
{}
Begin
  vMessage := Col;
End; {InputOBJ.SetColMsg}

Function InputOBJ. LabelCol (Element: Byte): Byte;
{}
Begin
  LabelCol := vLabel [Element];
End; {InputOBJ.LabelCol}

Function InputOBJ. ButtonCol (Element: Byte): Byte;
{}
Begin
  ButtonCol := vButton [Element];
End; {InputOBJ.ButtonCol}

Function InputOBJ. GroupCol (Element: Byte): Byte;
{}
Begin
  GroupCol := vGroup [Element];
End; {InputOBJ.GroupCol}

Function InputOBJ. ListCol (Element: Byte): Byte;
{}
Begin
  ListCol := vList [Element];
End; {InputOBJ.ListCol}

Function InputOBJ. FieldCol (Element: Byte): Byte;
{}
Begin
  FieldCol := vField [Element];
End; {InputOBJ.FieldCol}

Function InputOBJ. MessageCol: Byte;
{}
Begin
  MessageCol := vMessage;
End; {InputOBJ.MessageCol}

Procedure InputOBJ. SetIns (InsOn: Boolean);
{}
Begin
  vInsert := InsOn;
End; {InputOBJ.SetIns}

Procedure InputOBJ. SetRules (Rules: Byte);
{}
Begin
  vRules := Rules;
End; {SetRules}

Procedure InputOBJ. SetPadChar (Pad: Char);
{}
Begin
  vInputPad := Pad;
End; {InputOBJ.SetPadChar}

Procedure InputOBJ. SetCursor (Curs: tCursPos);
{}
Begin
  vCursorLoc := Curs;
End; {InputOBJ.SetCurs}

Procedure InputOBJ. SetJust (Just: tJust);
{}
Begin
  vInputJust := Just;
End; {InputOBJ.SetJust}

Procedure InputOBJ. SetCase (Cas: tCase);
{}
Begin
  vCase := Cas;
End; {InputOBJ.SetCase}

Procedure InputOBJ. SetForceCase (On: Boolean);
{}
Begin
  vForceCase := On;
End; {InputOBJ.SetForceCase}

Function InputOBJ. InputPad: Char;
{}
Begin
  InputPad := vInputPad;
End; {of func InputOBJ.InputPad}

Function InputOBJ. InputIns: Boolean;
{}
Begin
  InputIns := vInsert;
End; {InputOBJ.InputIns}

Function InputOBJ. InputRules: Byte;
{}
Begin
  InputRules := vRules;
End; {InputOBJ.InputRules}

Function InputOBJ. InputPadChar: Char;
{}
Begin
  InputPadChar := vInputPad;
End; {InputOBJ.InputPadChar}

Function InputOBJ. InputJust: tJust;
{}
Begin
  InputJust := vInputJust;
End; {InputOBJ.InputJust}

Function InputOBJ. InputCursorLoc: tCursPos;
{}
Begin
  InputCursorLoc := vCursorLoc;
End; {InputOBJ.InputCursorLoc}

Function InputOBJ. InputCase: tCase;
{}
Begin
  InputCase := vCase;
End; {InputOBJ.InputCase}

Function InputOBJ. InputForceCase: Boolean;
{}
Begin
  InputForceCase := vForceCase;
End; {InputOBJ.InputForceCase}

Destructor InputOBJ. Done;
Begin End;
{||||||||||||||||||||||||||||||||||||||}
{                                      }
{     I t e m O B J   M E T H O D S    }
{                                      }
{||||||||||||||||||||||||||||||||||||||}
Constructor ItemIOOBJ. Init;
{}
Begin
  vActive := False;
  vHotKey := 0;
  vID := 0;
  vBoundary. X1 := 0;
  vBoundary. Y1 := 0;
  vBoundary. X2 := 0;
  vBoundary. Y2 := 0;
End; {cons ItemIOOBJ.Init}

Procedure ItemIOOBJ. SetActiveStatus (Selectable: Boolean);
{}
Begin
  vActive := Selectable;
End; {ItemIOOBJ.SetActiveStatus}

Procedure ItemIOOBJ. SetHotkey (HK: Word);
{}
Begin
  vHotKey := HK;
End; {ItemIOOBJ.SetHotkey}

Function ItemIOOBJ. GetHotKey: Word;
{}
Begin
  GetHotKey := vHotkey;
End; {ItemIOOBJ.GetHotKey}

Procedure ItemIOOBJ. SetID (ID: Word);
{}
Begin
  vID := ID;
End; {ItemIOOBJ.SetID}

Function ItemIOOBJ. GetID: Word;
{}
Begin
  GetID := vID;
End; {ItemIOOBJ.GetID}

Function ItemIOOBJ. Visible: Boolean;
{}
Begin
  Visible := False;
End; {ItemIOOBJ.Visible}

Function ItemIOOBJ. Active: Boolean;
{}
Begin
  Active := vActive;
End; {ItemIOOBJ.Active}

Function ItemIOOBJ. IsHotKey (HK: Word): Boolean;
{}
Begin
  IsHotKey := (HK = vHotKey) And vActive;   {1.00a}
End; {ItemIOOBJ.IsHotKey}

Function ItemIOOBJ. OnTarget (X, Y: Byte): Boolean;
{}
Begin
  Ontarget :=     (X >= vBoundary. X1)
  And (X <= vBoundary. X2)
  And (Y >= vBoundary. Y1)
  And (Y <= vBoundary. Y2)
  And vActive;
End; {ItemIOOBJ.HotKey}

Function ItemIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Begin
  Select := None;
End;

Function ItemIOOBJ. ProcessKey (InKey: Word; X, Y: Byte): tAction;
{}
Begin
  ProcessKey := None;
End;

Procedure ItemIOOBJ. WriteLabel (Status: tStatus);
{}
Begin End;

Procedure ItemIOOBJ. Display (Status: tStatus);
{}
Begin End;

Function ItemIOOBJ. Suspend;
{}
Begin
  Display (Norm);
  Suspend := True;
End; {ItemIOOBJ.Suspend}

Procedure ItemIOOBJ. RaiseSignal (Var TheSig: tSignal);
{abstract}
Begin End;

Procedure ItemIOOBJ. HandleSignal (Var BaseSig: tSignal; Var NewSig: tSignal);
{abstract}
Begin End;

Procedure ItemIOOBJ. ShutDownSignal (Var BaseSig: tSignal);
{abstract}
Begin End;

Destructor ItemIOOBJ. Done;
{}
Begin End;

{||||||||||||||||||||||||||||||||||||||||||}
{                                          }
{     H o t k e y O B J   M E T H O D S    }
{                                          }
{||||||||||||||||||||||||||||||||||||||||||}

Constructor HotkeyIOOBJ. Init (HK: Word; Act: tAction);
{}
Begin
  ItemIOOBJ. Init;
  vBoundary. X1 := - 128;
  vBoundary. X2 := - 128;
  vBoundary. Y1 := - 128;
  vBoundary. Y2 := - 128;
  vActionCode := Act;
  vHotKey := HK;
End; {cons HotkeyIOOBJ.Init}

Function HotkeyIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Begin
  Select := vActionCode;
End; {HotkeyIOOBJ.Select}

Function HotkeyIOOBJ. IsHotKey (HK: Word): Boolean;
{}
Begin
  If HK = vHotKey Then
  Begin
    EscapingForm := (vActionCode = Escaped);
    FormHelpCalled := (vActionCode = Help);
    IsHotkey := True
  End
  Else
    IsHotKey := False;
End; {HotkeyIOOBJ.IsHotKey}

Destructor HotkeyIOOBJ. Done;
{}
Begin
  ItemIOOBJ. Done;
End; {dest HotkeyIOOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                        }
{     C o n t r o l K e y s I O O B J   M E T H O D S    }
{                                                        }
{||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor ControlKeysIOOBJ. Init;
{}
Begin
  ItemIOOBJ. Init;
  vFinKey := 324;
  vNexkey := 9;
  vPreKey := 271;
  vEscKey := 27;
End; {ControlKeysIOOBJ.Init}

Procedure ControlKeysIOOBJ. SetKeys (Next, Prev, Fin, Esc: Word);
{}
Begin
  vFinKey := Fin;
  vNexkey := Next;
  vPreKey := Prev;
  vEscKey := Esc;
End; {ControlKeysIOOBJ.SetKeys}

Function ControlKeysIOOBJ. IsHotkey (HK: Word): Boolean;       
{}
Begin
  If (Hk = vEscKey) Then
    EscapingForm := True;
  IsHotKey := (   (HK = vFinKey)
  Or (HK = vNexKey)
  Or (HK = vPreKey)
  Or (Hk = vEscKey)
  );
End; {ControlKeysIOOBJ.IsHotkey}

Function ControlKeysIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Begin
  If Chr (K) in ['a'..'z'] Then
    K := Ord (uCase (Chr (K)));
  If (K = vFinKey) Then
    Select := Finished
  Else If (K = vNexkey) Then
    Select := NextField
  Else If (K = vPreKey) Then
    Select := PrevField
  Else If (K = vEscKey) Then
    Select := Escaped
  Else
    Select := None;
End; {ControlKeysIOOBJ.Select}

Destructor ControlKeysIOOBJ. Done;                            
{}
Begin
  ItemIOOBJ. Done;
End; {ControlKeysIOOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                      }
{     V i s i b l e F i e l d O B J   M E T H O D S    }
{                                                      }
{||||||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor VisibleIOOBJ. Init;
{}
Begin
  ItemIOOBJ. Init;
  vActive := True;
  vLblPtr := Nil;
  vMsgPtr := Nil;
End; {VisibleIOOBJ.Init}

Function VisibleIOOBJ. Visible: Boolean;
{}
Begin
  Visible := True;
End; {VisibleIOOBJ.Visible}

Procedure VisibleIOOBJ. SetLabel (Lbl: String);
{}
Var L : Word;
Begin
  L := Succ (Length (Lbl) );
  If MaxAvail >= L Then
  Begin
    GetMem (vLblPtr, L);
    Move (Lbl [0], vLblPtr^, L);
  End;
End; {VisibleIOOBJ.SetLabel}

Function VisibleIOOBJ. OnTarget (X, Y: Byte): Boolean;
{}
Var LabelLen: Byte;
Begin
  If vLblPtr = Nil Then
    LabelLen := 0
  Else
  Begin
    Move (vLblPtr^, LabelLen, 1);
    If LabelLen > 1 Then
      Inc (LabelLen);
  End;
  OnTarget :=     (X >= vBoundary. X1 - LabelLen)
  And (X <= vBoundary. X2)
  And (Y >= vBoundary. Y1)
  And (Y <= vBoundary. Y2)
  And vActive;
End; {VisibleIOOBJ.OnTarget}

Procedure VisibleIOOBJ. SetMessage (X, Y: Byte; Msg: String);
{}
Var L : Word;
Begin
  L := Succ (Length (Msg) );
  If MaxAvail >= L Then
  Begin
    GetMem (vMsgPtr, L);
    Move (Msg [0], vMsgPtr^, L);
    vMsgX := X;
    vMsgY := Y;
  End;
End; {VisibleIOOBJ.SetMessage}

Procedure VisibleIOOBJ. WriteLabel (Status: tStatus);
{}
Var
  Temp: String;
  Norm, Hi, L: Byte;
Begin
  If vLblPtr <> Nil Then
  Begin
    Move (vLblPtr^, L, 1);
    If L > 0 Then
    Begin
      Move (vLblPtr^, Temp, Succ (L) );
      AssignColors (IOTOT^. vLabel, IOTOT^. vField, Status, Hi, Norm);
      If (Hi = 0) Or (Norm = 0) Then
        Screen^. WritePlain (Pred (vBoundary. X1) - Length (Temp), vBoundary. Y1, Temp)
      Else
        Screen^. WriteHi (Pred (vBoundary. X1) - Length (strip ('A', Screen^. Himarker, Temp) ), vBoundary.Y1,Hi,Norm,Temp);
    End;
  End;
End; {VisibleIOOBJ.WriteLabel}

Procedure VisibleIOOBJ. WriteMessage;
{}
Var
  Temp: String;
  Col, L: Byte;
Begin
  If vMsgPtr <> Nil Then
  Begin
    Move (vMsgPtr^, L, 1);
    If L > 0 Then
    Begin
      Move (vMsgPtr^, Temp, Succ (L) );
      Col := IOTOT^. MessageCol;
      If Col = 0 Then
        Screen^. WritePlain (vMsgX, vMsgY, Temp)
      Else
        Screen^. WriteAt (vMsgX, vMsgY, Col, Temp);
    End;
  End;
End; {VisibleIOOBJ.WriteMessage}

Function VisibleIOOBJ. Suspend: Boolean;
{}
Var Col, L: Byte;
Begin
  Display (Norm);
  WriteLabel (Norm);
  If vMsgPtr <> Nil Then   {clear the message}
  Begin
    Move (vMsgPtr^, L, 1);
    If L > 0 Then
    Begin
      Col := IOTOT^. MessageCol;
      If Col = 0 Then
        Screen^. WritePlain (vMsgX, vMsgY, replicate (L, ' ') )
      Else
        Screen^. WriteAt (vMsgX, vMsgY, Col, replicate (L, ' ') );
      
    End;
  End;
  Suspend := True;
End; {VisibleIOOBJ.Suspend}

Destructor VisibleIOOBJ. Done;
{}
Var Len : Byte;
Begin
  ItemIOOBJ. Done;
  If vLblPtr <> Nil Then
  Begin
    Move (vLblPtr^, Len, 1);
    FreeMem (vLblPtr, Succ (Len) );    {1.00e}
  End;
  If vMsgPtr <> Nil Then
  Begin
    Move (vMsgPtr^, Len, 1);
    FreeMem (vMsgPtr, Succ (Len) );    {1.00e}
  End;
End; {desc VisibleIOOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||}
{                                        }
{     S t r i p O B J   M E T H O D S    }
{                                        }
{||||||||||||||||||||||||||||||||||||||||}

Constructor StripIOOBJ. Init (X1, Y1: Byte; Tit: String; Act: tAction);
{}
Begin
  VisibleIOOBJ. Init;
  vBoundary. X1 := X1;
  vBoundary. Y1 := Y1;
  vBoundary. X2 := X1 + Pred (Length (Strip ('A', '~', Tit) ) );
  vBoundary. Y2 := Y1;
  vTitle := Tit;
  vActionCode := Act;
End; {StripIOOBJ.Init}

Function StripIOOBJ. IsHotKey (HK: Word): Boolean;
{}
Begin
  IsHotKey := ( (HK = vHotKey) Or (HK = AltKey (vHotKey) ) ) And (vActive);   {1.00a}
  If HK = vHotKey Then
  Begin
    EscapingForm := (vActionCode = Escaped);
    FormHelpCalled := (vActionCode = Help);
  End;
End; {StripIOOBJ.IsHotKey}

Function StripIOOBJ. OnTarget (X, Y: Byte): Boolean;
{}
Var BullsEye: Boolean;
Begin
  BullsEye := VisibleIOOBJ. OnTarget (X, Y);
  If BullsEye Then
  Begin
    EscapingForm := (vActionCode = Escaped);
    FormHelpCalled := (vActionCode = Help);
  End;
  OnTarget := BullsEye;
End; {ItemIOOBJ.HotKey}

Procedure StripIOOBJ. Display (Status: tStatus);
{}
Var
   Nor, High: Byte;
Begin
  AssignColors (IOTOT^. vButton, IOTOT^. vField, Status, High, Nor);
  With vBoundary do
  Begin
    Screen^. WriteHi (X1, Y1, High, Nor, vTitle);
    If Status = HiStatus Then
      GotoXY (X1 + (X2 - X1) Div 2, Y1 + (Y2 - Y1) Div 2);
  End;
End; {StripIOOBJ.Display}

Function StripIOOBJ. Select (K: Word; X, Y: Byte): tAction;      
{}
Begin
  Display (HiStatus);
  WriteMessage;
  If Chr (K) in ['a'..'z'] Then
    K := Ord (uCase (Chr (K)));
  If ( (K <> 0) And (K = vHotKey) ) Or (K = 513) Then
    Select := vActionCode
  Else
    Select := none;
End; {StripIOOBJ.Select}

Function StripIOOBJ. ProcessKey (InKey: Word; X, Y: Byte): tAction;
{}
Begin
  If (InKey = 13) Or (InKey = 513) Then
    ProcessKey := vActionCode
  Else
    Processkey := None;
End; {StripIOOBJ.ProcessKey}

Destructor StripIOOBJ. Done;
{}
Begin
  VisibleIOOBJ. Done;
End; {StripIOOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||}
{                                            }
{     S t r i p 3 d O B J   M E T H O D S    }
{                                            }
{||||||||||||||||||||||||||||||||||||||||||||}
Constructor Strip3dIOOBJ. Init (X1, Y1: Byte; Tit: String; Act: tAction);
{}
Begin
  StripIOOBJ. Init (X1, Y1, Tit, Act);
End; {Strip3dIOOBJ.Init}

Procedure Strip3dIOOBJ. Display (Status: tStatus);
{}
Var High, Nor, A: Byte;
Begin
  StripIOOBJ. Display (Status);
  A := Screen^. ReadAttr (Succ (vBoundary. X1), Succ (vBoundary. Y1) );
  If Monitor^. ColorOn Then {color System}
    A := Cattr (0, Battr (A) )
  Else
    A := Cattr (DarkGray, battr (A) );
  Screen^. WriteAT (Succ (vBoundary. X1), Succ (vBoundary. Y1), A,
  replicate (Succ (vBoundary. X2 - vBoundary. X1), Char (223) ) );
  Screen^. WriteAT (Succ (vBoundary. X2), vBoundary. Y1, A, Char (220) );
End; {Strip3dIOOBJ.Display}

Destructor Strip3dIOOBJ. Done;
{}
Begin
  StripIOOBJ. Done;
End; {desc Strip3dIOOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||||}
{                                          }
{     B u t t o n O B J   M E T H O D S    }
{                                          }
{||||||||||||||||||||||||||||||||||||||||||}

Constructor ButtonIOOBJ. Init (X1, Y1: Byte; Tit: String; Act: tAction);
{}
Var L : Byte;
Begin
  StripIOOBJ. Init (X1, Y1, Tit, Act);
  L := Length (Strip ('A', '~', Tit) );
  vBoundary. X2 := Succ (X1 + L);
  vBoundary. Y2 := Y1 + 2;
End; {ButtonIOOBJ.Init}

Procedure ButtonIOOBJ. Display (Status: tStatus);
{}
Var
   High, Nor, Style: Byte;
Begin
  AssignColors (IOTOT^. vButton, IOTOT^. vField, Status, High, Nor);
  If Status = HiStatus Then
    Style := 5
  Else
    Style := 1;
  With vBoundary do
  Begin
    Screen^. FillBox (X1, Y1, X2, Y2, Nor, Style);
    Screen^. WriteHi (Succ (X1), Succ (Y1), High, Nor, vTitle);
    If Status = HiStatus Then
      GotoXY (X1 + (X2 - X1) Div 2, Y1 + (Y2 - Y1) Div 2);
  End;
End; {ButtonIOOBJ.Display}

Destructor ButtonIOOBJ. Done;
{}
Begin
  StripIOOBJ. Done;
End; {desc ButtonIOOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                }
{     M u l t i L i n e O B J   M E T H O D S    }
{                                                }
{||||||||||||||||||||||||||||||||||||||||||||||||}

Constructor MultiLineIOOBJ. Init (X1, Y1, width, depth: Byte; Title: String);
{}
Begin
  VisibleIOOBJ. Init;
  vTitle := Title;
  vBoundary. X1 := X1;
  vBoundary. Y1 := Y1;
  vBoundary. X2 := Pred (X1 + width);
  vBoundary. Y2 := Pred (Y1 + depth);
  SetBoxOn (False);
End; {MultiLineIOOBJ.Init}

Procedure MultiLineIOOBJ. SetBoxOn (On: Boolean);
{}
Begin
  If On Then
  Begin
    vBorder. X1 := Succ (vBoundary. X1);
    vBorder. X2 := Pred (vBoundary. X2);
    If vTitle = '' Then
      vBorder. Y1 := Succ (vBoundary. Y1)
    Else
      vBorder. Y1 := (vBoundary. Y1 + 2);
    vBorder. Y2 := Pred (vBoundary. Y2);
  End
  Else
  Begin
    vBorder. X1 := vBoundary. X1;
    vBorder. X2 := vBoundary. X2;
    If vTitle = '' Then
      vBorder. Y1 := vBoundary. Y1
    Else
      vBorder. Y1 := Succ (vBoundary. Y1);
    vBorder. Y2 := vBoundary. Y2;
  End;
  vRows := vBorder. Y2 - Pred (vBorder. Y1);
End; {MultiLineIOOBJ.SetBoxOn}

Procedure MultiLineIOOBJ. Display (Status: tStatus);
{}
Var
  High, Nor: Byte;
  Style: Byte;
  I : Integer;
Begin
  AssignColors (IOTOT^. vLabel, IOTOT^. vField, Status, High, Nor);
  If Status = HiStatus Then
    Style := 2
  Else
    Style := 1;
  With Screen^ do
  Begin
    If vTitle <> '' Then
      WriteHi (vBoundary. X1, vBoundary. Y1, High, Nor, vTitle);
    If vBoundary. X1 < vBorder. X1 Then  {box}
      With vBorder do
        Box (Pred (X1), Pred (Y1), Succ (X2), Succ (Y2), Nor, Style);
  End;
End; {MultiLineIOOBJ.Display}

Procedure MultiLineIOOBJ. Activate;
{}
Var
   Action: tAction;
Begin
  Repeat
    Action := Select (0, 0, 0);
    Display (HiStatus);
    WriteLabel (HiStatus);
    with key^ do
      Repeat
        GetInput;
        If LastKey = 27 Then
          Action := Escaped
        Else
          Action := ProcessKey (LastKey, 1, 2);
      Until Action in [Finished, Escaped, Enter, NextField, PrevField, Stop1..Stop9];
  Until Suspend;
End; {MultiLineIOOBJ.Activate}

Destructor MultiLineIOOBJ. Done;
{}
Begin
  VisibleIOOBJ. Done;
End; {MultiLineIOOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||}
{                                        }
{     G r o u p O B J   M E T H O D S    }
{                                        }
{||||||||||||||||||||||||||||||||||||||||}
Constructor GroupIOOBJ. Init (X1, Y1, width, depth: Byte; Title: String);
{}
Begin
  MultiLineIOOBJ. Init (X1, Y1, width, depth, Title);
  vItemStack := Nil;
  vActiveItem := 0;
  vTotalItems := 0;
  vSubHotkeysActive := False;
End; {GroupIOOBJ.Init}

Procedure GroupIOOBJ. SetSubHotkeysActive (On: Boolean);
{}
Begin
  vSubHotkeysActive := On;
End; {GroupIOOBJ.SetSubHotkeysActive}

Procedure GroupIOOBJ. WriteItem (Item: Byte; IsActive: Boolean);
{}
Var
  Temp: GroupItemPtr;
  High, Nor: Byte;
  Status: tStatus;
  Len : Byte;
  Str : String;
Begin
  If IsActive Then          {1.00l}
    Status := HiStatus
  Else If vActive Then
    Status := Norm
  Else
    Status := Off;
  AssignColors (IOTOT^. vGroup, IOTOT^. vField, Status, High, Nor);
  Temp := NodePtr (Item);
  If (Temp = Nil) Or (Temp^. StrPtr = Nil) Then
    Exit
  Else
  Begin
    Move (Temp^. StrPtr^, Len, 1);
    If Len > 0 Then
      Move (Temp^. StrPtr^, Str, Succ (Len) )
    Else
      Str := '';
    If Temp^. Selected Then
      Str := vOnStr + ' ' + Str
    Else
      Str := vOffStr + ' ' + Str;
    Str := Padleft (Str, vBorder. X2 
    - Pred (vBorder. X1) 
    + Length (Str) 
    - Length (strip ('A', Screen^. HiMarker, Str) ),
    ' ');
    Screen^. WriteHi (vBorder. X1, vBorder. Y1 + Pred (Item), High, Nor, Str);
    If IsActive Then
      Screen^. GotoXY (Succ (vBorder. X1), vBorder. Y1 + Pred (Item) );
  End;
End; {GroupIOOBJ.WriteItem}

Procedure GroupIOOBJ. Display (Status: tStatus);
{}
Var
  BorderCol : Byte;
  Style: Byte;
  I : Integer;
Begin
  MultiLineIOOBJ. Display (Status);
  for I := 1 to vTotalItems do
    WriteItem (I, ( (I = vActiveItem) And (Status = HiStatus) ) );
End; {GroupIOOBJ.Display}

Function GroupIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Begin
  Display (HiStatus);
  Select := none;
End; {StripIOOBJ.Select}

Function GroupIOOBJ. HotKeyItem (HK: Word): Integer;
{}
Var 
   Counter: Integer;
   Temp: GroupItemPtr;
   Found : Boolean;
Begin
  If vSubHotkeysActive Then
  Begin
    If chr (HK) in ['a'..'z'] Then
      HK := Ord (uCase (Chr (HK) ) );
    Found := False;
    Counter := 1;
    Temp := vItemStack;
    While (Temp <> Nil) And (Found = False) do
    Begin
      Found := (Temp^. HK = HK);
      If Not Found Then
      Begin
        Inc (Counter);
        Temp := Temp^. NextNode;
      End;
    End;
    If Found Then
      HotKeyItem := Counter
    Else
      HotKeyItem := 0;
  End
  Else
    HotkeyItem := 0;
End; {GroupIOOBJ.HotKeyItem}

Function GroupIOOBJ. IsHotkey (HK: Word): Boolean;
{}
Var
  Found : Boolean;
  Temp: GroupItemPtr;
Begin
  Found := (HK = vHotkey) And vActive;   {1.00p}
  If (Found = False) And vActive Then    {1.00p}
    Found := (HotKeyItem (HK) > 0);
  IsHotkey := found;   
End;  {GroupIOOBJ.IsHotkey}

Function GroupIOOBJ. EndNode: GroupItemPtr;
{returns a pointer to the last item in the list}
Var
   Temp : GroupItemPtr;
Begin
  Temp := vItemStack;
  While (Temp <> Nil) And (Temp^. NextNode <> Nil) do
    Temp := Temp^. NextNode;
  EndNode := Temp;
End; {GroupIOOBJ.EndNode}

Procedure GroupIOOBJ. AddItem (Str: String; HK: Word; Selected: Boolean);
{}
Var Temp: GroupItemPtr;
Begin
  If MaxAvail < SizeOf (vItemStack^) + Succ (Length (Str) ) Then
    Exit
  Else
  Begin
    If vItemStack = Nil Then
    Begin
      GetMem (vItemStack, SizeOf (vItemStack^) );
      vActiveItem := 1;
      vItemStack^. PrevNode := Nil;
      Temp := vItemStack;
    End
    Else
    Begin
      Temp := EndNode;
      GetMem (Temp^. NextNode, SizeOf (Temp^) );
      Temp^. NextNode^. PrevNode := Temp;
      Temp := Temp^. NextNode;
    End;
    Temp^. NextNode := Nil;
    Inc (vTotalItems);
    GetMem (Temp^. StrPtr, Succ (Length (Str) ) );
    Move (Str [0], Temp^. StrPtr^, Succ (Length (Str) ) );
    Temp^. HK := HK;
    Temp^. Selected := Selected;
    If HK <> 0 Then
      vSubHotKeysActive := True;
  End;
End; {GroupIOOBJ.AddItem}

Function GroupIOOBJ. HitItem (X, Y: Byte): Byte;
{returns the item number of the item falling on line Y, else returns 0}
Var
  B: Integer;
Begin
  B := Y - Pred (vBorder. Y1);
  If (B > vTotalItems) Or (B < 0) Or (X < vBorder. X1) Or (X > vBorder. X2) Then
    HitItem := 0
  Else
    HitItem := B;
End; {GroupIOOBJ.HitItem}

Function GroupIOOBJ. NodePtr (Item: Byte): GroupItemPtr;
{}
Var
  Temp: GroupItemPtr;
  I: Integer;
Begin
  Temp := vItemStack;
  If Item > 1 Then
    for I := 2 to Item do
      If Temp <> Nil Then
        Temp := Temp^. NextNode;
  NodePtr := Temp;
End; {GroupIOOBJ.NodePtr}

Destructor GroupIOOBJ. Done;
{}
Var 
  Temp: GroupItemPtr;
  Len: Byte;
Begin
  MultiLineIOOBJ. Done;
  Temp := EndNode;
  While Temp <> Nil do
  Begin
    If Temp^. StrPtr <> Nil Then
    Begin
      Move (Temp^. StrPtr^, Len, 1);
      FreeMem (Temp^. StrPtr, Succ (Len) ); {1.00f}
    End;
    If Temp^. PrevNode = Nil Then
    Begin
      FreeMem (Temp, SizeOf (temp^) );
      Temp := Nil;
    End
    Else
    Begin
      Temp := Temp^. PrevNode;
      FreeMem (Temp^. NextNode, SizeOf (temp^) );
    End;
  End;
End; {desc GroupIOOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||}
{                                        }
{     C h e c k O B J   M E T H O D S    }
{                                        }
{||||||||||||||||||||||||||||||||||||||||}

Constructor CheckIOOBJ. Init (X1, Y1, width, depth: Byte; Title: String);
{}
Begin
  GroupIOOBJ. Init (X1, Y1, width, depth, Title);
  vOnstr := '[X]';
  vOffStr := '[ ]';
End; {CheckIOOBJ.Init}

Function CheckIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Var
  Temp: GroupItemPtr;
  New: Byte;
Begin
  Display (HiStatus);
  WriteMessage;
  New := HotKeyItem (K);
  If New > 0 Then
  Begin
    If vActiveItem <> New Then
      WriteItem (vActiveItem, False);
    vActiveItem := New;
    Temp := NodePtr (vActiveItem);
    vActiveItem := New;
    Temp^. Selected := Not Temp^. Selected;
    WriteItem (vActiveItem, True);
  End;
  If K = 513 Then
  Begin
    New := HitItem (X, Y);
    If New > 0 Then
    Begin
      WriteItem (vActiveItem, False);
      vActiveItem := New;
      Temp := NodePtr (vActiveItem);
      Temp^. Selected := Not Temp^. Selected;
      WriteItem (vActiveItem, True);
    End;
  End;
  Select := none;
End; {CheckIOOBJ.Select}

Function CheckIOOBJ. ProcessKey (InKey: Word; X, Y: Byte): tAction;
{}
Var
  Temp: GroupItemPtr;
  New : Byte;
Begin
  New := HotKeyItem (InKey);
  If New > 0 Then
  Begin
    If New <> vActiveItem Then
    Begin
      WriteItem (vActiveItem, False);
      vActiveItem := New;
    End;
    Temp := NodePtr (vActiveItem);
    Temp^. Selected := Not Temp^. Selected;
    WriteItem (vActiveItem, True);
  End
  Else
    Case InKey Of
      32:  {space bar}
           Begin
             Temp := NodePtr (vActiveItem);
             Temp^. Selected := Not Temp^. Selected;
             WriteItem (vActiveItem, True);
           End;
      513: {mouse enter}
           Begin
             New := HitItem (X, Y);
             If New > 0 Then
             Begin
               WriteItem (vActiveItem, False);
               vActiveItem := New;
               Temp := NodePtr (vActiveItem);
               Temp^. Selected := Not Temp^. Selected;
               WriteItem (vActiveItem, True);
             End;
           End;
      336, 592: {down arrow}  {1.00c}
                Begin
                  WriteItem (vActiveItem, False);
                  If vActiveItem < vTotalItems Then
                    Inc (vActiveItem)
                  Else
                    vActiveItem := 1;
                  WriteItem (vActiveItem, True);
                End;
      328, 584: {up arrow}
                Begin
                  WriteItem (vActiveItem, False);
                  If vActiveItem > 1 Then
                    Dec (vActiveItem)
                  Else
                    vActiveItem := vTotalItems;
                  WriteItem (vActiveItem, True);
                End;
    End; {case}
  If InKey = 13 Then
    ProcessKey := NextField
  Else
    ProcessKey := None;
End; {CheckIOOBJ.ProcessKey}

Procedure CheckIOOBJ. SetValue (Item: Byte; Selected: Boolean);
{}
Var Temp: GroupItemPtr;
Begin
  Temp := NodePtr (Item);
  If Temp <> Nil Then
    Temp^. Selected := Selected;
End; {CheckIOOBJ.SetValue}

Function CheckIOOBJ. GetValue (Item: Byte): Boolean;
{}
Var
  Temp: GroupItemPtr;
Begin
  Temp := NodePtr (Item);
  If Temp <> Nil Then
    GetValue := Temp^. Selected
  Else
    GetValue := False;
End; {CheckIOOBJ.GetValue}

Destructor CheckIOOBJ. Done;
{}
Begin
  GroupIOOBJ. Done;
End; {dest CheckIOOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||}
{                                        }
{     R a d i o O B J   M E T H O D S    }
{                                        }
{||||||||||||||||||||||||||||||||||||||||}

Constructor RadioIOOBJ. Init (X1, Y1, width, depth: Byte; Title: String);
{}
Begin
  GroupIOOBJ. Init (X1, Y1, width, depth, Title);
  vOnstr :=  '()';
  vOffStr := '( )';
End; {RadioIOOBJ.Init}

Procedure RadioIOOBJ. SetValue (Item: Byte);
{}
Var I : Integer;
Begin
  for I := 1 to vTotalItems do
    NodePtr (I)^. Selected := (I = Item);
End; {RadioIOOBJ.SetValue}

Function RadioIOOBJ. ProcessKey (InKey: Word; X, Y: Byte): tAction;
{}
Var
  Temp: GroupItemPtr;
  I : Integer;
  New: Byte;
Begin
  New := HotKeyItem (InKey);
  If New <> 0 Then
  Begin
    If New <> vActiveItem Then
    Begin
      vActiveItem := New;
      Temp := NodePtr (vActiveItem);
      If Not Temp^. Selected Then
      Begin
        SetValue (vActiveItem);
        for I := 1 to vTotalItems do
          WriteItem (I, (I = vActiveItem) );
      End;
    End;
  End
  Else
    Case InKey Of
      32:  {space bar}
           Begin
             (*
             Temp := NodePtr(vActiveItem);
             if not Temp^.Selected then
             begin
             SetValue(vActiveItem);
             for I := 1 to vTotalItems do
             WriteItem(I,(I=vActiveItem));
             end;
             *)
           End;
      513: {mouse enter}
           Begin
             New := HitItem (X, Y);
             If New > 0 Then
             Begin
               vActiveItem := New;
               Temp := NodePtr (vActiveItem);
               If Not Temp^. Selected Then
               Begin
                 SetValue (vActiveItem);
                 for I := 1 to vTotalItems do
                   WriteItem (I, (I = vActiveItem) );
               End;
             End;
           End;
      336, 592: {down arrow} {1.00c}
                Begin
                  SetValue (0);              {1.00i}
                  WriteItem (vActiveItem, False);
                  If vActiveItem < vTotalItems Then
                    Inc (vActiveItem)
                  Else
                    vActiveItem := 1;
                  SetValue (vActiveItem);    {1.00i}
                  WriteItem (vActiveItem, True);
                End;
      328, 584: {up arrow}
                Begin
                  SetValue (0);              {1.00i}
                  WriteItem (vActiveItem, False);
                  If vActiveItem > 1 Then
                    Dec (vActiveItem)
                  Else
                    vActiveItem := vTotalItems;
                  SetValue (vActiveItem);    {1.00i}
                  WriteItem (vActiveItem, True);
                End;
    End; {case}
  If InKey = 13 Then
    ProcessKey := NextField
  Else
    ProcessKey := None;
End; {RadioIOOBJ.ProcessKey}

Function RadioIOOBJ. Select (K: Word; X, Y: Byte): tAction;
{}
Var
  Temp: GroupItemPtr;
  New: Byte;
  I : Integer;
Begin
  vActiveItem := GetValue;
  Display (HiStatus);
  WriteMessage;
  I := HotKeyItem (K);
  If I > 0 Then
  Begin
    vActiveItem := I;
    Temp := NodePtr (vActiveItem);
    If Not Temp^. Selected Then
    Begin
      SetValue (vActiveItem);
      for I := 1 to vTotalItems do
        WriteItem (I, (I = vActiveItem) );
    End;
  End;
  If K = 513 Then
  Begin
    New := HitItem (X, Y);
    If New > 0 Then
    Begin
      vActiveItem := New;
      Temp := NodePtr (vActiveItem);
      If Not Temp^. Selected Then
      Begin
        SetValue (vActiveItem);
        for I := 1 to vTotalItems do
          WriteItem (I, (I = vActiveItem) );
      End;
    End;
  End;
  Select := none;
End; {RadioIOOBJ.Select}

Function RadioIOOBJ. GetValue: Byte;
{}
Var I : Integer;
Begin
  I := 1;
  While (NodePtr (I)^. Selected = False) And (I < vTotalItems) do
    Inc (I);
  GetValue := I;
End; {RadioIOOBJ.GetValue}

Destructor RadioIOOBJ. Done;
{}
Begin
  GroupIOOBJ. Done;
End; {dest RadioIOOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||}
{                                          }
{     A c t i o n O B J   M E T H O D S    }
{                                          }
{||||||||||||||||||||||||||||||||||||||||||}
Constructor FormOBJ. Init;
{}
Begin
  vItemStack := Nil;
  vActiveItem := Nil;
  vCharHook := NoCharHook;
  vLeaveHook := NoLeaveHook;
  vEnterHook := NoEnterHook;
  vHelpHook := NoHelpHook;
End; {cons FormOBJ.Init}

Function FormOBJ. EndNode: pItemNode;
{returns a pointer to the last item in the last}
Var
   Temp : pItemNode;
Begin
  Temp := vItemStack;
  While (Temp <> Nil) And (Temp^. NextNode <> Nil) do
    Temp := Temp^. NextNode;
  EndNode := Temp;
End; {FormOBJ.EndNode}

Procedure FormOBJ. AddItem (Var NewItem: ItemIOOBJ);
{}
Var
   Temp : pItemNode;
Begin
  If vItemStack = Nil Then
  Begin
    GetMem (vItemStack, SizeOf (vItemStack^) );
    vItemStack^. Item := @NewItem;
    vItemStack^. NextNode := Nil;
    vItemStack^. PrevNode := Nil;
    vActiveItem := vItemStack;
  End
  Else
  Begin
    Temp := EndNode;
    GetMem (Temp^. NextNode, SizeOf (Temp^) );
    Temp^. NextNode^. PrevNode := Temp;
    Temp := Temp^. NextNode;
    Temp^. Item := @NewItem;
    Temp^. NextNode := Nil;
  End;
End; {FormOBJ.AddItem}

Procedure FormOBJ. SetCharHook (Func: CharFunc);
{}
Begin
  vCharHook := Func;
End; {FormOBJ.SetCharHook}

Procedure FormOBJ. SetLeaveHook (Func: LeaveFieldFunc);
{}
Begin
  vLeaveHook := Func;
End; {FormOBJ.SetLeaveHook}

Procedure FormOBJ. SetEnterHook (Func: EnterFieldFunc);
{}
Begin
  vEnterHook := Func;
End; {FormOBJ.SetEnterHook}

Procedure FormOBJ. SetHelpHook (Proc: HelpProc);
{}
Begin
  vHelpHook := Proc;
End; {FormOBJ.SetHelpHook}

Procedure FormOBJ. DisplayItems;
{}
Var
   Temp: pItemNode;
Begin
  Temp := vItemStack;
  While Temp <> Nil do
  Begin
    If Temp^. Item^. Active Then
    Begin
      If Temp = vActiveItem Then
      Begin
        Temp^. Item^. Display (HiStatus);
        Temp^. Item^. WriteLabel (HiStatus);
      End
      Else
      Begin
        Temp^. Item^. Display (Norm);
        Temp^. Item^. WriteLabel (Norm);
      End;
    End
    Else
    Begin
      Temp^. Item^. Display (Off);
      Temp^. Item^. WriteLabel (Off);
    End;
    Temp := Temp^. NextNode;
  End;
End; {FormOBJ.DisplayItems}

Function FormOBJ. IDItemPtr (ID: Word): pItemNode;
{returns a pointer to the item which has the specified ID --
 if no item is found the function returns nil}
Var
  Temp: pItemNode;
  proceed: Boolean;
Begin
  Temp := vItemStack;
  Proceed := True;
  While (Temp <> Nil) And Proceed do
  Begin
    If Temp^. Item^. GetID = ID Then
      Proceed := False
    Else
      Temp := Temp^. NextNode;
  End;
  IDItemPtr := Temp;
End; {FormOBJ.IDItemPtr}

Procedure FormOBJ. SetActiveItem (ID: Word);
{}
Begin
  vActiveItem := IDItemPtr (ID);
  If vActiveItem = Nil Then
    vActiveItem := vItemStack;
End; {FormOBJ.SetActiveItem}

Function FormOBJ. HotkeyItemPtr (Hotkey: Word): pItemNode;
{returns a pointer to the item which can be selected with the hotkey --
 if no item is found the function returns nil}
Var
  Temp: pItemNode;
  proceed: Boolean;
Begin
  If chr (HotKey) in ['a'..'z'] Then
    HotKey := Ord (uCase (Chr (HotKey) ) );
  If vActiveItem^. Item^. IsHotKey (Hotkey) Then
    HotKeyItemPtr := vActiveItem
  Else
  Begin
    Proceed := True;
    Temp := vItemStack;
    While (Temp <> Nil) And Proceed do
    Begin
      If Temp^. Item^. IsHotKey (Hotkey) Then
        Proceed := False
      Else
        Temp := Temp^. NextNode;
    End;
    HotkeyItemPtr := Temp;
  End;
End; {FormOBJ.HotkeyItemPtr}

Function FormOBJ. HotSpotItemPtr (X, Y: Byte): pItemNode;
{returns a pointer to the item which can has been clicked on with the mouse --
 if no item is found the function returns nil}
Var
  Temp: pItemNode;
  proceed: Boolean;
Begin
  If vActiveItem^. Item^. OnTarget (X, Y) Then   {1.00b}
    Temp := vActiveItem
  Else
  Begin
    Temp := vItemStack;
    Proceed := True;
    While (Temp <> Nil) And Proceed do
    Begin
      If Temp^. Item^. OnTarget (X, Y) Then
        Proceed := False
      Else
        Temp := Temp^. NextNode;
    End;
  End;
  HotSpotItemPtr := Temp;
End; {FormOBJ.HotSpotItemPtr}

Procedure FormOBJ. BroadcastSignal (TheSig: tSignal; SignalSource: pItemNode);
{recursive signal passer - an item which is handling a signal may raise
 an additional signal}
Var
  ItemPtr: pItemNode;
  NewSig: tSignal;
Begin
  ItemPtr := SignalSource;
  Repeat
    {move on to next node}
    If ItemPtr^. NextNode <> Nil Then
      ItemPtr := ItemPtr^. NextNode
    Else
      ItemPtr := vItemStack;
    NewSig. ID := 0;  {do nothing}
    ItemPtr^. Item^. HandleSignal (TheSig, NewSig);
    If NewSig. ID <> 0 Then
      BroadcastSignal (NewSig, ItemPtr);
    If TheSig. ID = 0 Then
    Begin
      SignalSource^. Item^. ShutdownSignal (TheSig);
      If TheSIG. ID = 0 Then
        Exit
      Else
        BroadcastSignal (TheSig, SignalSource);
    End;
  Until ItemPtr = SignalSource;
  SignalSource^. Item^. ShutdownSignal (TheSig);
End; {FormOBJ.BroadcastSignal}

Procedure FormOBJ. HelpTask (ID: Word);
{}
Begin
  vHelpHook (ID);
End; {FormOBJ.HelpTask}

Function FormOBJ. CharTask (Var K: Word; Var X, Y: Byte; Var FieldID: Word): tAction;             
{}
Begin
  CharTask := vCharHook (K, X, Y, FieldID);
End; {FormOBJ.CharTask}

Function FormOBJ. EnterTask (Var NewID: Word; OldID: Word): tAction; 
{}
Begin
  EnterTask := vEnterHook (NewID, OldID);
End; {FormOBJ.EnterTask}

Function FormOBJ. LeaveTask (Var FieldID: Word): tAction;           
{}
Begin
  LeaveTask := vLeaveHook (FieldID);
End; {FormOBJ.LeaveTask}

Procedure FormOBJ. AdjustKey (Var Key: Word; Var X, Y: Byte);
{abstract}
Begin End;

Function FormOBJ. Go: tAction;
{}
Var
   HookAction,
   Task : tAction;
   NewItemPtr: pItemNode;
   LastActiveItemID, ID, K, W: Word;
   X, Y: Byte;
   Mvisible: Boolean;

   Procedure ProcessTask;
   {}
   Var TheSig: tSignal;
   Begin
     Case Task Of
       NextField:
                  Begin
                    NewItemPtr := vActiveItem;
                    Repeat
                      If NewItemPtr^. NextNode <> Nil Then
                        NewItemPtr := NewItemPtr^. NextNode
                      Else
                        NewItemPtr := vItemStack;
                    Until NewItemPtr^. Item^. Active;
                  End;
       PrevField:
                  Begin
                    NewItemPtr := vActiveItem;
                    Repeat
                      If NewItemPtr^. PrevNode <> Nil Then
                        NewItemPtr := NewItemPtr^. PrevNode
                      Else
                        NewItemPtr := EndNode;
                    Until NewItemPtr^. Item^. Active;
                  End;
       Refresh: DisplayItems;
       Signal:
               Begin
                 vActiveItem^. Item^. RaiseSignal (TheSig);
                 If TheSig. ID <> 0 Then
                   BroadcastSignal (TheSig, vActiveItem);
               End;
       Help:
             Begin
               HelpTask (LastActiveItemID);
               If LastActiveItemID <> 0 Then
               Begin
                 If LastActiveItemID <> HelpID Then
                   If vActiveItem^. Item^. Suspend Then
                     vActiveItem := IDItemPtr (LastActiveItemID);
               End;
               Task := vActiveItem^. Item^. Select (0, X, Y);
             End;
     End; {case}
   End; {ProcessTask}

   Procedure ProcessChar;
   Var
     Bypassing, Ignore: Boolean;
   Begin
     Key^. GetInput;
     If BreakOut Then Begin
       Task := Escaped;
       Exit;
     End;
     K := key^. LastKey;
     Ignore := False;

{     If K = kDown Then
       K := kTab
     Else
       If K = kUp Then
         K := 271;}

     AdjustKey (K, X, Y);
     If K = 600 Then
       HookAction := Escaped
     Else
     Begin
       ID := vActiveItem^. Item^. GetID;
       HookAction := CharTask (K, X, Y, ID);
     End;
     Case HookAction Of
       Escaped,
       Finished,
       Stop1..Stop9 :
                      Begin
                        Task := HookAction;
                        Exit;
                      End;
       Refresh: DisplayItems;
     End; {case}
     If ID <> vActiveItem^. Item^. GetID Then {hook changed the active field}
       NewItemPtr := IDItemPtr (ID)
     Else
       NewItemPtr := HotKeyItemPtr (K);
     If NewItemPtr = Nil Then {no hotkey pressed}
     Begin
       Begin
         Task := vActiveItem^. Item^. ProcessKey (K, X, Y);
         ProcessTask;
       End;
     End;
     If (NewItemPtr <> Nil) And (Ignore = False) Then
     Begin
       ByPassing := False;
       Repeat
         If EscapingForm Then
         Begin
           Task := Escaped;
         End
         Else If FormHelpCalled Then
         Begin
           HelpTask (vActiveItem^. Item^. GetID);
           Task := none;
           FormHelpCalled := False;
         End
           Else
           Begin
             If Bypassing Or vActiveItem^. Item^. Suspend Then
             Begin
               {Leave Hook}
               If (vActiveItem^. Item^. Active)
                  And (Bypassing = False)
               Then {don't Hook if Bypassing}
               Begin
                 ID := vActiveItem^. Item^. GetID;
                 HookAction := LeaveTask (ID);
                 Case HookAction Of
                   Escaped,
                   Finished,
                   Stop1..Stop9 : Begin
                     Task := HookAction;
                     Exit;
                   End;
                   Refresh:
                            Begin                           {1.00n}
                              DisplayItems;
                              vActiveItem^. Item^. Display (Norm);
                            End;
                 End; {case}
                 If ID = StayPut Then {1.00h}
                 Begin
                   Task := None;
                   vActiveItem^. Item^. Display (HiStatus);         {1.00o}
                   Exit;
                 End Else If ID <> vActiveItem^. Item^. GetID Then {hook changed the active field}
                   NewItemPtr := IDItemPtr (ID);
               End;
               {Change active fields}
               If NewItemPtr^. Item^. Active Then
               Begin
                 vActiveItem := NewItemPtr;
                 {Enter Hook}
                 ID := vActiveItem^. Item^. GetID;
                 HookAction := EnterTask (ID, LastActiveItemID);
                 Case HookAction Of
                   Escaped,
                   Finished,
                   Stop1..Stop9:
                                 Begin
                                   Task := HookAction;
                                   Exit;
                                 End;
                   Refresh: DisplayItems;
                 End; {case}
                 If ID <> vActiveItem^. Item^. GetID Then {hook changed the active field}
                 Begin
                   ByPassing := True;
                   NewItemPtr := IDItemPtr (ID);
                   Task := None;
                 End
                 Else
                 Begin
                   ByPassing := False;
                   W := vActiveItem^. Item^. GetID;
                   If ( (W <> 0) And (W <> HelpID) )
                      Or ( (W = HelpID) And ( (K <> 513) And (K <> vActiveItem^. Item^. GetHotKey) ) )
                   Then
                     LastActiveItemID := W;
                   Task := vActiveItem^. Item^. Select (K, X, Y);
                 End;
               End
               Else
               Begin                {1.00d}
                 {No Enter Hook for inactive tasks}
                 Task := NewItemPtr^. Item^. Select (K, X, Y);
                 If Not (Task in [Finished, Escaped, Stop1..Stop9] ) Then {1.00g}
                   ByPassing := True;
               End;
               ProcessTask;
             End
             Else    {suspension failed due to validation error}
               Task := None; {don't leave field}
           End;
       Until (Bypassing = False) And ( (Task in [NextField, PrevField] ) = False);
     End;
   End; {ProcessChar}

Begin
  EscapingForm := False;
  FormHelpCalled := False;
  DisplayItems;
  {No Enter Hook at initial start-up}
  If Not vActiveItem^. Item^. Visible Then
  Begin
    vActiveItem := vItemStack;
    While (vActiveItem <> Nil) And (vActiveItem^. Item^. Visible = False) do
      vActiveItem := vActiveItem^. NextNode;
  End;
  If vActiveItem = Nil Then {no fields to edit}
  Begin
    Go := None;  {1.00a}
  End
  Else
  Begin
    Task := vActiveItem^. Item^. Select (0, 0, 0);
    LastActiveItemID := vActiveItem^. Item^. GetID;
    Task := None;
    Repeat
      ProcessChar;
    Until (Task in [Finished, Escaped, Stop1..Stop9] );
    If Task <> Escaped Then
      If vActiveItem^. Item^. Suspend Then;
    Go := Task;
  End;
  EscapingForm := False;
  FormHelpCalled := False;
End; {FormOBJ.Go}

Function FormOBJ. StopID: Word;
{1.00j}
Begin
  If vActiveItem = Nil Then
    StopID := 0
  Else
    StopID := vActiveItem^. Item^. GetID;
End; {FormOBJ.StopID}

Destructor FormOBJ. Done;
{frees all allocated memory for the linked list}
Var
  Temp1, Temp2: pItemNode;
Begin
  If vItemStack <> Nil Then
  Begin
    Temp1 := vItemStack;
    Temp2 := Temp1^. NextNode;
    While Temp2 <> Nil do
    Begin
      FreeMem (Temp1, SizeOf (Temp1^) );
      Temp1 := Temp2;
      Temp2 := Temp1^. NextNode;
    End;
    FreeMem (Temp1, SizeOf (Temp1^) );
  End;
End; {destructor FormOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                }
{     W i n A c t i o n O B J   M E T H O D S    }
{                                                }
{||||||||||||||||||||||||||||||||||||||||||||||||}

Constructor WinFormOBJ. Init;
{}
Begin
  New (vWinPtr, Init);
  FormOBJ. Init;
End; {WinFormOBJ.Init}

Procedure WinFormOBJ. AdjustKey (Var Key: Word; Var X, Y: Byte);
{}
Var WX, WY: Byte;
    TempX, TempY: Integer;
Begin
  vWinPtr^. WinKey (Key, X, Y);
  TempX := X;
  TempY := Y;
  WX := vWinPtr^. GetX;
  WY := vWinPtr^. GetY;
  If (Key > 600) Or (TempX < WX) Or (TempY < WY) Then
  Begin
    TempX := 0;
    TempY := 0;
  End
  Else
  Begin
    Case vWinPtr^. GetStyle Of
      0: Begin
        Dec (TempX, Pred (WX) );
        Dec (TempY, Pred (WY) );
      End;
      6: 
         Begin
           Dec (TempX, Pred (WX) );
           Dec (TempY, WY + 2);
         End;
      Else Begin
        Dec (TempX, WX);
        Dec (TempY, WY);
      End;
    End; {case}
  End;
  If TempX > 0 Then
    X := TempX
  Else
    X := 0;
  If TempY > 0 Then
    Y := TempY
  Else
    Y := 0;
End; {WinFormOBJ.AdjustKey}

Function WinFormOBJ. Win: MoveWinPtr;
{}
Begin
  Win := vWinPtr;
End; {WinFormOBJ.Win}

Procedure WinFormOBJ. Draw;                       
{}
Begin
  vWinPtr^. Draw;
End; {WinFormOBJ.DisplayItems}

Destructor WinFormOBJ. Done;
{}
Begin
  Dispose (vWinPtr, Done);
  FormOBJ. Done;
End; {WinFormOBJ.Done}

{|||||||||||||||||||||||||||||||||||||||||||||||}
{                                               }
{     U N I T   I N I T I A L I Z A T I O N     }
{                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||}
Procedure IO1Init;
{initilizes objects and global variables}
Begin
  New (IOTOT, Init);
End; {IO1Init}

begin
  io1init;
End.
