Unit totDATE;
{$I Sys75.Inc}

Interface

Uses
  dos, totSTR;

type
  Str8  = String [8];
  Str10 = String [10];

  Date = Word;
  Time = LongInt;
  DateTimeRec =
    record
      D : Date;
      T : Time;
    end;

  DayType = (Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday);

const
  MinYear  = 1900;
  MaxYear  = 2078;
  MinDate  = $0000;        {= 01/01/1900}
  MaxDate  = $FF62;        {= 12/31/2078}
  Date1900 = $0000;        {= 01/01/1900}
  Date1980 = $7223;        {= 01/01/1980}
  Date2000 = $8EAC;        {= 01/01/2000}
  BadDate  = $FFFF;

  Threshold2000 : Integer = 1900;

  MinTime = 0;
  MaxTime = 86399;
  BadTime = $FFFFFFFF;
  First2Months = 58;
  FirstDayOfWeek = Monday;

  SecondsInDay = 86400;
  SecondsInHour = 3600;
  SecondsInMinute = 60;
  HoursInDay = 24;
  MinutesInHour = 60;

function  IsLeapYear(Year : Integer) : Boolean;
function  DaysInMonth(Month, Year : Integer) : Integer;
function  ValidDate(Day, Month, Year : Integer) : Boolean;
function  DMYtoDate(Day, Month, Year : Integer) : Date;
procedure DateToDMY(Julian : Date; var Day, Month, Year : Integer);
procedure DateTimeDiff(DT1, DT2 : DateTimeRec; var Days : Word; var Secs : LongInt);
procedure TimeToHMS(T : Time; var Hours, Minutes, Seconds : Byte);
function  HMStoTime(Hours, Minutes, Seconds : Byte) : Time;
procedure IncDateTime(var DT1, DT2 : DateTimeRec; Days : Integer; Secs : LongInt);
function  datenow: date;
function  timenow: time;

function  timestr (t:time):str8;
function  validtimestr (var time:str8):boolean;
function  timeval (q:str8):time;

function  datestr (d: date):str8;
function  validdatestr (var date: str10):boolean;
function  dateval (q:str10):date;

procedure now (var dt: datetimerec);
Function  CurrentTime (Sex: Boolean): String;
Function  CurrentDate (Yer: Boolean): String;
Procedure GetDateTimeStr (dt: datetimerec; Var Date, Time: Str8);
Function  dateof (d: date): String;
Function  timeof (t: time): String;
Function  DaysSince (da: date): LongInt;
Function  YearsDif (D1, D2: date): longint;
Function  MinPastMidNite (dt: time): Word;

Implementation

Function CurrentTime (Sex: Boolean): String;
Var
  Hour, Min, Sec: String [2];
  H, M, S, T : Word;
Begin
  GetTime (H, M, S, T);
  Str (H, Hour);
  Str (M, Min);
  Str (S, Sec);
  If Sex Then
    CurrentTime := padright (Hour, 2, '0') + ':' + padright (Min, 2, '0') + ':' + padright (Sec, 2, '0')
  Else
    CurrentTime := padright (Hour, 2, '0') + ':' + padright (Min, 2, '0');
End;

Function CurrentDate (Yer: Boolean): String;
Var
  Year: String [4];
  Month, Day: String [2];
  Y, M, D, o : Word;
Begin
  GetDate (Y, M, D, o);
  Str (Y, Year);
  Delete (Year, 1, 2);
  Str (M, Month);
  Str (D, Day);
  If Yer Then
    CurrentDate := padright (Month, 2, '0') + '/' + padright (Day, 2, '0') + '/' + padright (Year, 2, '0')
  Else
    CurrentDate := padright (Month, 2, '0') + '/' + padright (Day, 2, '0');
End;

Procedure GetDateTimeStr (dt: datetimerec; Var Date, Time: Str8);
Begin
  with dt do begin
    Time := TimeStr (t);
    Date := DateStr (d);
  end;
End;

function timestr (t:time):str8;
Var
  hr, mn, sc: byte;
  H, M, S: String [2];
begin
  timetohms (t, hr, mn, sc);
  Str (hr, H);
  Str (Mn, M);
  Str (Sc, S);

  If sc < 10 Then
    S := '0' + S;
  If Mn < 10 Then
    M := '0' + M;
  If Hr < 10 Then
    H := '0' + H;

  TimeStr := H + ':' + M + ':' + S;
end;

function validtimestr (var time: str8):boolean;
var
  b: byte;
begin
  repeat
    if (length (time) < 4) or (length (time) = 6) or (length (time) = 7) then break;
    if (length (time) = 4) and (time [2] = ':') then insert ('0', time, 1);
    if time [3] <> ':' then break;
    if not (time [1] in ['0'..'2']) then break;
    if not (time [2] in ['0'..'9']) then break;
    if not (time [4] in ['0'..'5']) then break;
    if not (time [5] in ['0'..'9']) then break;
    if (time [1] = '2') and (time [2] > '3') then break;

    if length (time) = 8 then begin
      if not (time [7] in ['0'..'5']) then break;
      if not (time [8] in ['0'..'9']) then break;
    end;

    validtimestr := true;
    exit;
  until false;

  validtimestr := false;
end;

function timeval (q:str8):time;
var
  hour, min, sec: integer;
begin
  timeval := 0;
  if not validtimestr (q) then exit;

  hour := strtoint (copy (q, 1, 2));
  min := strtoint (copy (q, 4, 5));
  if length (q) = 8 then
    sec := strtoint (copy (q, 7, 8))
  else
    sec := 0;

  timeval := hmstotime (hour, min, sec);
end;

function datestr (d: date):str8;
Var
  Y, Mo, Da: String [4];
  yr, mn, dy: integer;
begin
  datetodmy (d, dy, mn, yr);
  Str (Yr, Y);
  Str (Mn, Mo);
  Str (Dy, Da);

  If Mn < 10 Then
    Mo := '0' + Mo;
  If Dy < 10 Then
    Da := '0' + Da;

  Delete (Y, 1, 2);
  Datestr := Mo + '/' + Da + '/' + Y;
end;

function validdatestr (var date:str10):boolean;
var
  b: byte;
begin
  repeat
    if date [2] = '/' then insert ('0', date, 1);
    if date [5] = '/' then insert ('0', date, 4);
    if (length (date) < 5) or (length (date) = 6) or (length (date) = 7) or (length (date) = 9) then break;
    if (date [3] <> '/') or (date [6] <> '/') then break;

    if not (date [1] in ['0'..'1']) then break;
    if not (date [2] in ['0'..'9']) then break;
    if (date [1] = '1') and (date [2] > '2') then break;

    if not (date [4] in ['0'..'3']) then break;
    if not (date [5] in ['0'..'9']) then break;
    if (date [4] = '3') and (date [5] > '1') then break;

    if length (date) >= 8 then begin
      if not (date [7] in ['0'..'9']) then break;
      if not (date [8] in ['0'..'9']) then break;
    end;

    if length (date) = 10 then begin
      if not (date [9] in ['0'..'9']) then break;
      if not (date [10] in ['0'..'9']) then break;
    end;

    validdatestr := true;
    exit;
  until false;

  validdatestr := false;
end;

function dateval (q:str10):date;
var
  w: word;
  d, m, y: integer;
begin
  dateval := 0;
  if not validdatestr (q) then exit;
  if length (q) < 8 then exit;

  m := strtoint (copy (q, 1, 2));
  d := strtoint (copy (q, 4, 2));
  if length (q) = 10 then
    y := strtoint (copy (q, 7, 4))
  else begin
    w := strtoint (copy (q, 7, 2));
    if w < 80 then
      y := 2000 + w
    else
      y := 1900 + w;
  end;

  dateval := dmytodate (d, m, y);
end;

procedure now (var dt: datetimerec);
var
  hour, min, sec, year, month, day, t: word;
begin
  gettime (hour,min,sec,t);
  if (t > 50) and (sec = 59) then begin
    sec := 0;
    if min >= 59 then begin
      if hour >= 23 then
        hour := 0
      else
        inc (hour);
      min := 0;
    end else inc (min);
  end;
  getdate (year,month,day,t);
  with DT do begin
    D := DMYtoDate(Day, Month, Year);
    T := HMStoTime(Hour, Min, Sec);
  end;
end;

Function dateof (d: date): String;
begin
  Dateof := DateStr (d);
end;

Function timeof (t: time): String;
begin
  Timeof := TimeStr (t);
end;

Function DaysSince (da: date): LongInt;
var
  z: datetimerec;
Begin
  now (z);
  DaysSince := z. d - da;
End;

Function YearsDif (D1, D2: date): longint;
var
  days: word;
  secs: longint;
  dt1, dt2: datetimerec;
begin
  dt1. t := 0;
  dt2. t := 0;
  dt1. d := d1;
  dt2. d := d2;
  DateTimeDiff (Dt1, Dt2, Days, Secs);
  yearsdif := days div 365;
end;

Function  MinPastMidNite (dt: time): Word;
var
  h, m, s: byte;
begin
  timetohms (dt, h, m, s);
  MinPastMidnite := h * 60 + m;
end;

function IsLeapYear(Year : Integer) : Boolean;
  {-Return True if Year is a leap year}
begin
  IsLeapYear := (Year mod 4 = 0) and (Year mod 4000 <> 0) and
    ((Year mod 100 <> 0) or (Year mod 400 = 0));
end;

function DaysInMonth(Month, Year : Integer) : Integer;
  {-Return the number of days in the specified month of a given year}
begin
  if Word(Year) < 100 then begin
    Inc(Year, 1900);
    if Year < Threshold2000 then
      Inc(Year, 100);
  end;

  case Month of
    1, 3, 5, 7, 8, 10, 12 :
      DaysInMonth := 31;
    4, 6, 9, 11 :
      DaysInMonth := 30;
    2 :
      DaysInMonth := 28+Ord(IsLeapYear(Year));
  else
    DaysInMonth := 0;
  end;
end;

function ValidDate(Day, Month, Year : Integer) : Boolean;
  {-Verify that day, month, year is a valid date}
begin
  if Word(Year) < 100 then begin
    Inc(Year, 1900);
    if Year < Threshold2000 then
      Inc(Year, 100);
  end;
  if (Day < 1) or (Year < MinYear) or (Year > MaxYear) then
    ValidDate := False
  else case Month of
    1..12 :
      ValidDate := Day <= DaysInMonth(Month, Year);
  else
    ValidDate := False;
  end
end;

function DMYtoDate(Day, Month, Year : Integer) : Date;
  {-Convert from day, month, year to a julian date}
begin
  if Word(Year) < 100 then begin
    Inc(Year, 1900);
    if Year < Threshold2000 then
      Inc(Year, 100);
  end;
  if not ValidDate(Day, Month, Year) then
    DMYtoDate := BadDate
  else if (Year = MinYear) and (Month < 3) then
    if Month = 1 then
      DMYtoDate := Pred(Day)
    else
      DMYtoDate := Day+30
  else begin
    if Month > 2 then
      Dec(Month, 3)
    else begin
      Inc(Month, 9);
      Dec(Year);
    end;
    Dec(Year, MinYear);
    DMYtoDate :=
        ((LongInt(Year)*1461) div 4)+
        (((153*Month)+2) div 5)+Day+First2Months;
  end;
end;

procedure DateToDMY(Julian : Date; var Day, Month, Year : Integer);
  {-Convert from a julian date to month, day, year}
var
  I : LongInt;
begin
  if Julian = BadDate then begin
    Day := 0;
    Month := 0;
    Year := 0;
  end
  else if Julian <= First2Months then begin
    Year := MinYear;
    if Julian <= 30 then begin
      Month := 1;
      Day := Succ(Julian);
    end
    else begin
      Month := 2;
      Day := Julian-30;
    end;
  end
  else begin
    I := (4*LongInt(Julian-First2Months))-1;
    Year := I div 1461;
    I := (5*((I mod 1461) div 4)) + 2;
    Month := I div 153;
    Day := ((I mod 153)+5) div 5;
    if Month < 10 then
      Inc(Month, 3)
    else begin
      Dec(Month, 9);
      Inc(Year);
    end;
    Inc(Year, MinYear);
  end;
end;

procedure DateTimeDiff(DT1, DT2 : DateTimeRec; var Days : Word; var Secs : LongInt);
  {-Return the difference in days and seconds between two points in time}
var
  DTTemp : DateTimeRec;
begin
  {swap if DT1 later than DT2}
  if (DT1.D > DT2.D) or ((DT1.D = DT2.D) and (DT1.T > DT2.T)) then begin
    DTTemp := DT1;
    DT1 := DT2;
    DT2 := DTTemp;
  end;

  {the difference in days is easy}
  Days := DT2.D-DT1.D;

  {difference in seconds}
  if DT2.T < DT1.T then begin
    {subtract one day, add 24 hours}
    Dec(Days);
    Inc(DT2.T, SecondsInDay);
  end;
  Secs := DT2.T-DT1.T;
end;

procedure TimeToHMS(T : Time; var Hours, Minutes, Seconds : Byte);
  {-Convert a Time variable to Hours, Minutes, Seconds}
begin
  if T = BadTime then begin
    Hours := 0;
    Minutes := 0;
    Seconds := 0;
  end
  else begin
    Hours := T div SecondsInHour;
    Dec(T, LongInt(Hours)*SecondsInHour);
    Minutes := T div SecondsInMinute;
    Dec(T, LongInt(Minutes)*SecondsInMinute);
    Seconds := T;
  end;
end;

function HMStoTime(Hours, Minutes, Seconds : Byte) : Time;
  {-Convert Hours, Minutes, Seconds to a Time variable}
var
  T : Time;
begin
  Hours := Hours mod HoursInDay;
  T := (LongInt(Hours)*SecondsInHour)+(LongInt(Minutes)*SecondsInMinute)+Seconds;
  HMStoTime := T mod SecondsInDay;
end;

procedure IncDateTime(var DT1, DT2 : DateTimeRec; Days : Integer; Secs : LongInt);
  {-Increment (or decrement) DT1 by the specified number of days and seconds
    and put the result in DT2}
begin
  DT2 := DT1;

  {date first}
  Inc(Integer(DT2.D), Days);

  if Secs < 0 then begin
    {change the sign}
    Secs := -Secs;

   {adjust the date}
    Dec(DT2.D, Secs div SecondsInDay);
    Secs := Secs mod SecondsInDay;
     if Secs > DT2.T then begin
      {subtract a day from DT2.D and add a day's worth of seconds to DT2.T}
      Dec(DT2.D);
      Inc(DT2.T, SecondsInDay);
    end;
     {now subtract the seconds}
    Dec(DT2.T, Secs);
  end
  else begin
    {increment the seconds}
    Inc(DT2.T, Secs);
     {adjust date if necessary}
    Inc(DT2.D, DT2.T div SecondsInDay);
     {force time to 0..SecondsInDay-1 range}
    DT2.T := DT2.T mod SecondsInDay;
  end;
end;

function datenow: date;
var
  p: datetimerec;
begin
  now (p);
  datenow := p. d;
end;

function timenow: time;
var
  p: datetimerec;
begin
  now (p);
  timenow := p. t;
end;

End.



