TYPE

  xy = Record
    x, y: byte;
  end;

  axy = Record
    a, x, y: byte;
  end;

  menurec =                        { *.Mnu : Menu records }
  Record
    Name: String [8];              { used to specify which menu to load }
    prompt: String;                { menu prompt if script or name }
    helpfile: PathStr;             { help or pulldown display file }
    acs: STRING;                   { minimum acs requirements }
    password: STRING;              { password required }
    Special: String [2];           { menu type }
    FallBack: String [8];          { menu to set as fallback }
  End;

  pullinfo=
  Record
    ON:STRING;
    OFF:STRING;
    X:1..80;
    Y:1..25;
    END;

  commandrec =                { *.Cmd : Command records }
  Record
    desc: string[30];              { description for generics and reference only }
    keys: string[30];              { command-execution keys }
    acs: string[30];               { minimum acs requirements }
    data: String [2];              { the actual command }
    param: String;                 { command data }
    pull: PULLINFO;            { for pulldown menus }
    hidden: boolean;               { should command show up in generic menus? }
    pause: boolean;                { wait for enter after command? }
  End;

  pulldownrec = record
    vaxy: axy;
    comm: commandrec;
  end;
  var pulldown,
      list:pDLLobj;
      cmdlist: pDllobj;
      menu:Menurec;
      command:commandrec;
  Const
  FailFlag     : Boolean = False;
  NewMenu      : Boolean = False;
  RunFirstCmd  : Boolean = True;
  BadMenu      : Boolean = False;
  MaxInLen     : Byte = 80;
  TopMenu      : String[8] = '';
  CurMenu      : String[8] = '';
  BadCommandStr: String = '';
  InputStr     : String = '';
  WildCardStr  : String = '';
const
  maxchoices=30;
type
PULLD=RECORD
    CURRENTCHOICE:INTEGER;
    K:CHAR;
    CH:INTEGER;
    MAXC:INTEGER;
    UNHIGHLIGHT:ARRAY[1..MAXCHOICES] OF STRING[80];
    HIGHLIGHT:ARRAY[1..MAXCHOICES] OF STRING[80];
    COMMANDCHAR:ARRAY[1..MAXCHOICES] OF CHAR;
    CX:ARRAY[1..MAXCHOICES] OF INTEGER;
    CY:ARRAY[1..MAXCHOICES] OF INTEGER;
    END;
VAR PM:PULLD;
FUNCTION LPULLMENU:INTEGER;
    VAR X:INTEGER;
    CINPUT:CHAR;
    C:CHAR;

BEGIN
FOR X:=1 TO pm.MAXC DO BEGIN
GOTOXY(pm.CX[X],pm.CY[X]);
WRITE(pm.UNHIGHLIGHT[X]);
END;
GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
REPEAT
    C:=READKEY;
    if c=#0 then begin
    c:=readkey;
IF ORD(C) IN [72,75] THEN BEGIN
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.UNHIGHLIGHT[pm.CURRENTCHOICE]);
    DEC(pm.CURRENTCHOICE);
    IF pm.CURRENTCHOICE=0 THEN pm.CURRENTCHOICE:=pm.MAXC;
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
    END ELSE
IF ORD(C) IN [77,80] THEN BEGIN
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.UNHIGHLIGHT[pm.CURRENTCHOICE]);
    INC(pm.CURRENTCHOICE);
    IF pm.CURRENTCHOICE=pm.MAXC+1 THEN pm.CURRENTCHOICE:=1;
    GOTOXY(pm.CX[pm.CURRENTCHOICE],pm.CY[pm.CURRENTCHOICE]);
    WRITE(pm.HIGHLIGHT[pm.CURRENTCHOICE]);
    END;
end;
UNTIL ORD(C) IN [13];
LPULLMENU:=pm.CURRENTCHOICE;
END;
