Unit MiscSys;
{$I Sys75.Inc}

Interface

Procedure StringsEditor;
Procedure XferProtoEditor;
Procedure EventEditor;
Procedure MenuEditor;
Procedure ConfEditor;
Procedure SetEditor;

Implementation

Uses
  Dos,
  TotStr, TotLink, TotFast, TotKey, TotMisc, TotDate,
  Menus, Emu, EmuCodes, RemEmu, Comm, Spuds, Users, Misc, Events, Acs, regs;

Const
  MaxPrompts: byte = 139;

Procedure StringsEditor;
Var
  I, H: File of String;
  C: Char;
  fPos, FS: Integer;
  Page, Max: Byte;

  Function ReadShowPage: Byte;
  Var
    B: Byte;
    S: String;
  Begin
    Send (Cls);

    Seek (H, fpos);
    Seek (I, fpos);
    For B := 1 To 5 Do Begin
      Read (H, S);
      ColWriteln ('|US' + Chr (B + 48) + '|UP) |UP[|UR' + PadRight (IntToStr (fPos + B), 3, ' ')  + '|UP]|UR ' + S);
      Read (I, S);
      ColWriteln (S);
      If EoF (I) Then Break;
    End;
    ReadShowPage := B;
    ComWrite (^M^J'|UREnter String to edit |UP[|US1|UP-|US5|UP,|US[|UP,|US]|UP,|USG|UP,|USS|UP,|USH|UP,|USQ|UP]: |UI');
  End;

  Procedure ReadStr (N: Byte);
  Var
    S: String;
  Begin
    Seek (h, fpos + Pred (n));
    Read (h, s);
    if s = 'Currently unused.' then exit;
    comwriteln ('|URPress |UP[|US^U|UP] |URfor an Asskey Chart');
    with user do begin
      send (attr (cols [2]) + '%%file' + attr (cols [1]) + ' shows file, ' + attr (cols [2]) + '!!file' + attr (cols [1]) +
            ' runs script, ' + attr (cols [2]) + '^Xtext' + attr (cols [1]) + ' shows hdr, ' + attr (cols [2]) + '##x,y#' +
            attr (cols [1]) + ' goes to x,y.'^M^J^J);
    end;

    usercol (4);
    Send (s + ^M^J);
    Seek (i, fpos + Pred (n));
    Read (i, s);
    usercol (2);
    GetStr (255, False, True, S);
    If hung Then Exit;
    Seek (i, fpos + Pred (n));
    Write (i, s);
    Seek (i, fpos - n);
  End;

  Procedure Search;
  Var
    s1, s2: String;
  Begin
    s1 := '';
    Comwrite ('|UREnter text to search for|UP: |UI');
    getstr (255, False, True, s1);
    comwriteln ('');
    While Not EoF (i) Do Begin
      Read (i, s2);
      If Pos (setlower (s1), setlower (antipipe (s2))) <> 0 Then Begin
        fpos := Pred (FilePos (i));
        Exit;
      End;
    End;
    If fpos <> 0 Then Begin
      Seek (i, 0);
      While FilePos (i) <> fpos Do Begin
        Read (i, s2);
        If Pos (s1, setlower (antipipe (s2))) <> 0 Then Begin
          fpos := Pred (FilePos (i));
          Exit;
        End;
      End;
    End;
  End;

Var
  tw: word;

Begin
  ComWriteln ('');

  Assign (I, Uc. DataPath + 'Strings.Dat');
  {$I-}
  Reset (I);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    SwapVectors;
    Exec (Uc. BasePath + 'MakeStr.Exe', 'qwertyuiop');
    SwapVectors;
    If (DosError <> 0) Or (DosExitCode <> 0) Then Begin
      ComWriteln ('ERROR: Unable to create file ' + Uc. DataPath + 'Strings.Dat!');
      ErrorLog ('ERROR: Unable to create file ' + Uc. DataPath + 'Strings.Dat!');
      PressEnter;
      Exit;
    End;
  End;
  Reset (I);
  MaxPrompts := FileSize (I);
  Assign (H, Uc. HelpPath + 'Strings.Hlp');
  {$I-}
  Reset (H);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    ComWriteln ('ERROR: Unable to locate help file ' + Uc. HelpPath + 'Strings.Hlp!');
    ErrorLog ('ERROR: Unable to locate help file ' + Uc. HelpPath + 'Strings.Hlp!');
    PressEnter;
    Exit;
  End;

  Page := 1;
  fpos := 0;
  FS := FileSize (I);
  allowpads := false;

  Repeat
    Max := ReadShowPage;
    Repeat
      C := uCase (ReadInChar);
      If hung Then Break;
    Until Pos (c, 'Q12345[]HGS') <> 0;
    If hung Then Break;
    comwriteln (c);
    Case C Of
      'Q': Break;
      '1'..'5': If (Ord (C) - 48) <= Max Then ReadStr (Ord (C) - 48);
      ']': Begin
             if fpos + 5 >= fs then
               fpos := 0
             else
               Inc (fpos, 5);
             if fpos >= fs then Dec (fpos, 5);
           End;
      'G': Begin
             ComWrite ('|URGo to which prompt|UP (|UR1|UP-|UR' + IntToStr (MaxPrompts) + '|UP): |UI');
             tw := GetNumStr (False, False, 1, MaxPrompts, 1, MaxPrompts, 0, 0);
             if tw <> 0 then fpos := pred (tw);
           End;
      '[':
           Begin
             if fpos = 0 then
               fpos := fs - 5
             else
               Dec (fpos, 5);
             If fpos < 0 Then fpos := 0;
           End;
      'S': Search;
      'H': Begin
             TTYPauser := 1;
             If Exist (Uc. HelpPath + 'StrEdit.Hlp') Then
               ShowFile (Uc. HelpPath + 'StrEdit.Hlp', True, True)
             Else
               ComWriteln ('|UR' + Uc. HelpPath + 'StrEdit.Hlp not found.');
             PressEnter;
           End;
    End;
  Until hung;

  allowpads := true;
  Log (2, 'Entered string editor');
  Close (H);
  Close (I);
End;


Procedure XferProtoEditor;
var
  c: char;
  pf: File of ProtRec;
  pr: ProtRec;

  procedure editproto;

    Procedure DrawProtoEditor;
    Var
      B: Byte;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6]);
      Box (1, 4, 79, 24, User. Cols [6]);
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (53,2, '|15S|07ys|08tem/|157|075 |15P|07r|08otocol |15E|07di|08tor');
      ComWriteAt (3, 5, '|UP[|USA|UP]|UR Protocol Name');
      ComWriteAt (3, 6, '|UP[|USB|UP]|UR Protocol Type');
      ComWriteAt (3, 7, '|UP[|USC|UP]|UR Description');
      ComWriteAt (3, 8, '|UP[|USD|UP]|UR Usage ACS');
      ComWriteAt (3, 9, '|UP[|USE|UP]|UR Usage Key');
      ComWriteAt (3,10, '|UP[|USF|UP]|UR Executable');
      ComWriteAt (3,11, '|UP[|USG|UP]|UR Send command');
      ComWriteAt (3,12, '|UP[|USH|UP]|UR Recv command');
      ComWriteAt (3,13, '|UP[|USI|UP]|UR Batch Send');
      ComWriteAt (3,14, '|UP[|USJ|UP]|UR Batch Recv');
      ComWriteAt (3,15, '|UP[|USK|UP]|UR Resume Recv');
      ComWriteAt (3,16, '|UP[|USL|UP]|UR Close Port');
      ComWriteAt (3,17, '|UP[|USM|UP]|UR MNP Required');
      ComWriteAt (3,18, '|UP[|USN|UP]|UR Pulldown name');
      ComWriteAt (3,19, '|UP[|US[|UP]|UR Previous Protocol');
      ComWriteAt (3,20, '|UP[|US]|UP]|UR Next Protocol');
      ComWriteAt (3,21, '|UP[|USZ|UP]|UR Undo Changes');
      with user do begin
        send (goxy(3,22)+attr(cols[4])+'%1 '+attr(cols[1])+'= port (1-8), '+attr(cols[4])+'%2 '+attr(cols[1])+
              '= port baud, '+attr(cols[4])+'%3 '+attr(cols[1])+'= filename, '+attr(cols[4])+'%4 '+attr(cols[1])+
              '= cps, '+attr(cols[4])+'%5 '+attr(cols[1])+'= log file,');
        send (goxy(3,23)+attr(cols[4])+'%6 '+attr(cols[1])+'= port (0-7), '+attr(cols[4])+'%7 '+attr(cols[1])+
              '= base address, '+attr(cols[4])+'%8 '+attr(cols[1])+'= IRQ, '+attr(cols[4])+'%9 '+attr(cols[1])+
              '= vector.');
      end;
      usercol (3);
      For B := 5 To 18 Do
        ComWriteAt (21, B, ':');
    End;

    Procedure FillProtoData (C: Char);
    Var
      Z: Char;
      S: String [80];
    Begin
      If Hung Then Exit;
      usercol (2);
      With pr Do Case C Of
        'A': Send (GoXy (23, 5) + PadLeft (Name, 30, ' '));
        'B': begin
               Send (GoXy (23, 6));
               if ptype <> 0 then send ('Internal ');
               send (PadLeft (pee [ptype], 25, ' '));
             end;
        'C': Send (GoXy (23, 7) + PadLeft (descr, 40, ' '));
        'D': Send (GoXy (23, 8) + PadLeft (acs,   40, ' '));
        'E': Send (GoXy (23, 9) + PadLeft (ckeys, 1, ' '));
        'F': Send (GoXy (23,10) + PadLeft (pname, 12, ' '));
        'G': Send (GoXy (23,11) + PadLeft (sline, 56, ' '));
        'H': Send (GoXy (23,12) + PadLeft (rline, 56, ' '));
        'I': Send (GoXy (23,13) + PadLeft (bsline,56, ' '));
        'J': Send (GoXy (23,14) + PadLeft (brline,56, ' '));
        'K': Send (GoXy (23,15) + PadLeft (reline,56, ' '));
        'L': Send (GoXy (23,16) + noyes [closeport in opts]);
        'M': Send (GoXy (23,17) + noyes [mnpreq in opts]);
        'N': Send (GoXy (23,18) + PadLeft (pdname, 30, ' '));
         #0: For Z := 'A' To 'N' Do
               FillProtoData (Z);
      End;
    End;

  var
    bl: string [1];
    lui: byte;
  Begin
    If FileSize (pf) = 0 Then Begin
      ComWriteln ('|URThere are no protocols to change.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich protocol to change |UP[|US1|UP-|US' + IntToStr (FileSize (pf)) + '|UP]: |UI');
    lui := GetNumStr (False, False, 1, FileSize (pf), 1, FileSize (pf), 0, 0);
    If not hung then comwriteln ('');
    If (Lui = 0) Or Hung Then Exit;
    Seek (pf, Pred (Lui));
    Read (pf, pr);
    DrawProtoEditor;
    FillProtoData (#0);

    Repeat
      usercol (4);
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If Pos (C, 'ABCDEFGHIJKLMNZ[]Q') = 0 Then Continue;
      Send (C);
      usercol (2);

      With pr Do Case C Of
        'A':
             Begin
               Send (GoXy (23, 5));
               GetStr (12, true, False, Name);
{               FillProtoData (C);}
             End;
        'B':
             Begin
               if ptype = 10 then
                 ptype := 0
               else
                 inc (ptype);
               FillProtoData (C);
             End;
        'C':
             Begin
               Send (GoXy (23, 7));
               GetStr (40, true, False, descr);
{               FillProtoData (C);}
             End;
        'D':
             Begin
               Send (GoXy (23, 8));
               allowflagedit := true;
               GetCapStr (40, 'A', true, False, acs);
               allowflagedit := false;
{               FillProtoData (C);}
             End;
        'E':
             Begin
               Send (GoXy (23, 9));
               bl := ckeys;
               GetStr (1, true, false, bl);
               if bl <> '' then ckeys := ucase (bl [1]);
{               FillProtoData (C);}
             End;
        'F':
             Begin
               Send (GoXy (23, 10));
               GetCapStr (12, 'A', true, false, pname);
{               FillProtoData (C);}
             End;
        'G':
             Begin
               Send (GoXy (23, 11));
               GetStr (56, true, false, sline);
{               FillProtoData (C);}
             End;
        'H':
             Begin
               Send (GoXy (23, 12));
               GetStr (56, true, false, rline);
{               FillProtoData (C);}
             End;
        'I':
             Begin
               Send (GoXy (23, 13));
               GetStr (56, true, false, bsline);
{               FillProtoData (C);}
             End;
        'J':
             Begin
               Send (GoXy (23, 14));
               GetStr (56, true, false, brline);
{               FillProtoData (C);}
             End;
        'K':
             Begin
               Send (GoXy (23, 15));
               GetStr (56, true, false, reline);
{               FillProtoData (C);}
             End;
        'L':
             Begin
               if closeport in opts then
                 opts := opts - [closeport]
               else
                 opts := opts + [closeport];
               FillProtoData (C);
             End;
        'M':
             Begin
               if mnpreq in opts then
                 opts := opts - [mnpreq]
               else
                 opts := opts + [mnpreq];
               FillProtoData (C);
             End;
        'N':
             Begin
               Send (GoXy (23, 18));
               GetStr (30, true, false, pdname);
{               FillProtoData (C);}
             End;
        'Z':
             Begin
               Seek (pf, Pred (FilePos (pf)));
               Read (pf, pr);
               FillProtoData (#0);
             End;
        '[':
             Begin
               Seek (pf, Pred (FilePos (pf)));
               Write (pf, pr);

               Seek (pf, Pred (FilePos (pf)));
               If FilePos (pf) = 0 Then
                 Seek (pf, Pred (FileSize (pf)))
               Else
                 Seek (pf, Pred (FilePos (pf)));
               Read (pf, pr);
               FillProtoData (#0);
             End;
        ']':
             Begin
               Seek (pf, Pred (FilePos (pf)));
               Write (pf, pr);

               If FilePos (pf) = FileSize (pf) Then Seek (pf, 0);
               Read (pf, pr);
               FillProtoData (#0);
             End;
        'Q':
             Begin
               Seek (pf, Pred (FilePos (pf)));
               Write (pf, pr);
               Break;
             End;
      End;
    Until hung;
    Log (2, 'Edited xfer protocols');
  End;

  Procedure AddProto;
  Begin
    If FileSize (pf) >= 255 Then Begin
      ComWriteln ('|URNo more protocols can be added.');
      PressEnter;
      Exit;
    End;

    Seek (pf, FileSize (pf));
    FillChar (pr, Sizeof (pr), 0);
    pr. Name := 'New Protocol';
    Write (pf, pr);
    Log (2, 'Added new xfer protocol');
  End;

  Procedure DeleteProto;
  Var
    F: File;
    ze: word;
    High, Low: LongInt;
  Begin
    If FileSize (pf) = 0 Then Begin
      ComWriteln ('|URThere are no protocols to delete.');
      PressEnter;
      Exit;
    End;
    ComWrite ('|URWhich protocol(s) to delete');
    GetRange (' ', False, 1, FileSize (pf), 0, 0, -1, Low, High);
    if hung then exit;
    comwriteln ('');
    if low = -1 then exit;
    if low <> high then begin
      comwrite ('|USDelete protocols |UR' + inttostr (low) + '|UP-|UR' + inttostr (high) + ' ');
      if litebar (lbYes, false, true) = lbno then exit;
    end;

    Close (pf);
    Assign (F, Uc. DataPath + 'Protos.Dat');
    Reset (F, 1);
    Log (2, 'Deleted xfer protocol(s)');

    for ze := high downto low do
      RemoveRec (F, pred (ze), SizeOf (ProtRec));

    comwriteln ('');

    Close (F);
    Reset (pf);
  End;

var
  b: byte;
Begin
  Assign (pF, Uc. DataPath + 'Protos.Dat');
  {$I-}
  Reset (pf);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    Rewrite (pf);
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening protocol data file |15' + uc. datapath + 'Protos.Dat');
      ErrorLog ('|07Error opening protocol data file |15' + uc. datapath + 'Protos.Dat');
      Exit;
    End;
  End;

  Repeat
    B := 0;
    Seek (pf, 0);
    Send (Cls);

    FillIn1 := ' Transfer Protocols';
    pFile ('hdr.ans');
    ComWriteln ('');
    B := 0;

    While Not EoF (pf) Do Begin
      Inc (B);
      Read (pf, pr);
      With pr Do
        ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (name, 33, ' '));
      If B Mod 2 = 0 Then ComWriteln ('');
      If (B Mod 2 = 0) And (_y Mod curPageLen = curpageLen - 2) And (More (false) = mno) Then Break;
      If Hung Then Exit;
    End;

    If B Mod 2 <> 0 Then ComWriteln ('');
    ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, |UP[|USQ|UP]|URuit|UP: |UI');

    Repeat
      C := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (C, 'ACDUQ') <> 0;

    If Hung Then Break;
    ComWriteLn (C);
    Case C Of
      'A': AddProto;
      'C': EditProto;
      'D': DeleteProto;
      'Q': Break;
    End;
  Until Hung;
  {$I-}
  Close (pf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then ;
end;


Procedure EventEditor;
Const
  Zero: Byte = 0;
Var
  B: Byte;
  ef: File Of EventRec;
  er: EventRec;
  rf: file;
  sr: searchrec;
  tmp: ^nodedatatype;

  Procedure EditEvent;
  Const
    vKindStr: Array [eAcs..eXferAllow] Of String [10] =
    ('Login Acs ', 'ErrorLevel', 'Menu      ', 'Toggle    ', 'Transfers ');

    Procedure DrawEventEditor;
    Var
      B: Byte;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6] );
      Box (1, 4, 79, 20, User. Cols [6] );
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30, 2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (56, 2, '|15S|07ys|08tem/|157|075 |15E|07v|08ent |15E|07di|08tor');
      ComWriteAt (3, 5, '|UP[|USA|UP]|UR Event Name');
      ComWriteAt (3, 6, '|UP[|USB|UP]|UR Event Type');
      ComWriteAt (3, 7, '|UP[|USC|UP]|UR Event Node');
      ComWriteAt (3, 8, '|UP[|USD|UP]|UR Start Time');
      ComWriteAt (3, 9, '|UP[|USE|UP]|UR End Time');
      ComWriteAt (3, 10, '|UP[|USF|UP]|UR Limit Time');
      ComWriteAt (3, 11, '|UP[|USG|UP]|UR Errorlevel');
      ComWriteAt (3, 12, '|UP[|USH|UP]|UR Login ACS');
      ComWriteAt (3, 13, '|UP[|USI|UP]|UR Menu Command');
      ComWriteAt (3, 14, '|UP[|USJ|UP]|UR Parameter');
      ComWriteAt (3, 15, '|UP[|USK|UP]|UR Toggles');
      ComWriteAt (3, 16, '|UP[|USL|UP]|UR File Transfers');
      ComWriteAt (3, 17, '|UP[|US[|UP]|UR Previous Event');
      ComWriteAt (3, 18, '|UP[|US]|UP]|UR Next Event');
      ComWriteAt (3, 19, '|UP[|USZ|UP]|UR Undo Changes');
      usercol (3);
      For B := 5 To 16 Do
        ComWriteAt (22, B, ':');
    End;

    Procedure FillEventData (C: Char);
    Var
      Z: Char;
      S: String [80];
    Begin
      If Hung Then Exit;
      usercol (2);
      With er Do Case C Of
        'A': Send (GoXy (24, 5) + PadLeft (Name, 30, ' '));
        'B': Send (GoXy (24, 6) + vKindStr [Kind] );
        'C': Send (GoXy (24, 7) + PadLeft (IntToStr (Node), 3, ' '));
        'D': Send (GoXy (24, 8) + Copy (TimeStr (tStart), 1, 5));
        'E': If Kind = eAcs Then
               Send (GoXy (24, 9) + Copy (TimeStr (tEnd), 1, 5))
             Else
               Send (GoXy (24, 9) + '     ');
        'F': Send (GoXy (24, 10) + NoYes [Strict] );
        'G': If Kind = eErrorLevel Then
               Send (GoXy (24, 11) + PadLeft (IntToStr (ErrorLevel), 3, ' '))
             Else
               Send (GoXy (24, 11) + '   ');
        'H': If Kind = eAcs Then
               Send (GoXy (24, 12) + PadLeft (ACS, 40, ' '))
             Else
               Send (GoXy (24, 12) + Rep (' ', 40));
        'I': If Kind = eMenu Then
               Send (GoXy (24, 13) + PadLeft (mcData, 2, ' '))
             Else
               Send (GoXy (24, 13) + '  ');
        'J':
             Begin
               Send (GoXy (24, 14));
               If Kind = eMenu Then
                 If Length (mcParam) > 55 Then
                   Send (Copy (mcParam, 1, 54) + Attr (User. Cols [6] ) + '')
                 Else
                   Send (PadLeft (mcParam, 55, ' '))
               Else
                 Send (Rep (' ', 55));
             End;
        'K':
            Begin
              Send (GoXy (24, 15));
              If Kind = eToggle Then Begin
                S := '|08Available  |08Speaker  |08Printer  |08Custom';
                If MakeAvail Then S [2] := '1';
                If MakeBell Then S [16] := '1';
                If MakePrn Then S [28] := '1';
                If MakeMisc Then S [40] := '1';
                If MakeAvail Then S [3] := '5';
                If MakeBell Then S [17] := '5';
                If MakePrn Then S [29] := '5';
                If MakeMisc Then S [41] := '5';
                ComWrite (S);
              End Else
                Send (Rep (' ', 35));
            End;
        'L':
            Begin
              Send (GoXy (24, 16));
              If Kind = eXferAllow Then Begin
                S := '|08Downloads  |08Uploads  |08QWK Downs  |08QWK Ups';
                If AllowDl Then S [2] := '1';
                If AllowUl Then S [16] := '1';
                If AllowQwkDl Then S [28] := '1';
                If AllowQwkUl Then S [42] := '1';
                If AllowDl Then S [3] := '5';
                If AllowUl Then S [17] := '5';
                If AllowQwkDl Then S [29] := '5';
                If AllowQwkUl Then S [43] := '5';
                ComWrite (S);
              End Else
                Send (Rep (' ', 39));
            End;
        #0: For Z := 'A' To 'L' Do
          FillEventData (Z);
      End;
    End;

    Procedure DoToggle (S: Str20; Var E: Boolean);
    Begin
      If Hung Then Exit;
      Send (GoXy (1, 21));
      ComWrite ('|UR ' + S + ' ');
      E := LiteBar (LiteBarType (Not E), False, False) = lbYes;
      If Hung Then Exit;
      Send (^M + Clr2Eol);
    End;

    procedure i_hate_this;
    begin
      getmem (tmp, sizeof (nodedata));
      FindFirst (Uc. DataPath + 'node_*.dat', anyfile, sr);
      while doserror = 0 do begin
        assign (rf, Uc. DataPath + sr. name);
        reset (rf, 1);
        blockread (rf, tmp^, sizeof (nodedata));
        close (rf);

        Assign (rF, tmp^. NodePath + 'EventRun.Dat');
        {$I-}
        Reset (rF, 1);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult <> 0 Then with event^ do Begin
          Rewrite (rF, 1);
          FillChar (er, sizeof (er), 0);
          blockWrite (rF, er, sizeof (er));
          Close (rF);
        End Else Begin
          Seek (rF, filepos (ef));
          BlockWrite (rF, Zero, 1);
          Close (rF);
        End;
        findnext (sr);
      end;
      freemem (tmp, sizeof (nodedata));
      event^. readrun;
    end;

  Var
    C: Char;
    ts: String [5];
    B: Byte;
    lui: byte;
  Begin
    If FileSize (ef) = 0 Then Begin
      ComWriteln ('|URThere are no events to change.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich event to change |UP[|US1|UP-|US' + IntToStr (FileSize (ef)) + '|UP]: |UI');
    lui := GetNumStr (False, False, 1, FileSize (ef), 1, FileSize (ef), 0, 0);
    If not hung then comwriteln ('');
    If (Lui = 0) Or Hung Then Exit;
    Seek (ef, Pred (Lui));
    Read (ef, er);
    DrawEventEditor;
    FillEventData (#0);
    Repeat
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If Pos (C, 'ABCDEFGHIJKLZ[]Q') = 0 Then Continue;
      Send (C);
      usercol (4);
      With er Do Case C Of
        'A':
             Begin
               Send (GoXy (24, 5));
               GetStr (30, true, false, Name);
{               FillEventData (C);}
             End;
        'B':
             Begin
               Send (GoXy (1, 21));
               ComWrite ('|UR Event type ');
               Kind := EventType (Pred (LiteString ('', 'A~cs E~rrorlevel M~enu T~oggle X~fers', Succ (Byte (Kind)))));
               If Hung Then Break;
               Send (^M + Clr2Eol);
               FillChar (ErrorLevel, 106, 0);
               FillEventData (#0);
             End;
        'C':
             Begin
               Send (GoXy (24, 7));
               Node := GetNumStr (True, False, 1, Uc. NumNodes, 1, Uc. NumNodes, Node, Node);
{               FillEventData (C);}
             End;
        'D':
             Begin
               Repeat
                 Send (GoXy (24, 8));
                 ts := Copy (TimeStr (tStart), 1, 5);
                 GetLimitStr (true, false, 5, '1234567890:', ts);
               Until ValidTimeStr (ts);
               tStart := TimeVal (ts);
{               FillEventData (C);}
             End;
        'E': If Kind = eAcs Then Begin
               Repeat
                 Send (GoXy (24, 9));
                 ts := Copy (TimeStr (tEnd), 1, 5);
                 GetLimitStr (true, false, 5, '1234567890:', ts);
               Until ValidTimeStr (ts);
               tEnd := TimeVal (ts);
{               FillEventData (C);}
             End;
        'F': Begin
               Strict := Not Strict;
               FillEventData (C);
             End;
        'G': If Kind = eErrorLevel Then Begin
               Send (GoXy (24, 11));
               ErrorLevel := GetNumStr (True, False, 11, 255, 11, 255, ErrorLevel, ErrorLevel);
{               FillEventData (C);}
             End;
        'H': If Kind = eAcs Then Begin
               Send (GoXy (24, 12));
               allowflagedit := true;
               GetcapStr (30, 'A', true, false, Acs);
               allowflagedit := false;
{               FillEventData (C);}
             End;
        'I': If Kind = eMenu Then Begin
               Send (GoXy (24, 13));
               GetStr (2, true, false, mcData);
{               FillEventData (C);}
             End;
        'J': If Kind = eMenu Then Begin
               Send (GoXy (1, 21));
               ComWriteLn ('|UREnter the Parameter|UP:');
               GetStr (100, false, false, mcParam);
               If Hung Then Break;
               Send (GoXy (1, 21));
               For B := 1 To 3 Do
                 ComWriteln (Clr2Eol);
               FillEventData (C);
             End;
        'K': If Kind = eToggle Then Begin
               DoToggle ('Sysop available', MakeAvail);
               DoToggle ('Speaker on', MakeBell);
               DoToggle ('Printer on', MakePrn);
               DoToggle ('Custom on', MakeMisc);
               FillEventData (C);
             End;
        'L': If Kind = eXferAllow Then Begin
               DoToggle ('Allow file downloads', AllowDl);
               DoToggle ('Allow file uploads', AllowUl);
               DoToggle ('Allow QWK downloads', AllowQWKDl);
               DoToggle ('Allow QWK uploads', AllowQWKUl);
               FillEventData (C);
             End;
        'Z':
             Begin
               Seek (ef, Pred (FilePos (ef)));
               Read (ef, er);
               FillEventData (#0);
             End;
        '[':
             Begin
               Seek (ef, Pred (FilePos (ef)));
               Write (ef, er);

               i_hate_this;
               Event^. er [Pred (FilePos (ef))] := False;

               Seek (ef, Pred (FilePos (ef)));
               If FilePos (ef) = 0 Then
                 Seek (ef, Pred (FileSize (ef)))
               Else
                 Seek (ef, Pred (FilePos (ef)));
               Read (ef, er);
               FillEventData (#0);
             End;
        ']':
             Begin
               Seek (ef, Pred (FilePos (ef)));
               Write (ef, er);

               i_hate_this;
               Event^. er [Pred (FilePos (ef))] := False;

               If FilePos (ef) = FileSize (ef) Then Seek (ef, 0);
               Read (ef, er);
               FillEventData (#0);
             End;
        'Q':
             Begin
               Seek (ef, Pred (FilePos (ef)));
               Write (ef, er);

               i_hate_this;
               Event^. er [Pred (FilePos (ef))] := False;

               Break;
             End;
      End;
    Until hung;
    Log (2, 'Edited events');
    If Not hung Then ComWriteAt (1, 21, '|UR');
  End;

  Procedure AddEvent;
  Var
    F: File;
    lui: byte;
  Begin
    If FileSize (ef) >= 255 Then Begin
      ComWriteln ('|URNo more events can be added.');
      PressEnter;
      Exit;
    End Else If FileSize (ef) <> 0 Then Begin
      ComWrite ('|URInsert before which event |UP[|US1|UP-|US' + IntToStr (Succ (FileSize (ef))) + '|UP]: |UI');
      Lui := GetNumStr (False, False, 1, Succ (FileSize (ef)), 0, 0, 0, 0);
      If Not Hung Then ComWriteln ('');
      If (Lui = 0) Or Hung Then Exit;
    End Else Lui := 1;
    Close (ef);
    Assign (F, Uc. DataPath + 'Events.Dat');
    Reset (F, 1);
    InsertRec (F, Pred (Lui), SizeOf (EventRec));
    Close (F);
    Reset (ef);
    Seek (ef, Pred (Lui));
    FillChar (er, Sizeof (er), 0);
    er. Name := 'New Event';
    Write (ef, er);
    Log (2, 'Added new event');

    getmem (tmp, sizeof (nodedata));
    FindFirst (Uc. DataPath + 'node_*.dat', anyfile, sr);
    while doserror = 0 do begin
      assign (rf, Uc. DataPath + sr. name);
      reset (rf, 1);
      blockread (rf, tmp^, sizeof (nodedata));
      close (rf);

      Assign (rF, tmp^. NodePath + 'EventRun.Dat');
      {$I-}
      Reset (rF, 1);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IoResult <> 0 Then with event^ do Begin
        Rewrite (rF, 1);
        FillChar (er, sizeof (er), 0);
        blockWrite (rF, er, sizeof (er));
        Close (rF);
      End Else Begin
        Seek (rF, Lui);
        BlockWrite (rF, Zero, 1);
        Close (rF);
      End;
      findnext (sr);
    end;
    freemem (tmp, sizeof (nodedata));
    event^. readrun;
  End;

  Procedure DeleteEvent;
  Var
    F: File;
    ze: word;
    High, Low: LongInt;
  Begin
    If FileSize (ef) = 0 Then Begin
      ComWriteln ('|URThere are no events to delete.');
      PressEnter;
      Exit;
    End;
    ComWrite ('|URWhich event(s) to delete');
    GetRange (' ', False, 1, FileSize (ef), 0, 0, -1, Low, High);
    if hung then exit;
    comwriteln ('');
    if low = -1 then exit;
    if low <> high then begin
      comwrite ('|USDelete events |UR' + inttostr (low) + '|UP-|UR' + inttostr (high) + ' ');
      if litebar (lbYes, false, true) = lbno then exit;
    end;

    Log (2, 'Deleted event(s)');
    Close (ef);
    Assign (F, Uc. DataPath + 'Events.Dat');
    Reset (F, 1);

    for ze := high downto low do
      RemoveRec (F, pred (ze), SizeOf (EventRec));

    comwriteln ('');

    Close (F);
    Reset (ef);

    getmem (tmp, sizeof (nodedata));
    FindFirst (Uc. DataPath + 'node_*.dat', anyfile, sr);
    while doserror = 0 do begin
      assign (rf, Uc. DataPath + sr. name);
      reset (rf, 1);
      blockread (rf, tmp^, sizeof (nodedata));
      close (rf);

      Assign (rF, tmp^. NodePath + 'EventRun.Dat');
      {$I-}
      Reset (rF, 1);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IoResult <> 0 Then with event^ do Begin
        Rewrite (rF, 1);
        FillChar (er, sizeof (er), 0);
        blockWrite (rF, er, sizeof (er));
        Close (rF);
      End Else Begin
        for ze := high downto low do begin
          RemoveRec (rF, ze, 1);
          seek (rf, filesize (rf));
          blockwrite (rf, Zero, 1);
        end;
        Close (rF);
      End;
      findnext (sr);
    end;
    freemem (tmp, sizeof (nodedata));
    event^. readrun;
  End;

  Procedure MoveEvent;
  Var
    Movef: Byte;
    F: File;
    Q: Boolean;
    lui: byte;
  Begin
    If FileSize (ef) = 0 Then Begin
      ComWriteln ('|URThere are no events to move.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich event to move |UP[|US1|UP-|US' + IntToStr (FileSize (ef)) + '|UP]: |UI');
    Movef := GetNumStr (False, False, 1, FileSize (ef), 0, 0, 0, 0);
    if hung then exit;
    comwriteln ('');
    If Movef = 0 Then Exit;
    ComWrite (^M^J'|URInsert where|UP [|US1|UP-|US' + IntToStr (FileSize (ef)) + '|UP]: |UI');
    Lui := GetNumStr (False, False, 1, FileSize (ef), 0, 0, 0, 0);
    If Hung Then Exit;
    comwriteln ('');
    If lui = 0 Then Exit;
    Seek (ef, Pred (Movef));
    Read (ef, er);

    Log (2, 'Re-ordered events');
    getmem (tmp, sizeof (nodedata));
    FindFirst (Uc. DataPath + 'node_*.dat', anyfile, sr);
    while doserror = 0 do begin
      assign (rf, Uc. DataPath + sr. name);
      reset (rf, 1);
      blockread (rf, tmp^, sizeof (nodedata));
      close (rf);

      Assign (rF, tmp^. NodePath + 'EventRun.Dat');
      {$I-}
      Reset (rF, 1);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IoResult <> 0 Then with event^ do Begin
        Rewrite (rF, 1);
        FillChar (er, sizeof (er), 0);
        blockWrite (rF, er, sizeof (er));
        Close (rF);
      End Else Begin
        Seek (rF, Movef);
        BlockRead (rF, Q, 1);
        RemoveRec (rF, Movef, 1);
        InsertRec (rF, Lui, 1);
        Seek (rF, Lui);
        BlockWrite (rF, Q, 1);
        close (rf);
      End;
      findnext (sr);
    end;
    freemem (tmp, sizeof (nodedata));
    event^. readrun;

    Close (ef);
    Assign (F, Uc. DataPath + 'Events.Dat');
    Reset (F, 1);
    RemoveRec (F, Pred (Movef), SizeOf (EventRec));
    InsertRec (F, Pred (Lui), SizeOf (EventRec));
    Close (F);
    Reset (ef);
    Seek (ef, Pred (Lui));
    Write (ef, er);
  End;

Var
  Ch: Char;

Begin
  Assign (ef, Uc. DataPath + 'Events.Dat');
  {$I-}
  Reset (ef);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    Rewrite (ef);
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening event file |15' + Uc. DataPath + 'Events.Dat|07');
      ErrorLog ('|07Error opening event file |09' + Uc. DataPath + 'Events.Dat|07');
      Exit;
    End;
  End;

  Repeat
    B := 0;
    Seek (ef, 0);
    Send (Cls);

    FillIn1 := 'Event Editing';
    pFile ('hdr.ans');
    ComWriteln ('');
    B := 0;

    While Not EoF (ef) Do Begin
      Inc (B);
      Read (ef, er);
      With er Do
        ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (Name, 33, ' '));
      If B Mod 2 = 0 Then ComWriteln ('');
      If (B Mod 2 = 0) And (_y Mod curPageLen = curpageLen - 2) And (More (false) = mno) Then Break;
      If Hung Then Exit;
    End;

    If B Mod 2 <> 0 Then ComWriteln ('');
    ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, |UP[|USM|UP]|URove, |UP[|USQ|UP]|URuit' +
              '|UP: |UI');

    Repeat
      Ch := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (Ch, 'ACDMQ') <> 0;

    If Hung Then Break;
    ComWriteLn (CH);
    Case Ch Of
      'A': AddEvent;
      'C': EditEvent;
      'D': DeleteEvent;
      'M': MoveEvent;
      'Q': Break;
    End;
  Until Hung;
  {$I-}
  Close (ef);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then ;
  Event^. Load;
  Event^. CalcNext;
End;


Procedure MenuEditor;
Var
  M: File of MenuRec;
  C: File of CommandRec;
  Mr: MenuRec;
  Cr: CommandRec;
  mList: pStrDllObj;
  Ch: Char;

  Procedure ReadMenus;
  Var
    DirInfo: SearchRec;
    D, N, E: NameStr;
  Begin
    mList^. EmptyList;
    FindFirst (Uc. MenuPath + '*.MNU', AnyFile - Directory - VolumeID, DirInfo);
    While DosError = 0 Do
    Begin
      FSplit (DirInfo. Name, D, N, E);
      mList^. Add (N);
      FindNext (DirInfo);
    End;
    mList^. Sort (0, True);
  End;

  Procedure DrawMenuBox;
  Var
    S: String;
    B: Byte;
    W: Word;
  Begin
    ComWrite ('|UB%CS');
    Send ('' + RepPattern (11, 6, Replicate (10, '') + '') + Replicate (10, '') + ''^M^J);
    W := 0;
    While W < mList^. TotalNodes Do Begin
      ComWrite ('|UB');
      For B := 1 To 7 Do Begin
        If W < mList^. TotalNodes Then Begin
          Inc (W);
          With mList^ Do
            S := GetStr (NodePtr (W), 1, 255);
        End Else
          S := '';
        ComWrite ('|US' + PadRight (S, 9, ' ') + '|UB ');
      End;
      ComWriteLn ('');
    End;
    Send ('' + RepPattern (11, 6, Replicate (10, '') + '') + Replicate (10, '') + ''^M^J);
  End;

  Function SelectMenu: NameStr;
  Var
    Z, B: Byte;
    o: Word;
    S2, S: String;

    Procedure UpdateTyped;
    Var
      Q: Byte;
      A: Boolean;
      P: String;
    Begin
      A := False;
      With mList^ do
        For Q := Z to TotalNodes do Begin
          P := GetStr (NodePtr (Q), 1, 255);
          If (Copy (P, 1, Length (S2)) >= S2) And
          (Copy (P, 1, Pred (Length (S2))) = Copy (S2, 1, Pred (Length (S2)))) Then Begin
            If Not ((S2 [0] = #1) And (Q = 1) And (P > S2)) Then Begin
              ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
              A := True;
            End;
            Break;
          End;
        End;
      If A Then
        B := Pred (Q)
      Else
        Dec (S2 [0]);
    End;

  Begin
    If HighestEmu > TermTTY Then Begin
      B := 0;
      z := 1;
      s2 := '';
      Repeat
        With mList^ do
          S := GetStr (NodePtr (Succ (B)), 1, 255);
        Send (GoXy (2 + B Mod 7 * 11, B Div 7 + 2));
        ComWrite ('|UV ' + PadRight (S, 8, ' ') + ' ');
        Send (GoXy (2 + B Mod 7 * 11, B Div 7 + 2));
        o := ReadArrow;
        If hung Then Exit;
        Case o Of
          kEnter: Break;
          kLeft:  If B > 0 Then Begin
                    ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
                    s2 := '';
                    Dec (B);
                  End;
          kRight: If B < Pred (mList^. TotalNodes) Then Begin
                    ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
                    s2 := '';
                    Inc (B);
                  End;
          kUp:    If B > 6 Then Begin
                    ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
                    s2 := '';
                    Dec (B, 7);
                  End;
          kDown:  If B + 7 < mList^. TotalNodes Then Begin
                    ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
                    s2 := '';
                    Inc (B, 7);
                  End;
          kEsc:
                  Begin
                    S := '';
                    s2 := '';
                    Break;
                  End;
          kBkSp:  If S2 <> '' Then Begin
                    Dec (S2 [0]);
                    If S2 <> '' Then
                      UpdateTyped
                    Else Begin
                      B := 0;
                      ComWrite ('|US ' + PadRight (S, 8, ' ') + ' ');
                    End;
                  End;
          Else If (o < 256) And (o > 31) And (Length (S2) < 255) Then Begin
            S2 := S2 + uCase (Chr (Lo (o)));
            UpdateTyped;
          End;
        End;
      Until Hung;
    End Else Begin
      Repeat
        S := '';
        ComWrite ('Select a menu: ');
        GetStr (8, False, False, S);
        If Hung Then Exit;
        With mList^ do Begin
          For B := 1 to TotalNodes do
            If SetUpper (S) = GetStr (NodePtr (B), 1, 255) Then Break;
          If SetUpper (S) = GetStr (NodePtr (B), 1, 255) Then Break;
        End;
        S := '';
        ComWrite (^M + Rep (' ', 79) + ^M);
      Until Hung;
      ComWriteln ('');
    End;
    SelectMenu := S;
  End;

  Procedure EditMenu (S: NameStr);

    Procedure DrawMenu;
    Var
      B: Byte;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6] );
      Box (1, 4, 79, 18, User. Cols [6] );
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (57,2, '|15S|07ys|08tem/|157|075 |15M|07e|08nu |15E|07di|08tor');
      ComWriteAt (3, 5, '|UP[|USA|UP]|UR Menu Name');
      ComWriteAt (3, 6, '|UP[|USB|UP]|UR Menu Prompt');
      ComWriteAt (3, 7, '|UP[|USC|UP]|UR Display File');
      ComWriteAt (3, 8, '|UP[|USD|UP]|UR Minimum ACS');
      ComWriteAt (3, 9, '|UP[|USE|UP]|UR Password');
      ComWriteAt (3,10, '|UP[|USF|UP]|UR Menu Type');
      ComWriteAt (3,11, '|UP[|USG|UP]|UR Fallback');
      ComWriteAt (3,12, '|UP[|USH|UP]|UR Allow Global');
      ComWriteAt (3,13, '|UP[|USI|UP]|UR Allow Generics');
      ComWriteAt (3,14, '|UP[|USJ|UP]|UR Hotkeys');
      ComWriteAt (3,15, '|UP[|USK|UP]|UR Edit Commands');
      ComWriteAt (3,16, '|UP[|USL|UP]|UR Show Generic');
      ComWriteAt (3,17, '|UP[|USZ|UP]|UR Undo Changes');
      usercol (3);
      For B := 5 To 14 Do
        ComWriteAt (20, B, ':');
    End;

    Procedure FillMenuData (C: Char);
    Var
      Z: Char;
    Begin
      usercol (2);
      With Mr Do Case C Of
        'A': Send (GoXy (22, 5) + Name);
        'B': Begin
               Send (GoXy (22, 6));
               If Length (Prompt) > 57 Then
                 Send (Copy (Prompt, 1, 56) + Attr (User. Cols [6]) + '')
               Else
                Send (PadLeft (Prompt, 57, ' '));
             End;
        'C': Send (GoXy (22, 7) + HelpFile);
        'D': Send (GoXy (22, 8) + Acs);
        'E': Send (GoXy (22, 9) + Password);
        'F': Begin
               Send (GoXy (22,10));
               Case Special [1] of
                 'N': Send ('Normal  ');
                 'S': Send ('Special ');
                 'P': Send ('Pulldown');
                 'R': Send ('Random ' + Special [2]);
               End;
             End;
        'G': Send (GoXy (22,11) + FallBack);
        'H': Send (GoXy (22,12) + NoYes [AllowGlobals In MenuFlags]);
        'I': Send (GoXy (22,13) + NoYes [AllowGenerics In MenuFlags]);
        'J':
             Begin
               Send (GoXy (22, 14));
               If ForceNoHotKeys In MenuFlags Then
                 Send ('Hotkeys forced OFF')
               Else If ForceHotKeys In MenuFlags Then
                 Send ('Hotkeys forced ON ')
               Else
                 Send ('Hotkeys not forced');
             End;
        #0: For Z := 'A' To 'J' Do
              FillMenuData (Z);
      End;
    End;

    Procedure ListCommands;
    Var
      Lui: LongInt;
      B: Byte;

      Procedure CommandEditor (o: byte);

        Procedure ShowHelp;

          Procedure ClrArea;
          Var
            B: Byte;
          Begin
            Send (GoXy (1, 17));
            For B := 17 to 23 do
              ComWriteln (Clr2Eol);
            ComWrite (Clr2Eol);
          End;

        Var
          C: Char;
          B: Byte;
          T: Text;
          S: String;
        Begin
          Send (GoXy (1, 17));
          ComWriteLn (' |USA|UP) |URKeystrokes    |USB|UP) |URControl       |USC|UP) |URLogin         |USD|UP) |URMultiNode');
          ComWriteLn (' |USE|UP) |URMatrix        |USF|UP) |URNewScan       |USG|UP) |URMain          |USH|UP) |URDoor');
          ComWriteLn (' |USI|UP) |URSysop         |USJ|UP) |URFeedback      |USK|UP) |URNUV           |USL|UP) |URVoting');
          ComWriteLn (' |USM|UP) |URData Area     |USN|UP) |UREmail         |USO|UP) |URGroups        |USP|UP) |URFiles');
          ComWriteLn (' |USQ|UP) |URBatch File    |USR|UP) |URJoin Confs.   |USS|UP) |URMessage       |UST|UP) |URQWK Mail');
          ComWriteLn (' |USU|UP) |URTop Ten       |USV|UP) |URMsg Sponsors  |USW|UP) |URFile Sponsor');
          ComWriteLn ('');
          ComWrite   (' |15S|07h|08ow help on which type of comma|07n|15d|UP:|UI ');
          Repeat
            C := uCase (ReadInChar);
          Until Hung Or (C In [^M, 'A'..'W']);
          If Hung Then Exit;
          if c = ^m then begin
            ClrArea;
            exit;
          end;
          ComWrite (C);
          Assign (T, Uc. HelpPath + 'MenuEd' + IntToStr (Ord (C) - 64) + '.Hlp');
          {$I-}
          Reset (T);
          {$IFDEF Debug}{$I+}{$ENDIF}
          If IoResult <> 0 Then Begin
            ComWrite (^M^J'|15Could not open ' + Uc. HelpPath + 'MenuEd' + IntToStr (Ord (C) - 64) + '.Hlp!');
            iDelay (1000);
            ClrArea;
            Exit;
          End;
          ClrArea;
          Send (GoXy (1, 17));
          While Not Eof (T) do Begin
            ReadLn (T, S);
            If S <> '' Then ComWriteLn (S);
            If (_y = 24) or ((S = '') And (_y <> 17)) Then Begin
              If More (false) = mno Then Begin
                Close (T);
                If Hung Then Exit;
                ClrArea;
                Exit;
              End Else Begin
                If Hung Then Exit;
                ClrArea;
                Send (GoXy (1, 17));
              End;
            End;
          End;
          Close (T);
          PressEnter;
          If Hung Then Exit;
          ClrArea;
        End;

        Procedure DrawComm;
        Var
          B: Byte;
        Begin
          ComWrite ('|UB%CS');
          Box (1, 1, 79, 3, User. Cols [6]);
          Box (1, 4, 79, 16, User. Cols [6]);
          ComWriteAt (3, 2, '|URCommand|UP: |UI');
          ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
          ComWriteAt (54,2, '|15S|07ys|08tem/|157|075 |15C|07o|08mmand |15E|07di|08tor');
          ComWriteAt (3, 5, '|UP[|USA|UP]|UR Command Name');
          ComWriteAt (3, 6, '|UP[|USB|UP]|UR Command ACS');
          ComWriteAt (3, 7, '|UP[|USC|UP]|UR User Keys');
          ComWriteAt (3, 8, '|UP[|USD|UP]|UR Command Data');
          ComWriteAt (3, 9, '|UP[|USE|UP]|UR Parameter');
          ComWriteAt (3,10, '|UP[|USF|UP]|UR Pulldown ID');
          ComWriteAt (3,11, '|UP[|USG|UP]|UR Hidden');
          ComWriteAt(40,11, '|UP[|USH|UP]|UR Pause After');
          ComWriteAt (3,12, '|UP[|US[|UP]|UR Previous Command');
          ComWriteAt (3,13, '|UP[|US]|UP]|UR Next Command');
          ComWriteAt (3,14, '|UP[|US?|UP]|UR Show Help');
          ComWriteAt (3,15, '|UP[|USZ|UP]|UR Undo Changes');
          usercol (3);
          For B := 5 To 11 Do
            ComWriteAt (20, B, ':');
          ComWriteAt (56, B, ':');
        End;

        Procedure FillCommData (C: Char);
        Var
          Z: Char;
        Begin
          usercol (2);
          With Cr Do Case C Of
            'A': Send (GoXy (22, 5) + PadLeft (Desc, 30, ' '));
            'B': Send (GoXy (22, 6) + PadLeft (Acs, 40, ' '));
            'C': Send (GoXy (22, 7) + PadLeft (Keys, 30, ' '));
            'D': Send (GoXy (22, 8) + PadLeft (Data, 2, ' '));
            'E': Begin
                   Send (GoXy (22, 9));
                   If Length (Param) > 57 Then
                     Send (Copy (Param, 1, 56) + Attr (User. Cols [6]) + '')
                   Else
                    Send (PadLeft (Param, 57, ' '));
                 End;
            'F': Send (GoXy (22,10) + PadLeft (IntToStr (PullDnId), 3, ' '));
            'G': Send (GoXy (22,11) + NoYes [Hidden]);
            'H': Send (GoXy (58,11) + NoYes [Pause]);
            #0: For Z := 'A' To 'H' Do
                  FillCommData (Z);
          End;
        End;

      Var
        B: Byte;
        lui: byte;
      Begin
        If FileSize (C) = 0 Then Begin
          ComWriteln ('|URThere are no commands to change.');
          PressEnter;
          Exit;
        End;

        if o = 0 then begin
          ComWrite ('|URWhich command to change |UP[|US1|UP-|US' + IntToStr (FileSize (C)) + '|UP]: |UI');
          Lui := GetNumStr (False, False, 1, FileSize (C), 1, FileSize (C), 0, 0);
          If Hung Then Exit;
          comwriteln ('');
        end else lui := o;
        if lui = 0 then exit;

        Seek (C, Pred (Lui));
        Read (C, Cr);
        DrawComm;
        FillCommData (#0);
        If Hung Then Exit;

        With Cr do Repeat
          usercol (4);
          ComWriteAt (12, 2, ' '#8);
          Repeat
            Ch := uCase (ReadInChar);
            If Hung Then Break;
          Until Pos (Ch, 'ABCDEFGH?QZ[]') <> 0;
          If Hung Then Break;
          Send (Ch);
          usercol (2);

          Case Ch Of
            'A': Begin
                   Send (GoXy (22, 5));
                   GetStr (30, true, false, Desc);
                   If Hung Then Break;
{                   FillCommData (Ch);}
                 End;
            'B': Begin
                   Send (GoXy (22, 6));
                   allowflagedit := true;
                   GetcapStr (40, 'A', true, false, ACS);
                   allowflagedit := false;
                   If Hung Then Break;
{                   FillCommData (Ch);}
                 End;
            'C': Begin
                   Send (GoXy (22, 7));
                   GetStr (30, true, false, Keys);
                   If Hung Then Break;
{                   FillCommData (Ch);}
                 End;
            'D': Begin
                   Send (GoXy (22, 8));
                   GetStr (2, true, false, Data);
                   If Hung Then Break;
{                   FillCommData (Ch);}
                 End;
            'E': Begin
                   Send (GoXy (1, 17));
                   ComWriteLn ('|UREnter the Parameter|UP:');
                   GetStr (100, false, false, Param);
                   If Hung Then Break;
                   Send (GoXy (1, 17));
                   For B := 1 to 3 do
                     ComWriteln (Clr2Eol);
                   FillCommData (Ch);
                 End;
            'F': Begin
                   Send (GoXy (22, 10));
                   PullDnId := GetNumStr (True, True, 0, 255, 0, 255, PullDnId, PullDnId);
                   If Hung Then Break;
{                   FillCommData (Ch);}
                 End;
            'G': Begin
                   Hidden := Not Hidden;
                   FillCommData (Ch);
                 End;
            'H': Begin
                   Pause := Not Pause;
                   FillCommData (Ch);
                 End;
            ']': Begin
                   Seek (C, Pred (FilePos (C)));
                   Write (C, Cr);
                   If FilePos (C) = FileSize (C) Then
                     Seek (C, 0);
                   Read (C, Cr);
                   FillCommData (#0);
                 End;
            '[': Begin
                   Seek (C, Pred (FilePos (C)));
                   Write (C, Cr);
                   Seek (C, Pred (FilePos (C)));
                   If FilePos (C) = 0 Then
                     Seek (C, Pred (FileSize (C)))
                   Else
                     Seek (C, Pred (FilePos (C)));
                   Read (C, Cr);
                   FillCommData (#0);
                 End;
            'Q': Begin
                   Seek (C, Pred (FilePos (C)));
                   Write (C, Cr);
                   Break;
                 End;
            '?': ShowHelp;
            'Z': Begin
                   Seek (C, Pred (FilePos (C)));
                   Read (C, Cr);
                   FillCommData (#0);
                 End;
          End;
        Until Hung;
        Log (2, 'Edited commands in menu ' + mr. name);
      End;

      Procedure AddCommand;
      Var
        F: File;
        w, lui, lui2: word;
      Begin
        If FileSize (C) <> 0 Then Begin
          ComWrite ('|URInsert before which command |UP[|US1|UP-|US' + IntToStr (Succ (FileSize (C))) + '|UP]: |UI');
          Lui := GetNumStr (False, False, 1, Succ (FileSize (C)), 0, 0, 0, 0);
          If Hung Then Exit;
          comwriteln ('');
          if lui = 0 then exit;
        End Else Lui := 1;

        ComWrite ('|URInsert how many commands |UP[|US1|UP]: |UI');
        Lui2 := GetNumStr (False, False, 1, 99, 1, 1, 1, 0);
        If Hung Then Exit;
        comwriteln ('');

        Close (C);
        Assign (F, Uc. MenuPath + S + '.Cmd');
        Reset (F, 1);
        for w := 1 to lui2 do
          InsertRec (F, Pred (Lui), Sizeof (CommandRec));
        Close (F);
        Reset (C);
        Seek (C, Pred (Lui));
        With Cr do Begin
          Desc := 'New Option';
          Keys := 'NEW OPTION';
          Acs := '';
          Data := '';
          Param := '';
          PullDnId := 0;
          Hidden := False;
        End;
        for w := 1 to lui2 do
          Write (C, Cr);
        Log (2, 'Added command(s) to menu ' + mr. name);
        CommandEditor (lui);
      End;

      Procedure DeleteCommand;
      Var
        F: File;
        ez: word;
        low, high: longint;
      Begin
        If FileSize (C) = 0 Then Begin
          ComWriteln ('|URThere are no commands to delete.');
          PressEnter;
          Exit;
        End;
        ComWrite ('|URWhich command(s) to delete');
        GetRange (' ', False, 1, FileSize (C), 0, 0, 0, Low, High);
        If Hung Then Exit;
        comwriteln ('');
        if low = 0 then exit;
        if low <> high then begin
          comwrite ('|USDelete commands |UR' + inttostr (low) + '|UP-|UR' + inttostr (high) + ' ');
          if litebar (lbYes, false, true) = lbno then exit;
        end;
        Close (C);
        Assign (F, Uc. MenuPath + S + '.Cmd');
        Reset (F, 1);
        For ez := high downto low do
          RemoveRec (F, Pred (ez), Sizeof (CommandRec));
        Close (F);
        Reset (C);
        Log (2, 'Deleted command(s) from menu ' + mr. name);
      End;

      Procedure MoveCommand;
      Var
        lui, Movef: Byte;
        F: File;
      Begin
        If FileSize (C) = 0 Then Begin
          ComWriteln ('|URThere are no commands to move.');
          PressEnter;
          Exit;
        End;
        ComWrite ('|URWhich command to move |UP[|US1|UP-|US' + IntToStr (FileSize (C)) + '|UP]: |UI');
        movef := GetNumStr (False, False, 1, FileSize (C), 0, 0, 0, 0);
        If Hung Then Exit;
        comwriteln ('');
        if movef = 0 then exit;

        ComWrite ('|URInsert where|UP [|US1|UP-|US' + IntToStr (FileSize (C)) + '|UP]: |UI');
        Lui := GetNumStr (False, False, 1, FileSize (C), 0, 0, 0, 0);
        If Hung Then Exit;
        comwriteln ('');
        if lui = 0 then exit;

        Seek (C, Pred (Movef));
        Read (C, Cr);
        Close (C);
        Assign (F, Uc. MenuPath + S + '.Cmd');
        Reset (F, 1);
        RemoveRec (F, Pred (Movef), Sizeof (CommandRec));
        InsertRec (F, Pred (Lui), Sizeof (CommandRec));
        Close (F);
        Reset (C);
        Seek (C, Pred (Lui));
        Write (C, Cr);
        Log (2, 'Re-ordered command(s) in menu ' + mr. name);
      End;

      Procedure CopyCommand;
      Var
        lui, Movef: Byte;
        F: File;
      Begin
        If FileSize (C) = 0 Then Begin
          ComWriteln ('|URThere are no commands to copy.');
          PressEnter;
          Exit;
        End;
        ComWrite ('|URWhich command to copy |UP[|US1|UP-|US' + IntToStr (FileSize (C)) + '|UP]: |UI');
        movef := GetNumStr (False, False, 1, FileSize (C), 0, 0, 0, 0);
        If Hung Then Exit;
        comwriteln ('');
        if movef = 0 then exit;

        ComWrite ('|URInsert where|UP [|US1|UP-|US' + IntToStr (succ (FileSize (C))) + '|UP]: |UI');
        Lui := GetNumStr (False, False, 1, succ (FileSize (C)), 0, 0, 0, 0);
        If Hung Then Exit;
        comwriteln ('');
        if lui = 0 then exit;

        Seek (C, Pred (Movef));
        Read (C, Cr);
        Close (C);
        Assign (F, Uc. MenuPath + S + '.Cmd');
        Reset (F, 1);
        InsertRec (F, Pred (Lui), Sizeof (CommandRec));
        Close (F);
        Reset (C);
        Seek (C, Pred (Lui));
        Write (C, Cr);
        Log (2, 'Copied command(s) in menu ' + mr. name);
      End;

    Begin
      send (cls);
      Assign (C, Uc. MenuPath + S + '.Cmd');
      {$I-}
      Reset (C);
      {$IFDEF Debug} {$I+} {$ENDIF}
      If IOResult <> 0 Then Begin
        ComWriteln ('|07Error opening command file |15' + Uc. MenuPath + S + '.Cmd|07');
        ErrorLog ('|07Error opening command file |09' + Uc. MenuPath + S + '.Cmd|07');
        PressEnter;
        Exit;
      End;

      Repeat
        B := 0;
        Seek (C, 0);
        Send (Cls);

        While Not Eof (C) do Begin
          Inc (B);
          Read (C, Cr);
          With Cr do
            ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (Keys, 10, ' ') + '|UR ' +
                      PadLeft (Data, 2, ' ') + '  ');
          If (B Mod 4 = 0) And (B Div 4 Mod curPageLen = curPageLen - 2) And (More (false) = mno) Then Break;
          If Hung Then Exit;
        End;

        If B Mod 4 <> 0 Then ComWriteln ('');
        ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, |UP[|USM|UP]|URove, |UP[|USK|UP]|URopy,'+
                  ' |UP[|USQ|UP]|URuit|UP: |UI');

        Repeat
          Ch := uCase (ReadInChar);
          If Hung Then Break;
        Until Pos (Ch, 'ACDMKQ') <> 0;

        If Hung Then Break;
        ComWriteLn (Ch);
        Case Ch Of
          'A': AddCommand;
          'C': CommandEditor (0);
          'D': DeleteCommand;
          'M': MoveCommand;
          'K': CopyCommand;
          'Q': Break;
        End;
      Until Hung;
      {$I-}
      Close (C);
      {$IFDEF Debug}{$I+}{$ENDIF}
      If IoResult <> 0 Then ;
    End;

  Var
    B: Byte;
  Begin
    If S = '' Then Exit;
    Assign (M, Uc. MenuPath + S + '.Mnu');
    {$I-}
    Reset (M);
    {$IFDEF Debug} {$I+} {$ENDIF}
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening menu file |15' + Uc. MenuPath + S + '.Mnu|07');
      ErrorLog ('|07Error opening menu file |09' + Uc. MenuPath + S + '.Mnu|07');
      Exit;
    End;
    {$I-}
    Read (M, Mr);
    {$IFDEF Debug} {$I+} {$ENDIF}
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error reading menu file|15 ' + Uc. MenuPath + S + '.Mnu|07');
      ErrorLog ('|07Error reading menu file |09' + Uc. MenuPath + S + '.Mnu|07');
      Exit;
    End;
    Close (M);

    DrawMenu;
    FillMenuData (#0);
    If Hung Then Exit;

    With Mr do Repeat
      usercol (4);
      ComWriteAt (12, 2, ' '#8);
      Repeat
        Ch := uCase (ReadInChar);
        If Hung Then Break;
      Until Pos (Ch, 'ABCDEFGHIJKLQ') <> 0;
      If Hung Then Break;
      Send (Ch);
      usercol (2);

      Case Ch Of
        'A': Begin
               Send (GoXy (22, 5));
               GetStr (8, true, false, Name);
               If Hung Then Break;
{               FillMenuData (Ch);}
             End;
        'B': Begin
               Send (GoXy (1, 19));
               ComWriteln ('|UREnter the prompt|UP:|UI');
               GetStr (255, false, false, Prompt);
               If Hung Then Break;
               Send (GoXy (1, 19));
               For B := 19 to 24 do
                 ComWriteAt (1, B, Clr2Eol);
               FillMenuData (Ch);
             End;
        'C': Begin
               Send (GoXy (22, 7));
               GetStr (57, true, false, HelpFile);
               If Hung Then Break;
{               FillMenuData (Ch);}
             End;
        'D': Begin
               Send (GoXy (22, 8));
               allowflagedit := true;
               GetcapStr (40, 'A', true, false, Acs);
               allowflagedit := false;
               If Hung Then Break;
{               FillMenuData (Ch);}
             End;
        'E': Begin
               Send (GoXy (22, 9));
               GetStr (30, true, false, Password);
               If Hung Then Break;
{               FillMenuData (Ch);}
             End;
        'F': Begin
               Send (GoXy (1, 19));
               ComWrite ('|UR Menu type ');
               Case LiteString ('', 'N~ormal S~pecial P~ulldown R~andom', Pos (Special [1], 'NSPR')) of
                 1: Special := 'N';
                 2: Special := 'S';
                 3: Special := 'P';
                 4: Begin
                      If Hung Then Break;
                      Send (^M + Clr2Eol);
                      ComWrite ('|UR Enter highest random letter|UP: |UI');
                      Ch := uCase (ReadInChar);
                      If Hung Then Break;
                      Special := 'R' + Ch;
                      Send (^M + Clr2Eol);
                    End;
               End;
               If Hung Then Break;
               Send (^M + Clr2Eol);
               FillMenuData ('F');
             End;
        'G': Begin
               Send (GoXy (22, 11));
               GetStr (8, true, false, FallBack);
               If Hung Then Break;
{               FillMenuData (Ch);}
             End;
        'H': Begin
               If AllowGlobals In MenuFlags Then
                 MenuFlags := MenuFlags - [AllowGlobals]
               Else
                 MenuFlags := MenuFlags + [AllowGlobals];
               FillMenuData (Ch);
             End;
        'I': Begin
               If AllowGenerics In MenuFlags Then
                 MenuFlags := MenuFlags - [AllowGenerics]
               Else
                 MenuFlags := MenuFlags + [AllowGenerics];
               FillMenuData (Ch);
             End;
        'J': Begin
               If ForceNoHotKeys In MenuFlags Then
                 MenuFlags := MenuFlags - [ForceNoHotKeys] + [ForceHotKeys]
               Else If ForceHotKeys In MenuFlags Then
                 MenuFlags := MenuFlags - [ForceHotKeys]
               Else
                 MenuFlags := MenuFlags + [ForceNoHotKeys];
               FillMenuData (Ch);
             End;
        'K': Begin
               ListCommands;
               If Hung Then Break;
               DrawMenu;
               FillMenuData (#0);
             End;
        'L': Begin
               Send (Goxy (1, 19));
               ShowGenerics (Name, False);
               If Hung Then Break;
               PressEnter;
               If Hung Then Break;
               DrawMenu;
               FillMenuData (#0);
             End;
        'Z':
             Begin
               Assign (M, Uc. MenuPath + S + '.Mnu');
               Reset (M);
               Read (M, Mr);
               Close (M);
               FillMenuData (#0);
             End;
        'Q': Begin
               Assign (M, Uc. MenuPath + S + '.Mnu');
               Reset (M);
               Write (M, Mr);
               Close (M);
               Break;
             End;
      End;
    Until Hung;
    Log (2, 'Edited menu ' + mr. name);
  End;

  Procedure AddMenu;
  Begin
    FillChar (Mr, Sizeof (Mr), 0);
    ComWrite ('|URGive the menu a name|UP: |UI');
    GetStr (8, False, False, Mr. Name);
    If Hung Then Exit;
    Assign (M, Uc. MenuPath + Mr. Name + '.Mnu');
    {$I-}
    Rewrite (M);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then Exit;
    Mr. Special := 'N';
    mr. menuflags := [allowglobals];
    Write (M, Mr);
    Close (M);
    Assign (C, Uc. MenuPath + Mr. Name + '.Cmd');
    {$I-}
    Rewrite (C);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then Exit;
    Close (C);
    EditMenu (Mr. Name);
    Log (2, 'Added new menu ' + mr. name);
    ReadMenus;
  End;

  Procedure RenameMenu;
  Var
    S: NameStr;
    z: xy;
  Begin
    GetXy (Z);
    S := SelectMenu;
    If Hung Then Exit;
    If S = '' Then Exit;
    PutXy (Z);
    ComWrite ('|URGive the new menu a name|UP: |UI');
    GetStr (8, False, False, Mr. Name);
    If Hung Then Exit;
    if exist (uc. menupath + Mr. Name + '.Mnu') then begin
      comwrite ('|UR' + mr. name + ' already exists, overwrite ');
      if litebar (lbno, false, false) = lbno then begin
        send (^M + Clr2eol);
        exit;
      end;
      send (^M + Clr2eol);
    end;

    deletefile (uc. menupath + Mr. Name + '.Mnu');
    deletefile (uc. menupath + Mr. Name + '.Cmd');
    copyfile (uc. menupath + s + '.Mnu', uc. menupath + Mr. Name + '.mnu');
    copyfile (uc. menupath + s + '.cmd', uc. menupath + Mr. Name + '.Cmd');
    Log (2, 'Copied menu ' + s + ' to ' + mr. name);
    ReadMenus;
  End;

  Procedure DeleteMenu;
  Var
    S: NameStr;
    z: xy;
  Begin
    GetXy (Z);
    S := SelectMenu;
    If Hung Then Exit;
    If S = '' Then Exit;
    PutXy (Z);
    ComWrite ('|URAre you sure you want to delete menu ' + S + ' ');
    If LiteBar (lbNo, False, True) = lbNo Then Exit;
    If Hung Then Exit;
    Log (2, 'Deleted menu ' + s);
    DeleteFile (Uc. MenuPath + S + '.Mnu');
    DeleteFile (Uc. MenuPath + S + '.Cmd');
    ReadMenus;
  End;

Begin
  New (mList, Init);
  ReadMenus;
  Repeat
    DrawMenuBox;
    ComWrite ('|UP[|USA|UP]|URdd menu, |UP[|USC|UP]|URhange menu, |UP[|USD|UP]|URelete menu, |UP[|USR|UP]|URename menu, ' +
              '|UP[|USQ|UP]|URuit|UP: |UI');
    Repeat
      Ch := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (Ch, 'ACDQ') <> 0;
    If Hung Then Break;
    ComWriteLn (Ch);
    Case Ch Of
      'A': AddMenu;
      'C': EditMenu (SelectMenu);
      'D': DeleteMenu;
      'R': renamemenu;
      'Q': Break;
    End;
  Until Hung;
  Dispose (mList, Done);
End;

Procedure ConfEditor;
const
  em: boolean = false;
  cm: array [false..true] of string [7] = ('message', 'file');
Var
  B: Byte;
  cf: File of ConfRec;
  cr: ConfRec;
  rf: file;

  Procedure EditConf;

    Procedure DrawConfEditor;
    Var
      B: Byte;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6]);
      Box (1, 4, 79, 13, User. Cols [6]);
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (51,2, '|15S|07ys|08tem/|157|075 |15C|07o|08nference |15E|07di|08tor');
      ComWriteAt (3, 6, '|UP[|USA|UP]|UR Conference Name');
      ComWriteAt (3, 7, '|UP[|USB|UP]|UR Conference ACS');
      ComWriteAt (3, 8, '|UP[|USC|UP]|UR Conference Password');
      ComWriteAt (3, 9, '|UP[|USD|UP]|UR Pulldown Name');
      ComWriteAt (3,10, '|UP[|USU|UP]|UR Show Users With Access');
      ComWriteAt (3,11, '|UP[|US[|UP]|UR Previous');
      ComWriteAt (3,12, '|UP[|US]|UP]|UR Next');
      usercol (3);
      For B := 6 To 9 Do
        ComWriteAt (27, B, ':');
    End;

    Procedure FillConfData (C: Char);
    Var
      Z: Char;
    Begin
      If Hung Then Exit;
      usercol (2);
      With cr Do Case C Of
        'A': Send (GoXy (29, 6) + PadLeft (desc, 30, ' '));
        'B': Send (GoXy (29, 7) + PadLeft (acs, 40, ' '));
        'C': Send (GoXy (29, 8) + PadLeft (pw, 30, ' '));
        'D': Send (GoXy (29, 9) + PadLeft (pdn, 30, ' '));
        #0 : Begin
               For Z := 'A' To 'D' Do
                 FillConfData (Z);
               ComWriteAt (3, 5, '|UREditing ' + cm [em] + ' conference |UP#' +
                           padleft (inttostr (filepos (cf)), 6, ' '));
             End;
      End;
    End;

  Var
    C: Char;
    ts: String [5];
    B: Byte;
    lui: byte;
    uf: file of tuserdata;
    ur: ^tuserdata;
  Begin
    If FileSize (cf) = 0 Then Begin
      ComWriteln ('|URThere are no ' + cm [em] + ' conferences to change.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich ' + cm [em] + ' conference to change |UP[|US1|UP-|US' + IntToStr (FileSize (cf)) + '|UP]: |UI');
    lui := GetNumStr (False, False, 1, FileSize (cf), 1, FileSize (cf), 0, 0);
    If not hung then comwriteln ('');
    If (Lui = 0) Or Hung Then Exit;
    Seek (cf, Pred (Lui));
    Read (cf, cr);
    DrawConfEditor;
    FillConfData (#0);

    Repeat
      usercol (4);
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If Pos (C, 'ABCD[]UQ') = 0 Then Continue;
      Send (C);
      usercol (2);

      With cr Do Case C Of
        'A':
             Begin
               Send (GoXy (29, 6));
               GetStr (30, true, false, desc);
{               FillConfData (C);}
             End;
        'B':
             Begin
               Send (GoXy (29, 7));
               allowflagedit := true;
               GetcapStr (40, 'a', true, false, acs);
               allowflagedit := false;
{               FillConfData (C);}
             End;
        'C':
             Begin
               Send (GoXy (29, 8));
               GetStr (30, true, false, pw);
{               FillConfData (C);}
             End;
        'D':
             Begin
               Send (GoXy (29, 9));
               GetStr (30, true, false, pdn);
{               FillConfData (C);}
             End;
        'U':
             Begin
               Send (Cls);
               fillin1 := 'Users in ' + desc;
               pfile ('hdr.ans');
               comwriteln ('');
               assign (uf, uc. datapath + 'users.dat');
               reset (uf);
               getmem (ur, sizeof (tuserdata));
               While not eof (uf) do begin
                 read (uf, ur^);
                 if ( ur^. handle <> '') and UserHasAcs (ur^, acs) then comwriteln ('  ' + ur^. handle);
                 if (_y = 24) and (more (false) = mno) then break;
               end;
               close (uf);
               freemem (ur, sizeof (tuserdata));
               comwriteln ('');
               pressenter;
               DrawConfEditor;
               FillConfData (#0);
             End;
        '[':
             Begin
               Seek (cf, Pred (FilePos (cf)));
               Write (cf, cr);

               Seek (cf, Pred (FilePos (cf)));
               If FilePos (cf) = 0 Then
                 Seek (cf, Pred (FileSize (cf)))
               Else
                 Seek (cf, Pred (FilePos (cf)));
               Read (cf, cr);
               FillConfData (#0);
             End;
        ']':
             Begin
               Seek (cf, Pred (FilePos (cf)));
               Write (cf, cr);

               If FilePos (cf) = FileSize (cf) Then Seek (cf, 0);
               Read (cf, cr);
               FillConfData (#0);
             End;
        'Q':
             Begin
               Seek (cf, Pred (FilePos (cf)));
               Write (cf, cr);
               Break;
             End;
      End;
    Until hung;
    If Not hung Then ComWriteAt (1, 14, '|UR');
    Log (2, 'Edited ' + cm [em] + ' conferences');
  End;

  Procedure AddConf;
  Var
    F: File;
  Begin
    If FileSize (cf) >= 255 Then Begin
      ComWriteln ('|URNo more ' + cm [em] + ' conferences can be added.');
      Exit;
    End;
    Seek (cf, FileSize (cf));
    FillChar (cr, Sizeof (cr), 0);
    cr. desc := 'New Conference';
    Write (cf, cr);
    Log (2, 'Added new ' + cm [em] + ' conference');

    if em then
      assign (f, uc. filepath + 'FileArea.' + inttostr (FileSize (cf)))
    else
      assign (f, uc. bordpath + 'MsgBases.' + inttostr (FileSize (cf)));
    {$I-}
    reset (f);
    {$IFDEF Debug}{$I+}{$ENDIF}
    if ioresult = 2 then rewrite (f);
    close (f);
  End;

  Procedure DeleteConf;
  Var
    F: File;
    ze: word;
    lui: byte;
    b: byte;
  Begin
    If FileSize (cf) = 0 Then Begin
      ComWriteln ('|URThere are no ' + cm [em] + ' conferences to delete.');
      PressEnter;
      Exit;
    End;
    ComWrite ('|URWhich ' + cm [em] + ' conference to delete |UP[|US1|UP-|US' + IntToStr (FileSize (cf)) + '|UP]: |UI');
    Lui := GetNumStr (False, False, 1, Succ (FileSize (cf)), 0, 0, 0, 0);
    if hung then exit;
    comwriteln ('');
    if lui = 0 then exit;

    if em then begin
      deletefile (uc. filepath + 'FileArea.' + IntToStr (Lui));
      deletefile (uc. disppath + 'pdfarea!.' + IntToStr (Lui));
      renamefile (uc. disppath + 'pdfarea.' + IntToStr (Lui), uc. disppath + 'pdfarea!.' + IntToStr (Lui));

      for b := succ (lui) to filesize (cf) do begin
        renamefile (uc. filepath + 'FileArea.' + IntToStr (b), uc. filepath + 'FileArea.' + IntToStr (pred (b)));
        renamefile (uc. disppath + 'pdfarea.' + IntToStr (b), uc. disppath + 'pdfarea.' + IntToStr (pred (b)));
      end;
    end else begin
      deletefile (uc. bordpath + 'MsgBases.' + IntToStr (Lui));
      deletefile (uc. disppath + 'pdmbase!.' + IntToStr (Lui));
      renamefile (uc. disppath + 'pdmbase.' + IntToStr (Lui), uc. disppath + 'pdmbase!.' + IntToStr (Lui));

      for b := succ (lui) to filesize (cf) do begin
        renamefile (uc. bordpath + 'MsgBases.' + IntToStr (b), uc. bordpath + 'MsgBases.' + IntToStr (pred (b)));
        renamefile (uc. disppath + 'pdmbase.' + IntToStr (b), uc. disppath + 'pdmbase.' + IntToStr (pred (b)));
      end;
    end;

    Log (2, 'Deleted ' + cm [em] + ' conference ' + cr. desc);
    seek (cf, pred (lui));
    read (cf, cr);
    Close (cf);

    if em then
      Assign (F, Uc. DataPath + 'FileConf.Dat')
    else
      Assign (F, Uc. DataPath + 'MsgConf.Dat');

    Reset (F, 1);
    RemoveRec (F, Pred (Lui), SizeOf (ConfRec));
    comwriteln ('');

    Close (F);
    Reset (cf);
  End;

  Procedure MoveConf;
  var
    tr: confrec;
    lui: longint;
    wow, b: byte;

    procedure minilist;
    var
      b: byte;
    begin
      fillin1 := 'Conferences';
      pfile ('hdr.ans');
      send (^M^J);
      seek (cf, 0);
      b := 1;
      while not eof (cf) do begin
        read (cf, cr);
        comwriteln ('  |UP[|UI' + padright (inttostr (b), 3, ' ') + '|UP]|US  ' + cr. desc);
        inc (b);
      end;
      send (^M^J);
    end;

  var
    x2c, x3c: string [9];
    w: word;
  Begin
    If FileSize (cf) <= 1 Then Begin
      ComWriteln ('|URThere are no ' + cm [em] + ' conferences to re-order.');
      PressEnter;
      Exit;
    End;

    minilist;
    for b := 1 to filesize (cf) do begin
      seek (cf, pred (b));
      read (cf, cr);
      repeat
        comwrite ('|UR Enter new conference |US#' + inttostr (b) + ' |UP(|US' + cr. desc + '|UP) [|UI1|UP-|UI' +
                   inttostr (filesize (cf)) + '|UP, |UIQ|UP/|USquit|UP, |UI?|UP/|USlist|UP]: |UI');
        Lui := GetqNumStr (False, False, 1, FileSize (cf), 0, 0, b, 0, wow, '?qQ');
        comwriteln ('');
        if wow = 1 then
          minilist
        else if wow <> 0 then
          break
        else if lui <> 0 then
          break;
      until hung;

      if wow > 1 then exit;

      if hung then begin
        close (cf);
        exit;
      end;

      if (b = lui) or (lui = 0) then continue;

      seek (cf, pred (lui));
      read (cf, cr);

      if em then begin
        x2c := 'FileArea.';
        x3c := 'pdfarea.'
      end else begin
        x2c := 'MsgBases.';
        x3c := 'pdmbase.';
      end;

      if lui > b then begin
        deletefile (uc. filepath + x2c + 'tmp');
        deletefile (uc. disppath + x3c + 'tmp');
        renamefile (uc. filepath + x2c + inttostr (lui), uc. filepath + x2c + 'tmp');
        renamefile (uc. disppath + x3c + inttostr (lui), uc. disppath + x3c + 'tmp');
        for w := pred (lui) downto b do begin
          seek (cf, filepos (cf) - 2);
          read (cf, tr);
          write (cf, tr);
          seek (cf, pred (filepos (cf)));
          renamefile (uc. filepath + x2c + inttostr (w), uc. filepath + x2c + inttostr (succ (w)));
          renamefile (uc. disppath + x3c + inttostr (w), uc. disppath + x3c + inttostr (succ (w)));
        end;
        renamefile (uc. filepath + x2c + 'tmp', uc. filepath + x2c + inttostr (b));
        renamefile (uc. disppath + x3c + 'tmp', uc. disppath + x3c + inttostr (b));
      end else begin
        deletefile (uc. filepath + x2c + 'tmp');
        deletefile (uc. disppath + x3c + 'tmp');
        renamefile (uc. filepath + x2c + inttostr (lui), uc. filepath + x2c + 'tmp');
        renamefile (uc. disppath + x3c + inttostr (lui), uc. disppath + x3c + 'tmp');
        for w := lui to pred (b) do begin
          read (cf, tr);
          seek (cf, filepos (cf) - 2);
          write (cf, tr);
          seek (cf, succ (filepos (cf)));
          renamefile (uc. filepath + x2c + inttostr (w), uc. filepath + x2c + inttostr (succ (w)));
          renamefile (uc. disppath + x3c + inttostr (w), uc. disppath + x3c + inttostr (succ (w)));
        end;
        renamefile (uc. filepath + x2c + 'tmp', uc. filepath + x2c + inttostr (b));
        renamefile (uc. disppath + x3c + 'tmp', uc. disppath + x3c + inttostr (b));
      end;

      seek (cf, pred (b));
      write (cf, cr);
    end;
    Log (2, 'Re-ordered ' + cm [em] + ' conferences');
  End;

Var
  Ch: Char;
Label
  Top;
Begin
  tOP:
  if em then
    Assign (cF, Uc. DataPath + 'FileConf.Dat')
  else
    Assign (cF, Uc. DataPath + 'MsgConf.Dat');
  {$I-}
  Reset (cf);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    Rewrite (cf);
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening ' + cm [em] + ' conference file');
      ErrorLog ('|07Error opening ' + cm [em] + ' conference file');
      Exit;
    End;
  End;

  Repeat
    B := 0;
    Seek (cf, 0);
    Send (Cls);

    FillIn1 := cm [em] + ' Conferences';
    FillIn1 [1] := uCase (FillIn1 [1]);
    pFile ('hdr.ans');
    ComWriteln ('');
    B := 0;

    While Not EoF (cf) Do Begin
      Inc (B);
      Read (cf, cr);
      With cr Do
        ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (Desc, 33, ' '));
      If B Mod 2 = 0 Then ComWriteln ('');
      If (B Mod 2 = 0) And (_y Mod curPageLen = curPageLen - 2) And (More (false) = mno) Then Break;
      If Hung Then Exit;
    End;

    If B Mod 2 <> 0 Then ComWriteln ('');
    ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, |UP[|USR|UP]|URe-order, ' +
              '|UP[|USM|UP]|URessage, |UP[|USF|UP]|URile, |UP[|USQ|UP]|URuit|UP: |UI');

    Repeat
      Ch := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (Ch, 'ACDRMFQ') <> 0;

    If Hung Then Break;
    ComWriteLn (CH);
    Case Ch Of
      'A': AddConf;
      'C': EditConf;
      'D': DeleteConf;
      'R': MoveConf;
      'M': Begin
             Close (cf);
             em := false;
             goto top;
           End;
      'F': Begin
             Close (cf);
             em := true;
             goto top;
           End;
      'Q': Break;
    End;
  Until Hung;
  {$I-}
  Close (cf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then ;
End;

Procedure SetEditor;
const
  em: boolean = false;
  sm: array [false..true] of string [8] = ('stat', 'menu');
Var
  B: Byte;
  sf: File of SetRec;
  sr: SetRec;

  Procedure EditSet;

    Procedure DrawSetEditor;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6]);
      Box (1, 4, 79, 10, User. Cols [6]);
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (58,2, '|15S|07y|08stem/|157|075 |15S|07e|08t |15E|07d|08itor');
      ComWriteAt (3, 6, '|UP[|USA|UP]|UR Name |UP:');
      ComWriteAt (3, 7, '|UP[|USB|UP]|UR Path |UP:');
      ComWriteAt (3, 8, '|UP[|US[|UP]|UR Previous');
      ComWriteAt (3, 9, '|UP[|US]|UP]|UR Next');
    End;

    Procedure FillSetData (C: Char);
    Var
      Z: Char;
    Begin
      If Hung Then Exit;
      usercol (2);
      With sr Do Case C Of
        'A': Send (GoXy (14, 6) + PadLeft (name, 30, ' '));
        'B': Send (GoXy (14, 7) + PadLeft (path, 65, ' '));
        #0 : Begin
               For Z := 'A' To 'C' Do
                 FillSetData (Z);
               ComWriteAt (3, 5, '|UREditing ' + sm [em] + ' set |UP#' +
                           padleft (inttostr (filepos (sf)), 6, ' '));
             End;
      End;
    End;

  Var
    C: Char;
    lui: byte;
  Begin
    If FileSize (sf) = 0 Then Begin
      ComWriteln ('|URThere are no ' + sm [em] + ' sets to change.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich ' + sm [em] + ' set to change |UP[|US1|UP-|US' + IntToStr (FileSize (sf)) + '|UP]: |UI');
    lui := GetNumStr (False, False, 1, FileSize (sf), 1, FileSize (sf), 0, 0);
    If not hung then comwriteln ('');
    If (Lui = 0) Or Hung Then Exit;
    Seek (sf, Pred (Lui));
    Read (sf, sr);
    DrawSetEditor;
    FillSetData (#0);

    Repeat
      usercol (4);
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If Pos (C, 'AB[]UQ') = 0 Then Continue;
      Send (C);
      usercol (2);

      With sr Do Case C Of
        'A':
             Begin
               Send (GoXy (14, 6));
               GetStr (30, true, false, name);
{               FillConfData (C);}
             End;
        'B':
             Begin
               Send (GoXy (14, 7));
               GetStr (65, true, false, path);
               path := fexpand (path);
               FillSetData (C);
             End;
        '[':
             Begin
               Seek (sf, Pred (FilePos (sf)));
               Write (sf, sr);

               Seek (sf, Pred (FilePos (sf)));
               If FilePos (sf) = 0 Then
                 Seek (sf, Pred (FileSize (sf)))
               Else
                 Seek (sf, Pred (FilePos (sf)));
               Read (sf, sr);
               FillSetData (#0);
             End;
        ']':
             Begin
               Seek (sf, Pred (FilePos (sf)));
               Write (sf, sr);

               If FilePos (sf) = FileSize (sf) Then Seek (sf, 0);
               Read (sf, sr);
               FillSetData (#0);
             End;
        'Q':
             Begin
               Seek (sf, Pred (FilePos (sf)));
               Write (sf, sr);
               Break;
             End;
      End;
    Until hung;
    If Not hung Then ComWriteAt (1, 11, '|UR');
    Log (2, 'Edited ' + sm [em] + ' sets');
  End;

  Procedure AddSet;
  Begin
    If FileSize (sf) >= 255 Then Begin
      ComWriteln ('|URNo more ' + sm [em] + ' sets can be added.');
      Exit;
    End;
    Seek (sf, FileSize (sf));
    FillChar (sr, Sizeof (sr), 0);
    sr. name := 'New '+ sm [em] + ' set';
    Write (sf, sr);
    Log (2, 'Added new ' + sm [em] + ' set');
  End;

  Procedure DeleteSet;
  Var
    lui: byte;
    f: file;
  Begin
    If FileSize (sf) = 0 Then Begin
      ComWriteln ('|URThere are no ' + sm [em] + ' sets to delete.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich ' + sm [em] + ' set to delete |UP[|US1|UP-|US' + IntToStr (FileSize (sf)) + '|UP]: |UI');
    Lui := GetNumStr (False, False, 1, Succ (FileSize (sf)), 0, 0, 0, 0);
    if hung then exit;
    comwriteln ('');
    if lui = 0 then exit;

    Log (2, 'Deleted ' + sm [em] + ' set ' + sr. name);
    seek (sf, pred (lui));
    read (sf, sr);
    Close (sf);

    Assign (F, Uc. DataPath + sm [em] + 'set.Dat');
    Reset (F, 1);
    RemoveRec (F, Pred (Lui), Sizeof (setRec));
    comwriteln ('');

    Close (F);
    Reset (sf);
  End;

Var
  Ch: Char;
Label
  Top;
Begin
  tOP:
  Assign (sF, Uc. DataPath + sm [em] + 'set.Dat');
  {$I-}
  Reset (sf);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    Rewrite (sf);
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening ' + sm [em] + ' set file');
      ErrorLog ('|07Error opening ' + sm [em] + ' set file');
      Exit;
    End;
  End;

  Repeat
    B := 0;
    Seek (sf, 0);
    Send (Cls);

    FillIn1 := sm [em] + ' Sets';
    FillIn1 [1] := uCase (FillIn1 [1]);
    pFile ('hdr.ans');
    ComWriteln ('');
    B := 0;

    While Not EoF (sf) Do Begin
      Inc (B);
      Read (sf, sr);
      With sr Do
        ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (Name, 33, ' '));
      If B Mod 2 = 0 Then ComWriteln ('');
      If (B Mod 2 = 0) And (_y Mod curPageLen = curPageLen - 2) And (More (false) = mno) Then Break;
      If Hung Then Exit;
    End;

    If B Mod 2 <> 0 Then ComWriteln ('');
    ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, ' +
              '|UP[|USM|UP]|URenu, |UP[|USS|UP]|URtat, |UP[|USQ|UP]|URuit|UP: |UI');

    Repeat
      Ch := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (Ch, 'ACDMSQ') <> 0;

    If Hung Then Break;
    ComWriteLn (CH);
    Case Ch Of
      'A': AddSet;
      'C': EditSet;
      'D': DeleteSet;
      'M': Begin
             Close (sf);
             em := true;
             goto top;
           End;
      'S': Begin
             Close (sf);
             em := false;
             goto top;
           End;
      'Q': Break;
    End;
  Until Hung;
  {$I-}
  Close (sf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then ;
End;

End.
