USES DOS,CRT,STRINGS,PULLM,TOTLINK,STRL;
{$M 60000,0,45000}      { Memory Allocation Sizes }
PROCEDURE CLRSCR;
BEGIN
PRINT('|B0');
CRT.CLRSCR;
END;

TYPE
  menurec =                        { *.Mnu : Menu records }
  Record
    Name: String [8];              { used to specify which menu to load }
    prompt: String;                { menu prompt if script or name }
    helpfile: PathStr;             { help or pulldown display file }
    acs: STRING;                   { minimum acs requirements }
    password: STRING;              { password required }
    Special: String [2];           { menu type }
    FallBack: String [8];          { menu to set as fallback }
  End;

  pullinfo=
  Record
    ON:STRING;
    OFF:STRING;
    X:1..80;
    Y:1..25;
    END;

  commandrec =                { *.Cmd : Command records }
  Record
    desc: string[30];              { description for generics and reference only }
    keys: string[30];              { command-execution keys }
    acs: string[30];               { minimum acs requirements }
    data: String [2];              { the actual command }
    param: String;                 { command data }
    pull: PULLINFO;            { for pulldown menus }
    hidden: boolean;               { should command show up in generic menus? }
    pause: boolean;                { wait for enter after command? }
  End;
    VAR
    cmdlist: pDllobj;
    MENU:MENUREC;
    COMMAND:COMMANDREC;
    INPUT:STRING;
CONST TOP='|B0|08ͻ';
      MID='|B0|08                                                                        ';
      BOT='|B0|08ͼ';

  var f:FILE OF MENUREC;
      G:FILE OF COMMANDREC;
      X:INTEGER;

  PROCEDURE WRITEMENU;
  BEGIN
  RESET(F);
  WRITE(F,MENU);
  END;

  PROCEDURE WRITECOMMAND;
  VAR X:INTEGER;
      MAX:INTEGER;
  BEGIN
  MAX:=CMDLIST^.TOTALNODES;
  REWRITE(G);
  RESET(G);
  FOR X:=1 TO MAX DO BEGIN
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (X), Command);
  WRITE(G,COMMAND);
  END;
  END;

FUNCTION YESNOWRITE(A:BOOLEAN):STRING;
BEGIN
IF A=TRUE THEN YESNOWRITE:='YES' ELSE YESNOWRITE:='NO ';
END;

  PROCEDURE ADDCOMMAND(A:COMMANDREC);
  BEGIN
  {$I-} RESET(G); {$I+}
  IF IORESULT<>0 THEN REWRITE(G);
  SEEK(G,FILESIZE(G));
  WRITE(G,A);
{  CLOSE(G);}

  END;
  PROCEDURE REWRITEIT;
  VAR X:INTEGER;
  BEGIN
  X:=1;
  REWRITE(G);
  RESET(g);
  IF CMDLIST^.TOTALNODES=0 THEN EXIT;
  REPEAT
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (X), Command);
  WRITE(G,COMMAND);
  INC(X);
  UNTIL X=CMDLIST^.TOTALNODES;
  RESET(g);
  END;

  PROCEDURE KILLCOMMAND(B:BYTE);
  VAR X:INTEGER;
      F:COMMANDREC;
  BEGIN
  CMDLIST^.DELNODE(CMDLIST^.NODEPTR(B));
  CMDLIST^.change (CMDLIST^.nodeptr (B), COMMAND, sizeof (COMMAND));
  REWRITEIT;
  END;


  PROCEDURE SECOND;
  VAR K:CHAR;
      X:INTEGER;
      MAX:INTEGER;
      TEMP:STRING;
      LABEL START;
  BEGIN
  MAX:=CMDLIST^.TOTALNODES;
  X:=1;
  START:
  CLRSCR;
  PRINT('|B0|15');

  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (X), Command);
  WRITELN('[1] DESCRIPTION: ',COMMAND.DESC);
  WRITELN('[2] KEY        : ',COMMAND.KEYS);
  WRITELN('[3] ACS        : ',COMMAND.ACS);
  WRITELN('[4] MENU CODE  : ',COMMAND.DATA);
  WRITELN('[5] PARAM      : ',COMMAND.PARAM);
  IF MENU.SPECIAL='PD' THEN BEGIN
  WRITELN('[6] PULL ON    : ',COMMAND.PULL.ON);
  WRITELN('[7] PULL OFF   : ',COMMAND.PULL.OFF);
  WRITELN('[8] PULL X     : ',COMMAND.PULL.X);
  WRITELN('[9] PULL Y     : ',COMMAND.PULL.Y);
  WRITELN('[A] HIDDEN     : ',YESNOWRITE(COMMAND.HIDDEN));
  WRITELN('[B] PAUSE      : ',YESNOWRITE(COMMAND.PAUSE));
  END ELSE BEGIN
  WRITELN('[6] HIDDEN     : ',YESNOWRITE(COMMAND.HIDDEN));
  WRITELN('[7] PAUSE      : ',YESNOWRITE(COMMAND.PAUSE));
  END;
  WRITELN('[Q] QUIT ');
  WRITELN('[N] NEXT COMMAND ');
  WRITELN('[P] PREV COMMAND ');
  WRITELN('[!] ADD COMMAND ');
  WRITELN('[K] KILL COMMAND ');
  REPEAT
  K:=READKEY;

  IF K='K' THEN BEGIN
  KILLCOMMAND(X);
  MAX:=CMDLIST^.TOTALNODES;
  GOTO START;
  END;

  IF K='!' THEN BEGIN;
  FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
  ADDCOMMAND(COMMAND);
  CMDLIST^. Add (Command, Sizeof (Command));
  MAX:=CMDLIST^.TOTALNODES;
  END;

  IF K='A' THEN BEGIN;
  IF COMMAND.HIDDEN=FALSE THEN COMMAND.HIDDEN:=TRUE ELSE COMMAND.HIDDEN:=FALSE;
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  GOTO START;
  END;
  IF K='B' THEN BEGIN;
  IF COMMAND.PAUSE=FALSE THEN COMMAND.PAUSE:=TRUE ELSE COMMAND.PAUSE:=FALSE;
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  GOTO START;
  END;

  IF K='1' THEN BEGIN;
  EDSTR(COMMAND.DESC,18,1,30,15,1,100); GOTOXY(18,1); CLREOL; GOTOXY(18,1);WRITE(COMMAND.DESC);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='2' THEN BEGIN;
  EDSTR(COMMAND.KEYS,18,2,30,15,1,30); GOTOXY(18,2); CLREOL; GOTOXY(18,2);WRITE(COMMAND.KEYS);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='3' THEN BEGIN;
  EDSTR(COMMAND.ACS,18,3,30,15,1,30); GOTOXY(18,3); CLREOL; GOTOXY(18,3);WRITE(COMMAND.ACS);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='4' THEN BEGIN;
  EDSTR(COMMAND.DATA,18,4,2,15,1,2); GOTOXY(18,4); CLREOL; GOTOXY(18,4);WRITE(COMMAND.DATA);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='5' THEN BEGIN;
  EDSTR(COMMAND.PARAM,18,5,30,15,1,100); GOTOXY(18,5); CLREOL; GOTOXY(18,5);WRITE(COMMAND.PARAM);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF MENU.SPECIAL='PD' THEN BEGIN
  IF K='6' THEN BEGIN;
  EDSTR(COMMAND.PULL.ON,18,6,30,15,1,100); GOTOXY(18,6); CLREOL; GOTOXY(18,6);WRITE(COMMAND.PULL.ON);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='7' THEN BEGIN;
  EDSTR(COMMAND.PULL.OFF,18,7,30,15,1,100); GOTOXY(18,7); CLREOL; GOTOXY(18,7);WRITE(COMMAND.PULL.OFF);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='8' THEN BEGIN;
  TEMP:=STRR(COMMAND.PULL.X);
  EDSTR(TEMP,18,8,30,15,1,100); GOTOXY(18,8); CLREOL; GOTOXY(18,8);COMMAND.PULL.X:=VALU(TEMP);WRITE(COMMAND.PULL.X);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
  IF K='9' THEN BEGIN;
  TEMP:=STRR(COMMAND.PULL.Y);
  EDSTR(TEMP,18,9,30,15,1,100); GOTOXY(18,9); CLREOL; GOTOXY(18,9);COMMAND.PULL.Y:=VALU(TEMP);WRITE(COMMAND.PULL.Y);
  CMDLIST^.change (CMDLIST^.nodeptr (X), COMMAND, sizeof (COMMAND));
  END;
TEMP:='';
END;

  IF K='N' THEN BEGIN
  INC(X);
  IF X=MAX+1 THEN X:=1;
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (X), Command);
  GOTO START;
  END ELSE
  IF K='P' THEN BEGIN
  DEC(X);
  IF X=0 THEN X:=MAX;
  CMDLIST^. GetNodeData (CMDLIST^. NodePtr (X), Command);
  GOTO START;
  END;

  UNTIL K='Q';
  WRITECOMMAND;
  END;

  procedure first;
  VAR K:CHAR;
  LABEL START;
  begin
  START:
  clrscr;
  PRINT('|15');
  writeln('[1] MENU NAME: ',menu.name);
  writeln('[2] PROMPT   : ',menu.prompt);
  writeln('[3] HELPFILE : ',MENU.HELPFILE);
  WRITELN('[4] ACS      : ',MENU.ACS);
  WRITELN('[5] PASSWORD : ',MENU.PASSWORD);
  WRITE  ('[6] SPECIAL  : ');
  IF MENU.SPECIAL='PD' THEN WRITELN('PULLDOWN') ELSE WRITELN('LINE INPUT');
  WRITELN('[7] FALLBACK : ',MENU.FALLBACK);
  WRITELN('[E] EDIT COMMANDS');
  WRITELN('[Q] QUIT');
  REPEAT
  GOTOXY(1,10);
  PRINT('|B0|15-|07-|08> ');
  CLREOL;
  GOTOXY(5,10);
  K:=READKEY;
  WRITE(K);
  IF K='E' THEN BEGIN; SECOND; GOTO START; END;
  IF K='1' THEN BEGIN; EDSTR(MENU.NAME,16,1,8,15,1,8); GOTOXY(16,1); CLREOL; GOTOXY(16,1);WRITE(MENU.NAME); END;
  IF K='2' THEN BEGIN; EDSTR(MENU.PROMPT,16,2,60,15,1,255); GOTOXY(16,2); CLREOL; GOTOXY(16,2);WRITE(MENU.PROMPT); END;
  IF K='3' THEN BEGIN; EDSTR(MENU.HELPFILE,16,3,60,15,1,255); GOTOXY(16,3); CLREOL; GOTOXY(16,3);WRITE(MENU.HELPFILE); END;
  IF K='4' THEN BEGIN; EDSTR(MENU.ACS,16,4,60,15,1,255); GOTOXY(16,4); CLREOL; GOTOXY(16,4);WRITE(MENU.ACS); END;
  IF K='5' THEN BEGIN; EDSTR(MENU.PASSWORD,16,5,60,15,1,255); GOTOXY(16,5); CLREOL; GOTOXY(16,5);WRITE(MENU.PASSWORD); END;
  IF K='6' THEN BEGIN
                  IF MENU.SPECIAL='PD' THEN MENU.SPECIAL:='LI' ELSE
                  MENU.SPECIAL:='PD';
                  GOTOXY(16,6);
                  CLREOL;
                  GOTOXY(16,6);
                  IF MENU.SPECIAL='PD' THEN WRITELN('PULLDOWN') ELSE WRITELN('LINE INPUT');
                END;
  IF K='7' THEN BEGIN; EDSTR(MENU.FALLBACK,16,7,60,15,1,255); GOTOXY(16,7); CLREOL; GOTOXY(16,7);WRITE(MENU.FALLBACK); END;
  UNTIL K='Q';
  WRITEMENU;

  end;

procedure loadmenu(name:String);
  var
 P: PathStr;
 D: DirStr;
 N: NameStr;
 E: ExtStr;

  begin
  P:=NAME;
  FSplit(P, D, N, E);
  NAME:=N;
  assign(f,name+'.DAT');
  reset(f);
  FILLCHAR(MENU,SIZEOF(MENU),#0);
  READ(F,MENU);
{  CLOSE(F);}
  assign(G,name+'.MNU');
  reset(G);
  X:=0;
  REPEAT
  SEEK(G,X);
  FILLCHAR(COMMAND,SIZEOF(COMMAND),#0);
  READ(G,COMMAND);
{  write(command.desc);}

  CMDLIST^. Add (Command, Sizeof (Command));
  INC(X);
  UNTIL X=FILESIZE(G);

  {WRITE(CMDLIST^.TOTALNODES);
 delay(1000);
{  CLOSE(G);}
  end;


PROCEDURE FILELIST;
var
 DirInfo: SearchRec;         { For Windows, use TSearchRec }
 X:INTEGER;
 F:1..7;
begin                          { For Windows, use faArchive }
 FindFirst('*.MNU', Archive, DirInfo); { Same as DIR *.PAS }
 X:=1;
 F:=1;
 PRINT(TOP+#10+#13);
 while DosError = 0 do
 begin
   PRINT(MID);
   GOTOXY(1,WHEREY);
   {Writeln(DirInfo.Name);}
   PM.UNHIGHLIGHT[X]:='|B0|15'+DIRINFO.NAME;
   PM.  HIGHLIGHT[X]:='|B1|15'+DIRINFO.NAME;
   PM. NAME[X]:=DIRINFO.NAME;
   CASE F OF
   1:BEGIN; PM.CX[X]:=2; PM.CY[X]:=WHEREY; END;
   2:BEGIN; PM.CX[X]:=15; PM.CY[X]:=WHEREY; END;
   3:BEGIN; PM.CX[X]:=28; PM.CY[X]:=WHEREY; END;
   4:BEGIN; PM.CX[X]:=41; PM.CY[X]:=WHEREY; END;
   5:BEGIN; PM.CX[X]:=54; PM.CY[X]:=WHEREY; END;
   6:BEGIN; PM.CX[X]:=67; PM.CY[X]:=WHEREY; END;
   END;
   FindNext(DirInfo);
 INC(X);
 INC(F);
 PM.CURRENTCHOICE:=1;
 IF F=7 THEN begin; gotoxy(1,wherey+1);print(mid);F:=1;gotoxy(1,wherey); end;
 end;
PRINTLN('');
PRINTLN(BOT);
println('');
pm.cx[x]:=1;
pm.cy[x]:=wherey;
INC(X);
pm.unhighlight[X]:='|B0|15ADD MENU';
pm.  highlight[X]:='|B1|15ADD MENU';
INC(X);
pm.cx[x]:=10;
pm.cy[x]:=wherey;
pm.unhighlight[X]:='|B0|15DEL MENU';
pm.  highlight[X]:='|B1|15DEL MENU';
PM.MAXC:=X-1;

end;

VAR MENUIT:INTEGER;
    FILENAME:STRING;
BEGIN
CLRSCR;
NEW(CMDLIST,INIT);
FILELIST;
MENUIT:=PMENU;
FILENAME:=PM.NAME[MENUIT];
LOADMENU(FILENAME);
first;
{ CMDLIST^. GetNodeData (CMDLIST^. NodePtr (2), Command);}

CLOSE(F);

DISPOSE(CMDLIST);
END.

