{$R-,S-,I-,D-,F+,V-,B-,N-,L+,O+ }
unit lastcall;            (* Last Call Routines for ViSiON *)
interface
USES DOS,CRT,gentypes,subs1,general,strings,io,PROMPT,USER;

procedure addlastcaller (s:string);  (* Add Name To Last Call List *)
function getlastcaller:string;       (* Get The Last Caller *)
procedure lastcallers;               (* List Last 20 Callers *)
type   lastcallrec=record
       name:string[30];
       speed,date,time:string[8];
       callnum:BYTE;
       end;
implementation

procedure addlastcaller (s:string);
  var i:INTEGER;
  VAR ii:integer;
var
    last:lastcallrec;
    lastf:file of lastcallrec;

begin
{  NEW(LAST);}
  assign (lastf,CONFIGSET.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);
  if (ioresult<>0) or (filesize(lastf)=10) then begin
  last.callnum:=0;
  {$I-}rewrite (lastf){$I+}
  end;
  seek(lastf,filesize(lastf));
  with last do begin
    name:=s;
{    if LOCAL=TRUE then speed:='Local' else speed:=strr (connectbaud);}
    {    date:=datestr(now);
    time:=timestr(now);     }
    callnum:=filesize(lastf)+1;
  end;
  write (lastf,last);
  close (lastf);
{  Dispose(last);}
end;

function getlastcaller:string;
  var b:boolean;
var
    last:lastcallrec;
    lastf:file of lastcallrec;

begin
{new(last);}
  b:=false;
  getlastcaller:='';
  assign (lastf,CONFIGSET.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);{$I+}
  if (ioresult=0) then begin
    b:=true;
    if filesize (lastf)>0 then begin
      seek (lastf,0);
      read (lastf,last);
      getlastcaller:=last.name;
    end;
  end;
  if b then close (lastf);
{dispose(last);}
end;


procedure lastcallers;
  var i:integer;
      LASTS:MCIS;
var
    last:lastcallrec;
    lastf:file of lastcallrec;

begin
  assign (lastf,CONFIGSET.datadir+'CALLERS.DAT');
  {$I-}reset (lastf);{$I+}
  IF IORESULT<>0 THEN EXIT;
  PRINTFILE('LSTTOP.ANS',LASTS,FALSE);
  FILLCHAR(LASTS,SIZEOF(LASTS),#0);
  LASTS[1].MCI:='%LN';
  LASTS[2].MCI:='%LS';
  LASTS[3].MCI:='%LD';
  LASTS[4].MCI:='%LT';
  LASTS[5].MCI:='%L#';
  for i:=0 to filesize (lastf)-1 do begin
  seek (lastf,i);
  read (lastf,last);
  LASTS[1].STR:=LAST.NAME;
  LASTS[2].STR:=LAST.SPEED;
  LASTS[3].STR:=LAST.DATE;
  LASTS[4].STR:=LAST.TIME;
  LASTS[5].STR:=STRR(LAST.CALLNUM);
  printfile('LSTMID.ANS',LASTS,false);
  end;
  close (lastf);
  printfile('LSTBOT.ANS',LASTS,false);
  end;

begin
end.

