program FSE;

Uses Crt,dos,strings,tpansi;

Const
 Up     = 1;Down   = 2;Left   = 3;Right  = 04;Enter  = 05;Home   = 6;
 EndKey = 7;PageUp = 8;PageDn = 9;Escape = 10;BackSp = 11;

Type BufType = record
         from:string[20];
         too:string[20];
         date:string[8];
         description:string[50];
         lines:Array[1..100,0..159] of Byte;
         end;

Var Buffer  : ^BufType;
         FROMX,FROMY:BYTE;
         TOOX,TOOY:BYTE;
         DATEX,DATEY:BYTE;
         DESCX,DESCY:BYTE;
         from:string[20];
         too:string[20];
         date:string[8];
         description:string[80];

    Width   : Byte;  { Width of Window in Spaces     }
    Top     : Byte;  { ScrollDown Marker             }
    XPos    : Byte;  { X Position in Window          }
    YPos    : Byte;  { Y Position in Window          }
    Attrib  : Byte;  { Current Color                 }
    CH      : Char;  { Dummy Character               }
    Key     : Byte;  { Dummy Byte                    }
    X,Y,Z   : Byte;  { Dummy Counters                }
    Done    : Boolean; { End Fullscreen Editor?      }
    Console : Text;
    WorkColor : Byte;

    StartX,StartY       : Byte;
    EndX,EndY           : Byte;
    QuickPalX,QuickPalY : Byte;
    ColorBarX,ColorBarY : Byte;
    InputX,InputY       : Byte;
    var msgf:file of buftype;

PROCEDURE SAVESCREEN;
TYPE SCREENBUF=RECORD
     CH:CHAR;
     CO:BYTE;
     END;
     VAR SCREEN:array[1..1920] of SCREENBUF;
         T:TEXT;
         X:0..2000;
         fore:byte;
         back:byte;
         blink:boolean;
         bright:boolean;
         COVER:0..2000;
         COLORSAME:BOOLEAN;
begin
    FILLCHAR(sCREEN,SIZEOF(sCREEN),#0);
    ASSIGN(T,'SAVE.SCR');
    REWRITE(T);
Move(Mem[$B800:0000],SCREEN,3840);
COVER:=0;
WRITE(T,'[2J');
FOR X:=1 TO 1920 DO BEGIN
fore:=0;
back:=0;
COLORSAME:=FALSE;
blink:=false;
bright:=false;
fore:=screen[x].co mod 16;
back:=screen[x].co div 16;
blink:=screen[x].co shr 7<>0;
IF screen[x].co MOD 16 IN[0,1,2,3,4,5,6,7,16,17,18,19,20,21,22,23] THEN
bright:=false else bright:=true;

IF    (SCREEN[X].CO MOD 16)=
       (SCREEN[X-1].CO MOD 16) THEN
IF    (SCREEN[X].CO DIV 16)=
       (SCREEN[X-1].CO DIV 16) THEN
IF   SCREEN[X].CO SHR 7=
     SCREEN[X-1].CO SHR 7 THEN
       COLORSAME:=TRUE;

IF COLORSAME=FALSE THEN BEGIN
WRITE(T,'[');
case screen[x].co mod 16 of
    0:write(t,'0;30m');
    1:write(t,'0;34m');
    2:write(t,'0;32m');
    3:write(t,'0;36m');
    4:write(t,'0;31m');
    5:write(t,'0;35m');
    6:write(t,'0;33m');
    7:write(t,'0;37m');
    8:write(t,'1;30m');
    9:write(t,'1;34m');
    10:write(t,'1;32m');
    11:write(t,'1;36m');
    12:write(t,'1;31m');
    13:write(t,'1;35m');
    14:write(t,'1;33m');
    15:write(t,'1;37m');
    16:write(t,'5;0;30m');
    17:write(t,'5;0;34m');
    18:write(t,'5;0;32m');
    19:write(t,'5;0;36m');
    20:write(t,'5;0;31m');
    21:write(t,'5;0;35m');
    22:write(t,'5;0;33m');
    23:write(t,'5;0;37m');
    24:write(t,'5;1;30m');
    25:write(t,'5;1;34m');
    26:write(t,'5;1;32m');
    27:write(t,'5;1;36m');
    28:write(t,'5;1;31m');
    29:write(t,'5;1;35m');
    30:write(t,'5;1;33m');
    31:write(t,'5;1;37m');
 end;
write(t,'[');
case screen[x].co div 16 of
    0:WRITE(t,'40m');
    1:WRITE(t,'44m');
    2:WRITE(t,'42m');
    3:WRITE(t,'46m');
    4:WRITE(t,'41m');
    5:WRITE(t,'45m');
    6:WRITE(t,'43m');
    7:WRITE(t,'47m');
    end;
END;
write(t,screen[x].ch);
END;
CLOSE(T);
end;

procedure savemsg;
begin
seek(msgf,0);
write(msgf,buffer^);
end;

Procedure ShowAnsi2(s:string);
Var TFile : Text;
Begin
Assign(TFile,s);
{$I-} Reset(TFile); {$I+}
If IOResult <> 0 then Exit;
Repeat
 Read(TFile,CH);
 If CH <> '^' then Write(Console,CH) else
  Begin
   Read(TFile,CH);
   Write(Console,'^'+CH);
   End;

Until Eof(TFile);
Width := EndX - StartX;
Close(TFile);
End;



procedure FillWord(var x; count:integer; w:word);
Begin
 Inline($c4/$be/x/$8b/$86/w/$8b/$8e/count/$fc/$f2/$ab);
End;

Procedure pipewrite (S:String);
VAR X,Y:INTEGER;
    R:STRING;
    G:INTEGER;
BEGIN
G:=1;
R:='';
Y:=0;
FOR X:=1 TO LENGTH(S) DO BEGIN
CASE S[X] OF '|':BEGIN
CASE S[X+1] OF 'B':BEGIN
Y:=VALU(S[X+2]);
CRT.TEXTBACKGROUND(Y);
INC(X,2);
END ELSE BEGIN
R:=S[X+1]+S[X+2];
Y:=VALU(R);
CRT.TEXTCOLOR(Y);
INC(X,2);
END;
END;
END ELSE WRITE(ansi,S[X]);
END;
END;
END;

Procedure GotoXy(X,Y : Byte);
Begin
Write(Console,#27+'['+Strr(Y)+';'+Strr(X)+'H');
End;

Procedure Redraw;
Begin
 For Y := 1 to (EndY-StartY+1) do
 Begin
  GotoXy(StartX,StartY+Y-1);
  For X := 0 to Width do
   Begin
    TextAttr := Buffer^.lines[Y+Top-1,X*2+1];
    Write  (Chr(Buffer^.lines[Y+Top-1,X*2]));
   End;
 End;
 GotoXy(StartX+Xpos-1,StartY+Ypos-1);
End;

Procedure Ansi_Up;
Begin
 Write(Console,#27+'[A');
End;

Procedure Ansi_Down;
Begin
 Write(Console,#27+'[B');
End;

Procedure Ansi_Left(N : Byte);
Begin
 Write(Console,#27+'['+Strr(N)+'D');
End;

Procedure Ansi_Right(N : Byte);
Begin
 Write(Console,#27+'['+Strr(N)+'C');
End;

Procedure ScrollDown;
Begin
 If Top+(EndY-StartY) < 100 then
  Begin
   Inc(Top);
   Redraw;
  End;
End;

Procedure MoveDown;
Begin
 If YPos < (EndY - StartY+1) then
  Begin
   Inc(Ypos);
   Ansi_Down;
  End else ScrollDown;
End;

Procedure ScrollUp;
Begin
 If Top > 1 then
  Begin
   Dec(Top,1);
   Redraw;
  End;
End;

Procedure MoveUp;
Begin
 If YPos > 1 then
  Begin
   Dec(YPos,1);
   Ansi_Up;
  End else ScrollUp;
End;

Procedure ChangeColor(Attribute : Byte);
Const AnsiFG : Array[0..7] of Byte = (30,34,32,36,31,35,33,37);
      AnsiBG : Array[0..7] of Byte = (40,44,42,46,41,45,43,47);
Var FG,BG : Byte;
    High  : Byte;
Begin
 FG := Attribute and $0f;
 BG := (Attribute and $f0) shr 4;
 If FG > 7 then High := 1 else High := 0;
 If High = 1 then Dec(FG,8);
 Write(Console,#27+'['+Strr(High)+';'+Strr(AnsiFG[FG])+';'+Strr(AnsiBG[BG])+'m');
End;

Procedure ShowAnsi(s:string);
Var TFile : Text;
Begin
Assign(TFile,s);
{$I-} Reset(TFile); {$I+}
If IOResult <> 0 then Exit;
Assign(Console,'');
Rewrite(Console);
Repeat
 Read(TFile,CH);
 If CH <> '^' then Write(Console,CH) else
  Begin
   Read(TFile,CH);
   Case CH of
    '1' : Begin
           StartX := WhereX;
           StartY := WhereY;
           Ansi_Right(2);
          End;
    '2' : Begin
           EndX := WhereX;
           EndY := WhereY;
           Ansi_Right(2);
          End;
    '3' : Begin
           QuickPalX := WhereX;
           QuickPalY := WhereY;
           Ansi_Right(2);
          End;
     '4' : BEGIN
            FROMX:=WHEREX;
            FROMY:=WHEREY;
            ANSI_RIGHT(2);
           END;
     '5' : BEGIN
             TOOX:=WHEREX;
             TOOY:=WHEREY;
             ANSI_RIGHT(2);
           END;
     '6' : BEGIN
            DATEX:=WHEREX;
            DATEY:=WHEREY;
            ANSI_RIGHT(2);
           END;
     '7' : BEGIN
             DESCX:=WHEREX;
             DESCY:=WHEREY;
             ANSI_RIGHT(2);
           END;

     else Write(Console,'^'+CH);
   End;
  End;
Until Eof(TFile);
Width := EndX - StartX;
Close(TFile);
Close(Console);
End;

Function GrabKey : Byte;
Var C1,C2 : Char;
Begin
 C1 := Readkey;If C1 = #0 then C2 := Readkey;
   Case C1 of
    #13 : GrabKey := Enter;
    #27 : GrabKey := Escape;
    #8  : GrabKey := BackSp;
     else GrabKey := Ord(C1);
   Case C2 of
    #72 : GrabKey := Up;
    #80 : GrabKey := Down;
    #75 : GrabKey := Left;
    #77 : GrabKey := Right;
    #71 : GrabKey := Home;
    #79 : GrabKey := EndKey;
    #73 : GrabKey := PageUp;
    #81 : GrabKey := PageDn;
     else GrabKey := Ord(C1);
   End;
   End;
End;

Procedure QuickPallette;
Var TFile : Text;
    Y : Byte;
    Line : String;
    Donewithquickpallette : boolean;
 Foreground,background : Byte;
Begin
 savescreen;
 Assign(TFile,'FSEQP.ANS');
 {$I-} Reset(TFile); {$I+}
 If IOResult <> 0 then Exit;
 Y := 0;
 Repeat
  Inc(Y);
  Readln(TFile,Line);
  GotoXy(QuickPalX,QuickPalY+Y-1);
  For X := 1 to Length(Line) do
   Begin
     Case Line[X] of
      '|' : Begin
             If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
              Begin
               ColorBarX := WhereX;
               ColorBarY := WhereY;
               Ansi_Right(3);
               Inc(X,2);
              End;
            End;
      '&' : Begin
             InputX := WhereX;
             InputY := WhereY;
             Ansi_Right(1);
            End;
         Else Write(Console,Line[X]);
     End;
{    If Line[X] = '|' then
     Begin
      If (Line[X+1] = 'C') and (Line[X+2] = 'B') then
       Begin
        ColorBarX := WhereX;
        ColorBarY := WhereY;
       End;
     End;
    If Line[X] = '&' then
     Begin
      InputX := WhereX;
      InputY := WhereY;
     End;
    Write(Console,Line[X]);}
   End;
 Until Eof(TFile);
 Close(TFile);
 GotoXy(ColorBarX,ColorBarY);
 PipeWrite('|07 |01 |02 |03 |04 |05 |06 |07 |08 |09 |10 |11 |12 |13 |14 |15');
 DoneWithQuickPallette := False;
 Foreground := (Attrib and $0f);
 Background := (Attrib and $f0) shr 4;
 GotoXy(InputX,InputY);Write(Console,' ');Ansi_Left(1);
 Repeat
  GotoXy(ColorBarX+(Foreground*2),ColorBarY-1); Write(Console,'');
  GotoXy(ColorBarX+(Background*2),ColorBarY+1); Write(Console,'');
  GotoXy(InputX,InputY);
  Key := Grabkey;
  Case Key of
   Ord('A'),Ord('a'),Ord('S'),Ord('s'),Ord('Q'),Ord('q') : Write(Console,Chr(Key));
  End;
  Case Key of
   Ord('a'),
   Ord('A') : Begin
               Done := True;
               doneWithQuickpallette := True;
              End;
   ORD('S'):begin
            savemsg;
            end;

   Enter,Escape : DoneWithQuickpallette := True;
   Left   : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             Write(Console,' ');
             If Foreground > 0 then Dec(Foreground) else Foreground := 15;
            End;
   Right  : Begin
             GotoXy(ColorBarX+(Foreground*2),ColorBarY-1);
             Write(Console,' ');
             If Foreground < 15 then Inc(Foreground) else Foreground := 0;
            End;
    Up    : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             Write(Console,' ');
             If Background < 7 then Inc(Background) else Background := 0;
            End;
    Down  : Begin
             GotoXy(ColorBarX+(Background*2),ColorBarY+1);
             Write(Console,' ');
             If Background > 0 then Dec(Background) else Background := 7;
            End;
  End;
 until DoneWithQuickPallette;
 Key := 0;
 Redraw;
 Attrib := Background shl 4 + foreground;
 showansi('save.scr');
End;

procedure msgstat;
begin
gotoxy(fromx,fromy);
write(buffer^.from);
gotoxy(toox,tooy);
write(buffer^.too);
gotoxy(datex,datey);
write(buffer^.date);
gotoxy(descx,descy);
write(buffer^.description);

end;

procedure msgpost(readit:boolean);
 var count:integer;
 begin
 ShowAnsi('fse.ans');
 Assign(Console,'');
 REwrite(Console);
 Top := 1;CH := #0;X := 0;Y := 0;Z := 0;XPos := 1;YPos := 1;Done := False;
 Textcolor(7);Textbackground(0);
 Attrib := 7;
 buffer^.date:='';
 if readit=false then begin
 Getmem(Buffer,SizeOf(Buffer));
 Fillword(Buffer^,SizeOf(buffer^),$0720);
 buffer^.date:=date;
 buffer^.from:=from;
 buffer^.too:=too;
 buffer^.description:=description;
 end else begin;
 redraw;
 end;
 msgstat;
 GotoXy(StartX,StartY);
 WorkColor := 7;
 ChangeColor(WorkColor);
 Repeat
  Key := 0;
  Key := Grabkey;
  if readit=false then
  If (XPos = 1) and (Key = Ord('/')) then QuickPallette;
  Case Key of
   Escape : if readit=false then QuickPallette;
   BackSp : if readit=false then If XPos > 1 then
            Begin
             Dec(Xpos);
             Buffer^.lines[YPos+Top-1,XPos*2-2] := 32;
             Buffer^.lines[YPos+Top-1,XPos*2-1] := 7;
             Ansi_Left(1);
             Write(Console,' ');
             Ansi_Left(1);
            End;
   Left   : If XPos > 1 then
             Begin
              Dec(Xpos);
              Ansi_left(1);
             End;
   PageUp : Inc(WorkColor);
   PageDn : Dec(WorkColor);
   Right  : If XPos < (EndX-StartX) then
            Begin
             Inc(XPos);
             Ansi_Right(1);
            End;
   Home   : Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   EndKey : Begin
             XPos := Width;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
            End;
   Down   : MoveDown;
   Up     : MoveUp;
   Enter  : if readit=false then Begin
             XPos := 1;
             GotoXy(StartX+Xpos-1,StartY+Ypos-1);
             MoveDown;
            End;
  30..254 : if readit=false then Begin
             Buffer^.lines[YPos+Top-1,XPos*2-2] := Key;
             Buffer^.lines[YPos+Top-1,XPos*2-1] := Attrib;
             ChangeColor(Attrib);
             Write(Console,Chr(key));
             If XPos < (EndX-StartX) then Inc(XPos) else
              Begin
               XPos := 1;
               GotoXy(StartX+Xpos-1,StartY+Ypos-1);
               MoveDown;
              End;
            End;
  End;
 Until Done;
 Close(Console);
 Freemem(Buffer,Sizeof(Buffer));
End;

procedure startmsg;
begin
from:='Judge Dredd';
clrscr;
writeln('From: ',from);
write  ('To  : ');
readln(too);
Write  ('Description: ');
readln(description);
assign(msgf,'msg.dat');
rewrite(msgf);
msgpost(false);
close(msgf);
end;

procedure readmsg(s:string);
begin
 Getmem(Buffer,SizeOf(Buffer));
 Fillword(Buffer^,SizeOf(buffer^),$0720);
assign(msgf,'msg.dat');
reset(msgf);
read(msgf,buffer^);
msgpost(true);
end;

begin
startmsg;
{readmsg('s');}
end.