UNIT Modem;

INTERFACE

USES
   Dos, Crt, GlobType, PibTimer;

var brecv,bsent:longint;
    icomoffset:integer;

procedure sendchar (k:char);
procedure sendstring (s:string);
function numchars:integer;
function getchar:char;
procedure hangup;
procedure setparam (comnum:byte; baud:word; parity:boolean);
function carrier:boolean;
procedure setdtr (b:boolean);
procedure dontanswer;
procedure doanswer;
procedure closeport;
procedure clearinput;
procedure clearoutput;
procedure activateport;
procedure deactivateport;

PROCEDURE BIOS_RS232_Init( ComPort : INTEGER; ComParm : WORD );
PROCEDURE Async_Close( Drop_DTR: BOOLEAN );
PROCEDURE Async_Clear_Errors;
PROCEDURE Async_Reset_Port( ComPort       : INTEGER;
                            BaudRate      : WORD;
                            Parity        : CHAR;
                            WordSize      : INTEGER;
                            StopBits      : INTEGER  );
FUNCTION  Async_Open( ComPort       : INTEGER;
                      BaudRate      : WORD;
                      Parity        : CHAR;
                      WordSize      : INTEGER;
                      StopBits      : INTEGER  ) : BOOLEAN;
PROCEDURE Async_Send( C : Char );
FUNCTION Async_Receive( VAR C : Char ) : BOOLEAN;
PROCEDURE Async_Receive_With_Timeout( Secs : INTEGER; VAR C : INTEGER );
PROCEDURE Async_Stuff( Ch: CHAR );
PROCEDURE Async_Find_Delay( VAR One_MS_Delay : INTEGER );
PROCEDURE Async_Init( Async_Buffer_Max  : INTEGER;
                      Async_OBuffer_Max : INTEGER;
                      Async_High_Lev1   : INTEGER;
                      Async_High_Lev2   : INTEGER;
                      Async_Low_Lev     : INTEGER );
FUNCTION  Async_Carrier_Detect : BOOLEAN;
FUNCTION  Async_Carrier_Drop : BOOLEAN;
PROCEDURE Async_Term_Ready( Ready_Status : BOOLEAN );
FUNCTION  Async_Buffer_Check : BOOLEAN;
FUNCTION  Async_Line_Error( VAR Error_Flags: BYTE ) : BOOLEAN;
FUNCTION  Async_Ring_Detect : BOOLEAN;
PROCEDURE Async_Send_Break;
PROCEDURE Async_Send_String( S : AnyStr );
PROCEDURE Async_Send_String_With_Delays( S          : AnyStr;
                                         Char_Delay : INTEGER;
                                         EOS_Delay  : INTEGER  );
FUNCTION  Async_Percentage_Used : REAL;
PROCEDURE Async_Purge_Buffer;
FUNCTION  Async_Peek( Nchars : INTEGER ) : CHAR;
PROCEDURE Async_Setup_Port( ComPort       : INTEGER;
                            Base_Address  : INTEGER;
                            IRQ_Line      : INTEGER;
                            Int_Numb      : INTEGER );
PROCEDURE Async_Release_Buffers;
PROCEDURE Async_Flush_Input_Buffer;
PROCEDURE Async_Drain_Input_Buffer( Max_Wait_Time : INTEGER );
PROCEDURE Async_Flush_Output_Buffer;
PROCEDURE Async_Drain_Output_Buffer( Max_Wait_Time : INTEGER );
FUNCTION  Async_Port_Address_Given( Com_Port : INTEGER ) : BOOLEAN;
PROCEDURE Async_Send_Now( C : Char );
FUNCTION  Async_Wait_For_Quiet( Max_Wait : LONGINT;
                                Wait_Time: LONGINT  ) : BOOLEAN;
PROCEDURE Async_Set_Rejection( Reject_Bad : BOOLEAN; Reject_Char : CHAR );

IMPLEMENTATION
                                   (* Remove blank before $ in next *)
                                   (* statement to get multitasking *)
                                   (* defined.                      *)
{ $DEFINE MTASK }

(*$I PIBASYN1.MOD *)
(*$I PIBASYN2.MOD *)
(*$I PIBASYN3.MOD *)

var com:byte;
    baudra:word;

procedure closeport;
begin
  async_close(true);
end;

procedure sendchar (k:char);
begin
  bsent:=bsent+1;
  async_send(k);
end;

procedure sendstring (s:string);
var i:integer;
begin
  for i:=1 to length(s) do
  sendchar (s[i]);
end;

function numchars:integer;
var r:registers;
begin
  if async_buffer_check then numchars:=1 else numchars:=0;
end;

function getchar:char;
var k:char;
begin
  if async_receive(k) then begin
    getchar:=k;
    brecv:=brecv+1;
  end;
end;

procedure hangup;
begin
  async_term_ready (false);
end;

procedure setparam (comnum:byte; baud:word; parity:boolean);
begin
  com:=comnum;
  baudra:=baud;
  if (not Async_Open(comnum,baud,'N',8,1)) then writeln ('[COM Port #',comnum,' Error!');
end;

function carrier:boolean;
begin
  carrier:=async_carrier_detect;
end;

procedure setdtr (b:boolean);
begin
  async_term_ready (b);
end;

procedure dontanswer;
begin
  setdtr (false);
end;

procedure doanswer;
begin
  setdtr (true);
end;

procedure clearinput;
begin
  Async_Flush_Input_Buffer;
end;

procedure clearoutput;
begin
  Async_Flush_Output_Buffer;
end;

procedure activateport;
begin
  if carrier then setparam (com,baudra,false);
end;

procedure deactivateport;
begin
  if carrier then async_close (false);
end;

BEGIN (* PibAsync *)
                                   (* Default communications parameters *)
   Async_Do_CTS         := FALSE;
   Async_Do_DSR         := FALSE;
   Async_Hard_Wired_On  := FALSE;
   Async_Break_Length   := 500;
   Async_Do_XonXoff     := TRUE;
   Async_OV_XonXoff     := TRUE;
   Async_Buffer_Length  := 1024;
   Async_OBuffer_Length := 2048;
   Async_Reject_Noise   := True;
   Async_Noise_Char     := CHR( 0 );

                                   (* Port addresses of each com port *)

   Default_Com_Base[1]  := COM1_Base;
   Default_Com_Base[2]  := COM2_Base;
   Default_Com_Base[3]  := COM3_Base;
   Default_Com_Base[4]  := COM4_Base;

                                   (* IRQ line for each port *)

   Default_Com_Irq [1]  := COM1_Irq;
   Default_Com_Irq [2]  := COM2_Irq;
   Default_Com_Irq [3]  := COM3_Irq;
   Default_Com_Irq [4]  := COM4_Irq;

                                   (* Pick up address of send-a-character *)
                                   (* routine, which is used by INLINE    *)
                                   (* code.                               *)

   Async_Send_Addr := ADDR( Async_Send );
                                   (* Pick up address of send-a-character *)
                                   (* routine, which is used by INLINE    *)
                                   (* code.                               *)

   Async_Send_Addr := ADDR( Async_Send );

                                   (* Set CTS checking *)

                                   (* Set XON/XOFF to user request *)

   Async_Do_XonXoff     :=false;

                                   (* Set hard-wired as user requests *)


Async_Hard_Wired_On  := false;
if async_hard_wired_on then begin
 async_do_cts:=false;
 async_do_dsr:=false;
end else begin
   Async_Do_CTS:=true;
   Async_Do_DSR:=false;

end;
                                   (* Set half-second break duration *)
   Async_Break_Length   := 500;

                                   (* Let XON/XOFF break points default. *)

   Async_Init( 256, 512, 0, 0, 0);

END   (* PibAsync *).
