{$I+,S+}
unit usermisc;

interface

uses crt,dos,records,strunit;

function numusers:integer;
procedure readuser (var u:userrec; i:integer);
procedure writeuser (var u:userrec; i:integer);
procedure assigniidxf (curintvw:integer);
procedure openiidxf (curintvw:integer);
procedure closeiidxf;
procedure deleteuser (i:integer);
function finduser (s:string):integer;
function numconf:integer;
procedure openconf (c:char);
procedure quickvalidate (var u:userrec; i:integer; c:char);
procedure closefiles (b:boolean);
function age (var u:userrec):integer;
procedure useropen (b:boolean);
procedure idxopen (b:boolean);

implementation

function numusers;
begin
  useropen (false);
  numusers:=filesize (userf);
  useropen (true);
end;

procedure readuser (var u:userrec; i:integer);
begin
  if i<1 then exit;
  useropen (false);
  seek (userf,i-1);
  read (userf,u);
  useropen (true);
  idxopen (false);
  seek (idxf,i-1);
  read (idxf,idx);
  idxopen (true);
end;

procedure writeuser (var u:userrec; i:integer);
begin
  if i<1 then exit;
  useropen (false);
  seek (userf,i-1);
  write (userf,u);
  useropen (true);
  idxopen (false);
  seek (idxf,i-1);
  idx.handle:=u.handle;
  write (idxf,idx);
  idxopen (true);
end;

procedure assigniidxf (curintvw:integer);
begin
  assign (iidxf,setup.msgdir+'INTVW'+strr (curintvw)+'.IDX');
end;

procedure openiidxf (curintvw:integer);
begin
  assigniidxf (curintvw);
  {$I-}reset (iidxf);{$I+}
  if ioresult<>0 then {$I-}rewrite (iidxf);{$I+}
end;

procedure closeiidxf;
begin
  close (iidxf);
end;

procedure deleteuser (i:integer);
  var ii,iii:integer;
      u:userrec;
begin
  fillchar (u,sizeof(u),0);
  writeuser (u,i);
  if i=usernum then usernum:=0;
  for ii:=1 to maxinterview do begin
    openiidxf (ii);
    for iii:=1 to filesize (iidxf) do begin
      seek (iidxf,iii-1);
      read (iidxf,iidx);
      if iidx.usernum=i then iidx.active:=false;
      write (iidxf,iidx);
    end;
    closeiidxf;
  end;
end;

function finduser;
  var i,ii,num,tmp:integer;
      u:idxrec;
begin
  i:=0;
  ii:=0;
  if s='' then else begin
    val (s,num,tmp);
    idxopen (false);
    if (num>0) and (num<=filesize (idxf)) then begin
      i:=valu (s);
      seek (idxf,i-1);
      read (idxf,u);
      if length (u.handle)>0 then ii:=i;
    end else begin
      for i:=1 to filesize (idxf) do begin
        seek (idxf,i-1);
        read (idxf,u);
        if match (s,u.handle) then ii:=i;
      end;
    end;
    idxopen (true);
  end;
  finduser:=ii;
end;

function numconf:integer;
begin
  numconf:=filesize (conff);
end;

procedure openconf (c:char);
  var t:string[8];
begin
  if c='M' then t:='MSGCONF' else if c='T' then t:='XFERCONF' else exit;
  assign (conff,setup.datadir+t+'.DAT');
  {$I-}reset (conff);{$I+}
  if ioresult<>0 then {$I-}rewrite (conff);{$I+}
end;

procedure scanconf (var u:userrec; c:char);
  var i:integer;
begin
  openconf (c);
  for i:=1 to numconf do begin
    seek (conff,i-1);
    read (conff,conf);
    if c='M' then begin
      if conf.qv then u.msgconf[i]:=true;
    end else if c='T' then begin
      if conf.qv then u.xferconf[i]:=true;
    end;
  end;
  close (conff);
end;

procedure quickvalidate (var u:userrec; i:integer; c:char);
begin
  if usernum>0 then begin
    closefiles (false);
    {writeuser (user,usernum);}
    readuser (u,i);
    case c of
      'U':begin
            u.mlevel:=setup.vmlevel;
            u.msglevel:=setup.vmsglevel;
            u.xflevel:=setup.vxflevel;
            u.fpoint:=setup.vxfpoint;
            u.dailytime:=setup.vtime;
            u.time:=u.dailytime;
            u.note:=setup.vnote;
          end;
      'S':begin
            u.mlevel:=setup.sysmlevel;
            u.msglevel:=setup.sysmlevel;
            u.xflevel:=setup.sysxflevel;
            u.dailytime:=setup.systime;
            u.time:=u.dailytime;
          end;
      'U','S':begin
                scanconf (u,'M');
                scanconf (u,'T');
              end;
    end;
    writeuser (u,i);
    {readuser (user,usernum);}
  end;
end;

procedure closefiles (b:boolean);
  var i:integer;
begin
  i:=timeontoday;
  dec (user.time,i);
  {user.time:=user.time-i;}
  if user.time<0 then user.time:=0;
  writeuser (user,usernum);
  writestatus;
 {ShutDownExecSwap;}
end;

function age (var u:userrec):integer;
  var i,ii,j:byte;
begin
  i:=valu (copy (u.bday,7,2));
  ii:=valu (copy (curdate,7,2));
  j:=ii-i;
  if copy (curdate,1,5)<copy (u.bday,1,5) then dec (j);
  age:=j;
end;

procedure useropen (b:boolean);
begin
  if b then close (userf) else begin
    assign (userf,setup.datadir+'USERS.DAT');
    {$I-}reset (userf);{$I+}
    if ioresult<>0 then {$I-}rewrite (userf);{$I+}
  end;
end;

procedure idxopen (b:boolean);
begin
  if b then close (idxf) else begin
    assign (idxf,setup.datadir+'INDEX.DAT');
    {$I-}reset (idxf);{$I+}
    if ioresult<>0 then {$I-}rewrite (idxf);{$I+}
  end;
end;

begin
end.