{$I+,S+}
unit strunit;

interface

uses crt,dos;

function reverse (s:string):string;
function uppercase (s:string):string;
function match (s,ss:string):boolean;
Function Exist(Filename:string):boolean;
function strr (l:longint):string;
function streal (r:real):string;
function valu (s:string):longint;
function boostr (b:boolean):string;
function curdate:string;
function curtime:string;
procedure cursor (b:boolean);
function isopen (var ff):boolean;
function ratio (l1,l2:longint):integer;
procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);
function validfname (name:string):boolean;
function validtime (inp:string):boolean;
function validdate (inp:string):boolean;
function freek (d:integer):longint;
function sizek (d:integer):longint;
{procedure copyfile (srcname,destpath:string);
procedure movefile (srcname,destpath:string);}

type ScreenType = array [0..3999] of Byte;
var ScreenAddr : ScreenType absolute $B800:$0000;

implementation

function reverse;
  var i:integer;
      ss:string[80];
begin
  ss:='';
  for i:=length (s) downto 1 do ss:=ss+s[i];
  reverse:=ss;
end;

function uppercase;
  var i:integer;
     ss:string;
begin
  ss:='';
  for i:=1 to length (s) do ss:=ss+upcase (s[i]);
  uppercase:=ss;
end;

function match;
  var i:integer;
begin
  match:=false;
  if length(s)<>length(ss) then exit;
  for i:=1 to length(s) do
  if upcase(s[i])<>upcase(ss[i]) then exit;
  match:=true;
end;

Function Exist(Filename:string):boolean;
{returns true if file exists}
var Inf: SearchRec;
begin
    FindFirst(Filename,AnyFile,Inf);
    Exist := (DOSError = 0);
end;  {Func Exist}

function strr;
  var s:string;
begin
  str (l,s);
  strr:=s;
end;

function streal (r:real):string;
var s:string;
begin
  str (r:0:0,s);
  streal:=s;
end;

function valu (s:string):longint;
var i:longint;
    ii:integer;
begin
  val (s,i,ii);
  valu:=i;
end;

function boostr (b:boolean):string;
begin
  if b then boostr:='Y' else boostr:='N';
end;

function curdate;
  var s,ss:string[8];
      y,m,d,w:word;
begin
  s:='';
  getdate (y,m,d,w);
  case m of
    0..9:s:='0'+strr (m)+'/';
    else s:=strr (m)+'/';
  end;
  ss:=copy (strr (y),3,2);
  case d of
    0..9:s:=s+'0'+strr (d)+'/'+ss;
    else s:=s+strr (d)+'/'+ss;
  end;
  curdate:=s;
end;

function curtime;
  var s:string[8];
      h,m,sc,hu:word;
      pm:boolean;
begin
  s:='';
  pm:=false;
  gettime (h,m,sc,hu);
  if h>11 then begin
    pm:=true;
    if h>12 then dec (h,12);
  end;
  if h=0 then h:=12;
  case h of
    1..9:s:='0'+strr (h);
    else s:=strr (h);
  end;
  s:=s+':';
  case m of
    0..9:s:=s+'0'+strr (m);
    else s:=s+strr (m);
  end;
  if pm then s:=s+' pm' else s:=s+' am';
  curtime:=s;
end;

procedure cursor (b:boolean);
var r:registers;
begin
  with r do begin
  ah:=$01;
  if not b then begin
  ch:=$20; cl:=$20
  end else begin
  ch:=5; cl:=7
  end
 end;
 intr ($10,r)
end;

function isopen (var ff):boolean;
  type fib=textrec;
  var fi:fib absolute ff;
begin
  isopen:=fi.handle<>0;
end;

procedure UNCRUNCH (var Addr1,Addr2; BlkLen:Integer);
begin
  inline (
    $1E/               {       PUSH    DS             ;Save data segment.}
    $C5/$B6/ADDR1/     {       LDS     SI,[BP+Addr1]  ;Source Address}
    $C4/$BE/ADDR2/     {       LES     DI,[BP+Addr2]  ;Destination Addr}
    $8B/$8E/BLKLEN/    {       MOV     CX,[BP+BlkLen] ;Length of block}
    $E3/$5B/           {       JCXZ    Done}
    $8B/$D7/           {       MOV     DX,DI          ;Save X coordinate for later.}
    $33/$C0/           {       XOR     AX,AX          ;Set Current attributes.}
    $FC/               {       CLD}
    $AC/               {LOOPA: LODSB                  ;Get next character.}
    $3C/$20/           {       CMP     AL,32          ;If a control character, jump.}
    $72/$05/           {       JC      ForeGround}
    $AB/               {       STOSW                  ;Save letter on screen.}
    $E2/$F8/           {Next:  LOOP    LOOPA}
    $EB/$4C/           {       JMP     Short Done}
                       {ForeGround:}
    $3C/$10/           {       CMP     AL,16          ;If less than 16, then change the}
    $73/$07/           {       JNC     BackGround     ;foreground color.  Otherwise jump.}
    $80/$E4/$F0/       {       AND     AH,0F0H        ;Strip off old foreground.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$F1/           {       JMP     Next}
                       {BackGround:}
    $3C/$18/           {       CMP     AL,24          ;If less than 24, then change the}
    $74/$13/           {       JZ      NextLine       ;background color.  If exactly 24,}
    $73/$19/           {       JNC     FlashBitToggle ;then jump down to next line.}
    $2C/$10/           {       SUB     AL,16          ;Otherwise jump to multiple output}
    $02/$C0/           {       ADD     AL,AL          ;routines.}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $02/$C0/           {       ADD     AL,AL}
    $80/$E4/$8F/       {       AND     AH,8FH         ;Strip off old background.}
    $0A/$E0/           {       OR      AH,AL}
    $EB/$DA/           {       JMP     Next}
                       {NextLine:}
    $81/$C2/$A0/$00/   {       ADD     DX,160         ;If equal to 24,}
    $8B/$FA/           {       MOV     DI,DX          ;then jump down to}
    $EB/$D2/           {       JMP     Next           ;the next line.}
                       {FlashBitToggle:}
    $3C/$1B/           {       CMP     AL,27          ;Does user want to toggle the blink}
    $72/$07/           {       JC      MultiOutput    ;attribute?}
    $75/$CC/           {       JNZ     Next}
    $80/$F4/$80/       {       XOR     AH,128         ;Done.}
    $EB/$C7/           {       JMP     Next}
                       {MultiOutput:}
    $3C/$19/           {       CMP     AL,25          ;Set Z flag if multi-space output.}
    $8B/$D9/           {       MOV     BX,CX          ;Save main counter.}
    $AC/               {       LODSB                  ;Get count of number of times}
    $8A/$C8/           {       MOV     CL,AL          ;to display character.}
    $B0/$20/           {       MOV     AL,32}
    $74/$02/           {       JZ      StartOutput    ;Jump here if displaying spaces.}
    $AC/               {       LODSB                  ;Otherwise get character to use.}
    $4B/               {       DEC     BX             ;Adjust main counter.}
                       {StartOutput:}
    $32/$ED/           {       XOR     CH,CH}
    $41/               {       INC     CX}
    $F3/$AB/           {       REP STOSW}
    $8B/$CB/           {       MOV     CX,BX}
    $49/               {       DEC     CX             ;Adjust main counter.}
    $E0/$AA/           {       LOOPNZ  LOOPA          ;Loop if anything else to do...}
    $1F);              {Done:  POP     DS             ;Restore data segment.}
end; {UNCRUNCH}

function devicename (name:string):boolean;
var f:file;
    n:integer absolute f;
    r:registers;
begin
  devicename:=false;
  assign (f,name);
  {$I-}reset (f);{$I+}
  if ioresult<>0 then exit;
  r.bx:=n;
  r.ax:=$4400;
  intr ($21,r);
  devicename:=(r.dx and 128)=128;
  close (f);
end;

function validfname (name:string):boolean;
  const invalid:set of char=[#0..#31,'"',']','[',':','\','>','<','/','?','*',
    '|','+','=',';', ',' ,#127..#255];
  var p,cnt:integer;
    c:char;
    dotfound:boolean;
begin
  validfname:=false;
  dotfound:=false;
  if (length(name)>12) or (length(name)<1) then exit;
  for p:=1 to length(name) do begin
    c:=upcase(name[p]);
    if c in invalid then exit;
    if c='.' then begin
      if dotfound then exit;
      dotfound:=true;
      if (p<length(name)-3) or (p=1) then exit;
    end;
  end;
  validfname:=not devicename (name);
end;

function digit (c:char):boolean;
begin
  digit:=ord (c) in [48..57];
end;

function validtime (inp:string):boolean;
  var c,s,l:integer;
      d1,d2,d3,d4:char;
      ap,m:char;
begin
  validtime:=false;
  l:=length(inp);
  if (l<7) or (l>8) then exit;
  c:=pos (':',inp);
  if c<>l-5 then exit;
  s:=pos (' ',inp);
  if s<>l-2 then exit;
  d2:=inp[c-1];
  if l=7 then d1:='0' else d1:=inp[1];
  d3:=inp[c+1];
  d4:=inp[c+2];
  ap:=upcase(inp[s+1]);
  m:=upcase(inp[s+2]);
  if d1='1' then if d2>'2' then d2:='!';
  if (d1>='0') and (d1<='1') and digit(d2) and (d3>='0') and (d3<='5') and digit(d4) and ((ap='A') or (ap='P')) and (m='M')
  then validtime:=true;
end;

function validdate (inp:string):boolean;
  var k,l:char;

    function gchar:char;
    begin
      if length (inp)=0 then begin
        gchar:='?';
        exit;
      end;
      gchar:=inp[1];
      delete (inp,1,1);
    end;

begin
  validdate:=false;
  k:=gchar;
  l:=gchar;
  if not digit(k) then exit;
  if l='/' then if k='0' then exit else else begin
    if k>'1' then exit;
    if not digit (l) then exit;
    if (l>'2') and (k='1') then exit;
    l:=gchar;
    if l<>'/' then exit;
  end;
  k:=gchar;
  l:=gchar;
  if l='/' then if k='0' then exit else else begin
    if k>'3' then exit;
    if not digit (l) then exit;
    if (k='3') and (l>'1') then exit;
    l:=gchar;
    if l<>'/' then exit;
  end;
  if digit (gchar) and digit (gchar) then validdate:=true;
end;

function ratio (l1,l2:longint):integer;
  var l3:integer;
      r1,r2,r3:real;
begin
  if l1<1 then l1:=1;
  if l2<1 then l2:=1;
  r1:=int (l1);
  r2:=int (l2);
  r3:=r1/r2;
  r3:=r3*100;
  l3:=trunc (r3);
  ratio:=l3;
end;

function exdrv(s:string):byte;
begin
  s:=fexpand(s);
  exdrv:=ord(s[1])-64;
end;

function freek (d:integer):longint;
var lng:longint;
begin
  lng:=diskfree (d);
  freek:=lng div 1024;
end;

function sizek (d:integer):longint;
var lng:longint;
begin
  lng:=disksize (d);
  sizek:=lng div 1024;
end;

(*procedure copyfile1 (var ok,nospace:boolean; srcname,destname:string);
var buffer:array[1..16384] of byte;
    fs,dfs:longint;
    nrec,i:integer;
    src,dest:file;

  procedure dodate;
  var r:registers;
      od,ot,ha:integer;
  begin
    srcname:=srcname+#0;
    destname:=destname+#0;
    with r do begin
      ax:=$3d00; ds:=seg(srcname[1]); dx:=ofs(srcname[1]); msdos(dos.registers(r));
      ha:=ax; bx:=ha; ax:=$5700; msdos(dos.registers(r));
      od:=dx; ot:=cx; bx:=ha; ax:=$3e00; msdos(dos.registers(r));
      ax:=$3d02; ds:=seg(destname[1]); dx:=ofs(destname[1]); msdos(dos.registers(r));
      ha:=ax; bx:=ha; ax:=$5701; cx:=ot; dx:=od; msdos(dos.registers(r));
      ax:=$3e00; bx:=ha; msdos(dos.registers(r));
    end;
  end;

begin
  ok:=TRUE; nospace:=FALSE;
  assign(src,srcname);
  {$I-} reset(src,1); {$I+}
  if (ioresult<>0) then begin ok:=FALSE; exit; end;
  dfs:=freek(exdrv(destname));
  fs:=trunc(filesize(src)/1024.0)+1;
  if (fs>=dfs) then begin
    close(src);
    nospace:=TRUE; ok:=FALSE;
    exit;
  end else begin
    assign(dest,destname);
    {$I-} rewrite(dest,1); {$I+}
    if (ioresult<>0) then begin ok:=FALSE; exit; end;
    repeat
      blockread(src,buffer,16384,nrec);
      blockwrite(dest,buffer,nrec);
    until (nrec<16384);
    close(dest); close(src);
    dodate;
  end;
end;

function substall(src,old,new:string):string;
var p:integer;
begin
  p:=1;
  while p>0 do begin
    p:=pos(old,src);
    if p>0 then begin
      insert(new,src,p+length(old));
      delete(src,p,length(old));
    end;
  end;
  substall:=src;
end;

procedure movline(var src:string; s1,s2:string);
begin
  src:=substall(src,'@F',s1);
  src:=substall(src,'@I',s2);
end;

procedure copyfile (srcname,destpath:string);
var ps,ns,es:string;
    ok,nospace:boolean;
begin
  ok:=TRUE; nospace:=FALSE;
  fsplit(srcname,ps,ns,es);
  copyfile1(ok,nospace,srcname,destpath+ns+es);
  if (not ok) then if (nospace) then writeln ('Copy failed: Insufficient space!!'^G)
  else writeln ('Copy failed!!'^G);
end;

procedure movefile1 (var ok,nospace:boolean; srcname,destname:string);
var dfs,dft:integer;
    f:file;
    s,s1,s2,s3,opath:string;
begin
  ok:=TRUE; nospace:=FALSE;

  getdir(0,opath);
  assign(f,srcname); reset(f,1);
  dft:=trunc(filesize(f)/1024.0)+1; close(f);

  dfs:=freek(exdrv(destname));
  copyfile1(ok,nospace,srcname,destname);
  if ((ok) and (not nospace)) then begin
    {$I-} erase(f); {$I+}
  end;
  chdir(opath);
end;

procedure movefile (srcname,destpath:string);
var ps,ns,es:string;
    ok,nospace:boolean;
begin
  ok:=TRUE; nospace:=FALSE;
  fsplit(srcname,ps,ns,es);
  movefile1(ok,nospace,srcname,destpath+ns+es);
  if (not ok) then if (nospace) then writeln ('Move failed: Insufficient space!!'^G)
  else writeln ('Move failed!!'^G);
end;*)

begin
end.
