{$I+,S+}
unit records;

interface

uses crt,dos,strunit,keyttt5;

{ CONST                                                          }
{   BackSp  = #8;       PgUp  = #201;      CtrlPgUp = #138;      }
{   Tab     = #9;       PgDn  = #209;      CtrlPgDn = #246;      }
{   Enter   = #13;      Endkey= #207;      CtrlEnd  = #245;      }
{   Esc     = #27;      Home  = #199;      CtrlHome = #247;      }
{   STab    = #143;     Ins   = #210;      Del      = #211;      }
{   LArr    = #203;     CtrlLArr    = #243;    CtrlPrtsc = #242; }
{   RArr    = #205;     CtrlRArr    = #244;                      }
{   UArr    = #200;                                              }
{   DArr    = #208;                                              }
{   CtrlA  = #1;          AltA  = #158;        Alt1 = #248;      }
{   CtrlB  = #2;          AltB  = #176;        Alt2 = #249;      }
{   CtrlC  = #3;          AltC  = #174;        Alt3 = #250;      }
{   CtrlD  = #4;          AltD  = #160;        Alt4 = #251;      }
{   CtrlE  = #5;          AltE  = #146;        Alt5 = #252;      }
{   CtrlF  = #6;          AltF  = #161;        Alt6 = #253;      }
{   CtrlG  = #7;          AltG  = #162;        Alt7 = #254;      }
{   CtrlH  = #8;          AltH  = #163;        Alt8 = #255;      }
{   CtrlI  = #9;          AltI  = #151;        Alt9 = #134;      }
{   CtrlJ  = #10;         AltJ  = #164;        Alt0 = #135;      }
{   CtrlK  = #11;         AltK  = #165;        Altminus  = #136; }
{   CtrlL  = #12;         AltL  = #166;        Altequals = #137; }
{   CtrlM  = #13;         AltM  = #178;                          }
{   CtrlN  = #14;         AltN  = #177;                          }
{   CtrlO  = #15;         AltO  = #152;                          }
{   CtrlP  = #16;         AltP  = #153;                          }
{   CtrlQ  = #17;         AltQ  = #144;                          }
{   CtrlR  = #18;         AltR  = #147;                          }
{   CtrlS  = #19;         AltS  = #159;                          }
{   CtrlT  = #20;         AltT  = #148;                          }
{   CtrlU  = #21;         AltU  = #150;                          }
{   CtrlV  = #22;         AltV  = #175;                          }
{   CtrlW  = #23;         AltW  = #145;                          }
{   CtrlX  = #24;         AltX  = #173;                          }
{   CtrlY  = #25;         AltY  = #149;                          }
{   CtrlZ  = #26;         AltZ  = #172;                          }
{   F1  = #187;              sF1  = #212;                        }
{   F2  = #188;              sF2  = #213;                        }
{   F3  = #189;              sF3  = #214;                        }
{   F4  = #190;              sF4  = #215;                        }
{   F5  = #191;              sF5  = #216;                        }
{   F6  = #192;              sF6  = #217;                        }
{   F7  = #193;              sF7  = #218;                        }
{   F8  = #194;              sF8  = #219;                        }
{   F9  = #195;              sF9  = #220;                        }
{   F10 = #196;              sF10 = #221;                        }
{   F11 = #139;              sF11 = #141;                        }
{   F12 = #140;              sF12 = #142;                        }
{   CtrlF1  = #222;          AltF1  = #232;                      }
{   CtrlF2  = #223;          AltF2  = #233;                      }
{   CtrlF3  = #224;          AltF3  = #234;                      }
{   CtrlF4  = #225;          AltF4  = #235;                      }
{   CtrlF5  = #226;          AltF5  = #236;                      }
{   CtrlF6  = #227;          AltF6  = #237;                      }
{   CtrlF7  = #228;          AltF7  = #238;                      }
{   CtrlF8  = #229;          AltF8  = #239;                      }
{   CtrlF9  = #230;          AltF9  = #240;                      }
{   CtrlF10 = #231;          AltF10 = #241;                      }
{   CtrlF11 = #154;          AltF11 = #156;                      }
{   CtrlF12 = #155;          AltF12 = #157;                      }
{   MUp     = #128;                                              }
{   MDown   = #129;                                              }
{   MLeft   = #130;                                              }
{   MRight  = #131;                                              }
{   MLeftB  = #133;                                              }
{   MEnter  = #133;                                              }
{   MEsc    = #132;                                              }
{   MRightB = #132;                                              }

const bbsname='Infinity';
      qwkname='InfMail';
      filename='INFINITY';
      bbsver='1.0n';
      qwkver='1.0';
      author='Keith Brown';
      copydate='1993';
      date='03/01/92';
      expdate='12/31/99';
      maxlines=200;
      maxconf=20;
      maxnode=8;
      maxnuvotes=255;
      {maxvotes=20;
      maxchoices=10;}
      maxbatch=50;
      maxnuvcom=10;
      {numstrings=79;}
      maxmbases=50;
      maxtbases=50;
      maxinterview=20;
      maxprompt=255;
      maxlevel=100;
      nodeaction:array [0..8] of string[30]=('Unknown node','Node down','Waiting for Call',
      'Transferring a file','Available','Posting message','Multi-node chat','Applying for access',
      'At login shell');

type filelisttype=array [1..9] of boolean;{(fname,fext,fcost,fsize,fdesc,fgroup,fdown,fuploader,fuploaded);}
     conference=array [1..maxconf] of boolean;
     lastrd=array [1..maxmbases] of integer;

     longstr=string[80];
     medstr=string[30];
     smstr=string[15];
     datistr=string[8];

     { Configurable prompt- 2 line (longstr) }

     userrec=record
       handle,realname,occup,bbsref,note:string[30];
       password:string[20];
       phone:string[12];
       bday,firston,lastondate:string[8];
       sex:char;
       {fprompt,}paid,showol,pause:boolean;
       uploadk,downloadk,posts,ups,dkperday,kleft,baudrate:longint;
       bankt,bankc,bankl:word;
       numon,numpost,numup,numdn,fpoint,minpc,minud,time,dailytime,
       mlevel,msglevel,xflevel:integer;
       emulation,displaylen,curmonth,nummonth,pwlogon,cprompt,voteyes,voteno:byte;
       color:array [1..8] of byte;
       {1-Non-Highlight}
       {2-Regular}
       {3-Prompt/Punct}
       {4-Status}
       {5-Window Border}
       {6-"" Regular}
       {7-"" Status}
       {8-"" Highlight}
       msgconf,xferconf:conference;
       lastread:array [0..maxconf] of lastrd;
       filelist:filelisttype;
       curprompt1,curprompt2:longstr;
       maddress:array [1..2] of medstr;
       intvw:array [1..maxinterview] of boolean;
     end;

     nuvrec=record
       handle:medstr;
       usernum:integer;
       uservote:array [1..maxnuvotes] of integer;
       votedyes:array [1..maxnuvotes] of boolean;
       comment:array [1..maxnuvcom] of string[47];
       bycomment:array [1..maxnuvcom] of medstr;
     end;

     noderec=record
       useron:medstr;
       action:byte;
     end;

     nodechatrec=record
       useron:medstr;
       chat:longstr;
       showed:array [1..maxnode] of boolean;
     end;

     confrec=record
       name:string[30];
       qv:boolean;
     end;

     idxrec=record
       handle:string[30];
     end;

     bbslistrec=record
       bbsname,desc,author:string[30];
       software:string[8];
       phonenum:string[12];
       minbaud,maxbaud:longint;
     end;

     arearec=record
       xferdir:string[70];
       name,asysop:string[30];
       level,up,down:byte;
     end;

     msgarearec=record
       name,asysop:string[30];
       level,postlevel:byte;
       maxpost:integer;
     end;

     msgidx=record
       active:boolean;
     end;

     msgrec=record
       text:array [1..maxlines] of {^}longstr;
       subject,poster,receiver,unote:string[30];
       date,time:string[8];
       anon,read,priv:boolean;
       numlines:integer;
     end;

     intvwidx=record
       active:boolean;
       usernum:integer;
     end;

     filerec=record
       filename,group,pass:string[15];
       descrip,uploader,prvfile:string[30];
       path:string[70];
       dateup:string[8];
       ask,new:boolean;
       cost,numdown:integer;
       filesize:longint;
     end;

     {batchrec=record
       filename,group,pass:string[15];
       descrip,prvfile:string[30];
     end;}

     lastcallrec=record
       name:string[30];
       speed,date,time:string[8];
       callnum:longint;
     end;

     menurec=record
       comm:string[30];
       desc:string[25];
       key:{string[15]}char;
       tlevel,level:integer;
     end;

     onelinerrec=record
       from:string[30];
       oliner:string[80];
     end;

     protocolrec=record
       exec:string[12];
       desc,dcline,ucline:string[30];
       key:char;
     end;

     setuprec=record
       defcolor:array [1..8] of byte;
       com,newmlevel,newmsglevel,newxflevel,comlevel,comsglevel,coxflevel,
       sysmlevel,sysmsglevel,sysxflevel,logonlevel,nodenum,netnodenum,
       minpc,minud,shelltype,mode,statusbarcolor,vmlevel,vmsglevel,vxflevel,
       networktype,subscripmonth:byte;
       newxfpoint,vxfpoint,pointvalue,uploadfactor,maxt,maxc,maxl,numscreen,
       timeout,screensavetime,maxlc,systime:integer;
       inbuf,outbuf,newtime,vtime:word;
       initstring,sysname,syspass,newuserpass,lockoutpass,shellprompt,
       bankname,newnote,vnote,menuname:string[30];
       helpcomm,logincomm,applycomm,verifycomm,chatcomm,hangupcomm,
       eventtime,nettimestart,nettimeend:string[8];
       bbsdir,datadir,xferdir,msgdir,textdir,menudir,nodedir,networkdir,logdir,
       chatava,chatnotava,chatgreet,chatgoodbye,shelltodos,ansieditor,texteditor,
       event,newuserevent,loginevent,uploadevent,zipcomment,bbsad:string[70];
       sysphone,netnumber:string[12];
       {lockbaud,}private,host,netmsg,netmail,netnews,offhook,hang,
       returntime,internalmenus,ems,allowloan,fatmove,freefiles:boolean;
       hidch:char;
       subamt:real;
       dkperday,baud,minbaud,mindlbaud:longint;
       pwlogon{,irq},nuvintvw,yesvote,novote,minnuv:byte;
       autonuv,usenuv:boolean;
     end;

     statrec=record
       callstoday,newcallers,newup,newpost,newuser,uptoday,posttoday,
       dntoday:integer;
       numcallers,numpost,numup,numdn,posts,ups,numdays:longint;
       lastdayup,timedeventdate:string[8];
       bbsver:string[4];
       logo:boolean;
       {sysopavail:boolean;}
     end;

     timerrec=record
       started:boolean;
       startedat:integer;
       total:integer;
     end;

     registerrec=record
       serial:longint;
       sysop:string[30];
       maxusers:integer;
     end;

     stringrec=record
       str:string[80];
     end;

     blacklistrec=record
       name:string[30];
     end;

     interviewrec=record
       name:medstr;
       req:boolean;
       min,max:byte;
     end;

     {votingrec=record
       topic:string[80];
       level,addlevel,numvoted:integer;
       add,mandatory:boolean;
       choice:array [1..maxchoices] of string[30];
       choicevote:array [1..maxchoices] of integer;
     end;}

     promptrec=record
       name:medstr;
       prmpt1,prmpt2:longstr;
     end;

var connectbaud,baudrate:longint;
    {curcolor:byte;}
    {direct:text;}
    logf,msgf,intvwf,runerrlog:text;
    iidx:intvwidx;
    iidxf:file of intvwidx;
    midxf:file of msgidx;
    setup:setuprec;
    setupf:file of setuprec;
    user:userrec;
    userf:file of userrec;
    idx:idxrec;
    idxf:file of idxrec;
    bbs:bbslistrec;
    bbsf:file of bbslistrec;
    bl:blacklistrec;
    blf:file of blacklistrec;
    last:lastcallrec;
    lastf:file of lastcallrec;
    conf:confrec;
    conff:file of confrec;
    area:arearec;
    areaf:file of arearec;
    xfer:filerec;
    xferf:file of filerec;
    marea:msgarearec;
    msgareaf:file of msgarearec;
    node:noderec;
    nodef:file of noderec;
    cnode:nodechatrec;
    cnodef:file of nodechatrec;
    ol:onelinerrec;
    olf:file of onelinerrec;
    nuv:nuvrec;
    nuvf:file of nuvrec;
    {post:message;
    postf:file of message;}
    {auto:message;
    autof:file of message;}
    stat:statrec;
    statf:file of statrec;
    prmpt:promptrec;
    promptf:file of promptrec;
    intervwf:file of interviewrec;
    intervw:interviewrec;
    {votef:file of votingrec;
    vote:votingrec;}
    usernum,inlen,lasty,logontime,curconf,maxusers,curmsgarea,curarea,numbatch:integer;
    stati,linenum:byte;
    local,desqview,hidchar,splitmode,registered,inlock,outlock,sneak,autologin:boolean;
    curconfname:string[80];
    input,curmareaname,curareaname:string[80];
    lastprmpt:string;
    serialnum:longint;
    sysopname:string[30];
    laston:string[8];
    batch:array [1..maxbatch] of filerec;
    {strngs:array [1..numstrings] of longstr;}

procedure readsetup;
procedure writesetup;
procedure readstatus;
procedure writestatus;
function elapsedtime (var t:timerrec):integer;
procedure settimeleft (tl:integer);
procedure starttimer (var t:timerrec);
procedure stoptimer (var t:timerrec);
function timeleft:integer;
function timeontoday:integer;
function timer:integer;
function valtime (s:string):integer;
function timeevent:integer;
function sysopavail:boolean;
function udp:integer;
function pcp:integer;

implementation

procedure loadsetup (b:boolean);
begin
  assign (setupf,'SETUP.DAT');
  {$I-}reset (setupf);{$I+}
  if (ioresult<>0) then if b then begin
    clrscr;
    writeln ('The setup file does not exist.  Please run SETUP.EXE.');
    halt (0);
  end else {$I-}rewrite (setupf);{$I+}
  seek (setupf,0);
end;

procedure readsetup;
begin
  loadsetup (true);
  read (setupf,setup);
  close (setupf);
end;

procedure writesetup;
begin
  loadsetup (false);
  write (setupf,setup);
  close (setupf);
end;

procedure readstatus;
begin
  assign (statf,setup.datadir+'STATUS.DAT');
  {$I-}reset (statf);{$I+}
  if ioresult<>0 then begin
    fillchar (stat,sizeof (stat),0);
    stat.lastdayup:=curdate;
    {stat.sysopavail:=false;}
    {$I-}rewrite (statf);{$I+}
    write (statf,stat);
    exit;
  end;
  read (statf,stat);
  close (statf);
end;

procedure writestatus;
begin
  assign (statf,setup.datadir+'STATUS.DAT');
  {$I-}rewrite (statf);{$I+}
  write (statf,stat);
  close (statf);
end;

function elapsedtime (var t:timerrec):integer;
var i:integer;
begin
  if not t.started then begin
    elapsedtime:=0;
    t.startedat:=timer;
    exit;
  end;
  i:=timer-t.startedat;
  if i<0 then i:=i+1440;
  elapsedtime:=i;
end;

procedure settimeleft (tl:integer);
begin
  user.time:=timer+tl-logontime;
end;

procedure starttimer (var t:timerrec);
begin
  if t.started then exit;
  t.startedat:=timer;
  t.started:=true;
end;

procedure stoptimer (var t:timerrec);
begin
  if not t.started then begin
    t.startedat:=0;
    exit;
  end;
  t.startedat:=elapsedtime (t);
  t.total:=t.total+t.startedat;
  t.started:=false;
end;

function timeleft;
  var t,timeon:integer;
begin
  timeon:=timer-logontime;
  if timeon<0 then timeon:=timeon+1440;
  if timer<timeon then timeon:=timeon-1440;
  t:=user.time-timeon;
  if (t>999) or (t<1) then t:=0;
  timeleft:=t;
end;

function timeontoday;
  var timeon:integer;
begin
  timeon:=timer-logontime;
  if timeon<0 then timeon:=timeon+1440;
  timeontoday:=timeon;
end;

function timer;
  var r:registers;
begin
  r.ax:=$2c00;
  intr ($21,r);
  timer:=(r.cx shr 8)*60+(r.cx and 255);
end;

function valtime (s:string):integer;
  var h,i,m:integer;
      b:boolean;
      c:string[1];
begin
  h:=valu (copy (s,1,2));
  m:=valu (copy (s,4,2));
  c:=copy (s,length (s)-1,1);
  if h in [1..11] then begin
    if c='P' then h:=h+12;
  end else if c='P' then h:=12 else h:=0;
  valtime:=(h*60)+m;
end;

function timeevent;
  var i:integer;
begin
  if length (setup.event)=0 then i:=1440 else
  i:=valtime (setup.eventtime){-valtime (curtime)}-timer;
  if i<0 then i:=i+1440;
  timeevent:=i;
end;

function sysopavail;
begin
  sysopavail:=scrollon;
end;

function udp:integer;
begin
  udp:=ratio (user.numup,user.numdn);
end;

function pcp:integer;
begin
  pcp:=ratio (user.numpost,user.numon);
end;

begin
end.