unit modem;

interface

uses crt,dos,records,apmisc,apport,apuart,oocom;

function KbdAbort : Boolean;
procedure openport (com:byte; baud,inbuf,outbuf:word);
procedure closeport;
procedure setparam (com:byte; baud:longint; parity:boolean);
procedure hangup;
function carrier:boolean;
procedure sendchar (c:char);
procedure sendstring (s:string);
function getchar:char;
function numchars:integer;
{function charread:boolean;}
procedure deactivateport (b:boolean);
procedure activateport (b:boolean);
procedure setdtr (b:boolean);

var uart:uartport;
    comport:comnametype;

implementation

function KbdAbort : Boolean;
  {-Default abort function}
  const Escape = #$1B;
  var Ch : Char;
begin
  KbdAbort := False;
  if KeyPressed then begin
    Ch := ReadKey;
    if Ch = #0 then
      Ch := ReadKey;
    if Ch = Escape then
      KbdAbort := True;
  end;
end;

procedure openport (com:byte; baud,inbuf,outbuf:word);
begin
  comport:=comnametype (com-1);
  uart.initcustom (comport,baud,NoParity,8,1,inbuf,outbuf, DefPortOptions);
  if AsyncStatus <> ecOk then begin
    WriteLn('Failed to open port: ', AsyncStatus);
    Halt (255);
  end;
  if ClassifyUart(uart.GetBaseAddr, False) = U16550A then SetFifoBuffering(uart.GetBaseAddr, True, 4);
  uart.setabortfunc (kbdabort);
end;

procedure closeport;
begin
  uart.done;
end;

procedure setparam (com:byte; baud:longint; parity:boolean);
begin
  uart.setline (baud,noparity,8,1);
end;

procedure hangup;
begin
  uart.setdtr (false);
  if not carrier then uart.setdtr (true);
end;

function carrier;
  var dtr,rts:boolean;
begin
  carrier:=uart.checkdcd;
end;

procedure sendchar (c:char);
begin
  if carrier then delay (3);
  uart.putchar (c);
end;

procedure sendstring (s:string);
  var i:integer;
begin
  for i:=1 to length (s) do sendchar (s[i]);
end;

function getchar:char;
  var c:char;
begin
  uart.getchar (c);
  getchar:=c;
end;

function numchars:integer;
begin
  numchars:=uart.inbuffused;
end;

{function charread:boolean;
begin
  charread:=uart.charready;
end;}

procedure deactivateport (b:boolean);
begin
  {uart.deactivateport (b);}
  uart.ptoptionsoff (ptDropModemOnClose + ptRestoreOnClose);
  closeport;
end;

procedure activateport (b:boolean);
begin
  {uart.activateport (b);}
  openport (setup.com,baudrate,setup.inbuf,setup.outbuf);
end;

procedure setdtr (b:boolean);
begin
  uart.setdtr (b);
end;

begin
end.