(*****************************************************************************)
(*>                                                                         <*)
(*>  MENUS4  .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  Menu command execution routines.                                       <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,G+,I+,L+,N-,O+,R-,S+,V-}
unit menus4;

interface

uses
  crt, dos, overlay,  misc2,
  common;

procedure autovalidationcmd(pw:astr);
procedure addarumor;
procedure deleterumor;
procedure showrumor;
procedure Jamming_Game;
procedure edit_conference;
procedure change_conference;
(* procedure TPGisdown;  *)

implementation

procedure edit_conference; (* [c]<harldy> 1992 chuck, let's hope it works *)

var
 tmpfile: file of confrec;
 i,ii:integer;
 s,s1,s2:string;
 c,ch1,ch2:char;


begin
 sysoplog ('* Entered conference editor. ');
 repeat;
  lsdbox ('Innovation Conference System Editor [c]1994 Chuck');
  sprint (#3#0+' Conf. '#3#4+''+#3#0+'Required ACS  '+#3#4+''+#3#0+' Name');
  sprint (#3#4+' ');
  i:=-1;
  repeat
   inc(i);
   seek (conffile, i);
   read (conffile, conf);
   if i=0 then sprompt (#3#8+'*') else sprompt (' ');
   sprompt('  '+#3#3+conf.c+'   '+#3#4+' '+#3#3);
   s:=mln(conf.acs,13);
   sprompt (s+#3#4+' '+#3#3);
   sprint(conf.discription);
  until eof(conffile);
  sprint (#3#4+' ');
  sprint (#3#8+'*'+#3#1+ ' : Everyone will have access to this conference when they first log on.');
  nl;
  sprint (#3#5+'conference "A" is the ALL conference, meaning anyone in that conference');
  sprint (#3#5+'is treated as if they were in ALL the conferences.');
  nl; sprompt (#3#9+'[M]odify conference [A]dd conference [D]elete conference [Q]uit : '+#3#4);
  onek (ch1,'MADQ'^M); nl;
  case ch1 of
   'M': begin
         sprompt (#3#9+'Enter the letter of the conference to modify, or ENTER to quit : ');
         getkey(ch2); ch2:=upcase(ch2); sprint (#3#0+ch2);
         if ch2 <> ^M then begin
          i:=-1;
          repeat
           inc(i); seek (conffile,i); read(conffile,conf);
          until (conf.c=ch2) or eof(conffile);

          if (conf.c = ch2) then begin
           sysoplog ('[> Changed conference '+conf.discription+#3#3+' ['+conf.c+']');
           lsdbox ('Modify Cconference Menu');
           sprint (#3#0+'Status of this conference: '); nl;
           sprint (#3#3+'Conference Symbol : '+#3#5+conf.c);
           sprint (#3#3+'Conference Acs.   : '+#3#5+conf.acs);
           sprint (#3#3+'Conference Disc.  : '+#3#5+conf.discription);
           nl;
           if pynq ('Change conference symbol?') then begin
            sprompt ('Enter new symbol: ');
            getkey (ch2); ch2:=upcase(ch2); sprint (#3#1+ch2);
            conf.c:=ch2;
           end;
            if pynq ('Change conference access?') then begin
            sprint ('Enter new acs required:');
            input(s1,19);
            conf.acs:=s1;
           end;
           if pynq ('Change conference discription?') then begin
            sprint ('Enter new discription:');
            inputwc (s2,79);
            conf.discription:=s2;
           end;

           seek (conffile,i);
           write (conffile, conf);
           sprint ('Your changes have been made.');
          end else sprint ('Not found - no such conference exists.');
          pausescr;
         end;
        end;
   'A': begin
         nl; if pynq ('Are you sure you wish to add a conference?') then begin
          repeat;
           sprompt ('Enter the conference symbol/letter: ');
           (* make it check for duplicates !!!!!!! when you
              get a chance.. no big deal i guess *)
           getkey(ch2);
           ch2:=upcase(ch2);
           sprint (#3#0+ch2);
          until ch2 <> ^M;
          sprint ('Enter acs required for this conference: ');
          input(s1,19);
          sprint ('Enter the conference name: ');
          inputwc (s2,79);
          begin
           i:=-1; repeat inc(i); seek(conffile,i); until eof(conffile);
           ch2:=upcase(ch2); conf.c:=ch2; conf.acs:=s1; conf.discription:=s2;
           write (conffile, conf);
           sysoplog ('[> Added conference '+conf.discription+#3#3+' ['+conf.c+']');
           sprint ('Done. Conference Added.'); pausescr;
          end;
         end;
        end;
   'D': begin
         nl; sprompt ('Conference to delete: ');
         getkey (c); c:=upcase(c); sprint (#3#0+c);
         if (c<>^M)  then begin
          i:=-1;
          repeat
           inc(i); seek (conffile,i); read(conffile,conf);
          until (conf.c=c) or eof(conffile);
          if (conf.c=c) then begin
           nl; sprint (conf.discription+#3#3+' :');
           if pynq ('Delete this conference?') then begin
            sysoplog ('[> Killed conference '+conf.discription+#3#3+' ['+conf.c+']');
            nl; sprompt ('Deleting '+#3#3+conf.c+#3#1+'.');
            assign (tmpfile,systat.gfilepath+ 'CONPTMP.$!$');
            rewrite (tmpfile);
            i:=-1; ii:=-1;
            repeat
             inc(i); seek (conffile,i); read(conffile,conf); sprompt ('.');
             inc(ii); seek (tmpfile,ii); if (conf.c <> c) then write (tmpfile, conf) else
              begin
               dec(ii); sprompt ('.Done..');
              end;
             until eof(conffile);
            sprompt (' Saving.');
            close(conffile); erase (conffile);
            close (tmpfile); rename(tmpfile,systat.gfilepath+'CONF.DAT'); reset(conffile);
            sprint (' conference deleted.'); pausescr;
            end else begin sprint ('Nothing done.'); pausescr; end;
          end else begin sprint (#3#7+'Conference not found!!!'); pauseSCR;end;
         end else begin sprint ('Nothing done.'); pauseSCR; end;
        end;
       end;
 until ch1='Q';
end;

procedure change_conference;
var
 i,ii:integer;
 ch1:char;

begin
 sysoplog ('* Entered conference change menu. ');
 cls; lsdbox ('Innovation BBS Conference System [c]1992 Chuck');
 ii:=-1;
 repeat
  inc(ii); seek (conffile,ii); read(conffile,conf);
 until (conference=conf.c) or eof(conffile);
 sprint (#3#5+'You are curently in '+#3#9+conf.discription+#3#5+'.');
 nl;
 sprint (#3#0+' Conf. '#3#4+''+#3#0+' Name');
 sprint (#3#4+' ');
 i:=-1;
 repeat
  inc(i);
  seek (conffile, i);
  read (conffile, conf);
  if (aacs(conf.acs)) then begin
   if i=ii then sprompt (#3#8+'*') else sprompt (' ');
   sprompt('  '+#3#3+conf.c+'   '+#3#4+' ');
   sprint(#3#3+conf.discription);
  end;
  until eof(conffile);
  sprint (#3#4+' ');
  sprint (#3#8+'*'+#3#1+ ' : You are in this conference.');
  nl;
  sprompt (#3#0+'Enter new conference symbol to change to, or enter to quit: '+#3#9);
  getkey(ch1); ch1:=upcase(ch1); sprint (ch1);
  if (ch1<>^M) then begin
   ii:=-1;
   repeat
    inc(ii); seek (conffile,ii); read(conffile,conf);
   until (ch1=conf.c) or eof(conffile);
   if ( (ch1=conf.c) and (aacs(conf.acs)) ) then begin
     nl; sprint (#3#3+conf.c+#3#0+' : '+#3#3+conf.discription);
     begin
      conference:=ch1; nl; sprint (#3#7+'Changed to '+conf.discription);
      sysoplog ('[> Changed to conference '+conf.discription+#3#3+' ['+conf.c+']');
     end;
   end else sprint ('No such conference!');
   pauseSCR;
  end;
 end;

procedure JAMMING_Game;
 begin end;

procedure addarumor;
{ AO }
var
 newrumor:string[80];
 curon:integer;
begin
 curon:=0;
 lsdbox ('Rumor Entry');
 sprint (#3#1+'[Hit ENTER to abort]');
 sprint (#3#5+'Enter your rumor below. CTRL-P or Pipe color commands can be used.');
 inputWC (newrumor,80);
 if (newrumor <> '') then begin
    nl; sprint (newrumor);
    if pynq ('Is this what you want?') then begin
        nl; prompt('Wait:');
        with rumorz do begin
         oneline:=newrumor;
         name:=thisuser.name;
         repeat
          inc(curon); seek (rumorfile,curon);
         until eof(rumorfile);
         write (rumorfile,rumorz);
        end;
        sysoplog ('* Added this rumor:');
        sysoplog (newrumor);
        close (rumorfile); reset (rumorfile);
        sprint (^H^H^H^H^H+#3#9+'Your rumor has been added.');
        nl;
    end; (*end of "ok?" *)
 end; (*end of main*)
end;

procedure deleterumor;  (* [c]1992 biig niggier productions *)
{ CmdKeys: AD }
var
 tmpfile: file of onelinerec;
 thisrumorA,tmps2,tempshit,thisrumor,S:string;
 C:char;
 maxrumor, tmp1,tmp2,rumor,i:integer;

begin
 sysoplog ('[> Sysop''s rumor editor/deltor entered. ');
 tmps2:=''; tempshit:='';  rumor:=0; maxrumor:=0;
  repeat;
  maxrumor:= filesize(rumorfile);
  seek (rumorfile,rumor);
  Read (rumorfile,rumorZ);
  thisrumor:=rumorZ.oneline;
  thisrumorA:=rumorz.name;
  lsdbox ('Innovation Rumor Editor [c]1993 Eggs the Cat');
  STR (rumor+1,tempshit);
  STR (maxrumor,tmps2);
  sprint ('|07Number: |15'+tempshit+'/'+tmps2+'|07, By: |15'+thisrumorA);
  nl;
  sprint (#3#1+thisrumor);
  nl;
  sprint ('|07[|15D|07]|03elete Rumor        |07[|15E|07]|03dit Rumor');
  sprint ('|07[|15G|07]|03oto Rumor          |07[|15S|07]|03earch for Rumor');
  sprint ('|07[|15-|07]|03Back 1 Rumor       |07[|15M|07]|03ove Rumor');
  sprint ('|07[|15+|07]|03Up 1 Rumor         |07[|15Q|07]|03uit Editor');
  nl; sprompt('|08:|07 ');
  onek(c,'DESQM-+G');
  case C of
   'M': begin; sprint('MoveRm: Not Done Yet!'); pauseSCR; end;
   'S': begin; sprint('Search: Not Done Yet!'); pauseSCR; end;
   'D': begin;
         if pynq('Do you REALLY wanna kill this rumor?') then begin
         assign (tmpfile,systat.gfilepath+ 'PENITMP.$!$');
         rewrite (tmpfile);
         tmp1:=-1; tmp2:=-1;
         repeat
          inc(tmp1); seek (rumorfile,tmp1); read(rumorfile,rumorZ);
          if (tmp1<>rumor) then begin
           inc(tmp2); seek (tmpfile,tmp2); write (tmpfile, rumorZ);
          end;
         until eof(rumorfile);
         close(rumorfile); erase (rumorfile);
         close (tmpfile); rename(tmpfile,systat.gfilepath+'ONELINE.DAT');
         reset(rumorfile);
         sysoplog ('[> Killed rumor:');
         sysoplog (thisrumor);
         sysoplog ('|07     ...by: '+thisrumorA);
         if (rumor+1=maxrumor) then dec(rumor,1);
         end;
        end;
   '-': if (rumor <> 0) then dec(rumor);
   '+': if (rumor <> maxrumor-1) then inc(rumor);
   'G': begin;
         str(maxrumor,s);
         nl; sprompt ('Number of rumor to goto (1-'+s+') :');
         input (s,5); i:=value(s); dec(i);
         if s='' then i:=rumor; (*if he hit enter*)
         if (i > -1) and (i < maxrumor) then rumor:=i
           else begin
            sprint ('|12Number is out of range!');
            pausescr;
           end;
        end;

   'E': begin;
         if pynq ('Do you want to change the rumor itself?') then begin
          sprint (#3#0+'New Rumor:'+#3#1); inputWC (s,80); if s<>'' then begin
            rumorz.oneline:=s; seek(rumorfile,rumor);write (rumorfile, rumorz);
          end;
         end;
         if pynq ('Do you want to change the rumor author?') then begin
          sprint (#3#0+'New Author:'+#3#1);input (s,36); if s<>'' then begin
           rumorz.name:=s; seek(rumorfile,rumor); write (rumorfile,rumorz);
          end;
         end;
        end;
  else end;
 until (c = 'Q') or(hangup);
 close (rumorfile);
 reset (rumorfile);
end;

procedure showrumor;
{ AS }
var willyou: boolean;
    totalrumors, curon:integer;
    abort,next:boolean;
    totstr:string;

begin
willyou:=false;

if (bbsinfoZ.seeauthors=TRUE) then
begin;
 if pynq ('Include authors of rumors?') then willyou:=true;
end
else
if (bbsinfoZ.seeauthors=FALSE) and (thisuser.sl=255) then
begin
 if pynq ('Include authors of rumors?') then willyou:=true;
end;

      with rumorz do
       begin
       abort:=FALSE; next:=FALSE;
        lsdbox ('Complete Rumor Listing');
        curon:=0;
         repeat
           seek (rumorfile, curon);
           Read (rumorfile,rumorz);
           printacr(oneline,abort,next);
           if willyou=true then printACR (#3#7+'                      By: '+name,abort,next);
           inc(curon);
         until (EOF (rumorfile)) or (hangup);
        sysoplog ('[> Listed all rumors. ');
        nl;
       totalrumors := filesize(rumorfile);
       str(totalrumors,totstr);
       sprint ('|03');
       sprint ('|11'+totSTR+' rumor(s) total.');
       end;
       pausescr;
end;

procedure autovalidationcmd(pw:astr);
var s:astr;
    ok:boolean;
begin
  nl;
  if (pw='') then begin
    sysoplog('[> Auto-Validation command executed - No PW specified!  Nothing done.');
    print('Sorry; this function is not available at this time.');
    exit;
  end;
  if (thisuser.sl=systat.autosl) and (thisuser.dsl=systat.autodsl) and
     (thisuser.ar=systat.autoar) then begin
    sysoplog('[> Already validated user executed Auto-Validation command');
    print('You''ve already been validated!  You do not need to use this command.');
    exit;
  end;

  print('Note:');
  print('The SysOp Log records ALL usage of this command.');
  print('Press <Enter> to abort.');
  nl;
  prt('Password: '); input(s,50);
  if (s='') then sprint(#3#7+'Function aborted.'^G)
  else begin
    ok:=(s=allcaps(pw));
    if (not ok) then begin
      sysoplog('[> User entered wrong password for Auto-Validation: "'+s+'"');
      sprint(#3#7+'Wrong!'^G);
    end else begin
      sysoplog('[> User correctly entered Auto-Validation password.');
      autovalidate(thisuser,usernum);
      topscr; commandline('User Validated.');
      printf('autoval');
      if (nofile) then begin
        nl;
        print('Correct.  You are now validated.');
      end;
    end;
  end;
end;

end.
