Program Renegade_To_Impulse_Convert;

Uses Crt;

Type

  acrq='@'..'Z';                  { Access Restriction flags }

  uflags =
   (rlogon,                       { L - Limited to one call a day }
    rchat,                        { C - No SysOp paging }
    rvalidate,                    { V - Posts are unvalidated }
    ruserlist,                    { U - Can't list users }
    ramsg,                        { A - Can't post an auto message }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post }
    remail,                       { E - Can't send email }
    rvoting,                      { K - Can't use voting booth }
    rmsg,                         { M - Force email deletion }
    vt100,                        { Supports VT100 }
    hotkey,                       { hotkey input mode }
    avatar,                       { Supports Avatar }
    pause,                        { screen pausing }
    novice,                       { user requires novice help }
    ansi,                         { Supports ANSI }
    color,                        { Supports color }
    alert,                        { Alert SysOp upon login }
    smw,                          { Short message(s) waiting }
    nomail,                       { Mailbox is closed }
    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnocredits,                   { 3 - No credits checking }
    fnodeletion);                 { 4 - Protected from deletion }

  suflags =
    (lockedout,                   { if locked out }
    deleted,                      { if deleted }
    trapactivity,                 { if trapping users activity }
    trapseparate,                 { if trap to seperate TRAP file }
    chatauto,                     { if auto chat trapping }
    chatseparate,                 { if separate chat file to trap to }
    slogseparate,                 { if separate SysOp log }
    clsmsg,                       { if clear-screens }
    RIP,                          { if RIP graphics can be used }
    fseditor,                     { if Full Screen Editor }
    AutoDetect                    { Use auto-detected emulation }
  );
  colors   = array[FALSE..TRUE,0..9] of byte; { Color tables }
  secrange = array[0..255] of integer;        { Access tables }

  mzscanr  = set of 1..250;              { Which message bases to scan }
  fzscanr  = set of 1..250;             { Which file bases to scan }
  mhireadr = array[1..250] of longint;   { Lastread pointers }

  useridxrec=                         { USERS.IDX : Sorted names listing }
  record
    Name:string[36];                  { CRC-32 of the user's name }
    Number,                           { user number          }
    Left,
    Right:integer;
    RealName,                         { User's real name?    }
    Deleted:boolean;                  { deleted or not       }
  end;

  dlnscan =set of 0..96;

   rgrec=                            { USERS.DAT : User records }
    record
    name:string[36];                  { system name      }
    realname:string[36];              { real name        }
    pw:string[20];                    { password         }
    ph:string[12];                    { phone #          }
    bday:string[8];                   { birthdate        }
    firston:string[8];                { first on date    }
    laston:string[8];                 { last on date     }
    street:string[30];                { street address   }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    usrdefstr:array[1..3] of string[35]; { type of computer }
                                      { occupation       }
                                      { BBS reference    }
    note:string[35];                  { SysOp note       }
    userstartmenu:string[8];          { menu to start at }
    lockedfile:string[8];             { print lockout msg}
    flags:set of uflags;              { flags            }
    sflags:set of suflags;            { status flags     }
    ar:set of acrq;                   { AR flags         }
    vote:array[1..25] of byte;        { voting data      }

    sex:char;                         { gender           }
    ttimeon,                          { total time on    }
    uk,                               { UL k             }
    dk:longint;                       { DL k             }
    tltoday,                          { # min left today }
    forusr,                           { forward mail to  }
    junkfp:integer;               { # of file points }

    uploads,downloads,                { # of ULs/# of DLs}
    loggedon,                         { # times on       }
    msgpost,                          { # message posts  }
    emailsent,                        { # email sent     }
    feedback,                         { # feedback sent  }
    timebank,                         { # mins in bank   }
    timebankadd,                      { # added today    }
    dlktoday,                         { # kbytes dl today}
    dltoday:word;                     { # files dl today }

    waiting,                          { mail waiting     }
    linelen,                          { line length      }
    pagelen,                          { page length      }
    ontoday,                          { # times on today }
    illegal,                          { # illegal logons }
    barf,
    lastmbase,                        { # last msg base  }
    lastfbase,                        { # last file base }
    sl,dsl:byte;                      { SL / DSL         }

    mhiread:mhireadr;                 { Message last read date ptrs}
    mzscan:mzscanr;                   { Which message bases to scan}
    fzscan:fzscanr;                   { Which file bases to scan}

    cols:colors;                      { user colors }

    garbage:byte;
    timebankwith:word;                { amount of time withdrawn today}
    passwordchanged:word;             { last day password changed }
    defarctype:byte;                  { default QWK archive type }
    lastconf:char;                    { last conference they were in }
    lastqwk:longint;                  { date/time of last qwk packet }
    getownqwk,                        { add own messages to qwk packet? }
    scanfilesqwk,                     { scan file bases for qwk packets? }
    privateqwk:boolean;               { get private mail in qwk packets? }

    credit,                           { Amount of credit a user has }
    debit:longint;                    { Amount of debit a user has }
    expiration:longint;               { Expiration date of this user }
    expireto:char;                    { Subscription level to expire to }
    ColorScheme:byte;                 { User's color scheme # }
    TeleConfEcho,                     { echo Teleconf lines? }
    TeleConfInt:boolean;              { interrupt during typing? }
   End;

   clrs = array[FALSE..TRUE,0..9] of byte;

  flistflags =
   (fname,                        {filename }
    fsize,                        {file size}
    fpts,                         {fiel points}
    fdesc,                        {file desc.}
    extdesc,                      {extended desc.}
    whoul,                        {who uploaded it}
    dateul,                       {date uploaded}
    numdl);                       {num of d/l's.}


  userrec=                            { USER.LST : User account records }
  record
    name:string[36];                  { user name        }
    realname:string[36];              { real name        }
    pw:string[20];                    { user password    }
    ph:string[12];                    { user phone #     }
    bday:string[8];                   { user birthdate   }
    firston:string[8];                { firston date     }
    x1xs  :array[1..2] of byte;
    laston:string[8];                 { laston date      }
    x2xs  :array[1..2] of byte;
    street:string[30];                { mailing address  }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    computer:string[30];              { type of computer }
    occupation:string[40];            { occupation       }
    wherebbs:string[40];              { BBS reference    }
    note:string[39];                  { SysOp note       }
    prompt:integer;                   {Chosen Menu Prompt}
    lockedout:boolean;                { if locked out    }
    deleted:boolean;                  { if deleted       }
    lockedfile:string[8];             { lockout msg to print }
    novotes,
    yesvotes:byte;                    { # of yes/no votes in NUV }
    ac:set of uflags;                 { user flags   }
    fflag:set of flistflags;          { users configable file list }
    ar:set of acrq;                   { AR flags     }

    zzqscan:array[1..64] of word;     { last read msg pointers }
    xqxxx:array[1..64] of word;
    zzqscn:array[1..64] of boolean;   { scan boards flags  }
    zzdlnscn:dlnscan;                 { scan uboards flags }

    vote:array[1..20] of byte;        { voting data  }

    sex:char;                         { user sex }

    ttimeon:longint;                  { total mins spent on  }
    x1xx:integer;
    uk:longint;                       { UL k                 }
    x2xx:integer;
    dk:longint;                       { DL k                 }
    x3xx:integer;

    uploads,downloads,                { # of ULs / # of DLs  }
    loggedon,                         { # times logged on    }
    tltoday,                          { # min left today     }
    msgpost,                          { # public posts       }
    emailsent,                        { # email sent         }
    feedback,                         { # feedback sent      }
    forusr,                           { forward mail to user # }
    filepoints:integer;               { # of file points     }

    waiting,                          { mail waiting         }
    linelen,                          { line length (# cols) }
    pagelen,                          { page length (# rows) }
    ontoday,                          { # times on today     }
    illegal,                          { # illegal logon attempts }
    sl,dsl:byte;                      { SL / DSL }

    cols:clrs;                        { user colors }

    lastmsg,lastfil:byte;             { last msg/file areas   }
    credit:longint;                   { $$$ credit in dollars }
    x4xx:integer;
    timebank:integer;                 { # mins in Time Bank   }
    boardsysop:array[1..5] of byte;   { msg board SysOp       }

    trapactivity,                     { if trapping users activity }
    trapseperate:boolean;             { if trap to seperate TRAP file }

    timebankadd:integer;              { time added to timebank TODAY }
    mpointer:longint;                 { pointer to entry in MACRO.LST }
    chatauto,                         { if auto chat trapping }
    chatseperate:boolean;             { if seperate chat file to trap to }
    userstartmenu:string[8];          { menu to start user out on }
    slogseperate:boolean;             { seperate SysOp log? }
    clsmsg:byte;                      { 1 if clear-screen msg, 2 if not }

{ NEW STUFF }

    flistopt:byte;                    { type of file list type to use }
    msgorder:byte;                    { 0:Chrono, 1:ReplyTree }
    avadjust:byte;                    { AVATAR color adjust: 1=no, 2=yes }

{ NEW STUFF *ENDS* }

    res:array[1..54] of byte;         { RESERVED }
  end;

  smalrec=                            { NAMES.LST : Sorted names listing }
  record
    name:string[36];                  { user name }
    number:integer;                   { user number }
  end;



Procedure lst_Convert;
Var UFile:File of rgRec;
    CEL:rgRec;
    VFile:File of UserRec;
    VFile1:file of smalrec;
    VIS:UserRec;
    vis1:smalrec;
    Cnt,I:Integer;
const dcols:clrs=((15,7,7,15,15,15,112,7,15,7),(15,7,1,11,9,8,25,3,7,8));
Begin
  Writeln(^M^J'Converting: Renegade User Lists to Impulse Format!');
  Assign (UFile,'USERS.DAT');       { Open And Rename Renegade Users File }
  Reset (UFile);
  If IOResult <> 0 Then Begin
    Writeln ('File: USERS.DAT not found.. Cannot continue!');
    Close (UFile);
    Exit
  End;
  Assign (VFile,'USER.LST');      { Open and Create Impulse Users File }
  Rewrite (VFile);
  Assign (Vfile1,'NAMES.LST');
  Rewrite (Vfile1);
  Seek (Vfile,1);
  Seek (UFile,0);
  Seek (VFile1,1);
  Cnt:=0;
  TextAttr:=11;
  While Not Eof(UFile) Do Begin
    Read (UFile,CEL);
    inc(Cnt);
    vis1.name:=cel.name;
    vis1.number:=cnt;
    vis.name:=cel.name;
    vis.realname:=cel.realname;
    vis.pw:=cel.pw;
    vis.ph:=cel.ph;
    vis.bday:=cel.bday;
    vis.firston:=cel.firston;
    vis.laston:=cel.laston;
    vis.street:=cel.street;
    vis.citystate:=cel.citystate;
    vis.zipcode:=cel.zipcode;
    vis.computer:='';
    vis.occupation:='';
    vis.wherebbs:='';
    vis.prompt:=0;
    vis.note:=cel.note;
    vis.lockedout:=FALSE;
    vis.deleted:=FALSE;
    vis.lockedfile:='';
    vis.ac:=cel.flags;
    vis.fflag:=vis.fflag+[fname];
    vis.fflag:=vis.fflag+[fsize];
    vis.fflag:=vis.fflag+[fpts];
    vis.fflag:=vis.fflag+[fdesc];
    vis.fflag:=vis.fflag+[extdesc];
    vis.ar:=vis.ar;
    for i:=1 to 20 do vis.vote[i]:=0;
    vis.sex:=cel.sex;
    vis.ttimeon:=cel.ttimeon;
    vis.uk:=cel.uk;
    vis.dk:=cel.dk;
    vis.uploads:=cel.uploads;
    vis.downloads:=cel.downloads;
    vis.loggedon:=cel.loggedon;
    vis.tltoday:=cel.tltoday;
    vis.msgpost:=cel.msgpost;
    vis.emailsent:=cel.emailsent;
    vis.feedback:=cel.feedback;
    vis.forusr:=0;
    vis.filepoints:=cel.junkfp;
    vis.waiting:=0;
    vis.linelen:=cel.linelen;
    vis.pagelen:=cel.pagelen;
    vis.ontoday:=cel.ontoday;
    vis.illegal:=cel.illegal;
    vis.sl:=cel.sl;
    vis.dsl:=cel.sl;
    vis.cols:=dcols;
    vis.lastmsg:=1;
    vis.lastfil:=1;
    vis.credit:=0;
    vis.timebank:=cel.timebank;
    vis.fflag:=vis.fflag+[fname,fsize,fpts,fdesc,extdesc];
    vis.trapactivity:=FALSE;
    vis.trapseperate:=FALSE;
    vis.timebankadd:=0;
    vis.mpointer:=-1;
    vis.chatauto:=false;
    vis.chatseperate:=false;
    vis.userstartmenu:=cel.userstartmenu;
    vis.slogseperate:=false;
    vis.clsmsg:=2;
    vis.flistopt:=1;
    vis.msgorder:=0;
    vis.avadjust:=1;
    for i:=1 to 54 do vis.res[i]:=0;
    if (cnt=1) then begin
      seek(vfile,0);
      write(vfile,vis);
      seek(vfile,0);
      write(vfile1,vis1);
    end else begin
      Write (VFile,VIS);
      Write (VFile1,VIS1);
    end;
    Seek (VFile,Cnt);
    Seek (VFile1,Cnt);
  End;
  Writeln (Cnt-1,' Users Converted over to Impulse.');
  Close (UFile);
  Close (VFile);
  Close (VFile1);
End;

Var K:Char;
Begin
  TextAttr:=7;
  ClrScr;
  TextAttr:=11;
  Write (#13#10#13#10'Renegade to ');
  TextAttr:=11;
  Write('Impulse ');
  TextAttr:=11;
  Writeln ('User Converter.');
  TextAttr:=9;
  Writeln ('Written by: Nivenh - Impulse Programming Staff.');
  TextAttr:=15;
  Writeln;
  Repeat
   Write('Continue With Conversion [N]? ');
   K:=Upcase(ReadKey);
  Until K in [#13,'Y','N'];
  If K = 'Y' Then Begin
    lst_Convert;
{    Writeln('Renegade USERS.DAT Saved as USERSDAT.OLD');}
  End;
End.