{$A+,B+,D-,E+,F+,I+,L+,N-,O-,R-,S-,V-}
UNIT tmpcom;

INTERFACE

USES
  Dos,crt;

CONST
  com_installed: Boolean = FALSE;
  usefossil:boolean = FALSE;

var
  fosport:word;
  regs:registers;


procedure com_flush_rx;
procedure com_flush_tx;
procedure com_purge_tx;
function com_carrier:boolean;
function com_rx:char;
function com_tx_ready:boolean;
function com_tx_empty:boolean;
function com_rx_empty:boolean;
procedure com_tx (ch: Char);
procedure com_tx_string (st: String);
procedure com_lower_dtr;
procedure com_raise_dtr;
procedure com_set_speed(speed:word);
procedure com_install(portnum:word);
procedure com_deinstall;


implementation

uses timetask, common;

const
  max_port = 4;

var
  exit_save:pointer;

procedure com_flush_rx;
var ch:char;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.ah:=$0A;
  intr($14,regs);
  end;
end;

procedure com_flush_tx;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.ah:=$08;
  intr($14,regs);
  end;
end;

procedure com_purge_tx;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.ah:=$09;
  intr($14,regs);
  end;
end;

function com_carrier:boolean;
begin
 if (not localioonly) then begin
   regs.dx:=fosport;
   regs.ah:=$03;
   intr($14,regs);
   if (regs.ax and $0080) = 0 then
   com_carrier:=FALSE
   else
   com_carrier:=TRUE;
   end;
end;

function com_rx:char;
var times:integer;
begin
  inc(times);
  if (times>700) then begin
    timeslice;
    times:=0;
  end;
  Asm
    mov ah,02h
    mov dx,fosport
    int 14h
  End;
end;

function com_tx_ready: Boolean;
begin
    com_tx_ready:=TRUE;
end;

function com_tx_empty:boolean;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.ah:=$03;
  intr($14,regs);
  com_tx_empty:=((regs.ax and $4000) <> 0);
  end;
end;

function com_rx_empty:boolean;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.ah:=$0C;
  intr($14,regs);
  com_rx_empty:=(regs.ax = $FFFF);
  end;
end;

procedure com_tx(ch:char);
var result:word;
    times:integer;
begin
 inc(times);
 if (times>=700) then begin
   timeslice;
   times:=0;
 end;
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.al:=ord(ch);
  regs.ah:=$01;
  intr($14,regs);
  end;
end;

procedure com_tx_string(st:string);
var i:byte;
    result:word;
begin
 if (not localioonly) then begin
  for i:=1 to length(st) do com_tx(st[i]);
  end;
end;

procedure com_lower_dtr;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.al:=$00;
  regs.ah:=$06;
  intr($14,regs);
 end;
end;

procedure com_raise_dtr;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  regs.al:=$01;
  regs.ah:=$06;
  intr($14,regs);
 end;
end;

procedure com_set_speed (speed: Word);
var divisor:word;
    baudhigh:boolean;
begin
 if (not localioonly) then begin
  regs.dx:=fosport;
  case speed of
    300:regs.al:=(2 shl 5)+3;
    600:regs.al:=(3 shl 5)+3;
    1200:regs.al:=(4 shl 5)+3;
    2400:regs.al:=(5 shl 5)+3;
    4800:regs.al:=(6 shl 5)+3;
    9600:regs.al:=(7 shl 5)+3;
    12000:regs.al:=(0 shl 5)+3;
    14400:regs.al:=(0 shl 5)+3;
    16800:regs.al:=(1 shl 5)+3;
    19200:regs.al:=(0 shl 5)+3;
    21600:regs.al:=(1 shl 5)+3;
    24000:regs.al:=(1 shl 5)+3;
    26400:regs.al:=(1 shl 5)+3;
    28800:regs.al:=(1 shl 5)+3;
    38400:regs.al:=(1 shl 5)+3;
    57600:begin
           baudhigh:=speed=57600;
           asm
           MOV AH, 1Bh
           INT 14h
           CMP CX, '0X'
           JNE @EXIT
           MOV AH, 1Eh
           MOV BX, 0000h
           MOV CH, 03h
           MOV DX, FOSPORT
           CMP BaudHigh, True
           JE @1
           MOV CL, 84h
           JMP @INT
          @1:
           MOV CL, 82h
          @INT:
           INT 14h
          @EXIT:
          end;
         exit;
         end;
   11520:begin
          baudhigh:=speed=11520;
           asm
           MOV AH, 1Bh
           INT 14h
           CMP CX, '0X'
           JNE @EXIT
           MOV AH, 1Eh
           MOV BX, 0000h
           MOV CH, 03h
           MOV DX, FOSPORT
           CMP BaudHigh, True
           JE @1
           MOV CL, 84h
           JMP @INT
          @1:
           MOV CL, 82h
          @INT:
           INT 14h
          @EXIT:
          end;
         exit;
        end;
  end;
  regs.ah:=$00;
  intr($14,regs);
 end;
end;

procedure com_install(portnum:word);
 const Buffer_Size = 1024;
 var Input_Buffer : ARRAY [1..Buffer_Size] OF BYTE;
begin
  usefossil:=false;
  if (not localioonly) then begin
  Regs.Ah := $04;                          { Communications Port        }
  Regs.Dx := Portnum - 1;                  { Sets FOSPORT to COMPORT    }
  Regs.Bx := $4F50;
  intr($14,regs);
  usefossil := Regs.Ax = $1954;
  FosPort := Portnum - 1;
  if (usefossil) then begin
    Regs.DI:=OFS(Input_Buffer);  { Input buffer offset  to DI }
    Regs.ES:=SEG(Input_Buffer);  { Input buffer segment to ES }
    Regs.CX:=Buffer_Size;          { Max bytes to read to CX }
    regs.al:=$F0;
    regs.ah:=$18;
    regs.dx:=fosport;
    intr($14,regs);
  end else begin
  clrscr;
  textcolor(8);
  write(''); textcolor(15);writeln(' Fossil Not Active');
  writeln;
  textcolor(7);
  writeln('  Load a FOSSIL Driver.');
  writeln;
  writeln;
  halt(0);
  end;
 end;
end;

Procedure deinitcom; Assembler;
Asm
  mov ax,05h
  mov dx,fosport
  int 14h
End;

procedure com_deinstall;
begin
  if (not localioonly) then begin
   deinitcom;
  end;
end;

{$F+} procedure exit_procedure; {$F-}
begin
  com_deinstall;
  exitproc:=exit_save;
end;

begin
  exit_save:=exitproc;
  exitproc:=@exit_procedure;
end.

