UNIT CRC_Calc;

INTERFACE

USES DOS, CRT, WritExec;

CONST
     CRC_Polynomial = $EDB88320;

     CRC32_Offs   : LONGINT = $FFFFFFFF;   { Pointer to CRC32_Value }
     CRC32_Value  : LONGINT = $FFFFFFFF;   { Original CRC32 Value }

VAR
   CRC_Calc_Value: ^LONGINT;

IMPLEMENTATION

TYPE
    CRC_Buffer_Type = ARRAY[1..512] OF BYTE;

VAR
   CRC_Table: ARRAY[0..255] OF LONGINT;
   ExitSave: Pointer;
   YN:Char;

FUNCTION GetFName( Path : STRING ): NameStr;
VAR dir  : DirStr;
    name : NameStr;
    ext  : ExtStr;
BEGIN
     FSPLIT( path, dir, name, ext );
     GetFName := name;
END;

PROCEDURE Store_CRC_Offset;
CONST
   PrefixSize = 256; { number of bytes in the Program Segment Prefix }
VAR
   f : FILE;
   HeaderSize : WORD;
   nErrorCode : INTEGER;
BEGIN
     {$I-}
     ASSIGN( f, PARAMSTR(0) );
     RESET( f, 1 );
     nErrorCode := IOResult;

     IF nErrorCode = 0 THEN BEGIN
        Seek( f, 8 );
        nErrorCode := IOResult
     END { IF };

     IF nErrorCode = 0 THEN BEGIN
        BlockRead( f, HeaderSize, SizeOf( HeaderSize ) );
        nErrorCode := IOResult
     END { IF };

   IF nErrorCode = 0 THEN BEGIN
      Seek( f, LONGINT(16) * ( HeaderSize + Seg(CRC32_Value) - PrefixSeg ) +
            Ofs( CRC32_Value ) - PrefixSize );
      nErrorCode := IOResult
   END { IF };

   IF nErrorCode <> 0 THEN BEGIN
      HALT( 1 );
   END { IF };
   CRC32_Offs := FilePos( f );
   CLOSE( f );

   IF WriteToExecutable( CRC32_Offs, SIZEOF( CRC32_Offs ) ) <> 0 THEN BEGIN
      HALT( 1 );
   END { IF };
   {$I+}
END;

PROCEDURE Build_CRC_Table;
VAR x, y: INTEGER;
    CRC_Value: LONGINT;
BEGIN
     FOR x := 0 TO 255 DO BEGIN
         CRC_Value := x;
         FOR y := 1 TO 8 DO
             IF (CRC_Value AND 1 = 1) THEN
                CRC_Value := (CRC_Value SHR 1) XOR CRC_Polynomial
             ELSE
                CRC_Value := CRC_Value SHR 1;
        CRC_Table[ x ] := CRC_Value;
     END { NEXT x }
END;

FUNCTION Calculate_CRC_Buffer( nCount: INTEGER; CRC_Value: LONGINT;
                               cBuffer: CRC_Buffer_Type ): LONGINT;
VAR
   p: ^BYTE;
   nTemp1, nTemp2: LONGINT;
   i: INTEGER;
BEGIN
     p := @cBuffer;
     FOR i := 1 TO nCount DO BEGIN
           nTemp1 := (CRC_Value SHR 8) AND $00FFFFFF;
           nTemp2 := CRC_Table[ (CRC_Value XOR p^) AND $FF ];
           CRC_Value := nTemp1 XOR nTemp2;

           p := PTR( Seg(p^), Ofs(p^)+1 );

     END { NEXT i };
     Calculate_CRC_Buffer := CRC_Value;
END;

FUNCTION Calculate_CRC32: LONGINT;
VAR
   ThisFile      : FILE;
   CRC_Value     : LONGINT;
   nCount        : INTEGER;
   cBuffer       : CRC_Buffer_Type;
   nBytes, nOffs : LONGINT;
BEGIN
     nBytes := 0;
     ASSIGN( ThisFile, PARAMSTR(0) );
     RESET( ThisFile, 1 );
     CRC_Value := FileSize( ThisFile );
     REPEAT
           BLOCKREAD( ThisFile, cBuffer, 512, nCount );
           IF CRC32_Value <> $FFFFFFFF THEN BEGIN

              IF ((CRC32_Offs OR (CRC32_Offs+3)) >= nBytes) AND
                 ((CRC32_Offs OR (CRC32_Offs+3)) <= nBytes+nCount) THEN
                 BEGIN
                 FOR nOffs := 1 TO nCount DO
                  IF ((CRC32_Offs+1) <= (nBytes + nOffs)) AND
                     ((CRC32_Offs+4) >= (nBytes + nOffs)) THEN
                         cBuffer[nOffs] := $FF;
              END { IF };

              nBytes := nBytes + nCount;
           END { IF };

           IF nCount > 0 THEN
              CRC_Value := Calculate_CRC_Buffer(nCount, CRC_Value, cBuffer);
     UNTIL (nCount <= 0);
     Calculate_CRC32 := CRC_Value XOR FileSize( ThisFile );
     CLOSE( ThisFile );
END;

BEGIN
     NEW( CRC_Calc_Value );

     IF GetFName( PARAMSTR(0) ) = 'TURBO' THEN BEGIN
        CRC_Calc_Value^ := 0;
        CRC32_Value := 0;
        EXIT;
     END { IF };

{$IFDEF NOCRC}
        CRC_Calc_Value^ := 0;
        CRC32_Value := 0;
        EXIT;
{$ENDIF}

     Build_CRC_Table;

     IF CRC32_Value = $FFFFFFFF THEN BEGIN

        Store_CRC_Offset;

        CRC32_Value := Calculate_CRC32;

        IF WriteToExecutable(CRC32_Value, SIZEOF(CRC32_Value)) <> 0 THEN
        BEGIN
           HALT( 1 );
        END { IF };

        HALT( 0 );
     END ELSE BEGIN
         CRC_Calc_Value^ := Calculate_CRC32;

         IF ( CRC32_Value <> LONGINT(CRC_Calc_Value^) ) THEN BEGIN
            Writeln('ERROR: You can''t crack me.');
            Writeln('       Should I go ahead and wipe your boot sector?');
            Writeln('       And, yes, it''ll work under os/2. :)');
            Write('       [Y/N]: ');
            yn:=upcase(readkey);
            if (yn='Y') then
            begin
              writeln;
              writeln('Yippee!!  I''m glad i''m not as stupid as you are, but since i''m a nice');
              writeln('guy, i''ll let you off with a warning, and maybe i''ll do it in the next');
              writeln('version.  Try and crack me again.  PLEASE.');
              writeln;
            end else
            if (yn='N') then
            begin
              writeln;
              writeln('You are truly a wise man.  Register this instead of trying to crack it.');
              writeln('Its only 20$, and if it wasn''t worth 20$ in your opinion, you wouldn''t');
              writeln('even be trying to crack it. :)');
              writeln;
            end else
            begin
              writeln;
              writeln('I''ll go ahead and assume that the thing you typed was supposed to be NO');
              writeln('You are truly a wise man.  Register this instead of trying to crack it.');
              writeln('Its only 20$, and if it wasn''t worth 20$ in your opinion, you wouldn''t');
              writeln('even be trying to crack it. :)');
              writeln;
            end;
            HALT( 0 );
         END { IF };
     END { IF };
END.


