unit Answer;

interface

uses Crt;

type
	st2 = string[2];

var
	KeySet: set of char;
  ExtSet: set of char;
  Key: char;
  Ext: char;
  Accepted: set of char;
  Cr: boolean;
  EraseKey: st2;
  Mask: char;
  Ins: boolean;
  Caps: boolean;
  Min: byte;

const
	ver = '1.11';
  compildate = '12/20/92';
  copyright = 'Answer TP unit '+ver+' (c)'+compildate+', David Turgeon';

function Ask(txt: string; color, len: byte; oldans: string): string;

implementation

Procedure SetCursor(Cursor : Word);

  InLine($59/              { pop  cx        }
         $B4/$01/          { mov  ah,1      }
         $CD/$10);         { int  10h       }

function StringOf(n: byte; k: char): string;
  var
  	c: byte;
    temp: string;
	begin
    temp := '';
    if n > 0 then
	  	for c := 1 to n do
  	  	temp := temp + k;
    StringOf := temp;
  end;

function Ask(txt: string; color, len: byte; oldans: string): string;
	var
  	x, y, l, p: byte;
    bx: byte;
    m: string;
    k, k2: char;
    oldattr: byte;
    instat: boolean;
  label
  	2, finish;
	procedure Writem(m: string);
		begin
    	GotoXY(bx, y);
	    Write(StringOf(len, ' '));
      GotoXY(bx, y);
  		if Mask <> #0 then
    		Write(StringOf(Length(m), Mask))
	    else
  	  	Write(m);
	  end;
  begin
    instat := Ins;
    Key := #0;
    Ext := #0;
    oldattr := TextAttr;
    y := WhereY;
		bx := WhereX + Length(txt);
		x := bx + Length(oldans);
    Write(txt);
    if color > 0 then TextAttr := color;
    Write(StringOf(len, ' '));
    l := len;
    Inc(l);
    m := oldans;
    p := 1+Length(oldans);
    GotoXY(bx, y);
    Writem(oldans);
  2:
    if not instat then
    	SetCursor(148)
    else
    	SetCursor(1543);
    GotoXY(x, y);
    k2 := #0;
    k := ReadKey;
    if k = #0 then
    	k2 := ReadKey;
    if k = #13 then
		begin
      if Length(m) >= min then
				goto finish;
    end;
    if k = #8 then
    begin
      if p > 1 then
      begin
        Dec(x);
        Dec(p);
	     	Delete(m, p, 1);
  	    Writem(m);
      end;
      goto 2;
    end;
    if ((EraseKey[1] <> #0) and (k = EraseKey[1])) or
		   ((EraseKey[1] =  #0) and (k2 <> #0) and (k2 = EraseKey[2])) then
    begin
    	x := bx;
      GotoXY(x, y);
      Write(StringOf(len, ' '));
      p := 1;
      m := '';
      goto 2;
    end;
    if k2 <> #0 then
    begin
      if k2 in ExtSet then
      begin
      	Key := #0;
        Ext := k2;
        goto finish;
      end;
      case k2 of
        #82:
        	begin
          	if instat then
            	instat := false
            else
            	instat := true;
          end;
      	#75:
          if p > 1 then
        	begin
          	Dec(x);
            Dec(p);
          end;
        #77:
          if p <= Length(m) then
        	begin
          	Inc(p);
            Inc(x);
          end;
        #71:
        	begin
            x := bx;
            p := 1;
          end;
        #79:
        	begin
          	x := bx+Length(m);
            p := 1+Length(m);
          end;
        #83: {del}
        	begin
            Delete(m, p, 1);
            GotoXY(bx, y);
            Writem(m);
          end
      end;
      goto 2;
    end;
    if k in KeySet then
    begin
    	Key := k;
      Ext := #0;
      goto finish;
    end;
    if Caps then k := UpCase(k);
    if p >= l then goto 2;
    if k in Accepted then
    begin
      if instat then
      begin
	  	  Insert(k, m, p);
        if Length(m) > len then
        	Delete(m, len+1, 1);
      end
      else
      	m[p] := k;
      Writem(m);
    	Inc(x);
	    Inc(p);
    end;
    goto 2;
  finish:
    TextAttr := oldattr;
    if cr then Writeln;
  	Ask := m;
    SetCursor(1543);
  end;

begin
  KeySet := [];
  ExtSet := [];
  Key := #0;
  Ext := #0;
  Cr := true;
  EraseKey := #27+#0;
  Mask := #0;
  Ins := true;
  Accepted := [#32..#255];
  Caps := false;
  Min := 0;
end.
