
{ BarMenu unit 1.0 for Turbo Pascal
  10/16/92, David Turgeon
  Tested on Turbo Pascal 6.0
  If you change something please send me what you changed, and
  add your name below...
  Absolutely freeware, public domain, free...
  David Turgeon CP 66 Lac-Beauport QC Canada G0A 2C0 }


unit aEnvTpu;


interface


type
  DesktopObj = object
    desk: byte;
    shadow: byte;
    procedure Init(df, db, shad: byte);
    procedure Desktop;
  end;
  BarObj = object
  	text: byte;
    hi: byte;
    x1: byte;
    x2: byte;
    y: byte;
    s: string[80];
    center: boolean;
    procedure Init(txf, txb, hif, hib, cx1, cx2, cy: byte);
    procedure InitString(cs: string);
    procedure Bar;
  end;
  WinBarObj = object
    border: byte;
  	text: byte;
    hi: byte;
    x1: byte;
    x2: byte;
    y1: byte;
    y2: byte;
    s: string[80];
    procedure Init(bof, bob, txf, txb, hif, hib, cx1, cy1, cx2, cy2: byte);
    procedure InitString(cs: string);
    procedure Bar;
  end;
  MessageObj = object
  	snum: byte;
    s: array[1..23] of string[80];
    title: string;
    border: byte;
    text: byte;
    hi: byte;
    x: byte;
    y: byte;
    removeafter: boolean;
    wait: boolean;
    kset: set of char;
    eset: set of char;
    returnedkey: char;
    extended: boolean;
    procedure Init(bof, bob, txf, txb, hif, hib, cx, cy: byte);
    procedure InitString(cnum: byte; cs: string);
    procedure Message;
  end;
  ProgressBarObj = object
  	bnum: byte;
    b: array[1..23] of string[78];
    bval: array[1..23] of byte;
    blen: byte;
    title: string;
    border: byte;
    text: byte;
    bar: byte;
    x: byte;
    y: byte;
    removeafter: boolean;
    procedure Init(bof, bob, txf, txb, baf, bab, cx, cy: byte);
    procedure InitBar(cnum: byte; cb: string; cbval: byte);
    procedure ProgressBar(update: boolean);
  end;
  AnsFieldObj = object
    title: string;
  	kset: set of char;
    eset: set of char;
    s: string[78];
    q: string[78];
    border: byte;
    text: byte;
    ans: byte;
    removeafter: boolean;
    esc: char;
    returnedkey: char;
    extended: boolean;
    len: byte;
    x: byte;
    y: byte;
    maskchar: char;
    procedure Init(bof, bob, txf, txb, anf, anb, cx, cy: byte);
    procedure InitQuestion(cq: string; clen: byte);
    procedure InitString(cs: string);
    procedure Ask;
  end;
	MenuObj = object {the barmenu}
    title: string;
    knum: 1..15;
    ks: array[1..15] of char;
    kset: set of char;
    eset: set of char;
    extended: boolean;
    returnedkey: char;
    items: array[1..15] of string[78];
    choice: char;
    x: byte;
    y: byte;
    border: byte;
    text: byte;
    hi: byte;
    bar: byte;
  	lastone: byte;
    hilite: boolean;
    removeafter: boolean;
		procedure Init(bof, bob, txf, txb, hif, hib, baf, bab: byte;
    							 cx, cy: byte; high: boolean);
    procedure InitItem(cnum: byte; citem: string; cks: char);
    procedure Menu(first: byte);
  end;
	DialogObj = object {the barmenu}
    title: string;
    knum: 1..10;
    kset: set of char;
    eset: set of char;
    s: string[78];
    extended: boolean;
    returnedkey: char;
    space: char;
    items: array[1..10] of string[78];
    iss: array[1..10] of boolean;
    sans: array[1..10] of string[78];
    bans: array[1..10] of boolean;
    len: array[1..10] of byte;
    numonly: array[1..10] of boolean;
    x: byte;
    y: byte;
    border: byte;
    text: byte;
    hi: byte;
    bar: byte;
    ans: byte;
  	lastone: byte;
    removeafter: boolean;
		procedure Init(bof, bob, txf, txb, hif, hib, baf, bab, anf, anb, cx, cy: byte);
    procedure InitItem(cnum: byte; citem: string; ciss: boolean; csans: string; clen: byte; cbans: boolean);
    procedure InitString(cs: string);
    procedure Menu(first: byte);
  end;
	ColorsObj = object
    title: string;
    knum: 1..9;
    snum: 1..9;
    anum: byte;
    kset: set of char;
    eset: set of char;
    s: string[78];
    extended: boolean;
    returnedkey: char;
    space: char;
    sample: array[1..9] of string[78];
    items: array[1..9] of string[78];
    cans: array[1..9] of byte;
    x: byte;
    y: byte;
    border: byte;
    text: byte;
    hi: byte;
    bar: byte;
    ans: byte;
  	lastone: byte;
    removeafter: boolean;
		procedure Init(bof, bob, txf, txb, hif, hib, baf, bab, cx, cy: byte);
    procedure InitItem(cnum: byte; citem: string; ccans: byte);
    procedure InitSample(cnum: byte; csample: string);
    procedure InitString(cs: string);
    procedure Menu(first: byte);
  end;
	OneLineObj = object {one line bar-menu}
    knum: 1..15;
    ks: array[1..15] of char;
    kpos: array[1..15] of byte;
    under: array[1..15] of boolean;
    kmenu: array[1..15] of MenuObj;
    kset: set of char;
    eset: set of char;
    extended: boolean;
    returnedkey: char;
    items: array[1..15] of string[78];
    choice: char;
    whatmenu: byte;
    esc: char;
    x1: byte;
    x2: byte;
    y: byte;
    text: byte;
    hi: byte;
    bar: byte;
  	lastone: byte;
    hilite: boolean;
    removeafter: boolean;
		procedure Init(txf, txb, hif, hib, baf, bab: byte;
    							 cx1, cx2, cy: byte; high: boolean);
    procedure InitItem(cnum: byte; citem: string; cks: char; ckpos: byte;
		                   cunder: boolean);
    procedure Menu(first: byte);
  end;
	ScrollObj = object
    title: string;
    knum: 1..255;
    kset: set of char;
    eset: set of char;
    extended: boolean;
    returnedkey: char;
    items: array[1..255] of string[78];
    itemchosen: byte;
    upper: byte;
    x: byte;
    y1: byte;
    y2: byte;
    border: byte;
    text: byte;
    hi: byte;
    bar: byte;
  	lastone: byte;
    hilite: boolean;
    removeafter: boolean;
		procedure Init(bof, bob, txf, txb, hif, hib, baf, bab: byte;
    							 cx, cy1, cy2: byte);
    procedure InitItem(cnum: byte; citem: string);
    procedure Menu(first: byte; cupper: byte);
    procedure Sort;
  end;


var
  BarLeft, BarRight: char;
  Check: array[false..true] of char;
	CheckLeft, CheckRight: char;
  BorderChar: byte;
  ProgressBarChar: char;
  ScrollUpChar, ScrollDownChar: char;


procedure DoWindow(x1, y1, x2, y2, cf, cb: byte; title: string);

procedure DoScreen(x1, y1, x2, y2, cf, cb: byte);

procedure NoMenu;

procedure NoWindow;

procedure NoDesktop;

procedure NoBar;

procedure HiBack;

procedure Blink;


procedure Color(attr: byte);


implementation


uses Windows, Crt, Dos, Answer, TheUnit, BMDat, Back{, rKey};


function bt(num: byte): BorderType;
	begin
  	case num of
    	0: bt := none;
      1: bt := single;
      2: bt := double;
      3: bt := doubletop;
      4: bt := doubleside;
      5: bt := solid;
    else
    	bt := double;
    end;
	end;


procedure HiBack;
	begin
  	HighBackground(true);
  end;

procedure Blink;
	begin
  	HighBackground(false);
  end;

procedure NoDesktop;
	begin
  	RemoveWindow;
  end;

procedure NoMenu;
	begin
  	RemoveWindow;
  end;

procedure NoWindow;
	begin
  	RemoveWindow;
  end;

procedure NoBar;
	begin
  	RemoveWindow;
  end;


procedure Color(attr: byte);
	begin
  	TextAttr := attr;
  end;

Procedure WriteCh(Cha : Char);
{-Writes character without translation to the current }
{ cursor location, cursor is NOT moved                }

{ I took this proc on Pascal Echo, thanks! :-) }

Var
  Reg : Registers;  { USES DOS !! }

Begin
  With Reg Do
  Begin
    Ah := 9;
    Al := Ord(Cha);
    BH := 0;  { display page }
    BL := TextAttr;  { from CRT unit }
    CX := 1;  { write 1 character }
    Intr($10,Reg);
  End;
End;


procedure MenuObj.Init(bof, bob, txf, txb, hif, hib, baf, bab: byte;
    							     cx, cy: byte; high: boolean);

	begin
    border := bof+bob*16;
    text := txf+txb*16;
    hi := hif+hib*16;
    bar := baf+bab*16;
    x := cx;
    y := cy;
    hilite := high;
    title := '';
    kset := [];
    eset := [];
    removeafter := true;
    lastone := 1;
  end;


procedure MenuObj.InitItem(cnum: byte; citem: string; cks: char);

	begin
  	items[cnum] := citem;
    ks[cnum]   := cks;
  end;


procedure MenuObj.Menu(first: byte);

  var
  	itempos: byte;
    Ok: boolean;
    mkey: char;
    count: byte;
    long: byte;

	function Longer: byte;
 		var
   		count: byte;
	    current: byte;
  	begin
   		current := Length(title);
	   	for count := 1 to knum do
  	  begin
    	  if Length(items[count]) > current then
	       	current := Length(items[count]);
  	  end;
    	Longer := current;
	  end;

  procedure NewChoices;
    var
      b:byte;
    	count2: byte;
      found: boolean;
  	begin
      found := false;
      Color(text);
		  GotoXY(1, lastone);
		  Write(' ');
      items[lastone] := items[lastone] + StringOf(long-Length(items[lastone]), ' ');
      for count2 := 1 to Length(items[lastone]) do
      begin
       	if (UpCase(items[lastone][count2]) = UpCase(ks[lastone])) and (hilite) and (not found) then
        begin
         	Color(hi);
          Write(items[lastone][count2]);
          Color(text);
          found := true;
        end
        else
         	Write(items[lastone][count2]);
      end;
      WriteCh(' ');
    end;

	procedure Choices;
		begin
      Color(text);
      ClrScr;
		end;

  procedure DoBar(n: byte);
  	begin
    	GotoXY(1, n);
      Color(bar);
      Write(BarLeft);
      Write(items[n]);
      WriteCh(BarRight);
    end;

	begin
    Cursor(off);
    long := Longer;
    Ok := false;
    Extended := false;
    returnedkey := #0;
    if x = 0 then
    	x := 40-((Longer+4) div 2);
    MakeWindow(x, y, x+long+3, y+knum+1, border mod 16, border div 16, bt(BorderChar), title);
    itempos := first;
    Choices;
    lastone := 0;
    repeat
      Inc(lastone);
     	NewChoices;
    until lastone = knum;
    repeat
      NewChoices;
      lastone := itempos;
      DoBar(itempos);
    	mkey := UpCase(ReadKey);
      if mkey = #0 then
      begin
      	mkey := ReadKey;
        case mkey of
        	#71: itempos := 1;
          #72: if itempos < 2 then
          			itempos := knum
          		else
              	Dec(itempos);
        	#79: itempos := knum;
          #80: if itempos > (knum-1) then
          			itempos := 1
          		else
              	Inc(itempos);
        end;
        if mkey in eset then
        begin
        	Ok := true;
          returnedkey := mkey;
          mkey := UpCase(ks[itempos]);
          extended := true;
        end;
      end
      else if mkey = #13 then
      begin
        mkey := UpCase(ks[itempos]);
        Ok := true;
      end
      else if UpCase(mkey) in kset then
      begin
      	returnedkey := mkey;
      	Ok := true;
      end;
    until Ok;
    NewChoices;
    lastone := itempos;
    if not extended then
    begin
	    for count := 1 to knum do
  	  	if UpCase(ks[count]) = UpCase(mkey) then
    	  begin
      	  DoBar(count);
		    	lastone := count;
	      end;
    end;
    if RemoveAfter then RemoveWindow;
    choice := mkey;
  end;


procedure DialogObj.Init(bof, bob, txf, txb, hif, hib, baf, bab, anf, anb, cx, cy: byte);
  var
  	c: byte;
	begin
    for c := 1 to 10 do
    	numonly[c] := false;
  	border := bof+bob*16; text := txf+txb*16;
    bar := baf+bab*16;    ans := anf+anb*16;
    hi := hif+hib*16;
    x := cx; 							y := cy;
    kset := [];
    eset := [];
    title := '';
    extended := false;
    returnedkey := #0;
    space := #32;
  end;

procedure DialogObj.InitItem(cnum: byte; citem: string; ciss: boolean; csans: string; clen: byte; cbans: boolean);
	begin
  	items[cnum] := citem;
    iss  [cnum] := ciss;
    sans [cnum] := csans;
    len  [cnum] := clen;
    bans [cnum] := cbans;
  end;

procedure DialogObj.InitString(cs: string);
	begin
  	s := cs;
  end;

procedure DialogObj.Menu(first: byte);
  var
  	itempos: byte;
    Ok: boolean;
    mkey: char;
    count: byte;
    long, longi, longa: byte;
    c2: byte;

	function Length2(s: string): byte;
  	var
    	c: byte;
      tmp: byte;
    begin
      tmp := 0;
      if Length(s) > 0 then
    	for c := 1 to Length(s) do
      begin
        if not (s[c] in ['{', '}']) then
					Inc(tmp);
			end;
			Length2 := tmp;
    end;

	function LongerItem: byte;
 		var
   		count: byte;
	    current: byte;
  	begin
   		current := 1;
	   	for count := 1 to knum do
  	  begin
    	  if Length(items[count]) > current then
	       	current := Length(items[count]);
  	  end;
    	LongerItem := current;
	  end;

	function LongerAns: byte;
 		var
   		count: byte;
	    current: byte;
      temp: byte;
  	begin
   		current := 1;
	   	for count := 1 to knum do
  	  begin
        if iss[count] then
        	temp := len[count]
        else
        	temp := 3;
    	  if temp > current then
	       	current := temp;
  	  end;
    	LongerAns := current;
	  end;

  procedure NewChoices;
    var
      b:byte;
    	count2: byte;
      found: boolean;
  	begin
      found := false;
      Color(text);
		  GotoXY(1, lastone);
		  Write(' ');
      items[lastone] := StringOf(longi-Length(items[lastone]), ' ') + items[lastone];
      Write(items[lastone]);
      if iss[lastone] then
      begin
        Color(ans);
      	Write(sans[lastone]+StringOf(len[lastone]-Length(sans[lastone]), ' '));
        Color(text);
				Write(StringOf(longa-len[lastone], ' '))
      end
      else
      	Write(CheckLeft+Check[bans[lastone]]+CheckRight+StringOf(longa-3, ' '));
      WriteCh(' ');
    end;

	procedure Choices;
    var
    	lng: byte;
		begin
      c2 := 0;
      Color(text);
      ClrScr;
      lng := Length2(s);
      if lng > 0 then
      begin
        GotoXY(((long) div 2)-(lng div 2)+2, knum+1);
        while c2 < Length(s) do
        begin
          Inc(c2);
          if s[c2] = '{' then
          	Color(hi)
          else if s[c2] = '}' then
          	Color(text)
          else
	        	Write(s[c2]);
        end;
      end;
		end;

  procedure DoBar(n: byte);
  	begin
    	GotoXY(1, n);
      Color(bar);
      Write(BarLeft);
      Write(items[n]);
      if iss[n] then
      begin
        Color(ans);
      	Write(sans[n]+StringOf(len[n] - Length(sans[n]), ' '));
				Color(bar);
				Write(StringOf(longa-len[n], ' '))
      end
      else
      	Write(CheckLeft+Check[bans[n]]+CheckRight+StringOf(longa-3, ' '));
      WriteCh(BarRight);
    end;

	begin
    Cursor(off);
    longi := LongerItem;
    longa := LongerAns;
    long := longi+longa;
    itempos := long;
    if Length(title) > itempos then
    	itempos := Length(title);
    if Length2(s) > itempos then
    	itempos := Length2(s);
    if long < itempos then
    begin
    	longa := itempos-longi;
      long := longa+longi;
    end;
    Ok := false;
    Extended := false;
    returnedkey := #0;
    if x = 0 then
    	x := 40-((Long+4) div 2);
    MakeWindow(x, y, x+long+3, y+knum+2, border mod 16, border div 16, bt(BorderChar), title);
    itempos := first;
    Choices;
    lastone := 0;
    repeat
      Inc(lastone);
     	NewChoices;
    until lastone = knum;
    repeat
      Cursor(off);
      NewChoices;
      lastone := itempos;
      DoBar(itempos);
      if iss[itempos] then
      begin
        GotoXY(1, itempos);
        Cr := false;
        erasekey := ^Y+#0;
        keyset := kset + [#9];
        extset := eset + [#72, #80, #15];
        if numonly[itempos] then
        	accepted := ['0'..'9']
        else
        	accepted := [#32..#255];
      	sans[itempos] := Ask(BarLeft+items[itempos], ans, len[itempos], sans[itempos]);
        DoBar(itempos);
        if (key = #0) and (ext = #0) then
					mkey := #13
				else
          mkey := key;
      end
      else
      begin
      	mkey := UpCase(ReadKey);
        if mkey = space then
        begin
        	bans[itempos] := not bans[itempos];
        end;
    	end;
      if mkey = #0 then
      begin
        if iss[itempos] = true then
        	mkey := ext
        else
	      	mkey := ReadKey;
        case mkey of
        	#71: itempos := 1;
          #72, #15: if itempos < 2 then
          			itempos := knum
          		else
              	Dec(itempos);
        	#79: itempos := knum;
          #80: if itempos > (knum-1) then
          			itempos := 1
          		else
              	Inc(itempos);
        end;
        if mkey in eset then
        begin
        	Ok := true;
          returnedkey := mkey;
          extended := true;
        end;
      end
      else if mkey = #9 then
      begin
        if itempos > (knum-1) then
        	itempos := 1
        else
          Inc(itempos);
      end
      else if UpCase(mkey) in kset then
      begin
      	returnedkey := mkey;
        extended := false;
      	Ok := true;
      end;
    until Ok;
    NewChoices;
    DoBar(itempos);
    if RemoveAfter then RemoveWindow;
	end;

procedure ColorsObj.Init(bof, bob, txf, txb, hif, hib, baf, bab, cx, cy: byte);
  var
  	c: byte;
	begin
  	border := bof+bob*16; text := txf+txb*16;
    bar := baf+bab*16;
    hi := hif+hib*16;
    x := cx; 							y := cy;
    kset := [];
    eset := [];
    title := '';
    extended := false;
    returnedkey := #0;
    space := #32;
    RemoveAfter := true;
    anum := 255;
  end;

procedure ColorsObj.InitItem(cnum: byte; citem: string; ccans: byte);
	begin
  	items[cnum] := citem;
    cans[cnum] := ccans;
  end;

procedure ColorsObj.InitSample(cnum: byte; csample: string);
	begin
  	sample[cnum] := csample;
  end;

procedure ColorsObj.InitString(cs: string);
	begin
  	s := cs;
  end;

procedure ColorsObj.Menu(first: byte);
  var
  	itempos: byte;
    Ok: boolean;
    mkey: char;
    count: byte;
    long, longi, longa: byte;
    c2: byte;

	function Length2(s: string): byte;
  	var
    	c: byte;
      tmp: byte;
    begin
      tmp := 0;
      if Length(s) > 0 then
    	for c := 1 to Length(s) do
      begin
        if not (s[c] in ['{', '}']) then
					Inc(tmp);
			end;
			Length2 := tmp;
    end;

  function Length3(s: string): byte;
  	var
    	c, tmp: byte;
    begin
    	tmp := 0;
      if Length(s) > 0 then
      	for c := 1 to Length(s) do
        begin
        	if not (s[c] in [#1..#10]) then
          	Inc(tmp);
        end;
      Length3 := tmp;
    end;

	function LongerItem: byte;
 		var
   		count: byte;
	    current: byte;
  	begin
   		current := 1;
	   	for count := 1 to knum do
  	  begin
    	  if Length(items[count]) > current then
	       	current := Length(items[count]);
  	  end;
      for count := 1 to snum do
      begin
      	if Length3(sample[count]) > current then
        	current := Length3(sample[count]);
      end;
    	LongerItem := current;
	  end;

  procedure Samples;
  	var
    	count, incount: byte;
  	begin
    	for count := 1 to snum do
      begin
      	GotoXY(1, count);
        Color(text);
        ClrEol;
        Write(' ');
        if Length(sample[count]) > 0 then
	        for incount := 1 to Length(sample[count]) do
          begin
          	if sample[count, incount] in [#1..#9] then
							TextAttr := cans[Ord(sample[count, incount])]
            else
            	Write(sample[count, incount]);
          end;
      end;
    end;

  procedure NewChoices;
  	begin
      Color(text);
		  GotoXY(1, snum+lastone);
		  Write(' '+items[lastone]);
      Write(StringOf(long-Length(items[lastone]), ' '));
      WriteCh(' ');
    end;

	procedure Choices;
    var
    	lng: byte;
		begin
      c2 := 0;
      Color(text);
      ClrScr;
      Samples;
      Color(text);
      lng := Length2(s);
      if lng > 0 then
      begin
        GotoXY(((long) div 2)-(lng div 2)+2, snum+knum+1);
        while c2 < Length(s) do
        begin
          Inc(c2);
          if s[c2] = '{' then
          	Color(hi)
          else if s[c2] = '}' then
          	Color(text)
          else
	        	Write(s[c2]);
        end;
      end;
		end;

  procedure DoBar(n: byte);
  	begin
    	GotoXY(1, n+snum);
      Color(bar);
      Write(BarLeft);
      Write(items[n]);
      Write(StringOf(long-Length(items[n]), ' '));
      WriteCh(BarRight);
    end;

	begin
    Cursor(off);
    long := LongerItem;
    if Length(title) > long then
    	long := Length(title);
    if Length2(s) > long then
    	long := Length2(s);
    Ok := false;
    Extended := false;
    returnedkey := #0;
    if x = 0 then
    	x := 40-((Long+4) div 2);
    MakeWindow(x, y, x+long+3, y+knum+snum+2, border mod 16, border div 16, bt(BorderChar), title);
    itempos := first;
    Choices;
    lastone := 0;
    repeat
      Inc(lastone);
     	NewChoices;
    until lastone = knum;
    repeat
      Cursor(off);
      NewChoices;
      lastone := itempos;
      DoBar(itempos);
     	mkey := UpCase(ReadKey);
      if mkey = #0 then
      begin
      	mkey := ReadKey;
        case mkey of
        	#71: itempos := 1;
          #72, #15: if itempos < 2 then
          			itempos := knum
          		else
              	Dec(itempos);
        	#79: itempos := knum;
          #80: if itempos > (knum-1) then
          			itempos := 1
          		else
              	Inc(itempos);
          #75: if cans[itempos] > 0 then
                Dec(cans[itempos])
               else
                cans[itempos] := anum;
          #77: if cans[itempos] < anum then
                Inc(cans[itempos])
               else
                cans[itempos] := 0;
          #73: if cans[itempos] < anum-16 then
                Inc(cans[itempos], 16)
               else
                cans[itempos] := 16 - (anum-cans[itempos]) - 1;
          #81: if cans[itempos] > 16 then
          		  Dec(cans[itempos], 16)
          		 else
                cans[itempos] := anum - 16 + cans[itempos] + 1;
        end;
        if mkey in [#75, #77, #73, #81] then
	        Samples;
        if mkey in eset then
        begin
        	Ok := true;
          returnedkey := mkey;
          extended := true;
        end;
      end
      else if mkey = #9 then
      begin
      	if itempos > (knum-1) then
        	itempos := 1
        else
        	Inc(itempos);
      end
      else if UpCase(mkey) in kset then
      begin
      	returnedkey := mkey;
        extended := false;
      	Ok := true;
      end;
    until Ok;
    NewChoices;
    DoBar(itempos);
    if RemoveAfter then RemoveWindow;
	end;

procedure OneLineObj.Init(txf, txb, hif, hib, baf, bab: byte;
    							     cx1, cx2, cy: byte; high: boolean);

  var
  	c: byte;
	begin
    text := txf+txb*16;
    hi := hif+hib*16;
    bar := baf+bab*16;
    x1 := cx1; x2 := cx2;
    y := cy;
    hilite := high;
    esc := #27;
    eset := [];
    kset := [];
    removeafter := true;
    for c := 1 to 15 do
    	under[c] := false;
  end;


procedure OneLineObj.InitItem(cnum: byte; citem: string; cks: char;
                           ckpos: byte; cunder: boolean);

	begin
  	items[cnum] := citem;
    ks[cnum]    := cks;
    kpos[cnum]  := ckpos;
    under[cnum] := cunder;
  end;


procedure OneLineObj.Menu(first: byte);

  var
  	itempos: byte;
    Ok: boolean;
    ok2: boolean;
    ckey, ekey: char;
    count: byte;
    frommenu: boolean;

  procedure NewChoices;
    var
      b:byte;
    	count2: byte;
      found: boolean;
  	begin
      found := false;
      Color(text);
		  GotoXY(kpos[lastone], 1);
		  Write(' ');
      for count2 := 1 to Length(items[lastone]) do
      begin
       	if (UpCase(items[lastone][count2]) = UpCase(ks[lastone])) and (hilite) and (not found) then
        begin
         	Color(hi);
          Write(items[lastone][count2]);
          Color(text);
          found := true;
        end
        else
         	Write(items[lastone][count2]);
      end;
      WriteCh(' ');
    end;

	procedure Choices;
		begin
      Color(text);
      ClrScr;
		end;

  procedure DoBar(n: byte);
  	begin
    	GotoXY(kpos[n], 1);
      Color(bar);
      Write(BarLeft);
      Write(items[n]);
      WriteCh(BarRight);
    end;

	begin
    Cursor(off);
    Ok := false;
    ok2 := false;
    frommenu := false;
    Extended := false;
    returnedkey := #0;
    MakeWindow(x1, y, x2, y, text mod 16, text div 16, none, '');
    itempos := first;
    Choices;
    lastone := 0;
    repeat
      Inc(lastone);
     	NewChoices;
    until lastone = knum;
    repeat
	    NewChoices;
  	  DoBar(itempos);
      if under[itempos] then
      begin
	      with kmenu[itempos] do
  	    begin
    	  	kset := kset + [esc];
      	  eset := eset + [#75, #77];
        	removeafter := true;
        end;
        kmenu[itempos].eset := kmenu[itempos].eset + eset;
	      kmenu[itempos].Menu(kmenu[itempos].lastone);
        frommenu := true;
        ok2 := true;
      end
      else
      	frommenu := false;
      ckey := #0;
      ekey := #0;
      if (under[itempos]) and (ok2) then
      begin
        if not kmenu[itempos].extended then
        begin
         	ckey := kmenu[itempos].choice;
          returnedkey := kmenu[itempos].returnedkey;
          extended := false;
        end
        else
        begin
         	ckey := #0;
          ekey := kmenu[itempos].returnedkey;
          extended := true;
          returnedkey := kmenu[itempos].returnedkey;
        end;
      end
      else
      begin
        DoBar(itempos);
      	ckey := ReadKey;
        if ckey = #0 then
        	ekey := ReadKey;
      end;
      ok2 := true;
      NewChoices;
      lastone := itempos;
      DoBar(itempos);
      if ckey = #0 then
      begin
        case ekey of
          #75: if itempos < 2 then
          			itempos := knum
          		else
              	Dec(itempos);
          #77: if itempos > (knum-1) then
          			itempos := 1
          		else
              	Inc(itempos);
        end;
        if ekey in eset then
        begin
        	Ok := true;
          returnedkey := ekey;
          ckey := ks[itempos];
          extended := true;
        end;
      end
      else if ckey = #13 then
      begin
        if not frommenu then
					ckey := ks[itempos];
        Ok := true;
      end
      else if ckey = esc then
      begin
      	if not frommenu then
        	ckey := ks[itempos];
        Ok := true;
        Returnedkey := esc;
      end
      else if (UpCase(ckey) in kset) or (frommenu) then
      begin
        if (not frommenu) then
				for count := 1 to knum do
        	if UpCase(ks[count]) = UpCase(ckey) then
          	itempos := count;
        if not extended then returnedkey := ckey;
      	Ok := true;
      end;
    until Ok;
    whatmenu := itempos;
    if RemoveAfter then RemoveWindow;
    choice := ckey;
  end;


procedure ScrollObj.Init(bof, bob, txf, txb, hif, hib, baf, bab: byte;
      							     cx, cy1, cy2: byte);
	begin
    border := bof+bob*16;
    text := txf+txb*16;
    hi := hif+hib*16;
    bar := baf+bab*16;
    x := cx;
    y1 := cy1;
    y2 := cy2;
    title := '';
    kset := [];
    eset := [];
    removeafter := true;
  end;


procedure ScrollObj.InitItem(cnum: byte; citem: string);

	begin
  	items[cnum] := citem;
  end;


procedure ScrollObj.Menu(first: byte; cupper: byte);

  var
  	itempos: byte;
    Ok: boolean;
    mkey: char;
    count: byte;
    long: byte;
    redraw: boolean;

	function Longer: byte;
 		var
   		count: byte;
	    current: byte;
  	begin
   		current := Length(title);
	   	for count := 1 to knum do
  	  begin
    	  if Length(items[count]) > current then
	       	current := Length(items[count]);
  	  end;
    	Longer := current;
	  end;

  procedure NewChoices;
    var
      b:byte;
    	count2: byte;
      found: boolean;
  	begin
      found := false;
      Color(text);
		  Write(' ');
      items[lastone] := items[lastone] + StringOf(long-Length(items[lastone]), ' ');
      Write(items[lastone]);
      WriteCh(' ');
    end;

	procedure Choices;
		begin
      Window(x, y1, x+long+3, y2);
      Color(border);
      GotoXY(long+4, 2);
      Write(ScrollUpChar);
      GotoXY(long+4, y2-y1);
      Write(ScrollDownChar);
	    Window(x+1, y1+1, x+long+2, y2-1);
      Color(text);
      ClrScr;
		end;

  procedure DoBar(n: byte);
  	begin
    	GotoXY(1, n-upper+1);
      Color(bar);
      Write(BarLeft);
      Write(items[n]);
      WriteCh(BarRight);
    end;

  procedure AllMenu(f: byte);
	  var
			save: byte;
  	begin
	    Choices;
  	  save := lastone;
    	lastone := f-1;
	    repeat
  	    Inc(lastone);
    	  GotoXY(1, lastone-upper+1);
     		NewChoices;
	    until (lastone = knum) or (lastone-upper+1 = y2-y1-1);
  	  lastone := save;
	  end;

	begin
    Cursor(off);
    long := Longer;
    Ok := false;
    Extended := false;
    returnedkey := #0;
    if x = 0 then
    	x := 40-((Longer+4) div 2);
    MakeWindow(x, y1, x+long+3, y2, border mod 16, border div 16, bt(BorderChar), title);
    itempos := first;
    lastone := first;
    upper := cupper;
    Choices;
    AllMenu(upper);
    repeat
      redraw := false;
      lastone := itempos;
      DoBar(itempos);
    	mkey := UpCase(ReadKey);
      if mkey = #0 then
      begin
      	mkey := ReadKey;
        case mkey of
        	#71:
						begin
							itempos := 1;
              upper := 1;
              redraw := true;
            end;
          #72:
            if itempos > 1 then
            begin
             	Dec(itempos);
              if (itempos-upper+1 < 1) then
              begin
								redraw := true;
                Dec(upper);
              end;
						end;
        	#79:
						begin
							itempos := knum;
              upper := knum;
              redraw := true;
            end;
          #80:
            if itempos < knum then
            begin
             	Inc(itempos);
              if (itempos-upper+1 > y2-y1-1) then
              begin
              	Inc(upper);
								redraw := true;
              end;
						end;
          #73: {pgup}
          	begin
            	if (itempos > y2-y1-1) then
              begin
                itempos := itempos-(y2-y1-1);
                upper := upper-(y2-y1-1);
                if upper < 1 then upper := 1;
              end
              else
              begin
              	itempos := 1;
                upper := 1;
              end;
              redraw := true;
            end;
          #81: {pgdn}
          	begin
            	if (itempos < knum-(y2-y1-1)) then
              begin
                itempos := itempos+(y2-y1-1);
                upper := upper+(y2-y1-1);
              end
              else
              begin
              	itempos := knum;
                upper := knum;
              end;
              redraw := true;
            end;
        end;
        if mkey in eset then
        begin
        	Ok := true;
          returnedkey := mkey;
          extended := true;
        end;
      end
      else if mkey = #13 then
      begin
        Ok := true;
      end
      else if UpCase(mkey) in kset then
      begin
      	returnedkey := mkey;
      	Ok := true;
      end;
      if redraw then AllMenu(upper)
      else
      begin
	      GotoXY(1, lastone-upper+1);
  	    NewChoices;
      end;
    until Ok;
    DoBar(itempos);
    if RemoveAfter then RemoveWindow;
    itemchosen := itempos;
  end;


procedure ScrollObj.Sort;
	var
  	c1, c2, lower: byte;
    tmp: string;
	begin
    for c1 := 1 to knum-1 do
    begin
    	lower := c1;
      for c2 := c1+1 to knum do
      begin
      	if UpCaseStr(items[c2]) < UpCaseStr(items[lower]) then lower := c2;
      end;
			tmp := items[lower];
      items[lower] := items[c1];
      items[c1] := tmp;
    end;
  end;

procedure AnsFieldObj.Init(bof, bob, txf, txb, anf, anb, cx, cy: byte);
	begin
  	border := bof+bob*16;
    text   := txf+txb*16;
    ans    := anf+anb*16;
    s := '';
    esc := #27;
    kset := [esc];
    eset := [];
    returnedkey := #0;
    extended := false;
    x := cx;
    y := cy;
    removeafter := true;
    maskchar := #0;
  end;

procedure AnsFieldObj.InitQuestion(cq: string; clen: byte);
	begin
  	q := cq;
    len := clen;
  end;

procedure AnsFieldObj.InitString(cs: string);
	begin
  	s := cs;
  end;

procedure AnsFieldObj.Ask;
	begin
    Mask := maskchar;
    Cr := false;
    SetCursor(1543);
    EraseKey := ^Y#0;
  	KeySet := kset;
    ExtSet := eset;
    if x = 0 then
    	x := 40-((len+Length(q)+3) div 2);
    MakeWindow(x, y, x+3+len+Length(q), y+2, border mod 16, border div 16, bt(BorderChar), title);
    Color(text);
    ClrScr;
    Write(' ');
    s := Answer.Ask(q, ans, len, s);
    if Key <> #0 then
    begin
    	returnedkey := Key;
      extended := false;
    end
    else
    begin
    	returnedkey := Ext;
      if Ext <> #0 then extended := true;
    end;
		if removeafter then RemoveWindow;
  end;


procedure ProgressBarObj.Init(bof, bob, txf, txb, baf, bab, cx, cy: byte);
	begin
    title := '';
  	border := bof+bob*16;
    text   := txf+txb*16;
    bar    := baf+bab*16;
    x := cx; y := cy;
    removeafter := true;
  end;

procedure ProgressBarObj.InitBar(cnum: byte; cb: string; cbval: byte);
	begin
    b[cnum] := cb;
    bval[cnum] := cbval;
  end;

procedure ProgressBarObj.ProgressBar(update: boolean);

  var
  	long, lng: byte;
    c, c2: byte;
    ckey: char;
    ok: boolean;

	function Longer: byte;
 		var
   		count: byte;
	    current: byte;
      other: byte;
  	begin
   		current := blen;
	   	for count := 1 to bnum do
  	  begin
        other := Length(b[count]);
    	  if other > current then
	       	current := other;
  	  end;
    	Longer := current;
	  end;

	begin
    Cursor(off);
    long := Longer;
    if not update then
    begin
  	  if x = 0 then
    		x := 40-((long+3) div 2);
	  	MakeWindow(x, y, x+long+3, y+1+bnum*2, border mod 16, border div 16, bt(BorderChar), title);
    end
    else
    	GotoXY(1, 1);
    for c := 1 to bnum do
  	begin
      c2 := 0;
      lng := Length(b[c]);
      Color(text);
      ClrEol;
      if lng > 0 then
      begin
        GotoXY(((long) div 2)-(lng div 2)+2, WhereY);
        Writeln(b[c]);
      end;
      GotoXY((long div 2)-(blen div 2)+2, WhereY);
      Color(bar);
      lng := Round((bval[c] / 100) * blen);
      Write(StringOf(lng, ProgressBarChar)+StringOf(blen-lng, ' '));
      if c < bnum then Writeln;
    end;
	  if removeafter then RemoveWindow;
  end;


procedure MessageObj.Init(bof, bob, txf, txb, hif, hib, cx, cy: byte);
	begin
    title := '';
  	border := bof+bob*16;
    text   := txf+txb*16;
    hi     := hif+hib*16;
    x := cx; y := cy;
    removeafter := true;
    wait := true;
    kset := [#13, #27];
    eset := [];
  end;

procedure MessageObj.InitString(cnum: byte; cs: string);
	begin
    s[cnum] := cs;
  end;

procedure MessageObj.Message;

  var
  	long, lng: byte;
    c, c2: byte;
    ckey: char;
    ok: boolean;

	function Length2(s: string): byte;
  	var
    	c: byte;
      tmp: byte;
    begin
      tmp := 0;
      if Length(s) > 0 then
    	for c := 1 to Length(s) do
      begin
        if not (s[c] in ['{', '}']) then
					Inc(tmp);
			end;
			Length2 := tmp;
    end;

	function Longer: byte;
 		var
   		count: byte;
	    current: byte;
      other: byte;
  	begin
   		current := 0;
	   	for count := 1 to snum do
  	  begin
        other := Length2(s[count]);
    	  if other > current then
	       	current := other;
  	  end;
    	Longer := current;
	  end;

	begin
    returnedkey := #0;
    extended := false;
    Cursor(off);
    long := Longer;
    if x = 0 then
    	x := 40-((long+3) div 2);
  	MakeWindow(x, y, x+long+3, y+1+snum, border mod 16, border div 16, bt(BorderChar), title);
    Color(text);
    for c := 1 to snum do
  	begin
      c2 := 0;
      lng := Length2(s[c]);
      if lng > 0 then
      begin
        GotoXY(((long) div 2)-(lng div 2)+2, WhereY);
        while c2 < Length(s[c]) do
        begin
          Inc(c2);
          if s[c, c2] = '{' then
          	Color(hi)
          else if s[c, c2] = '}' then
          	Color(text)
          else
	        	Write(s[c, c2]);
        end;
      end;
      if c < snum then Writeln;
    end;
  	ok := false;
	  if wait then
  		repeat
    		ckey := ReadKey;
	      if ckey = #0 then
  	    begin
    	  	ckey := ReadKey;
      	  if ckey in eset then
          begin
        		Ok := true;
            returnedkey := ckey;
            extended := true;
          end;
	      end
  	    else if ckey in kset then
        begin
    	  	Ok := true;
          returnedkey := ckey;
          extended := false;
        end;
	    until Ok;
	  if removeafter then RemoveWindow;
  end;

procedure WinbarObj.Init(bof, bob, txf, txb, hif, hib, cx1, cy1, cx2, cy2: byte);
	begin
    border := bof+bob*16;
  	text := txf+txb*16;
    hi := hif+hib*16;
    x1 := cx1;
    x2 := cx2;
    y1 := cy1;
    y2 := cy2;
    s := '';
  end;

procedure WinBarObj.InitString(cs: string);
	begin
  	s := cs;
  end;

procedure WinBarObj.Bar;
	var
  	c2: byte;
	function Length2(s: string): byte;
  	var
    	c: byte;
      tmp: byte;
    begin
      tmp := 0;
      if Length(s) > 0 then
    	for c := 1 to Length(s) do
      begin
        if not (s[c] in ['{', '}']) then
					Inc(tmp);
			end;
			Length2 := tmp;
    end;
	begin
    MakeWindow(x1, y1, x2, y2, border mod 16, border div 16, bt(BorderChar), '');
    c2 := 0;
    if Length(s) > 0 then
    begin
      GotoXY(((x2-x1+1) div 2)-(Length2(s) div 2), WhereY);
      while c2 < Length(s) do
      begin
        Inc(c2);
        if s[c2] = '{' then
        	Color(hi)
        else if s[c2] = '}' then
         	Color(text)
        else
        	Write(s[c2]);
      end;
    end;
  end;

procedure BarObj.Init(txf, txb, hif, hib, cx1, cx2, cy: byte);
	begin
  	text := txf+txb*16;
    hi := hif+hib*16;
    x1 := cx1;
    x2 := cx2;
    y := cy;
    s := '';
    center := true;
  end;

procedure BarObj.InitString(cs: string);
	begin
  	s := cs;
  end;

procedure BarObj.Bar;
	var
  	c2: byte;
	function Length2(s: string): byte;
  	var
    	c: byte;
      tmp: byte;
    begin
      tmp := 0;
      if Length(s) > 0 then
    	for c := 1 to Length(s) do
      begin
        if not (s[c] in ['{', '}']) then
					Inc(tmp);
			end;
			Length2 := tmp;
    end;
	begin
    MakeWindow(x1, y, x2, y, text mod 16, text div 16, none, '');
    c2 := 0;
    if Length(s) > 0 then
    begin
      if center then
	      GotoXY(((x2-x1+1) div 2)-(Length2(s) div 2), WhereY)
      else
      	GotoXY(1, WhereY);
      while c2 < Length(s) do
      begin
        Inc(c2);
        if s[c2] = '{' then
        	Color(hi)
        else if s[c2] = '}' then
         	Color(text)
        else
        	Write(s[c2]);
      end;
    end;
  end;

procedure DesktopObj.Init(df, db, shad: byte);
	begin
  	desk := df+db*16;
    shadow := shad;
  end;

procedure DesktopObj.Desktop;
	begin
    MakeWindow(1, 1, 80, 25, desk mod 16, desk div 16, none, '');
  	BMDat.MkDesktop(desk, shadow);
  end;

procedure DoWindow(x1, y1, x2, y2, cf, cb: byte; title: string);
	begin
  	MakeWindow(x1, y1, x2, y2, cf, cb, bt(BorderChar), title);
  end;

procedure DoScreen(x1, y1, x2, y2, cf, cb: byte);
	begin
  	MakeWindow(x1, y1, x2, y2, cf, cb, none, '');
  end;

begin
	BarLeft := ' ';
  BarRight := ' ';
  Check[true]  := '';
  Check[false] := '';
  CheckLeft := '[';
  CheckRight := ']';
  BorderChar := 2;
  ProgressBarChar := '';
  ScrollUpChar := #24;
  ScrollDownChar := #25;
end.
