UNIT scrnunit;

{$R-,S-,I-,D-,V-,B-}

INTERFACE

USES DOS,CRT;

{$L scrn.obj}

CONST maxwindows=20;

TYPE dataarearec=RECORD
                   scrnseg,
                   filter,
                   wchattr,
                   wch,
                   wattr,
                   rchattr,
                   scrnwid,
                   dubscrnwid,
                   numwindows,
                   curwindow,
                   beepduration,
                   beepfrequency,
                   realcursortrack:INTEGER;
                   windul,
                   windlr,
                   windulptr,
                   windsize,
                   windcursor,
                   windcptr,
                   windattr:ARRAY [1..maxwindows] OF INTEGER
                 END;

  block=RECORD
          X1,Y1,X2,Y2:BYTE
        END;

  window=RECORD
           handle,index,
           X1,Y1,X2,Y2,xsize,ysize,
           titlecolor,framecolor,normalcolor,
           boldcolor,datacolor,choicecolor,barcolor,inputcolor,
           imagesize:INTEGER;
           imageptr:POINTER;
           title:STRING[80]
         END;

  WindowPtr=^window;

  jointtype=(vertleft,vertright,horizup,horizdown,cross);

VAR scrn:TEXT;           { Accessed by SCRN.ASM }
  darea:dataarearec;   { Accessed by SCRN.ASM }
  w1,w2:window; { some neat shit I think }
  wholescreen:window;
  curwindowptr:WindowPtr;

PROCEDURE initscrnunit;
PROCEDURE setblock (VAR B:block; X1,Y1,X2,Y2:INTEGER);
PROCEDURE pushcurwindow;
PROCEDURE popcurwindow;
PROCEDURE pushdarea;       { DON'T DO pusdarea; movewindow; popdarea!!!! }
PROCEDURE popdarea;
PROCEDURE setcurwindow (VAR w:window);
PROCEDURE openwindow (VAR w:window; X1,Y1,X2,Y2,framecolor,normalcolor:INTEGER);
PROCEDURE windowtitle (title:STRING);
PROCEDURE closewindow;
PROCEDURE movewindow (nx,ny:INTEGER);
PROCEDURE reshapewindow (X1,Y1,X2,Y2:INTEGER);
PROCEDURE GotoXY (X,Y:INTEGER);
PROCEDURE drawjoint (X,Y:INTEGER; jt:jointtype);
FUNCTION  WhereX:INTEGER;
FUNCTION  WhereY:INTEGER;
FUNCTION  curcolor:INTEGER;
PROCEDURE colorregion (X1,X2,Y,Attr:INTEGER);
PROCEDURE clreol;
PROCEDURE clrscr;
PROCEDURE setfilter (filtersnow:BOOLEAN);
PROCEDURE setcursortracking (realtrack:BOOLEAN);
PROCEDURE fillblock (B:block; Ch:CHAR; A:INTEGER);
PROCEDURE clearblock (B:block; A:INTEGER);
PROCEDURE colorblock (B:block; A:INTEGER);
PROCEDURE frameblock (B:block; A:INTEGER);
PROCEDURE scrupblock (B:block; A:INTEGER);
PROCEDURE scrdnblock (B:block; A:INTEGER);
PROCEDURE readblock (B:block; VAR buffer);
PROCEDURE writeblock (B:block; VAR buffer);
PROCEDURE fillwindow (Ch:CHAR; A:INTEGER);
PROCEDURE clearwindow (A:INTEGER);
PROCEDURE colorwindow (A:INTEGER);
PROCEDURE framewindow (A:INTEGER);
PROCEDURE scrupwindow (A:INTEGER);
PROCEDURE scrdnwindow (A:INTEGER);
PROCEDURE readwindow (VAR buffer);
PROCEDURE writewindow (VAR buffer);
PROCEDURE setcolor (Attr:INTEGER);
PROCEDURE movecsr;
FUNCTION initwindow(X1,Y1,X2,Y2:INTEGER):INTEGER;

IMPLEMENTATION

CONST windowstacksize=50;
  dareastacksize=50;
  jointchars:ARRAY [vertleft..cross] OF CHAR=(#180,#195,#193,#194,#197);

TYPE dareaptr=^dataarearec;

VAR windowstack:ARRAY [0..windowstacksize] OF WindowPtr;
  windowstackptr:INTEGER;
  dareastack:ARRAY [1..dareastacksize] OF dareaptr;
  dareastackcwp:ARRAY [1..dareastacksize] OF WindowPtr;
  dareastackptr:INTEGER;

{$F+}
  PROCEDURE setfilter (filtersnow:BOOLEAN); EXTERNAL;
  PROCEDURE setcursortracking (realtrack:BOOLEAN); EXTERNAL;
  PROCEDURE fillblock (B:block; Ch:CHAR; A:INTEGER); EXTERNAL;
  PROCEDURE clearblock (B:block; A:INTEGER); EXTERNAL;
  PROCEDURE colorblock (B:block; A:INTEGER); EXTERNAL;
  PROCEDURE frameblock (B:block; A:INTEGER); EXTERNAL;
  PROCEDURE scrupblock (B:block; A:INTEGER); EXTERNAL;
  PROCEDURE scrdnblock (B:block; A:INTEGER); EXTERNAL;
  PROCEDURE readblock (B:block; VAR buffer); EXTERNAL;
  PROCEDURE writeblock (B:block; VAR buffer); EXTERNAL;
  PROCEDURE fillwindow (Ch:CHAR; A:INTEGER); EXTERNAL;
  PROCEDURE clearwindow (A:INTEGER); EXTERNAL;
  PROCEDURE colorwindow (A:INTEGER); EXTERNAL;
  PROCEDURE framewindow (A:INTEGER); EXTERNAL;
  PROCEDURE scrupwindow (A:INTEGER); EXTERNAL;
  PROCEDURE scrdnwindow (A:INTEGER); EXTERNAL;
  PROCEDURE readwindow (VAR buffer); EXTERNAL;
  PROCEDURE writewindow (VAR buffer); EXTERNAL;
  PROCEDURE setcolor (Attr:INTEGER); EXTERNAL;
  PROCEDURE movecsr; EXTERNAL;

  PROCEDURE initscrn; EXTERNAL;    {These aren't public}
  PROCEDURE setwindow (X1,Y1,X2,Y2:INTEGER); EXTERNAL;
  PROCEDURE movexy (X,Y:INTEGER); EXTERNAL;
  FUNCTION  initwindow (X1,Y1,X2,Y2:INTEGER):INTEGER; EXTERNAL;
  PROCEDURE killwindow; EXTERNAL;

{$F+}

  PROCEDURE setblock (VAR B:block; X1,Y1,X2,Y2:INTEGER);
  BEGIN
  B.X1:=X1;
  B.Y1:=Y1;
  B.X2:=X2;
  B.Y2:=Y2
  END;

  PROCEDURE setcurwindow (VAR w:window);
  BEGIN
  darea.curwindow:=w.handle;
  curwindowptr:=@w;
  IF darea.realcursortrack<>0 THEN movecsr
  END;

  PROCEDURE pushcurwindow;
  BEGIN
  IF windowstackptr>=windowstacksize THEN BEGIN
  WRITELN ('Too many pushed windows');
  HALT (1)
  END;
  INC (windowstackptr);
  windowstack[windowstackptr]:=curwindowptr
  END;

  PROCEDURE popcurwindow;
  BEGIN
  setcurwindow (windowstack[windowstackptr]^);
  IF windowstackptr>0 THEN DEC (windowstackptr)
  END;

  PROCEDURE pushdarea;
  BEGIN
  IF dareastackptr>=dareastacksize THEN BEGIN
  WRITELN ('Too many pushed data areas');
  HALT (1)
  END;
  INC (dareastackptr);
  NEW (dareastack[dareastackptr]);
  dareastack[dareastackptr]^:=darea;
  dareastackcwp[dareastackptr]:=curwindowptr
  END;

  PROCEDURE popdarea;
  BEGIN
  IF dareastackptr>0 THEN BEGIN
  darea:=dareastack[dareastackptr]^;
  curwindowptr:=dareastackcwp[dareastackptr];
  DISPOSE (dareastack[dareastackptr]);
  DEC (dareastackptr);
  END
  END;

  PROCEDURE setwindowcoors (nx1,ny1,nx2,ny2:INTEGER);
  BEGIN
  WITH curwindowptr^ DO BEGIN
  setwindow (nx1,ny1,nx2,ny2);
  X1:=nx1;
  Y1:=ny1;
  X2:=nx2;
  Y2:=ny2;
  xsize:=nx2-nx1-1;
  ysize:=ny2-ny1-1;
  imagesize:=(xsize+2)*(ysize+2)*2
  END
  END;

  PROCEDURE openwindow (VAR w:window; X1,Y1,X2,Y2,framecolor,normalcolor:INTEGER);
  BEGIN
  pushcurwindow;
  X1:=X1-1;
  Y1:=Y1-1;
  X2:=X2-1;
  Y2:=Y2-1;
  w:=wholescreen;
  w.handle:=initwindow (X1,Y1,X2,Y2);
  setcurwindow (w);
  IF w.handle<0 THEN BEGIN
  WRITELN ('Too many opened windows');
  HALT (1)
  END;
  w.index:=(w.handle DIV 2)+1;
  setwindowcoors (X1,Y1,X2,Y2);
  w.framecolor:=framecolor;
  w.normalcolor:=normalcolor;
  GETMEM (w.imageptr,w.imagesize);
  readwindow (w.imageptr^);
  framewindow (framecolor);
  clearwindow (normalcolor)
  END;

  PROCEDURE windowtitle (title:STRING);
  BEGIN
  pushdarea;
  movexy (1,0);
  setcolor (curwindowptr^.titlecolor);
  curwindowptr^.title:=title;
  WRITE (scrn,COPY(title,1,curwindowptr^.xsize));
  popdarea
  END;

  PROCEDURE closewindow;
  VAR w:WindowPtr;
  BEGIN
  w:=curwindowptr;
  IF w^.handle=0 THEN EXIT;
  writewindow (w^.imageptr^);
  FREEMEM (w^.imageptr,w^.imagesize);
  killwindow;
  w^.handle:=0;
  popcurwindow
  END;

{$S+}

  PROCEDURE reshapewindow (X1,Y1,X2,Y2:INTEGER);
  VAR contblock:block;
    contents:ARRAY[1..4096] OF BYTE;
    nxs,nys,cx2,cy2:INTEGER;
    w:WindowPtr;
  BEGIN
  X1:=X1-1;
  Y1:=Y1-1;
  X2:=X2-1;
  Y2:=Y2-1;
  w:=curwindowptr;
  nxs:=X2-X1-1;
  nys:=Y2-Y1-1;
    IF nxs<w^.xsize THEN cx2:=nxs ELSE cx2:=w^.xsize;
    IF nys<w^.ysize THEN cy2:=nys ELSE cy2:=w^.ysize;
  setblock (contblock,0,0,cx2,cy2);
  readblock (contblock,contents);
  writewindow (w^.imageptr^);
  FREEMEM (w^.imageptr,w^.imagesize);      { Old window essentially closed }
  setwindowcoors (X1,Y1,X2,Y2);
  GETMEM (w^.imageptr,w^.imagesize);
  readwindow (w^.imageptr^);
  framewindow (contents[2]);    { Use attribute from screen }
  clearwindow (w^.normalcolor);
  writeblock (contblock,contents)
  END;

{$S-}

  PROCEDURE movewindow (nx,ny:INTEGER);
  BEGIN
  WITH curwindowptr^ DO
    reshapewindow (nx,ny,nx+xsize+1,ny+ysize+1)
  END;

  PROCEDURE GotoXY (X,Y:INTEGER);
  BEGIN
  movexy (X,Y)
  END;

  PROCEDURE drawjoint (X,Y:INTEGER; jt:jointtype);
  BEGIN
  pushcurwindow;
  X:=X+curwindowptr^.X1;
  Y:=Y+curwindowptr^.Y1;
  setcurwindow (wholescreen);
  GotoXY (X,Y);
  WRITE (jointchars[jt]);
  popcurwindow
  END;

  FUNCTION WhereX:INTEGER;
  BEGIN
  WhereX:=LO(darea.windcursor[curwindowptr^.index])
  END;

  FUNCTION WhereY:INTEGER;
  BEGIN
  WhereY:=darea.windcursor[curwindowptr^.index] SHR 8
  END;

  FUNCTION curcolor:INTEGER;
  BEGIN
  curcolor:=darea.windattr[curwindowptr^.index]
  END;

  PROCEDURE colorregion (X1,X2,Y,Attr:INTEGER);
  VAR B:block;
  BEGIN
  setblock (B,X1,Y,X2,Y);
  colorblock (B,Attr)
  END;

  PROCEDURE clreol;
  VAR B:block;
    Y:INTEGER;
  BEGIN
  Y:=WhereY;
  setblock (B,WhereX,Y,curwindowptr^.xsize,Y);
  clearblock (B,curcolor)
  END;

  PROCEDURE clrscr;
  BEGIN
  clearwindow (curcolor);
  GotoXY (1,1)
  END;

  PROCEDURE initscrnunit;
  BEGIN
  initscrn;
  WITH wholescreen DO BEGIN
  handle:=0;
  index:=1;
  X1:=-1;
  Y1:=-1;
  X2:=darea.scrnwid;
  Y2:=25;
  xsize:=X2;
  ysize:=Y2;
  titlecolor:=$70;
  framecolor:=7;
  normalcolor:=7;
  boldcolor:=15;
  choicecolor:=15;
  datacolor:=15;
  barcolor:=$70;
  inputcolor:=15;
  imagesize:=0;
  imageptr:=NIL
  END;
  dareastackptr:=0;
  windowstackptr:=0;
  windowstack[0]:=@wholescreen;
  curwindowptr:=@wholescreen;
  WITH textrec(OUTPUT) DO BEGIN
  inoutfunc:=textrec(scrn).inoutfunc;
  flushfunc:=textrec(scrn).flushfunc
  END
  END;

BEGIN
initscrnunit
END.
