{--------------------------------------------------------------------------}
{                         TechnoJock's Turbo Toolkit                       }
{                                                                          }
{                              Version   5.01                              }
{                                                                          }
{                                                                          }
{              Copyright 1986, 1989 TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                     {--------------------------------}                                       
                     {       Unit:  FastTTT5          }
                     {--------------------------------}


{$S-,R-,V-,D-}       

UNIT FastTTT5;

{Change history:  4/01/89 5.00a    Changed VertLine and Horizline
}

INTERFACE

USES DOS, CRT;

CONST
  MaxScreenStr = 80;
  FCol:BYTE = white;
  BCol:BYTE = black;
TYPE
  StrScreen = STRING[MaxScreenStr];
VAR
  BaseOfScreen : WORD;       {Base address of video memory}
  VSeg : WORD;               {Base address of active screen}
  VOfs : WORD;       {Base address of active screen}
  SnowProne : BOOLEAN;       {Check for snow on color cards?}
  Speed : LONGINT;           {delay factor for growbox routine}

FUNCTION  ColorScreen:BOOLEAN;
FUNCTION  Attr(F,B:BYTE):BYTE;
PROCEDURE FastWrite(Col,Row,Attr:BYTE; St:StrScreen);
PROCEDURE PlainWrite(Col,Row:BYTE; St:StrScreen);
PROCEDURE ColWrite(Col,Row:BYTE; St:StrScreen);
PROCEDURE FWrite(St:StrScreen);
PROCEDURE FWriteLN(St:StrScreen);
PROCEDURE Attrib(X1,Y1,X2,Y2,F,B:BYTE);
PROCEDURE Clickwrite(Col,Row,F,B:BYTE; St:StrScreen);
FUNCTION  Replicate(N:BYTE; Character:CHAR):StrScreen;
PROCEDURE Box(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
PROCEDURE FBox(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
PROCEDURE GrowFBox(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
PROCEDURE HorizLine(X1,X2,Y,F,B,lineType:BYTE);
PROCEDURE VertLine(X,Y1,Y2,F,B,lineType:BYTE);
PROCEDURE ClearText(X1,Y1,X2,Y2,F,B:INTEGER);
PROCEDURE ClearLine(Y,F,B:INTEGER);
PROCEDURE WriteAT(X,Y,F,B:INTEGER; St:StrScreen);
PROCEDURE WriteBetween(X1,X2,Y,F,B:BYTE; St:StrScreen);
PROCEDURE WriteCenter(LineNO,F,B:INTEGER; St:StrScreen);
PROCEDURE WriteVert(X,Y,F,B:INTEGER; St:StrScreen);
FUNCTION  EGAVGASystem: BOOLEAN;
PROCEDURE InitFastTTT;

IMPLEMENTATION

  {$L FASTTTT5}

  {$F+}
  PROCEDURE FastWrite(Col,Row,Attr:BYTE; St:StrScreen); EXTERNAL;
  PROCEDURE PlainWrite(Col,Row:BYTE; St:StrScreen); EXTERNAL;
  PROCEDURE Attribute(Col,Row,Attr:BYTE; Number:WORD); EXTERNAL;
  {$F-}

  FUNCTION ColorScreen: BOOLEAN;
  {}
  BEGIN
  ColorScreen := (BaseOfScreen = $B800);
  END; {of func ColorScreen}

  FUNCTION Attr(F,B:BYTE):BYTE;
  {converts foreground(F) and background(B) colors to combined Attribute byte}
  BEGIN
  Attr := (B SHL 4) OR F;
  END;  {Func Attr}

  PROCEDURE ColWrite(Col,Row:BYTE; St:StrScreen);
  BEGIN
  FastWrite(Col,Row,Attr(FCol,BCol),St);
  END;

  PROCEDURE FWrite(St:StrScreen);
  VAR Col,Row : BYTE;
  BEGIN
  Col := WhereX;
  Row := WhereY;
  FastWrite(Col,Row,Attr(FCol,BCol),St);
  GotoXY(Col+LENGTH(St),Row);
  END;

  PROCEDURE FWriteLN(St:StrScreen);
  VAR Col,Row : BYTE;
  BEGIN
  Col := WhereX;
  Row := WhereY;
  FastWrite(Col,Row,Attr(FCol,BCol),St);
  GotoXY(1,SUCC(Row));
  END;

  

  PROCEDURE Attrib(X1,Y1,X2,Y2,F,B:BYTE);
  {changes color attrib at specified coords}
  VAR
    I,X,A : BYTE;
  BEGIN
  A := Attr(F,B);
  X := SUCC(X2-X1);
  FOR I := Y1 TO Y2 DO
    Attribute(X1,I,A,X);
  END; {Proc Attrib}


  PROCEDURE Clickwrite(Col,Row,F,B:BYTE; St:StrScreen);
  {writes text to the screen with a click!}
  VAR
    I : INTEGER;
    L,A : BYTE;
  BEGIN
  A := Attr(F,B);
  L := LENGTH(St);
  FOR I := L DOWNTO 1 DO
    BEGIN
    FastWrite(Col,Row,A,COPY(St,I,SUCC(L-I)));
    sound(500);delay(20);nosound;delay(30);
    END;
  END;

  FUNCTION Replicate(N : BYTE; Character:CHAR):StrScreen;
  {returns a string with Character repeated N times}
  VAR tempstr : StrScreen;
  BEGIN
  IF N = 0 THEN
    tempstr := ''
  ELSE
    BEGIN
    IF (N > 80) THEN
      N := 1;
    FILLCHAR(tempstr,N+1,Character);
    tempstr[0] := CHR(N);
    END;
  Replicate := tempstr;
  END;

  PROCEDURE ClearText(X1,Y1,X2,Y2,F,B:INTEGER);
  VAR
    Y : INTEGER;
    Attrib : BYTE;
  BEGIN
  IF X2 > 80 THEN X2 := 80;
  Attrib := Attr(F,B);
  FOR Y := Y1 TO Y2 DO
    FastWrite(X1,Y,Attrib,Replicate(X2-X1+1,' '));
  END;   {cleartext}

  PROCEDURE ClearLine(Y,F,B:INTEGER);
  BEGIN
  FastWrite(1,Y,Attr(F,B),Replicate(80,' '));
  END;

  PROCEDURE Box(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
  {Draws a box on the screen}
  VAR
    I:INTEGER;
    corner1,corner2,corner3,corner4,
    HorizLine,
    VertLine : CHAR;
    Attrib : BYTE;
  BEGIN
  CASE boxtype OF
    0:BEGIN
      corner1:=' ';
      corner2:=' ';
      corner3:=' ';
      corner4:=' ';
      HorizLine:=' ';
      VertLine:=' ';
      END;
    1:BEGIN
      corner1:='';
      corner2:='';
      corner3:='';
      corner4:='';
      HorizLine:='';
      VertLine:='';
      END;
    2:BEGIN
      corner1:='';
      corner2:='';
      corner3:='';
      corner4:='';
      HorizLine:='';
      VertLine:='';
      END;
    3:BEGIN
      corner1:='';
      corner2:='';
      corner3:='';
      corner4:='';
      HorizLine:='';
      VertLine:='';
      END;
    4:BEGIN
      corner1:='';
      corner2:='';
      corner3:='';
      corner4:='';
      HorizLine:='';
      VertLine:='';
      END;
    ELSE
      corner1:=CHR(ORD(boxtype));
    corner2:=CHR(ORD(boxtype));
    corner3:=CHR(ORD(boxtype));
    corner4:=CHR(ORD(boxtype));
    HorizLine:=CHR(ORD(boxtype));
    VertLine:=CHR(ORD(boxtype));
  END;{case}
  Attrib := Attr(F,B);
  FastWrite(X1,Y1,Attrib,corner1);
  FastWrite(X1+1,Y1,Attrib,Replicate(X2-X1-1,HorizLine));
  FastWrite(X2,Y1,Attrib,corner2);
  FOR I := Y1+1 TO Y2-1 DO
    BEGIN
    FastWrite(X1,I,Attrib,VertLine);
    FastWrite(X2,I,Attrib,VertLine);
    END;
  FastWrite(X1,Y2,Attrib,corner3);
  FastWrite(X1+1,Y2,Attrib,Replicate(X2-X1-1,HorizLine));
  FastWrite(X2,Y2,Attrib,corner4);
  END; {Proc Box}

  PROCEDURE FBox(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
  {Draws a box and clears text within Box frame}
  BEGIN
  Box(X1,Y1,X2,Y2,F,B,boxtype);
  ClearText(SUCC(X1),SUCC(Y1),PRED(X2),PRED(Y2),F,B);
  END;

  PROCEDURE GrowFBox(X1,Y1,X2,Y2,F,B,boxtype:INTEGER);
  {Draws exploding filled box!}
  VAR I,TX1,TY1,TX2,TY2,Ratio : INTEGER;
  BEGIN
  IF 2*(Y2 -Y1 +1) > X2 - X1 + 1 THEN
    Ratio :=   2
  ELSE
    Ratio :=  1;
  TX2 := (X2 - X1) DIV 2 + X1 + 2;
  TX1 := TX2 - 3;                 {needs a box 3 by 3 minimum}
  TY2 := (Y2 - Y1) DIV 2 + Y1 + 2;
  TY1 := TY2 - 3;
  IF (X2-X1) < 3 THEN
    BEGIN
    TX2 := X2;
    TX1 := X1;
    END;
  IF (Y2-Y1) < 3 THEN
    BEGIN
    TY2 := Y2;
    TY1 := Y1;
    END;
  REPEAT
    FBox(TX1,TY1,TX2,TY2,F,B,boxtype);
      IF TX1 >= X1 + (1*Ratio) THEN TX1 := TX1 - (1*Ratio) ELSE TX1 := X1;
    IF TY1 > Y1  THEN TY1 := TY1 - 1;
      IF TX2 + (1*Ratio) <= X2 THEN TX2 := TX2 + (1*Ratio) ELSE TX2 := X2;
    IF TY2 + 1 <= Y2 THEN TY2 := TY2 + 1;
    FOR I := 1 TO Speed*1000 DO {nothing};
  UNTIL (TX1 = X1) AND (TY1 = Y1) AND (TX2 = X2) AND (TY2 = Y2);
  FBox(TX1,TY1,TX2,TY2,F,B,boxtype);
  END;

  PROCEDURE HorizLine(X1,X2,Y,F,B,lineType : BYTE);
  VAR
    I : INTEGER;
    HorizLine : CHAR;
    Attrib : BYTE;
  BEGIN
  CASE lineType OF                     {5.00a}
    0       : HorizLine := ' ';
    2,4,7,9 : HorizLine := '';
    1,3,6,8 : HorizLine := '';
    ELSE HorizLine := CHR(lineType);
  END; {case}
  Attrib := Attr(F,B);
  IF X2 > X1 THEN
    FastWrite(X1,Y,Attrib,Replicate(X2-X1+1,HorizLine))
  ELSE
    FastWrite(X1,Y,Attrib,Replicate(X1-X2+1,HorizLine));
  END;   {horizline}

  PROCEDURE VertLine(X,Y1,Y2,F,B,lineType : BYTE);
  VAR
    I : INTEGER;
    VertLine : CHAR;
    Attrib : BYTE;
  BEGIN
  CASE lineType OF                {5.00a}
    0       : VertLine := ' ';
    2,4,7,9 : VertLine := '';
    1,3,6,8 : VertLine := '';
    ELSE VertLine := CHR(lineType);
  END; {case}
  Attrib := Attr(F,B);
  IF Y2 > Y1 THEN
    FOR I := Y1 TO Y2 DO FastWrite(X,I,Attrib,VertLine)
  ELSE
    FOR I := Y2 TO Y1 DO FastWrite(X,I,Attrib,VertLine);
  END;   {vertline}

  PROCEDURE WriteAT(X,Y,F,B:INTEGER;St:StrScreen);
  BEGIN
  FastWrite(X,Y,Attr(F,B),St);
  END;

  PROCEDURE WriteCenter(LineNO,F,B:INTEGER;St:StrScreen);
  BEGIN
  FastWrite(40 - LENGTH(St) DIV 2,LineNO,Attr(F,B),St);
  END;

  PROCEDURE WriteBetween(X1,X2,Y,F,B:BYTE;St:StrScreen);
  VAR X : INTEGER;
  BEGIN
  IF LENGTH(St) >= X2 - X1 + 1 THEN
    WriteAT(X1,Y,F,B,St)
  ELSE
    BEGIN
    X := X1 + (X2 - X1 + 1 - LENGTH(St)) DIV 2 ;
    WriteAT(X,Y,F,B,St);
    END;
  END;

  PROCEDURE WriteVert(X,Y,F,B:INTEGER;St : StrScreen);
  VAR
    I:INTEGER;
    tempstr:StrScreen;
  BEGIN
  IF LENGTH(St) > 26 - Y THEN DELETE(St,27 - Y,80);
  FOR I := 1 TO LENGTH(St) DO
    BEGIN
    tempstr := St[I];
    FastWrite(X,Y-1+I,Attr(F,B),St[I]);
    END;
  END;

  FUNCTION EGAVGASystem: BOOLEAN;
  {}
  VAR  Regs : registers;
  BEGIN
  WITH Regs DO
    BEGIN
    Ax := $1C00;
    Cx := 7;
    Intr($10,Regs);
    IF Al = $1C THEN  {VGA}
      BEGIN
      EGAVGASystem := TRUE;
      EXIT;
      END;
    Ax := $1200;
    Bl := $32;
    Intr($10,Regs);
    IF Al = $12 THEN {MCGA}
      BEGIN
      EGAVGASystem := TRUE;
      EXIT;
      END;
    Ah := $12;
    Bl := $10;
    Cx := $FFFF;
    Intr($10,Regs);
    EGAVGASystem := (Cx <> $FFFF);  {EGA}
    END; {with}
  END; {of func NoSnowSystem}

  FUNCTION Get_Video_Mode:BYTE;
  {}
  VAR
    Regs : registers;
  BEGIN
  WITH Regs DO
    BEGIN
    Ax := $0F00;
    Intr($10,Regs);
    Get_Video_Mode := Al;
    END; {with}
  END; {of proc Video_Mode}

  PROCEDURE InitFastTTT;
  BEGIN
  IF Get_Video_Mode = 7 THEN
    BEGIN
    BaseOfScreen := $B000;  {Mono}
    SnowProne := FALSE;
    END
  ELSE
    BEGIN
    BaseOfScreen := $B800; {Color}
    SnowProne := NOT EGAVGASystem;
    END;
  VSeg := BaseOfScreen;
  VOfs := 0;
  END;

BEGIN   {the following is always called when the unit is loaded}
InitFastTTT;
Speed := 200;
END.
