{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit tchat;

interface

uses crt, dos, overlay, tmpcom, common;

procedure two_way_chat;
procedure two_way_color_chat;
procedure two_way_sound_chat;
procedure dochar(user : integer; var row : integer; var col : integer;
                 firstrow : integer; Rows : integer; cols : integer;
                 c : char);

implementation
uses common1;

const maxlines = 23; {It's best to leave this at around 20-23.}
      maxcols  = 80; {Unless of course it's less.. max is 100.}

VAR Cnt : INTEGER;
    beep1,beep2,beep3,ExitChat : BOOLEAN;
    Ch : CHAR;
    ChatLine : STRING[MaxCols-2];
    Back : ARRAY[1..2] OF STRING[100];
    C,CC : Char;
    Row1, Col1, Row2, Col2 : INTEGER;

PROCEDURE Special(UNum : INTEGER; SpecS : STRING; Len : INTEGER);
VAR Cnt : INTEGER;
    S   : STRING;
BEGIN
  S:='';
  FOR Cnt:=1 TO Len DO S:=S + Upcase(SpecS[Cnt]);
  IF S='/Q' THEN begin
        Cls;
        ExitChat:=TRUE;
       END;
END; {Special}

procedure gotopos(x,y:integer);
begin
  if (spd<>'KB') then pr1(#27+'['+cstr(y)+';'+cstr(x)+'H');
  if (wantout) then gotoxy(x,y);
  pap:=0;
end;


PROCEDURE DoChar(User : INTEGER; VAR Row : INTEGER; VAR Col : INTEGER;
                 FirstRow : INTEGER; Rows : INTEGER; Cols : INTEGER;
                 C : CHAR);

VAR Tmp1, Tmp2 : INTEGER;
    WrapS : STRING;
    WrapC : INTEGER;
    Wrap  : BOOLEAN;
    Bugs  : BOOLEAN;

BEGIN
  Wrap:=FALSE;
  Bugs:=TRUE;
  {Ordinary characters}
  IF (ORD(C)>31) AND (ORD(C)<127) THEN BEGIN
    gotopos(Col, Row);
    sprompt(c);
    Back[User][Col]:=C;
    Col:=Col+1;
  END;
  {Back space}
  IF ORD(C)=8 THEN BEGIN
    Col:=Col-1;
    IF Col=0 THEN Col:=1;
    gotopos(Col, Row);
    sprompt(' ');
  END;
  {Return}
  IF ORD(C)=13 THEN BEGIN
    Tmp1:=Col;
    Col:=Cols+1;
    Special(User, Back[User],Tmp1-1);
    Bugs:=FALSE;
  END;
  IF (Col>Cols) THEN BEGIN
    Tmp1:=Cols+1;
    IF Bugs THEN Wrap:=TRUE;
    REPEAT
      Tmp1:=Tmp1-1;
      WrapC:=Tmp1;
      IF Tmp1=1 THEN Wrap:=FALSE;
    UNTIL ((Back[User][Tmp1]=' ')
      OR (Back[User][Tmp1]='-')
      OR (Back[User][Tmp1]='.')
      OR (Back[User][Tmp1]=',')
      OR (Wrap=FALSE));
    IF Wrap THEN BEGIN
      Tmp2:=0;
      FOR Tmp1:=WrapC+1 TO Cols DO BEGIN
        Tmp2:=Tmp2+1;
        WrapS[Tmp2]:=Back[User][Tmp1];
        gotopos(Tmp1, Row);
        sprompt(' ');
        Back[User][Tmp1]:=' ';
      END;
      WrapC:=Tmp2;
    END;
    Col:=1;
    Row:=Row+1;
    IF Row>Rows THEN BEGIN
      FOR Tmp1:=FirstRow TO Rows DO BEGIN
        gotopos(1, Tmp1);
        FOR Tmp2:=1 TO Cols DO
          sprompt(' ');
      END;
      Row:=FirstRow;
      FOR Tmp1:=1 TO Cols DO BEGIN
        gotopos(Tmp1, Row);
        sprompt(Back[User][Tmp1]);
      END;
      Row:=Row+1;
    END ELSE For Tmp1:=1 TO Cols DO Back[User][Tmp1]:=' ';
  END;
  IF Wrap THEN
    FOR Tmp1:=1 TO WrapC DO BEGIN
      gotopos(Col, Row);
      sprompt(WrapS[Tmp1]);
      Back[User][Col]:=WrapS[Tmp1];
      Col:=Col+1;
    END;
  gotopos(Col, Row);
END; {DoChar}

procedure dobeep(i:integer);
var
v:integer;
begin
if (i=1) then
 begin
   sound(2000);
   delay(4);
   nosound;
 end;
  if (i=2) then
   begin
      for v:=1 to 10 do
      sound(900);
      delay(4);
      nosound;
   end;
   if (i=3) then
    begin
      sound(2500);
      delay(30);
      nosound;
    end;
end;

PROCEDURE Two_Way_Chat;
BEGIN
  Back[1]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  Back[2]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  redrawforansi;
  cls;
  gotopos(1, MaxLines DIV 2);
  Row1:=2;
  Col1:=1;
  Row2:=(MaxLines DIV 2)+1;
  Col2:=1;
  exitchat:=FALSE;
  chatcall:=FALSE;
  chatr:='';
  echo:=TRUE;
  printf('chat1');
  if (nofile) then
  begin
  gotopos(1,1);
  sprint(#27+'[0;1;44m                                                                                ');
  gotopos(1,1);
  sprint(centre(#27+'[0;1;44m'+caps(systat.sysopname)+' is chatting with '+caps(thisuser.name)+' '+
  'at '+spd+' baud in normal mode.'));
  gotopos(1,11);
  sprint(#27+'[0;1;34m[ ^0Genesis ^1v^01^1.^02 ^02^1/^0Way Chat '+
  '^4]');
end;
redrawforansi;
if (not incom) then
begin
  gotopos(2,13);
  sprint(#3#5+'System warning: There is no carrier detected!');
end;
cl3(7);
gotopos(col1, row1);
repeat
  if (keypressed) then begin
    ch:=readkey;
  if (ord(ch)=27) then exitchat:=TRUE;
  cl3(7);
  dochar(1, row1, col1, 2, (maxlines div 2)-1, maxcols, ch);
  end else
    if ((not com_rx_empty) and (incom) and (not trm)) then begin
     ch:=inkey;
      cl3(8);
      dochar(2, row2, col2, (maxlines div 2)+1, maxlines, maxcols, ch);
    end;
if (exitchat) then
begin
  clrscr;
  cls;
  sprint(fstring.endchat);
  nl;
 end;
until (exitchat) or (hangup);
end;

PROCEDURE Two_Way_Color_Chat;
var
colors:integer;
BEGIN
  Back[1]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  Back[2]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  redrawforansi;
  cls;
  gotopos(1, MaxLines DIV 2);
  Row1:=2;
  Col1:=1;
  Row2:=(MaxLines DIV 2)+1;
  Col2:=1;
  exitchat:=FALSE;
  chatcall:=FALSE;
  chatr:='';
  echo:=TRUE;
  printf('chat2');
  if (nofile) then
  begin
  gotopos(1,1);
  sprint(#27+'[0;1;44m                                                                                ');
  gotopos(1,1);
  sprint(centre(#27+'[0;1;44m'+caps(systat.sysopname)+' is chatting with '+caps(thisuser.name)+' '+
  'at '+spd+' baud in color mode.'));
  gotopos(1,11);
  sprint(#27+'[0;1;34m[ ^0Genesis ^1v^01^1.^02 ^02^1/^0Way Chat '+
  '^4]');
 end;
redrawforansi;
if (not incom) then
begin
  gotopos(2,13);
  sprint(#3#5+'System warning: There is no carrier detected!');
end;
cl(systat.sysopcolor);
gotopos(col1, row1);
randomize;
repeat
  if (keypressed) then begin
    ch:=readkey;
  if (ord(ch)=27) then exitchat:=TRUE;
   colors:=random(9);
   cl2(colors);
   dochar(1, row1, col1, 2, (maxlines div 2)-1, maxcols, ch);
  end else
    if ((not com_rx_empty) and (incom) and (not trm)) then begin
     ch:=inkey;
      colors:=random(9);
      cl2(colors);
      dochar(2, row2, col2, (maxlines div 2)+1, maxlines, maxcols, ch);
    end;
if (exitchat) then
begin
  clrscr;
  cls;
  sprint(fstring.endchat);
  nl;
 end;
until (exitchat) or (hangup);
end;

PROCEDURE Two_Way_Sound_Chat;
BEGIN
  Back[1]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  Back[2]:='12345678901234567890123456789012345678901234567901234567890123456789012345678901234567890123456790';
  redrawforansi;
  cls;
  gotopos(1, MaxLines DIV 2);
  Row1:=2;
  Col1:=1;
  Row2:=(MaxLines DIV 2)+1;
  Col2:=1;
  exitchat:=FALSE;
  chatcall:=FALSE;
  chatr:='';
  echo:=TRUE;
  printf('chat3');
  if (nofile) then
  begin
  gotopos(1,1);
  sprint(#27+'[0;1;44m                                                                                ');
  gotopos(1,1);
  printf('chat');
  sprint(centre(#27+'[0;1;44m'+caps(systat.sysopname)+' is chatting with '+caps(thisuser.name)+' '+
  'at '+spd+' baud in sound mode.'));
  gotopos(1,11);
  sprint(#27+'[0;1;34m[ ^0Genesis ^1v^01^1.^02 ^02^1/^0Way Chat '+
  '^4]');
  end;
redrawforansi;
if (not incom) then
begin
  gotopos(2,13);
  sprint(#3#5+'System warning: There is no carrier detected!');
end;
cl3(7);
gotopos(col1, row1);
repeat
  if (keypressed) then begin
    ch:=readkey;
  if (ord(ch)=27) then exitchat:=TRUE;
  cl3(7);
  dochar(1, row1, col1, 2, (maxlines div 2)-1, maxcols, ch);
  end else
    if ((not com_rx_empty) and (incom) and (not trm)) then begin
     ch:=inkey;
      dobeep(2);
      cl3(8);
      dochar(2, row2, col2, (maxlines div 2)+1, maxlines, maxcols, ch);
    end;
if (exitchat) then
begin
  clrscr;
  cls;
  sprint(fstring.endchat);
  nl;
 end;
until (exitchat) or (hangup);
end;

end.
