(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP7M .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: Menu editor -- "M" command (modify commands)          <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop7m;

interface

uses
  crt, dos, overlay,
  common,
  file9,
  menus2,
  sysop1;

procedure memm(scurmenu:astr; var menuchanged:boolean);

implementation

procedure memm(scurmenu:astr; var menuchanged:boolean);
var i1,i2,ii,z:integer;
    c:char;
    s:astr;
    b:byte;
    bb:boolean;
begin
  prt('Begin editing at which? (1-'+cstr(noc)+') : '); inu(ii);
  c:=' ';
  if (ii>=1) and (ii<=noc) then begin
    while (c<>'Q') and (not hangup) do begin
      repeat
        with cmdr[ii] do begin
          if (c<>'?') then begin
            cls;
            sprint(#3#9+'Menu currently editing : '+scurmenu);
            nl;
            sprint('^5Command ^1#^7'+cstr(ii)+' ^5of ^1#^7'+cstr(noc));
            nl;
            with cmdr[ii] do begin
              sprint('^3(^41^3). Long description : ^5'+ldesc);
              sprint('^3(^42^3). Short description : ^5'+sdesc);
              sprint('^3(^43^3). Command letters : ^5'+ckeys);
              sprint('^3(^44^3). Access required : ^5'+acs);
              sprint('^3(^45^3). Command keys : ^5'+cmdkeys);
              sprint('^3(^46^3). String : ^5'+mstring);
              s:='';
              if (hidden in commandflags) then s:='(H)idden';
              if (unhidden in commandflags) then begin
                if (s<>'') then s:=s+', ';
                s:=s+'(U)nhidden';
              end;
              if (s='') then s:='None';
              sprint('^3(^47^3). Flags : ^5'+s);
              sprint('^3(^4Q^3). Quit');
            end;
          end;
          nl;
          prt('Menu editor (?=help), (1-7), (Q)uit : ');
          onek(c,'Q1234567[]FJL?'^M);
          nl;
          case c of
            '1':begin
                  nl;
                  sprint('^0New long description.'); prt(': ');
                  inputwnwc(ldesc,70,menuchanged);
                end;
            '2':begin
                  nl;
                  sprint('^0New short description.'); prt(': ');
                  inputwnwc(sdesc,35,menuchanged);
                end;
            '3':begin
                  nl;
                  sprint('^0New command letters.'); prt(': '); mpl(14);
                  input(s,14);
                  if (s<>'') then begin ckeys:=s; menuchanged:=TRUE; end;
                end;
            '4':begin
                  nl;
                  sprint('^0New Access level needed for execution.'); prt(': '); mpl(20);
                  inputwn(acs,20,menuchanged);
                end;
            '5':begin
                  nl;
                  sprint('^0New command type.'); prt(': '); mpl(2); input(s,2);
                  if (length(s)=2) then begin cmdkeys:=s; menuchanged:=TRUE; end;
                end;
            '6':begin
                  nl;
                  sprint('^0New String.'); prt(': '); mpl(50);
                  inputwnwc(mstring,50,menuchanged);
                end;
            '7':begin
                  nl;
                  sprint('^0(^1H^0)idden command or ^0(^1U^0)nhidden command');
                  prt('Flag editor (Q)uit, (H), (U) : '); onek(c,'QHU'^M);
                  bb:=menuchanged; menuchanged:=TRUE;
                  case c of
                    'H':if (hidden in commandflags) then
                          commandflags:=commandflags-[hidden]
                     else commandflags:=commandflags+[hidden];
                    'U':if (unhidden in commandflags) then
                          commandflags:=commandflags-[unhidden]
                     else commandflags:=commandflags+[unhidden];
                  else
                        menuchanged:=bb;
                  end;
                  c:=#0;
                end;
            '[':if (ii>1) then dec(ii) else c:=' ';
            ']':if (ii<noc) then inc(ii) else c:=' ';
            'F':if (ii<>1) then ii:=1 else c:=' ';
            'J':begin
                  nl;
                  sprint('^0Jump to entry.'); prt(': ');
                  input(s,3);
                  if (value(s)>=1) and (value(s)<=noc) then ii:=value(s) else c:=' ';
                end;
            'L':if (ii<>noc) then ii:=noc else c:=' ';
            '?':ee_help;
          end;
        end;
      until (c in ['Q','[',']','F','J','L']) or (hangup);
    end;
  end;
end;

end.
