(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2S .PAS -  Written by Eric Oman                                   <*)
(*>                                                                         <*)
(*>  SysOp functions: System Configuration Editor -- "S" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2s;

interface

uses
  crt, dos, overlay,
  common;

procedure postring;

implementation

const
  aresure='Are you sure this is what you want? ';

procedure instring(p:astr; var v:astr; len:integer);
var changed:boolean;
begin
  print('Enter new "'+p+'" string:');
  inputwnwc(v,len,changed);
end;

procedure postring;
var fstringf:file of fstringrec;
    s,s2:astr;
    onpage:integer;
    c:char;
    abort,next,done:boolean;

  function cc(s:astr):astr;
  begin
    while pos('^',s)>0 do s[pos('^',s)]:=#3;
    cc:=#3#1+s;
  end;

  procedure showstrings;
  begin
    abort:=FALSE; next:=FALSE;
    with fstring do
      case onpage of
        1:begin                       
            printacr(#3#5+'['#3#3+'A'+#3#5+']. SysOp In       '+#3#2+': '+cc(sysopin),abort,next);
            printacr(#3#5+'['#3#3+'B'+#3#5+']. SysOp Out      '+#3#2+': '+cc(sysopout),abort,next);
            printacr(#3#5+'['#3#3+'C'+#3#5+']. Echo Chr       '+#3#2+': '+cc(echoc),abort,next);
            printacr(#3#5+'['#3#3+'D'+#3#5+']. Welcome Prompt '+#3#2+': '+cc(ansiq),abort,next);
            printacr(#3#5+'['#3#3+'E'+#3#5+']. Engage Chat    '+#3#2+': '+cc(engage),abort,next);
            printacr(#3#5+'['#3#3+'F'+#3#5+']. Exit Chat      '+#3#2+': '+cc(endchat),abort,next);
            printacr(#3#5+'['#3#3+'G'+#3#5+']. Sysop Working  '+#3#2+': '+cc(wait),abort,next);
            printacr(#3#5+'['#3#3+'H'+#3#5+']. Pause Screen   '+#3#2+': '+cc(pause),abort,next);
            printacr(#3#5+'['#3#3+'I'+#3#5+']. Chat Reason    '+#3#2+': '+cc(ChatReason),abort,next);
            nl;
            prt('Enter selection (A-I,[,]),(Q)uit : ');

            onek(c,'QABCDEFGHI[]');

          end;
        2:begin
            printacr(#3#5+'['+#3#3+'A'+#3#5+']. NewScan Start      '+#3#2+': '+cc(newscan1),abort,next);
            printacr(#3#5+'['+#3#3+'B'+#3#5+']. NewScan Done       '+#3#2+': '+cc(newscan2),abort,next);
            printacr(#3#5+'['+#3#3+'C'+#3#5+']. Read Msgs Prompt   '+#3#2+': '+cc(scanmessage),abort,next);
            printacr(#3#5+'['+#3#3+'D'+#3#5+']. Automessage By:    '+#3#2+': '+cc(automsgt),abort,next);
            printacr(#3#5+'['+#3#3+'F'+#3#5+']. Dos Prompt         '+#3#2+': '+cc(dosprompt),abort,next);
            printacr(#3#5+'['+#3#3+'G'+#3#5+']. NewScan Begin      '+#3#2+': '+cc(newscanbegin),abort,next);
            printacr(#3#5+'['+#3#3+'H'+#3#5+']. NewScan End        '+#3#2+': '+cc(newscanend),abort,next);
            printacr(#3#5+'['+#3#3+'I'+#3#5+']. Auto-Msg. Border   '+#3#2+': '+auto1,abort,next);
            printacr(#3#5+'['+#3#3+'J'+#3#5+']. Auto-Msg. Color    '+#3#2+': '+cstr(systat.autocolor),abort,next);
            nl;
            prt('Enter selection (A-J,[,]),(Q)uit : ');
            onek(c,'QABCDEFGHIJ[]');
          end;
        3:begin
            printacr(#3#5+'['+#3#3+'A'+#3#5+']. Shell To DOS L#1 '+#3#2+': '+cc(shelldos1),abort,next);
            printacr(#3#5+'['+#3#3+'B'+#3#5+']. Shell To DOS L#2 '+#3#2+': '+cc(shelldos2),abort,next);
            printacr(#3#5+'['+#3#3+'C'+#3#5+']. Chat Call #1     '+#3#2+': '+cc(chatcall1),abort,next);
            printacr(#3#5+'['+#3#3+'D'+#3#5+']. Chat Call #2     '+#3#2+': '+cc(chatcall2),abort,next);
            printacr(#3#5+'['+#3#3+'E'+#3#5+']. Guest User Info  '+#3#2+': '+cc(guestline),abort,next);
            printacr(#3#5+'['+#3#3+'F'+#3#5+']. Name Not Found   '+#3#2+': '+cc(namenotfound),abort,next);
            printacr(#3#5+'['+#3#3+'G'+#3#5+']. Bulletin Line    '+#3#2+': '+cc(bulletinline),abort,next);
            printacr(#3#5+'['+#3#3+'H'+#3#5+']. Thanks For Voting'+#3#2+': '+cc(thanxvote),abort,next);
            nl;
            prt('Enter selection (A-H,[,]),(Q)uit : ');
            onek(c,'QABCDEFGH[]');
          end;
        4:begin
            printacr(#3#5+'['+#3#3+'A'+#3#5+']. List Line        '+#3#2+': '+cc(listline),abort,next);
            printacr(#3#5+'['+#3#3+'B'+#3#5+']. File NewScan Line'+#3#2+': '+cc(newline),abort,next);
            printacr(#3#5+'['+#3#3+'C'+#3#5+']. Search Line      '+#3#2+': '+cc(searchline),abort,next);
            printacr(#3#5+'['+#3#3+'D'+#3#5+']. Find Descrip. L#1'+#3#2+': '+cc(findline1),abort,next);
            printacr(#3#5+'['+#3#3+'E'+#3#5+']. Find Descrip. L#2'+#3#2+': '+cc(findline2),abort,next);
            printacr(#3#5+'['+#3#3+'F'+#3#5+']. Download Line    '+#3#2+': '+cc(downloadline),abort,next);
            printacr(#3#5+'['+#3#3+'G'+#3#5+']. Upload Line      '+#3#2+': '+cc(uploadline),abort,next);
            printacr(#3#5+'['+#3#3+'H'+#3#5+']. View Content Line'+#3#2+': '+cc(viewline),abort,next);
            printacr(#3#5+'['+#3#3+'I'+#3#5+']. Insuff. File Pts '+#3#2+': '+cc(nofilepts),abort,next);
            printacr(#3#5+'['+#3#3+'J'+#3#5+']. Bad UL/DL Ratio  '+#3#2+': '+cc(unbalance),abort,next);
            nl;
            prt('Enter selection (A-J,[,]),(Q)uit : ');
            onek(c,'QABCDEFGHIJ[]');
          end;
        5:begin
            printacr(#3#5+'['+#3#3+'A'+#3#5+']. P/N File Info    '+#3#2+': '+cc(pninfo),abort,next);
            printacr(#3#5+'['+#3#3+'B'+#3#5+']. Get Filespec L#1 '+#3#2+': '+cc(gfnline1),abort,next);
            printacr(#3#5+'['+#3#3+'C'+#3#5+']. Get Filespec L#2 '+#3#2+': '+cc(gfnline2),abort,next);
            printacr(#3#5+'['+#3#3+'D'+#3#5+']. Add To Batch     '+#3#2+': '+cc(batchadd),abort,next);
            printacr(#3#5+'['+#3#3+'E'+#3#5+']. Edit Rumor       '+#3#2+': '+cc(editrumor),abort,next);
            printacr(#3#5+'['+#3#3+'F'+#3#5+']. Delete Rumor     '+#3#2+': '+cc(deleterumor),abort,next);
            printacr(#3#5+'['+#3#3+'G'+#3#5+']. Add Rumor        '+#3#2+': '+cc(addrumor),abort,next);
            printacr(#3#5+'['+#3#3+'H'+#3#5+']. Add To Wish List '+#3#2+': '+cc(addwish),abort,next);
            printacr(#3#5+'['+#3#3+'I'+#3#5+']. Add Mental Note  '+#3#2+': '+cc(addmental),abort,next);
            nl;
            prt('Enter selection (A-I,[,]),(Q)uit : ');
            onek(c,'QABCDEFGHI[]');
          end;
      end;
  end;

  procedure dostringstuff;
  var
  b:byte;
  begin

    case c of
      'Q':done:=TRUE;

      '[':begin
            dec(onpage);
            if (onpage<1) then onpage:=5;
          end;
      ']':begin
            inc(onpage);
            if (onpage>5) then onpage:=1;
          end;
    end;
    with fstring do
      case onpage of
        1:case c of

            'A':instring('SysOp IN',sysopin,80);
            'B':instring('SysOp OUT',sysopout,80);
            'C':begin
                prt('Enter New Echo Character : ');
                mpl(1); inputl(s,1);
                if (s<>'') then echoc:=s[1];
                end;
            'D':instring('Welcome Screen (Enter "" for no questions asked, "NONE" for no question or file)',ansiq,80);
            'E':instring('Engage chat',engage,80);
            'F':instring('End chat',endchat,80);
            'G':instring('SysOp working',wait,80);
            'H':instring('Pause',pause,80);
            'I':instring('Chat Reason',ChatReason,80);

            'Q':done:=TRUE;
          end;
        2:case c of
            'A':instring('NewScan line 1',newscan1,80);
            'B':instring('NewScan line 2',newscan2,80);
            'C':instring('Read message prompt',scanmessage,80);
            'D':instring('Auto message title',automsgt,80);
            'G':instring('NewScan Begin',newscanbegin,80);
            'H':instring('NewScan End',newscanend,80);
            'F':instring('Dos Prompt',dosprompt,80);
            'I':Begin
                  print('Enter new auto message border character:');
                  inputl(s,1);
                  if (s<>'') then auto1:=s[1];
                end;
            'J':Begin
                  print('Enter new auto message border color:');
                  prt(': ');
                  ini(b);
                 if not(badini) then systat.autocolor:=b;
                end;
              end;
      3:case c of
            'A':instring('Shell to DOS line 1',shelldos1,80);
            'B':instring('Shell to DOS line 2',shelldos2,80);
            'C':instring('Chat call line 1',chatcall1,80);
            'D':instring('Chat call line 2',chatcall2,80);
            'E':instring('Guest Line',guestline,80);
            'F':instring('Name not found line during logon',namenotfound,80);
            'G':instring('Bulletins prompt line',bulletinline,80);
            'H':instring('Thanks for voting',thanxvote,80);
          end;
        4:case c of
            'A':instring('List line',listline,80);
            'B':instring('File NewScan line',newline,80);
            'C':instring('Search line',searchline,80);
            'D':instring('Find description line 1',findline1,80);
            'E':instring('Find description line 2',findline2,80);
            'F':instring('Download line',downloadline,80);
            'G':instring('Upload line',uploadline,80);
            'H':instring('View interior contents line',viewline,80);
            'I':instring('Insufficient file points',nofilepts,80);
            'J':instring('Upload/Download ratio unbalanced',unbalance,80);
          end;
        5:case c of
            'A':instring('P / N file information',pninfo,80);
            'B':instring('Get filespec line 1',gfnline1,80);
            'C':instring('Get filespec line 2',gfnline2,80);
            'D':instring('Add to batch queue',batchadd,80);
            'E':instring('Edit a Rumor',editrumor,80);
            'F':instring('Delete a Rumor',deleterumor,80);
            'G':instring('Add a Rumor',addrumor,80);
            'H':instring('Add to Wish List',addwish,80);
            'I':instring('Add Mental Note',addmental,80);
         end;

      end;
  end;

begin
  onpage:=1; done:=FALSE;
  repeat
    cls;
    sprint('^4[ ^9String Configuration ^4]');
    sprint('^4[ ^9Page '+cstr(onpage)+' of 5 ^4]');
    nl;
    showstrings;
    nl;
    dostringstuff;
  until ((done) or (hangup));
  assign(fstringf,systat.gfilepath+'string.dat');
  reset(fstringf); seek(fstringf,0); write(fstringf,fstring); close(fstringf);
end;

end.

