/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <ctype.h>
#include <string.h>
#include "pphlp.h"
int getKeyWordContext(char str[])
{
if (toupper(str[0]) == 'A') goto a;
if (toupper(str[0]) == 'B') goto b;
if (toupper(str[0]) == 'C') goto c;
if (toupper(str[0]) == 'D') goto d;
if (toupper(str[0]) == 'E') goto e;
if (toupper(str[0]) == 'F') goto f;
if (toupper(str[0]) == 'G') goto g;
if (toupper(str[0]) == 'H') goto h;
if (toupper(str[0]) == 'I') goto i;
if (toupper(str[0]) == 'J') goto j;
if (toupper(str[0]) == 'K') goto k;
if (toupper(str[0]) == 'L') goto l;
if (toupper(str[0]) == 'M') goto m;
if (toupper(str[0]) == 'N') goto n;
if (toupper(str[0]) == 'O') goto o;
if (toupper(str[0]) == 'P') goto p;
if (toupper(str[0]) == 'Q') goto q;
if (toupper(str[0]) == 'R') goto r;
if (toupper(str[0]) == 'S') goto s;
if (toupper(str[0]) == 'T') goto t;
if (toupper(str[0]) == 'U') goto u;
if (toupper(str[0]) == 'V') goto v;
if (toupper(str[0]) == 'W') goto w;
if (toupper(str[0]) == 'X') goto x;
if (toupper(str[0]) == 'Y') goto y;
if (toupper(str[0]) == '@') goto arrobas;

a:
if (!strcmpi(str,"Abort")) return hcAbort;
if (!strcmpi(str,"Abs")) return hcAbs;
if (!strcmpi(str,"AdjBytes")) return hcAdjBytes;
if (!strcmpi(str,"AdjDBytes")) return hcAdjDBytes;
if (!strcmpi(str,"AdjTBytes")) return hcAdjTBytes;
if (!strcmpi(str,"AdjTFiles")) return hcAdjTFiles;
if (!strcmpi(str,"AdjTime")) return hcAdjTime;
if (!strcmpi(str,"Alias")) return hcAlias;
if (!strcmpi(str,"And")) return hcAnd;
if (!strcmpi(str,"AnsiOn")) return hcAnsiOn;
if (!strcmpi(str,"AnsiPos")) return hcAnsiPos;
if (!strcmpi(str,"Append")) return hcAppend;
if (!strcmpi(str,"Asc")) return hcAsc;
if (!strcmpi(str,"Auto")) return hcPredefConsts;
if (!strcmpi(str,"ACCOUNT")) return hcAccount;
if (!strcmpi(str,"ACC_MSGR")) return hcAccounting;
if (!strcmpi(str,"ACC_MSGW")) return hcAccounting;
if (!strcmpi(str,"ACC_STAT")) return hcAccounting;
if (!strcmpi(str,"ACC_TIME")) return hcAccounting;
if (!strcmpi(str,"ACTMSGNUM")) return hcActMsgNum;
if (!strcmpi(str,"ATTACH_LIM_P")) return hcQwkLimits;
if (!strcmpi(str,"ATTACH_LIM_U")) return hcQwkLimits;
b:
if (!strcmpi(str,"B2w")) return hcB2w;
if (!strcmpi(str,"Backup")) return hcBackup;
if (!strcmpi(str,"BitSet")) return hcBitSet;
if (!strcmpi(str,"Blt")) return hcBlt;
if (!strcmpi(str,"Break")) return hcBreak;
if (!strcmpi(str,"Broadcast")) return hcBroadcast;
if (!strcmpi(str,"Bye")) return hcBye;
if (!strcmpi(str,"Boolean")) return hcDataTypes;
if (!strcmpi(str,"Bell")) return hcPredefConsts;
if (!strcmpi(str,"BigStr")) return hcDataTypes;
if (!strcmpi(str,"Byte")) return hcDataTypes;
if (!strcmpi(str,"BEGIN")) return hcProcedure;
c:
if (!strcmpi(str,"Call")) return hcCall;
if (!strcmpi(str,"CallID")) return hcCallID;
if (!strcmpi(str,"CallNum")) return hcCallNum;
if (!strcmpi(str,"Carrier")) return hcCarrier;
if (!strcmpi(str,"CcType")) return hcCcType;
if (!strcmpi(str,"CdCheckOff")) return hcCdCheckOff;
if (!strcmpi(str,"CdCheckOn")) return hcCdCheckOn;
if (!strcmpi(str,"CdOn")) return hcCdOn;
if (!strcmpi(str,"Chat")) return hcChat;
if (!strcmpi(str,"ChatStat")) return hcChatStat;
if (!strcmpi(str,"Chr")) return hcChr;
if (!strcmpi(str,"CloseCap")) return hcCloseCap;
if (!strcmpi(str,"ClrEol")) return hcClrEol;
if (!strcmpi(str,"Cls")) return hcCls;
if (!strcmpi(str,"Color")) return hcColor;
if (!strcmpi(str,"Command")) return hcCommand;
if (!strcmpi(str,"ConfAlias")) return hcConfAlias;
if (!strcmpi(str,"ConfExp")) return hcConfExp;
if (!strcmpi(str,"ConfFlag")) return hcConfFlag;
if (!strcmpi(str,"ConfReg")) return hcConfReg;
if (!strcmpi(str,"ConfSel")) return hcConfSel;
if (!strcmpi(str,"ConfSys")) return hcConfSys;
if (!strcmpi(str,"ConfUnFlag")) return hcConfUnFlag;
if (!strcmpi(str,"ConfMw")) return hcConfMw;
if (!strcmpi(str,"Continue")) return hcContinue;
if (!strcmpi(str,"Copy")) return hcCopy;
if (!strcmpi(str,"CurColor")) return hcCurColor;
if (!strcmpi(str,"CurConf")) return hcCurConf;
if (!strcmpi(str,"CurSec")) return hcCurSec;
if (!strcmpi(str,"CurUser")) return hcCurUser;
if (!strcmpi(str,"Cur_User")) return hcPredefConsts;
if (!strcmpi(str,"CASE")) return hcSelect;
if (!strcmpi(str,"CHRG_CALL")) return hcAccounting;
if (!strcmpi(str,"CHRG_CHAT")) return hcAccounting;
if (!strcmpi(str,"CHRG_DOWNBYTES")) return hcAccounting;
if (!strcmpi(str,"CHRG_DOWNFILE")) return hcAccounting;
if (!strcmpi(str,"CHRG_MSGCAP")) return hcAccounting;
if (!strcmpi(str,"CHRG_MSGECHOED")) return hcAccounting;
if (!strcmpi(str,"CHRG_MSGPRIVATE")) return hcAccounting;
if (!strcmpi(str,"CHRG_MSGREAD")) return hcAccounting;
if (!strcmpi(str,"CHRG_MSGWRITE")) return hcAccounting;
if (!strcmpi(str,"CHRG_PEAKTIME")) return hcAccounting;
if (!strcmpi(str,"CHRG_TIME")) return hcAccounting;
if (!strcmpi(str,"CMAXMSGS")) return hcQwkLimits;
if (!strcmpi(str,"CRC32")) return hcCrc32;
if (!strcmpi(str,"CRC_FILE")) return hcCrc32;
if (!strcmpi(str,"CRC_STR")) return hcCrc32;
if (!strcmpi(str,"CRED_SPECIAL")) return hcAccounting;
if (!strcmpi(str,"CRED_UPBYTES")) return hcAccounting;
if (!strcmpi(str,"CRED_UPFILE")) return hcAccounting;
d:
if (!strcmpi(str,"Date")) return hcDate;
if (!strcmpi(str,"Day")) return hcDay;
if (!strcmpi(str,"DbgLevel")) return hcDbgLevel;
if (!strcmpi(str,"Dec")) return hcDec;
if (!strcmpi(str,"DefAns")) return hcDefAns;
if (!strcmpi(str,"DefColor")) return hcDefColor;
if (!strcmpi(str,"DelUser")) return hcDelUser;
if (!strcmpi(str,"Defs")) return hcPredefConsts;
if (!strcmpi(str,"Delay")) return hcDelay;
if (!strcmpi(str,"Delete")) return hcDelete;
if (!strcmpi(str,"Dir")) return hcDir;
if (!strcmpi(str,"DispFile")) return hcDispFile;
if (!strcmpi(str,"DispStr")) return hcDispStr;
if (!strcmpi(str,"DispText")) return hcDispText;
if (!strcmpi(str,"DoIntr")) return hcDoIntr;
if (!strcmpi(str,"Dow")) return hcDow;
if (!strcmpi(str,"Download")) return hcDownload;
if (!strcmpi(str,"DtrOff")) return hcDtrOff;
if (!strcmpi(str,"DtrOn")) return hcDtrOn;
if (!strcmpi(str,"DReal")) return hcDataTypes;
if (!strcmpi(str,"Double")) return hcDataTypes;
if (!strcmpi(str,"DWord")) return hcDataTypes;
if (!strcmpi(str,"DADD")) return hcDBase;
if (!strcmpi(str,"DAPPEND")) return hcDBase;
if (!strcmpi(str,"DBLANK")) return hcDBase;
if (!strcmpi(str,"DBOF")) return hcDBase;
if (!strcmpi(str,"DBOTTOM")) return hcDBase;
if (!strcmpi(str,"DCHANGED")) return hcDBase;
if (!strcmpi(str,"DCLOSE")) return hcDBase;
if (!strcmpi(str,"DCLOSEALL")) return hcDBase;
if (!strcmpi(str,"DCREATE")) return hcDBase;
if (!strcmpi(str,"DDATE")) return hcDBase;
if (!strcmpi(str,"DDECIMALS")) return hcDBase;
if (!strcmpi(str,"DDELETE")) return hcDBase;
if (!strcmpi(str,"DDELETED")) return hcDBase;
if (!strcmpi(str,"DEB_CALL")) return hcAccounting;
if (!strcmpi(str,"DEB_CHAT")) return hcAccounting;
if (!strcmpi(str,"DEB_DOWNBYTES")) return hcAccounting;
if (!strcmpi(str,"DEB_DOWNFILE")) return hcAccounting;
if (!strcmpi(str,"DEB_MSGCAP")) return hcAccounting;
if (!strcmpi(str,"DEB_MSGECHOED")) return hcAccounting;
if (!strcmpi(str,"DEB_MSGPRIVATE")) return hcAccounting;
if (!strcmpi(str,"DEB_MSGREAD")) return hcAccounting;
if (!strcmpi(str,"DEB_MSGWRITE")) return hcAccounting;
if (!strcmpi(str,"DEB_SPECIAL")) return hcAccounting;
if (!strcmpi(str,"DEB_TIME")) return hcAccounting;
if (!strcmpi(str,"DEB_TPU")) return hcAccounting;
if (!strcmpi(str,"DECLARE")) return hcProcedure;
if (!strcmpi(str,"DEFAULT")) return hcSelect;
if (!strcmpi(str,"DEOF")) return hcDBase;
if (!strcmpi(str,"DERR")) return hcDBase;
if (!strcmpi(str,"DERRMSG")) return hcDBase;
if (!strcmpi(str,"DFBLANK")) return hcDBase;
if (!strcmpi(str,"DFCOPY")) return hcDBase;
if (!strcmpi(str,"DFIELDS")) return hcDBase;
if (!strcmpi(str,"DGET")) return hcDBase;
if (!strcmpi(str,"DGETALIAS")) return hcDBase;
if (!strcmpi(str,"DGO")) return hcDBase;
if (!strcmpi(str,"DLENGTH")) return hcDBase;
if (!strcmpi(str,"DLOCK")) return hcDBase;
if (!strcmpi(str,"DLOCKF")) return hcDBase;
if (!strcmpi(str,"DLOCKG")) return hcDBase;
if (!strcmpi(str,"DLOCKR")) return hcDBase;
if (!strcmpi(str,"DNAME")) return hcDBase;
if (!strcmpi(str,"DNCLOSE")) return hcDBase;
if (!strcmpi(str,"DNCLOSEALL")) return hcDBase;
if (!strcmpi(str,"DNCREATE")) return hcDBase;
if (!strcmpi(str,"DNEW")) return hcDBase;
if (!strcmpi(str,"DNEXT")) return hcDNext;
if (!strcmpi(str,"DNOPEN")) return hcDBase;
if (!strcmpi(str,"DOPEN")) return hcDBase;
if (!strcmpi(str,"DPACK")) return hcDBase;
if (!strcmpi(str,"DPUT")) return hcDBase;
if (!strcmpi(str,"DRECALL")) return hcDBase;
if (!strcmpi(str,"DRECCOUNT")) return hcDBase;
if (!strcmpi(str,"DRECNO")) return hcDBase;
if (!strcmpi(str,"DRIVESPACE")) return hcDriveSpace;
if (!strcmpi(str,"DSEEK")) return hcDBase;
if (!strcmpi(str,"DSELECT")) return hcDBase;
if (!strcmpi(str,"DSETALIAS")) return hcDBase;
if (!strcmpi(str,"DSKIP")) return hcDBase;
if (!strcmpi(str,"DTAG")) return hcDBase;
if (!strcmpi(str,"DTOP")) return hcDBase;
if (!strcmpi(str,"DTYPE")) return hcDBase;
if (!strcmpi(str,"DUNLOCK")) return hcDBase;
e:
if (!strcmpi(str,"End")) return hcEnd;
if (!strcmpi(str,"ErrCorrect")) return hcErrorCorrect;
if (!strcmpi(str,"EvtTimeAdj")) return hcEvtTimeAdj;
if (!strcmpi(str,"Exist")) return hcExist;
if (!strcmpi(str,"EchoDots")) return hcPredefConsts;
if (!strcmpi(str,"EraseLine")) return hcPredefConsts;
if (!strcmpi(str,"Edate")) return hcDataTypes;
if (!strcmpi(str,"Else")) return hcIfThen;
if (!strcmpi(str,"ElseIf")) return hcIfThen;
if (!strcmpi(str,"EndIf")) return hcIfThen;
if (!strcmpi(str,"EndWhile")) return hcWhile;
if (!strcmpi(str,"Erase")) return hcDelete;
if (!strcmpi(str,"ENDFUNC")) return hcFunction;
if (!strcmpi(str,"ENDPROC")) return hcProcedure;
f:
if (!strcmpi(str,"For")) return hcForNext;
if (!strcmpi(str,"FAppend")) return hcFAppend;
if (!strcmpi(str,"FClose")) return hcFClose;
if (!strcmpi(str,"FCreate")) return hcFCreate;
if (!strcmpi(str,"FDGet")) return hcFDGet;
if (!strcmpi(str,"FDPut")) return hcFDPut;
if (!strcmpi(str,"FDPutLn")) return hcFDPutLn;
if (!strcmpi(str,"FDPutPad")) return hcFDPutPad;
if (!strcmpi(str,"FDRead")) return hcFDRead;
if (!strcmpi(str,"FDWrite")) return hcFDWrite;
if (!strcmpi(str,"FDefIn")) return hcFDefIn;
if (!strcmpi(str,"FFlush")) return hcFFlush;
if (!strcmpi(str,"FGet")) return hcFGet;
if (!strcmpi(str,"FOpen")) return hcFOpen;
if (!strcmpi(str,"FPut")) return hcFPut;
if (!strcmpi(str,"FPutLn")) return hcFPutLn;
if (!strcmpi(str,"FPutPad")) return hcFPutPad;
if (!strcmpi(str,"FRead")) return hcFRead;
if (!strcmpi(str,"FRewind")) return hcFRewind;
if (!strcmpi(str,"FSeek")) return hcFSeek;
if (!strcmpi(str,"FWrite")) return hcFWrite;
if (!strcmpi(str,"Ferr")) return hcFerr;
if (!strcmpi(str,"FileInf")) return hcFileInf;
if (!strcmpi(str,"FindFirst")) return hcFindFirst;
if (!strcmpi(str,"FindNext")) return hcFindNext;
if (!strcmpi(str,"Flag")) return hcFlag;
if (!strcmpi(str,"FlagCnt")) return hcFlagCnt;
if (!strcmpi(str,"FmtCC")) return hcFmtCC;
if (!strcmpi(str,"FmtReal")) return hcFmtReal;
if (!strcmpi(str,"Forward")) return hcForward;
if (!strcmpi(str,"FreshLine")) return hcFreshLine;
if (!strcmpi(str,"False")) return hcPredefConsts;
if (!strcmpi(str,"FCL")) return hcPredefConsts;
if (!strcmpi(str,"FieldLen")) return hcPredefConsts;
if (!strcmpi(str,"FNS")) return hcPredefConsts;
if (!strcmpi(str,"F_Exp")) return hcPredefConsts;
if (!strcmpi(str,"F_Mw")) return hcPredefConsts;
if (!strcmpi(str,"F_Reg")) return hcPredefConsts;
if (!strcmpi(str,"F_Sel")) return hcPredefConsts;
if (!strcmpi(str,"F_Sys")) return hcPredefConsts;
if (!strcmpi(str,"Float")) return hcDataTypes;
if (!strcmpi(str,"FCLOSEALL")) return hcFCloseAll;
if (!strcmpi(str,"FNEXT")) return hcFNext;
if (!strcmpi(str,"FREALTUSER")) return hcFReAltUser;
if (!strcmpi(str,"FUNC")) return hcFunction;
if (!strcmpi(str,"FUNCTION")) return hcFunction;
g:
if (!strcmpi(str,"GetAltUser")) return hcGetAltUser;
if (!strcmpi(str,"GetEnv")) return hcGetEnv;
if (!strcmpi(str,"GetToken")) return hcGetToken;
if (!strcmpi(str,"GetUser")) return hcGetUser;
if (!strcmpi(str,"GetX")) return hcGetX;
if (!strcmpi(str,"GetY")) return hcGetY;
if (!strcmpi(str,"GoSub")) return hcGoSub;
if (!strcmpi(str,"GoTo")) return hcGoTo;
if (!strcmpi(str,"Goodbye")) return hcGoodbye;
if (!strcmpi(str,"GrafMode")) return hcGrafMode;
if (!strcmpi(str,"Graph")) return hcPredefConsts;
if (!strcmpi(str,"Guide")) return hcPredefConsts;
if (!strcmpi(str,"Go")) return hcGo;
h:
if (!strcmpi(str,"Hangup")) return hcHangup;
if (!strcmpi(str,"HelpPath")) return hcHelpPath;
if (!strcmpi(str,"HiMsgNum")) return hcHiMsgNum;
if (!strcmpi(str,"Hour")) return hcHour;
if (!strcmpi(str,"HighAscii")) return hcPredefConsts;
if (!strcmpi(str,"HDR_ACTIVE")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_BLOCKS")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_DATE")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_ECHO")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_FROM")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_MSGNUM")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_MSGREF")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_PWD")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_REPLY")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_RPLYDATE")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_RPLYTIME")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_STATUS")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_SUBJ")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_TIME")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HDR_TO")) return hcMessageHeaderConsts;
if (!strcmpi(str,"HICONFNUM")) return hcHiConfNum;
i:
if (!strcmpi(str,"I2s")) return hcI2s;
if (!strcmpi(str,"Inc")) return hcInc;
if (!strcmpi(str,"Include")) return hcCompileDirective;
if (!strcmpi(str,"Inkey")) return hcInkey;
if (!strcmpi(str,"Input")) return hcInput;
if (!strcmpi(str,"InputCC")) return hcInputCC;
if (!strcmpi(str,"InputDate")) return hcInputDate;
if (!strcmpi(str,"InputInt")) return hcInputInt;
if (!strcmpi(str,"InputMoney")) return hcInputMoney;
if (!strcmpi(str,"InputStr")) return hcInputStr;
if (!strcmpi(str,"InputText")) return hcInputText;
if (!strcmpi(str,"InputTime")) return hcInputTime;
if (!strcmpi(str,"InputYN")) return hcInputYN;
if (!strcmpi(str,"Instr")) return hcInstr;
if (!strcmpi(str,"IsNonStop")) return hcIsNonStop;
if (!strcmpi(str,"Integer")) return hcDataTypes;
if (!strcmpi(str,"Int")) return hcDataTypes;
if (!strcmpi(str,"If")) return hcIfThen;
if (!strcmpi(str,"IsBitSet")) return hcIsBitSet;
if (!strcmpi(str,"INBYTES")) return hcInBytes;
j:
if (!strcmpi(str,"Join")) return hcJoin;
k:
if (!strcmpi(str,"KInkey")) return hcKInkey;
if (!strcmpi(str,"KbdBufSize")) return hcKbdBufSize;
if (!strcmpi(str,"KbdChkOff")) return hcKbdChkOff;
if (!strcmpi(str,"KbdChkOn")) return hcKbdChkOn;
if (!strcmpi(str,"KbdFile")) return hcKbdFile;
if (!strcmpi(str,"KbdFileUsed")) return hcKbdFileUsed;
if (!strcmpi(str,"KbdFlush")) return hcKbdFlush;
if (!strcmpi(str,"KbdString")) return hcKbdString;
if (!strcmpi(str,"KbdStuff")) return hcKbdStuff;
if (!strcmpi(str,"KeyFlush")) return hcKeyFlush;
l:
if (!strcmpi(str,"Lang")) return hcLang;
if (!strcmpi(str,"LangExt")) return hcLangExt;
if (!strcmpi(str,"LastAns")) return hcLastAns;
if (!strcmpi(str,"LastIn")) return hcLastIn;
if (!strcmpi(str,"Left")) return hcLeft;
if (!strcmpi(str,"Len")) return hcLen;
if (!strcmpi(str,"Let")) return hcLet;
if (!strcmpi(str,"Log")) return hcLog;
if (!strcmpi(str,"LoggedOn")) return hcLoggedOn;
if (!strcmpi(str,"LoMsgNum")) return hcLoMsgNum;
if (!strcmpi(str,"Loop")) return hcLoop;
if (!strcmpi(str,"Lower")) return hcLower;
if (!strcmpi(str,"Lprinted")) return hcLprinted;
if (!strcmpi(str,"Ltrim")) return hcLtrim;
if (!strcmpi(str,"LfAfter")) return hcPredefConsts;
if (!strcmpi(str,"LfBefore")) return hcPredefConsts;
if (!strcmpi(str,"Logit")) return hcPredefConsts;
if (!strcmpi(str,"LogitLeft")) return hcPredefConsts;
if (!strcmpi(str,"Long")) return hcDataTypes;
m:
if (!strcmpi(str,"MGetByte")) return hcMGetByte;
if (!strcmpi(str,"MInkey")) return hcMInkey;
if (!strcmpi(str,"MPrint")) return hcMPrint;
if (!strcmpi(str,"MPrintLn")) return hcMPrintLn;
if (!strcmpi(str,"Mask_alnum")) return hcMask_Alnum;
if (!strcmpi(str,"Mask_alpha")) return hcMask_Alpha;
if (!strcmpi(str,"Mask_ascii")) return hcMask_Ascii;
if (!strcmpi(str,"Mask_file")) return hcMask_File;
if (!strcmpi(str,"Mask_num")) return hcMask_Num;
if (!strcmpi(str,"Mask_path")) return hcMask_Path;
if (!strcmpi(str,"Mask_pwd")) return hcMask_Pwd;
if (!strcmpi(str,"MaxNode")) return hcMaxNode;
if (!strcmpi(str,"MdmFlush")) return hcMdmFlush;
if (!strcmpi(str,"MegaNum")) return hcMegaNum;
if (!strcmpi(str,"Message")) return hcMessage;
if (!strcmpi(str,"Mid")) return hcMid;
if (!strcmpi(str,"Min")) return hcMin;
if (!strcmpi(str,"MinLeft")) return hcMinLeft;
if (!strcmpi(str,"MinOn")) return hcMinOn;
if (!strcmpi(str,"Mixed")) return hcMixed;
if (!strcmpi(str,"MkAddr")) return hcMkAddr;
if (!strcmpi(str,"MkDate")) return hcMkDate;
if (!strcmpi(str,"Modem")) return hcModem;
if (!strcmpi(str,"Month")) return hcMonth;
if (!strcmpi(str,"More")) return hcMore;
if (!strcmpi(str,"MouseReg")) return hcMouseReg;
if (!strcmpi(str,"Money")) return hcDataTypes;
if (!strcmpi(str,"MAXMSGS")) return hcQwkLimits;
if (!strcmpi(str,"MSGTOFILE")) return hcMsgToFile;
n:
if (!strcmpi(str,"NewLine")) return hcNewLine;
if (!strcmpi(str,"NewLines")) return hcNewLines;
if (!strcmpi(str,"NoChar")) return hcNoChar;
if (!strcmpi(str,"Not")) return hcNot;
if (!strcmpi(str,"Nc")) return hcPredefConsts;
if (!strcmpi(str,"NoClear")) return hcPredefConsts;
if (!strcmpi(str,"No_User")) return hcPredefConsts;
if (!strcmpi(str,"Next")) return hcForNext;
if (!strcmpi(str,"NEWBALANCE")) return hcAccounting;
o:
if (!strcmpi(str,"OnLocal")) return hcOnLocal;
if (!strcmpi(str,"OpText")) return hcOpText;
if (!strcmpi(str,"OpenCap")) return hcOpenCap;
if (!strcmpi(str,"Or")) return hcOr;
if (!strcmpi(str,"O_Rd")) return hcPredefConsts;
if (!strcmpi(str,"O_Rw")) return hcPredefConsts;
if (!strcmpi(str,"O_Wr")) return hcPredefConsts;
if (!strcmpi(str,"OUTBYTES")) return hcOutBytes;
p:
if (!strcmpi(str,"PPEName")) return hcPPEName;
if (!strcmpi(str,"PPEPath")) return hcPPEPath;
if (!strcmpi(str,"PPLBufSize")) return hcPPLBufSize;
if (!strcmpi(str,"PRFound")) return hcPRFound;
if (!strcmpi(str,"PRFoundLn")) return hcPRFound;
if (!strcmpi(str,"PageOff")) return hcPageOff;
if (!strcmpi(str,"PageOn")) return hcPageOn;
if (!strcmpi(str,"PageStat")) return hcPageStat;
if (!strcmpi(str,"PcbDat")) return hcPcbDat;
if (!strcmpi(str,"PcbNode")) return hcPcbNode;
if (!strcmpi(str,"PeekB")) return hcPeekB;
if (!strcmpi(str,"Peek")) return hcPeekB;
if (!strcmpi(str,"PeekDW")) return hcPeekDW;
if (!strcmpi(str,"PeekW")) return hcPeekW;
if (!strcmpi(str,"PokeB")) return hcPokeB;
if (!strcmpi(str,"Poke")) return hcPokeB;
if (!strcmpi(str,"PokeDW")) return hcPokeDW;
if (!strcmpi(str,"PokeW")) return hcPokeW;
if (!strcmpi(str,"Pop")) return hcPop;
if (!strcmpi(str,"Print")) return hcPrint;
if (!strcmpi(str,"PrintLn")) return hcPrintLn;
if (!strcmpi(str,"PromptStr")) return hcPromptStr;
if (!strcmpi(str,"Psa")) return hcPsa;
if (!strcmpi(str,"Push")) return hcPush;
if (!strcmpi(str,"PutAltUser")) return hcPutAltUser;
if (!strcmpi(str,"PutUser")) return hcPutUser;
if (!strcmpi(str,"Peek")) return hcPeekB;
if (!strcmpi(str,"Poke")) return hcPokeB;
if (!strcmpi(str,"PAY_UPBYTES")) return hcAccounting;
if (!strcmpi(str,"PAY_UPFILE")) return hcAccounting;
if (!strcmpi(str,"PCBACCOUNT")) return hcPCBAccount;
if (!strcmpi(str,"PCBACCSTAT")) return hcPcbAccStat;
if (!strcmpi(str,"PCBMAC")) return hcPcbMac;
if (!strcmpi(str,"PROC")) return hcProcedure;
if (!strcmpi(str,"PROCEDURE")) return hcProcedure;
q:
if (!strcmpi(str,"Quest")) return hcQuest;
if (!strcmpi(str,"Quit")) return hcQuit;
if (!strcmpi(str,"QWKLIMITS")) return hcQwkLimits;
r:
if (!strcmpi(str,"Random")) return hcRandom;
if (!strcmpi(str,"RdUnet")) return hcRdUnet;
if (!strcmpi(str,"RdUsys")) return hcRdUsys;
if (!strcmpi(str,"ReDim")) return hcReDim;
if (!strcmpi(str,"ReadLine")) return hcReadLine;
if (!strcmpi(str,"RegAh")) return hcRegAh;
if (!strcmpi(str,"RegAl")) return hcRegAl;
if (!strcmpi(str,"RegAx")) return hcRegAx;
if (!strcmpi(str,"RegBh")) return hcRegBh;
if (!strcmpi(str,"RegBl")) return hcRegBl;
if (!strcmpi(str,"RegBx")) return hcRegBx;
if (!strcmpi(str,"RegCf")) return hcRegCf;
if (!strcmpi(str,"RegCh")) return hcRegCh;
if (!strcmpi(str,"RegCl")) return hcRegCl;
if (!strcmpi(str,"RegCx")) return hcRegCx;
if (!strcmpi(str,"RegDh")) return hcRegDh;
if (!strcmpi(str,"RegDi")) return hcRegDi;
if (!strcmpi(str,"RegDl")) return hcRegDl;
if (!strcmpi(str,"RegDs")) return hcRegDs;
if (!strcmpi(str,"RegDx")) return hcRegDx;
if (!strcmpi(str,"RegEs")) return hcRegEs;
if (!strcmpi(str,"RegF")) return hcRegF;
if (!strcmpi(str,"RegSi")) return hcRegSi;
if (!strcmpi(str,"Rename")) return hcRename;
if (!strcmpi(str,"Replace")) return hcReplace;
if (!strcmpi(str,"ReplaceStr")) return hcReplaceStr;
if (!strcmpi(str,"ResetDisp")) return hcResetDisp;
if (!strcmpi(str,"RestScrn")) return hcRestScrn;
if (!strcmpi(str,"Return")) return hcReturn;
if (!strcmpi(str,"Right")) return hcRight;
if (!strcmpi(str,"Rtrim")) return hcRtrim;
if (!strcmpi(str,"Real")) return hcDataTypes;
if (!strcmpi(str,"RECORDUSAGE")) return hcRecordUsage;
s:
if (!strcmpi(str,"S2i")) return hcS2i;
if (!strcmpi(str,"SPrint")) return hcSPrint;
if (!strcmpi(str,"SPrintLn")) return hcSPrintLn;
if (!strcmpi(str,"SaveScrn")) return hcSaveScrn;
if (!strcmpi(str,"ScrFile")) return hcScrFile;
if (!strcmpi(str,"ScrText")) return hcScrText;
if (!strcmpi(str,"SearchFind")) return hcSearchFind;
if (!strcmpi(str,"SearchInit")) return hcSearchInit;
if (!strcmpi(str,"SearchStop")) return hcSearchStop;
if (!strcmpi(str,"Sec")) return hcSec;
if (!strcmpi(str,"SendModem")) return hcSendModem;
if (!strcmpi(str,"Shell")) return hcShell;
if (!strcmpi(str,"ShowOff")) return hcShowOff;
if (!strcmpi(str,"ShowOn")) return hcShowOn;
if (!strcmpi(str,"ShowStat")) return hcShowStat;
if (!strcmpi(str,"SlPath")) return hcSlPath;
if (!strcmpi(str,"Sort")) return hcSort;
if (!strcmpi(str,"Sound")) return hcSound;
if (!strcmpi(str,"Space")) return hcSpace;
if (!strcmpi(str,"StartDisp")) return hcStartDisp;
if (!strcmpi(str,"Stop")) return hcStop;
if (!strcmpi(str,"String")) return hcString;
if (!strcmpi(str,"Strip")) return hcStrip;
if (!strcmpi(str,"StripAtx")) return hcStripAtx;
if (!strcmpi(str,"StripStr")) return hcStripStr;
if (!strcmpi(str,"Syntax")) return hcSyntax;
if (!strcmpi(str,"SysopSec")) return hcSysopSec;
if (!strcmpi(str,"Sec")) return hcPredefConsts;
if (!strcmpi(str,"Stacked")) return hcPredefConsts;
if (!strcmpi(str,"String")) return hcDataTypes;
if (!strcmpi(str,"S_Db")) return hcPredefConsts;
if (!strcmpi(str,"S_Dn")) return hcPredefConsts;
if (!strcmpi(str,"S_Dr")) return hcPredefConsts;
if (!strcmpi(str,"S_Dw")) return hcPredefConsts;
if (!strcmpi(str,"SByte")) return hcDataTypes;
if (!strcmpi(str,"SWord")) return hcDataTypes;
if (!strcmpi(str,"SDWord")) return hcDataTypes;
if (!strcmpi(str,"Short")) return hcDataTypes;
if (!strcmpi(str,"Sub")) return hcGoSub;
if (!strcmpi(str,"SCANMSGHDR")) return hcScanMsgHdr;
if (!strcmpi(str,"SEC_DROP")) return hcAccounting;
if (!strcmpi(str,"SELECT")) return hcSelect;
if (!strcmpi(str,"SETENV")) return hcSetEnv;
if (!strcmpi(str,"SETLMR")) return hcSetLmr;
if (!strcmpi(str,"STACKABORT")) return hcStackAbort;
if (!strcmpi(str,"STACKERR")) return hcStackErr;
if (!strcmpi(str,"STACKLEFT")) return hcStackLeft;
if (!strcmpi(str,"START_BAL")) return hcAccounting;
if (!strcmpi(str,"START_SESSION")) return hcAccounting;
if (!strcmpi(str,"STK_LIMIT")) return hcPredefVars;
t:
if (!strcmpi(str,"Time")) return hcTime;
if (!strcmpi(str,"To")) return hcTo;
if (!strcmpi(str,"TPACGet")) return hcTPACGet;
if (!strcmpi(str,"TPACPut")) return hcTPACPut;
if (!strcmpi(str,"TPACRead")) return hcTPACRead;
if (!strcmpi(str,"TPACWrite")) return hcTPACWrite;
if (!strcmpi(str,"TPAGet")) return hcTPAGet;
if (!strcmpi(str,"TPAPut")) return hcTPAPut;
if (!strcmpi(str,"TPARead")) return hcTPARead;
if (!strcmpi(str,"TPAWrite")) return hcTPAWrite;
if (!strcmpi(str,"TempPath")) return hcTempPath;
if (!strcmpi(str,"TimeAP")) return hcTimeAP;
if (!strcmpi(str,"TokCount")) return hcTokCount;
if (!strcmpi(str,"TokenStr")) return hcTokenStr;
if (!strcmpi(str,"Tokenize")) return hcTokenize;
if (!strcmpi(str,"Trim")) return hcTrim;
if (!strcmpi(str,"True")) return hcPredefConsts;
if (!strcmpi(str,"Then")) return hcIfThen;
if (!strcmpi(str,"ToBoolean")) return hcToType;
if (!strcmpi(str,"ToMoney")) return hcToType;
if (!strcmpi(str,"ToString")) return hcToType;
if (!strcmpi(str,"ToBigStr")) return hcToType;
if (!strcmpi(str,"ToInteger")) return hcToType;
if (!strcmpi(str,"ToUnsigned")) return hcToType;
if (!strcmpi(str,"ToReal")) return hcToType;
if (!strcmpi(str,"ToDReal")) return hcToType;
if (!strcmpi(str,"ToFloat")) return hcToType;
if (!strcmpi(str,"ToDouble")) return hcToType;
if (!strcmpi(str,"ToDate")) return hcToType;
if (!strcmpi(str,"ToEDate")) return hcToType;
if (!strcmpi(str,"ToTime")) return hcToType;
if (!strcmpi(str,"ToByte")) return hcToType;
if (!strcmpi(str,"ToWord")) return hcToType;
if (!strcmpi(str,"ToDWord")) return hcToType;
if (!strcmpi(str,"ToUByte")) return hcToType;
if (!strcmpi(str,"ToUWord")) return hcToType;
if (!strcmpi(str,"ToUDWord")) return hcToType;
if (!strcmpi(str,"ToSByte")) return hcToType;
if (!strcmpi(str,"ToSWord")) return hcToType;
if (!strcmpi(str,"ToSDWord")) return hcToType;
if (!strcmpi(str,"ToShort")) return hcToType;
if (!strcmpi(str,"ToInt")) return hcToType;
if (!strcmpi(str,"ToLong")) return hcToType;
if (!strcmpi(str,"To")) return hcTo;
if (!strcmpi(str,"TODDATE")) return hcToDDate;
u:
if (!strcmpi(str,"U_Bdl")) return hcU_Bdl;
if (!strcmpi(str,"U_BdlDay")) return hcU_BdlDay;
if (!strcmpi(str,"U_Bul")) return hcU_Bul;
if (!strcmpi(str,"U_Fdl")) return hcU_Fdl;
if (!strcmpi(str,"U_Ful")) return hcU_Ful;
if (!strcmpi(str,"U_InConf")) return hcU_InConf;
if (!strcmpi(str,"U_LDate")) return hcU_LDate;
if (!strcmpi(str,"U_LDir")) return hcU_LDir;
if (!strcmpi(str,"U_LTime")) return hcU_LTime;
if (!strcmpi(str,"U_Lmr")) return hcU_Lmr;
if (!strcmpi(str,"U_Logons")) return hcU_Logons;
if (!strcmpi(str,"U_MsgRd")) return hcU_MsgRd;
if (!strcmpi(str,"U_MsgWr")) return hcU_MsgWr;
if (!strcmpi(str,"U_Name")) return hcU_Name;
if (!strcmpi(str,"U_PwdHist")) return hcU_PwdHist;
if (!strcmpi(str,"U_PwdLc")) return hcU_PwdLc;
if (!strcmpi(str,"U_PwdTc")) return hcU_PwdTc;
if (!strcmpi(str,"U_RecNum")) return hcU_RecNum;
if (!strcmpi(str,"U_Stat")) return hcU_Stat;
if (!strcmpi(str,"U_TimeOn")) return hcU_TimeOn;
if (!strcmpi(str,"Un_City")) return hcUn_City;
if (!strcmpi(str,"Un_Name")) return hcUn_Name;
if (!strcmpi(str,"Un_Oper")) return hcUn_Oper;
if (!strcmpi(str,"Un_Stat")) return hcUn_Stat;
if (!strcmpi(str,"Upper")) return hcUpper;
if (!strcmpi(str,"UserAlias")) return hcUserAlias;
if (!strcmpi(str,"Upcase")) return hcPredefConsts;
if (!strcmpi(str,"U_Cls")) return hcPredefVars;
if (!strcmpi(str,"U_Def79")) return hcPredefVars;
if (!strcmpi(str,"U_Expert")) return hcPredefVars;
if (!strcmpi(str,"U_Fse")) return hcPredefVars;
if (!strcmpi(str,"U_Fsep")) return hcPredefVars;
if (!strcmpi(str,"U_LongHdr")) return hcPredefVars;
if (!strcmpi(str,"U_Scroll")) return hcPredefVars;
if (!strcmpi(str,"U_ExpDate")) return hcPredefVars;
if (!strcmpi(str,"U_PwdExp")) return hcPredefVars;
if (!strcmpi(str,"U_ExpSec")) return hcPredefVars;
if (!strcmpi(str,"U_PageLen")) return hcPredefVars;
if (!strcmpi(str,"U_Sec")) return hcPredefVars;
if (!strcmpi(str,"U_Addr")) return hcPredefVars;
if (!strcmpi(str,"U_Alias")) return hcPredefVars;
if (!strcmpi(str,"U_BdPhone")) return hcPredefVars;
if (!strcmpi(str,"U_City")) return hcPredefVars;
if (!strcmpi(str,"U_Cmnt1")) return hcPredefVars;
if (!strcmpi(str,"U_Cmnt2")) return hcPredefVars;
if (!strcmpi(str,"U_HvPhone")) return hcPredefVars;
if (!strcmpi(str,"U_Notes")) return hcPredefVars;
if (!strcmpi(str,"U_Pwd")) return hcPredefVars;
if (!strcmpi(str,"U_Trans")) return hcPredefVars;
if (!strcmpi(str,"U_Ver")) return hcPredefVars;
if (!strcmpi(str,"Unsigned")) return hcDataTypes;
if (!strcmpi(str,"UByte")) return hcDataTypes;
if (!strcmpi(str,"UWord")) return hcDataTypes;
if (!strcmpi(str,"UDWord")) return hcDataTypes;
if (!strcmpi(str,"USEFUNCS")) return hcCompileDirective;
v:
if (!strcmpi(str,"ValCC")) return hcValCC;
if (!strcmpi(str,"ValDate")) return hcValDate;
if (!strcmpi(str,"ValTime")) return hcValTime;
if (!strcmpi(str,"VarAddr")) return hcVarAddr;
if (!strcmpi(str,"VarOff")) return hcVarOff;
if (!strcmpi(str,"VarSeg")) return hcVarSeg;
if (!strcmpi(str,"Ver")) return hcVer;
if (!strcmpi(str,"VAR")) return hcProcedure;
w:
if (!strcmpi(str,"Wait")) return hcWait;
if (!strcmpi(str,"WaitFor")) return hcWaitFor;
if (!strcmpi(str,"While")) return hcWhile;
if (!strcmpi(str,"WrUnet")) return hcWrUnet;
if (!strcmpi(str,"WrUsys")) return hcWrUsys;
if (!strcmpi(str,"WrUsysDoor")) return hcWrUsysDoor;
if (!strcmpi(str,"WordWrap")) return hcPredefConsts;
if (!strcmpi(str,"Word")) return hcDataTypes;
if (!strcmpi(str,"WARN_LEVEL")) return hcAccounting;
x:
if (!strcmpi(str,"Xor")) return hcXor;
y:
if (!strcmpi(str,"Year")) return hcYear;
if (!strcmpi(str,"YesChar")) return hcYesChar;
if (!strcmpi(str,"YesNo")) return hcPredefConsts;
arrobas:
if (!strncmpi(str,"@X",2)) return hcArrobasColors;
if (!strcmpi(str,"@OPTEXT@")) return hcOpText;

return(1000);
}




