#if !defined( __ASCII_H )
#define __ASCII_H

const int cmColorTableCmdBase = 911;
const int cmColorFocused       =   0;


class TColorTable : public TView
{

public:

    TColorTable( TRect& r );
    TColorTable( StreamableInit ) : TView(streamableInit) { };
    virtual void draw();
    virtual void handleEvent( TEvent& event );
    void colorFocused();

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};


inline ipstream& operator >> ( ipstream& is, TColorTable& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TColorTable*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TColorTable& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TColorTable* cl )
    { return os << (TStreamable *) cl; }


class TColorReport : public TView
{

public:

    TColorReport( TRect& r );
    TColorReport( StreamableInit ) : TView(streamableInit) { };
    virtual void draw();
    virtual void handleEvent( TEvent& event );
    long colorCode;

private:


    virtual const char *streamableName() const
	{ return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorReport& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TColorReport*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TColorReport& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TColorReport* cl )
    { return os << (TStreamable *) cl; }


class TColorChart : public TWindow
{

public:

    TColorChart();
    TColorChart( StreamableInit ) : TWindow(streamableInit),
				    TWindowInit(&initFrame) { };

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorChart& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TColorChart*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TColorChart& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TColorChart* cl )
    { return os << (TStreamable *) cl; }


#endif      // __ASCII_H
