/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/**************************************************************************/
/******** VFS 1.0                                                  ********/
/********                                    Functions Prototypes  ********/
/********     Virtual File System                                  ********/
/**************************************************************************/

#ifndef __VFS_H
#define __VFS_H

#define VFS_FILE_INC 32767
#define VFS_FILE_READBIN 0
#define VFS_FILE_READTXT 1
#define VFS_FILE_WRITEBIN 2
#define VFS_FILE_WRITETXT 3

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif


typedef struct {
	huge unsigned char *data;
    unsigned long ptr;
    unsigned long size;
    unsigned long limit;
//    unsigned long truesize;
    char filename[255];
    char mode;
    } vfs_file;

#ifdef __cplusplus
extern "C" {
#endif

vfs_file *vfs_fopenread(char *fl, int mode);
void vfs_fread(void *ptr, size_t size, size_t n, vfs_file *buf);
void vfs_fseek(vfs_file *fl, long i, int whence);
unsigned long vfs_ftell(vfs_file *fl);
void vfs_fclose(vfs_file *fl);
size_t vfs_fwrite(void *ptr, size_t size, size_t n, vfs_file *buf);
vfs_file *vfs_fopenwrite(char *fl, int mode);
void vfs_fputs(char *str, vfs_file *fl);
void vfs_fputc(char c, vfs_file *fl);
int vfs_feof(vfs_file *fl);
char *vfs_fgets(char *dest, int n, vfs_file *fl);
char vfs_fgetc(vfs_file *fl);
vfs_file *vfs_outtoin(vfs_file *out, int mode);

#ifdef __cplusplus
}
#endif

#endif

