/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
                           + Project Frontier +

 PPL Runtime

 RUNTIME FUNCTIONS DEFINITIONS 

*/

#ifndef __PPL_H
#define __PPL_H

#include "..\lang\ppl_type.h"
#include "..\lang\vfs.h"
#include "..\com\system.h"
#include <stdio.h>
#include <dos.h>
#include <dir.h>

#define FRONTIER_VERSION 5 // Frontier kernel version * 100
#define FRONTIER_BETA 1    // 1 = beta, 0 = release

#ifdef __cplusplus
extern "C" {
#endif

		     int fppe_runPPE(char *file);
            void fppe_runScript(void);
	         int fppe_loadPPE(char *);
            void fppe_allocValue(pplvar *);
          double fppe_getValue(pplvar *);
	        void fppe_setValue(pplvar *, double);
         pplvar *fppe_newvar(int type, char nDim, int dim[3]);
         pplvar *fppe_copytable1var(pplvar *d1, pplvar *v);
         pplvar *fppe_copytable2var(pplvar *d1, pplvar *d2, pplvar *v);
         pplvar *fppe_copytable3var(pplvar *d1, pplvar *d2, pplvar *d3, pplvar *v);
			long fppe_table1dec(pplvar *v, int a1);
			long fppe_table2dec(pplvar *v, int a1, int a2);
			long fppe_table3dec(pplvar *v, int a1, int a2, int a3);
	        void fppe_pushvar(pplvar *);
	        void fppe_unallocvars(void);
	        void fppe_freevar(pplvar *);
	        void fppe_pushGosubStack(unsigned int);
	unsigned int fppe_popGosubStack(void);
            void fppe_unallocPPEvars(void);
      parse_type fppe_popParse(void);
            void fppe_pushParse(parse_type p);
	        void fppe_allocPPESystem(void);
	        void fppe_freePPESystem(void);
         pplvar *fppe_execFunc(pplvar *);
            void fppe_execProc(pplvar *);
	     pplvar *fppe_toStringVar(pplvar *);
			void fppe_ToString(char *buf, pplvar *v);
            void fppe_runtimeError(char *msg);
			void fppe_reloadUserVars(void);
			void fppe_assignStrVarToAny(pplvar *s, char *str);
			void fppe_allocStrTable(pplvar *s, unsigned int elems, int elemSize);
			void fppe_unallocStrTable(pplvar *s, unsigned int elems);
			void fppe_assignVar(pplvar *d, pplvar *s);
			 int fppe_isFloat(pplvar *s);
			 int fppe_isStr(pplvar *s);
			 int fppe_isSigned(pplvar *s);
			void fppe_strcpy(pplvar *dest, char*src);
			void fppe_strncpy(pplvar *dest, char*src, int size);
		   char *fppe_Cstr(char *str);
	     pplvar *fppe_intPplVar(int a);
			void fppe_rewriteUserVars(void);
			void fppe_extendString(pplvar *s, int size);
			 int fppe_sizeofType(int type);

#ifdef __cplusplus
}
#endif

extern int narg;
extern pplvar **argument;
extern int endPPE;
extern int doCloseUp;
extern int breakPPE;
extern char IFresult;
extern FILE *fileHandle[];								// handles (add 1, -1 to 7)
extern ferr[];								            // ferr
extern struct REGPACK ppeREGS;							// dointr regs
extern int execStrings;
extern pplvar emptyVar;
extern pplvar zeroVar;
extern char *PPErunning;
extern int defaultIn, defaultOut;
extern struct ffblk ppl_ffblk;
extern int curProc;
extern int inPPE;
extern char readlineLastFile[MAXPATH];
extern userType ppe_user;
extern int totalPPLVars;
extern pplvar **vars;
extern pplvar **globalVars;
extern long curOffset;
extern vfs_file *script;
extern long codestart;
extern char tmpS[];
extern int nVars;
extern int globalNVars;
extern int imbrication;
#ifdef DEBUGGER
extern int identHdr;
#endif

#endif
