/* keywatch.c 12-29-91 Robert Mashlan, Public Domain                */
/* modified by Francis Gastellu*/

// Hotkeys support

#include <alloc.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <time.h>
#include "..\com\keywatch.h"
#include "..\com\system.h"
#include "..\lang\ppl.h"

#ifdef DEBUGGER
#include "..\lang\debug.h"
#endif

#pragma option -O2


volatile char k=0;
volatile char ek=0;
volatile char kf=0;
volatile char keys[128];            // array of key states
volatile char ekeys[128];           // array of AT key states
volatile int keyPressed=0;

void interrupt (*oldkbisr)();    	// address of old kb ISR
void interrupt (*oldbreakisr)();    // address of old kb ISR

void keyboardisr(void)
{
int a;
for (a = 0;a<128;a++)
	{ keys[a]= 0; ekeys[a]=0; }

oldkbisr=getvect(0x09);
setvect(0x09,newkbisr);
#ifdef BREAKHANDLER
oldbreakisr=getvect(0x1B);
setvect(0x1B,newbreakisr);
#endif
}

void remkeyboardisr(void)
{
setvect(0x09,oldkbisr);
#ifdef BREAKHANDLER
setvect(0x1B,oldbreakisr);
#endif
}

void interrupt newbreakisr(void)
{
#ifdef DEBUGGER
nextBreak=-1;
fullRun=0;
#endif
}

void interrupt far newkbisr(void)
{
      static extkey;
      BYTE scancode = (BYTE)keyport();         /* read keyboard scan code */

      if (scancode == 0xe0)
            extkey = 1;               /* use ekey array on next scan code */
      else
      {
            if (scancode & 0x80)
                  (extkey ? ekeys : keys)[scancode & 0x7f] = 0;
            else {
				(extkey ? ekeys : keys)[scancode] = 1;
                k = ek = 0;
                if (extkey)
					ek = scancode;
                else
                	k = scancode;
                kf = 0;
                if (keys[0x36] || keys[0x2A]) kf |= 1;
                if (keys[0x1D] || ekeys[0x1D]) kf |= 2;
                if (keys[0x38] || ekeys[0x38]) kf |= 4;
			    keyPressed=1;
            	}
            extkey = 0;
      }
        picEdge();

      oldkbisr();                       /* chain to previous keyboard ISR */
}




