{$R-,S-,I-,D-,V-,B-,N-,L- }
{$O+}
unit statret;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

interface

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}


uses gentypes,dos;

type systemstatus=array [1..511] of byte;

VAR numcallers:real;
    tonext:integer;
    sysopavail:availtype;
    lastdayup:sstr;
    numdaysup,callstoday:integer;
    numminsidle,numminsused,numminsxfer:minuterec;
    timedeventdate:sstr;
    newfeedback,newuploads,newcalls,newposts,newmail:integer;
    dummyfiller:array [1..500] of byte;

Function timer:integer;
Procedure starttimer (VAR m:minuterec);
Function elapsedtime (VAR m:minuterec):integer;
Procedure stoptimer (VAR m:minuterec);
Procedure writestatus;
Procedure readstatus;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

implementation

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}


Function timer:integer;
VAR r:registers;
begin
  r.ax:=$2c00;
  intr ($21,r);
  timer:=(r.cx shr 8)*60+(r.cx and 255)
end;

Procedure starttimer (VAR m:minuterec);
begin
  if m.started then exit;
  m.startedat:=timer;
  m.started:=true
end;

Function elapsedtime (VAR m:minuterec):integer;
VAR n:integer;
begin
  if not m.started then begin
    elapsedtime:=0;
    m.startedat:=timer;
    exit
  end;
  n:=timer-m.startedat;
  if n<0 then n:=n+1440;
  elapsedtime:=n
end;

Procedure stoptimer (VAR m:minuterec);
begin
  if not m.started then begin
    m.startedat:=0;
    exit
  end;
  m.startedat:=elapsedtime(m);
  m.total:=m.total+m.startedat;
  m.started:=false
end;

Procedure writestatus;
const numtimers=3;
type timerset=array [1..numtimers] of minuterec;
VAR realt:timerset absolute numminsidle;
    t:timerset;
    cnt:integer;
    ss:systemstatus absolute numcallers;
    f:file of systemstatus;
begin
  assign (f,'Status');
  rewrite (f);
  t:=realt;
  for cnt:=1 to numtimers do
    if realt[cnt].started
     then stoptimer (realt[cnt]);
  write (f,ss);
  realt:=t;
  close (f)
end;

Procedure readstatus;
VAR f:file of systemstatus;
    ss:systemstatus absolute numcallers;
begin
  assign (f,'Status');
  reset (f);
  if ioresult<>0 then begin
    fillchar (numcallers,511,0);
    tonext:=-1;
    sysopavail:=bytime;
    writestatus;
    exit
  end;
  read (f,ss);
  close (f)
end;

end.
