{$R-,S-,I-,D-,V-,B-,N-,L- }
{$O-}
unit modem;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

interface

uses crt,dos;

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}


const RBR=$3F8; THR=$3F8; DLL=$3F8; DLM=$3F9; IER=$3F9;
      IIR=$3FA; LCR=$3FB; MCR=$3FC; LSR=$3FD; MSR=$3FE;
      intnum=255;

VAR icomoffset:integer;

Procedure mfunc (VAR r:registers; ahval,alval:byte);
Procedure sendchar (k:char);
Function numchars:integer;
Function getchar:char;
Procedure hangup;
Procedure setoutbuffer (size:integer);
Procedure setparam (comnum:byte; baud:integer; parity:boolean);
Function carrier:boolean;
Function driverpresent:boolean;
Procedure setterminalready (b:boolean);
Procedure dontanswer;
Procedure doanswer;


{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}

implementation

{/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\}


Procedure mfunc (VAR r:registers; ahval,alval:byte);
begin
  r.ax:=alval+(ahval shl 8);
  intr (intnum,r)
end;

Procedure sendchar (k:char);
VAR r:registers;
begin
  mfunc (r,3,ord(k))
end;

Function numchars:integer;
VAR r:registers;
begin
  mfunc (r,1,0);
  numchars:=r.ax
end;

Function getchar:char;
VAR r:registers;
begin
  mfunc (r,2,0);
  getchar:=chr(r.ax and 255)
end;

Procedure hangup;
VAR r:registers;
begin
  mfunc (r,6,0);
  delay (200)
end;

Procedure setoutbuffer (size:integer);
VAR r:registers;
begin
  r.bx:=size;
  mfunc (r,8,0)
end;

Procedure setparam (comnum:byte; baud:integer; parity:boolean);
VAR r:registers;
    p:byte;
begin
  mfunc (r,0,comnum);
  r.bx:=baud;
  if parity then p:=1 else p:=0;
  mfunc (r,7,p);
  setoutbuffer (baud div 30);
  case comnum of
    1:icomoffset:=0;
    2:icomoffset:=-256
  end
end;

Function carrier:boolean;
begin
  carrier:=(port[msr+icomoffset] and 128)=128
end;

Function driverpresent:boolean;
begin
  driverpresent:=memw[memw[0:intnum*4+2]:memw[0:intnum*4]]=7686
end;

Procedure setterminalready (b:boolean);
begin
  port [icomoffset+mcr]:=ord(b) or 8
end;

Procedure dontanswer;
begin
  setterminalready (false)
end;

Procedure doanswer;
begin
  setterminalready (true)
end;

Begin
end.
