program makeproto;

{$R-,S+,I-,D+,F-,V-,B-,N-,L+ }
{$M 16384,5000,5000 }

uses configrt,gentypes,general,dos,crt;

type
  fstr=string[8];

const protver='1.00';

type protorec = record
              letter:char;
                desc:string[30];
            progname:string[12];
                comm:string[60];
              end;

var pro:file of protorec; prots:protorec; which:char;
    filenm: string[15];
    updated:boolean;
    thekruft:string;
    protlist:array [1..120] of protorec; count:integer; work:string[80];

procedure makefile(fname:string);
var ff:file of protorec; frec:protorec;
begin
     assign(ff,fname);
     rewrite(ff);
     frec.letter:='Z';
     frec.desc:='External Zmodem';
     frec.progname:='DSZ.COM';
     frec.comm:=' port %1 speed %2 sz %3';
     write(ff,frec);
     close(ff);
end;

function exist(fname:string):boolean;
var ff:file;
begin
     assign(ff,fname); {$I-};
     reset(ff); {$I+};
     exist:=(ioresult=0);
end;



procedure dobar(width:integer);
var ct:integer;
begin
     write('[');
     for ct:=1 to width do write('');
     writeln(']');
end;

procedure readyfile;
begin
     count:=0; reset(pro);
     while not eof(pro) do begin
               count:=count+1;
               read(pro,prots);
               protlist[count].letter:=prots.letter;
               protlist[count].desc:=prots.desc;
               protlist[count].comm:=prots.comm;
               protlist[count].progname:=prots.progname;
               end;
end;

procedure tab (n:anystr; np:integer);
var cnt:integer;
begin
  write (n);
  for cnt:=length(n) to np-1 do begin
   write (' ');
  end;
end;

{Procedure DoLonglist;
var ct:integer;
begin;
      writeln;
      textcolor (9);
      write('[');
      textcolor (11);
      write('#');
      textcolor (9);
      write('] [');
      textcolor (11);
      write('Ltr');
      textcolor (9);
      write('] [');
      textcolor (11);
      write('Description of the Protocols');
      textcolor (9);
      write('] [');
      textcolor (11);
      write('Command Line of the Protocols');
      textcolor (9);
      writeln(']');
      textcolor (15);

For ct:=1 to count do begin
          write(ct:2,'    ',protlist[ct].letter,'   ');
          tab (protlist[ct].desc,31); writeln(protlist[ct].progname+protlist[ct].comm);
          end;
      writeln;
textcolor (11);
end;
}

procedure spacelen(le:byte);
   var aaa:byte;
   begin
    for aaa:=1 to le do
    write(' ');
end;

procedure top;
procedure wb(s: string);
begin
     textcolor(9);
     write(s);
end;
procedure wy(s: string);
begin
     textcolor(11);
     write(s);
end;
begin
     textcolor(9);
     writeln('   Ŀ');
     wb('   ');wy(' #');wb(' ');wy(' Ltr');wb(' ');wy('        Description');
     wb('          ');wy('         Command Line');textcolor(9);writeln('          ');
     textcolor(9);
     writeln('   Ĵ');
     textcolor(15);
end;

procedure bottom;
begin
     textcolor(9);
     writeln('   ');
     textcolor(15);
end;

Procedure DoLonglist;
var ct:integer;
begin;
      writeln;
      if count<1 then
      begin
           textcolor(11);
           writeln('No Protocols exist! Use [A] to add one.');
           textcolor(15);
           writeln;
           exit;
      end;
      top;
For ct:=1 to count do begin
          textcolor(9);
          write('   ');
          textcolor(15);
          write(ct:2);textcolor(9);write('   ');
          textcolor(15);write(protlist[ct].letter);
          textcolor(9);write('  ');textcolor(15);
          write(protlist[ct].desc);textcolor(9);
          spacelen(29-length(protlist[ct].desc));
          write('');textcolor(15);
          if length(protlist[ct].progname+protlist[ct].comm) < 31 then
          begin
               write(protlist[ct].progname+protlist[ct].comm);
               spacelen(31-length(protlist[ct].progname+protlist[ct].comm));
          end else
          begin
               thekruft:=protlist[ct].progname+protlist[ct].comm;
               delete(thekruft,29,length(thekruft));
               textcolor(15);
               write(thekruft);
               write('   ');
               textcolor(15);
               spacelen(31-length(thekruft+'   '));
          end;
          textcolor(9);writeln('');
          textcolor(15);
          end;
          bottom;
      writeln;
end;

Procedure GetParm(addit:string; lump:integer);
begin
     textcolor (11);
     writeln;
     writeln('Enter the ',addit,' protocol.');
     dobar(lump);
       write(':'); textcolor (12); readln(work);
end;

procedure edit;
var
   ct: integer;
   editnum: integer;
   done: boolean;

Function chg(dood: string): string;
var news: string;
begin
     textcolor(15);
     writeln;
     write('New '+dood); readln(news);
     if length(news)<1 then chg:='Undefined' else
     begin
          chg:=news;
          updated:=true;
     end;
     writeln;
end;

Function changeprot(s:char;dude:string): char;
var newc: string;
begin
     textcolor(15);
     writeln;
     write('New '+dude);readln(newc);
     if newc='' then changeprot:='!' else
     begin
          changeprot:=upcase(newc[1]);
          updated:=true;
     end;
end;

begin
     writeln;textcolor(15);
     write('Edit which protocol? [#]: '); readln(editnum);
     if (editnum > count) or (editnum <= 0) then
                writeln('Invalid must be between 1-',count,'!');
     if (editnum > count) or (editnum <= 0) then exit;
     writeln;
     textcolor(9);
     write('[');
     textcolor (15);write('L');
     textcolor (9);write('] ');
     textcolor (11);write('Letter       : ');textcolor(15);writeln(protlist[editnum].letter);
     textcolor(9);
     write('[');
     textcolor (15);write('D');
     textcolor (9);write('] ');
     textcolor (11);write('Description  : ');textcolor(15);writeln(protlist[editnum].desc);
     textcolor(9);
     write('[');
     textcolor (15);write('P');
     textcolor (9);write('] ');
     textcolor (11);write('Program Name : ');textcolor(15);writeln(protlist[editnum].progname);
     textcolor(9);
     write('[');
     textcolor (15);write('C');
     textcolor (9);write('] ');
     textcolor (11);write('Command Line : ');textcolor(15);writeln(protlist[editnum].comm);
     writeln;
     textcolor(9);
     write('[Edit Option] [CR/Quit]: ');
     textcolor(12);
     which:=upcase(readkey);
     writeln(which);
     case which of
          'L'   : protlist[editnum].letter:=changeprot('?','Letter: ');
          'D'   : protlist[editnum].desc:=chg('Description: ');
          'P'   : protlist[editnum].progname:=chg('Program Name: ');
          'C'   : begin
                       protlist[editnum].comm:=chg('Command Line: ');
                       protlist[editnum].comm:=' '+protlist[editnum].comm;
                  end;
          #13   : begin writeln;
     textcolor (11);
     write('Protocol Changed');
     textcolor (9);
     write('.  [');
     textcolor (15);
     write('S');
     textcolor (9);
     write(']');
     textcolor (11);
     write('ave to make permanent');
     textcolor (9);
     write('.'#13);
      end;
     end;
     exit;
end;

procedure Newprotocol;
begin
     writeln; count:=count+1;
     textcolor (11);
     writeln('Will be added as #',count,' to list.'); writeln;
     getparm('letter to respresent this',1); writeln;
     protlist[count].letter:=upcase(work[1]);
     getparm('description of the',30);
     protlist[count].desc:=copy(work,1,30);
     getparm('program name (i.e. DSZ.COM, LYNX.EXE) of this',12);
     protlist[count].progname:=copy(work,1,12); writeln; writeln;
     textcolor (11);
     writeln('Below show the PARAMETER-ONLY portion of the command line');
     writeln('Use : %1=Port   %2=Speed   %3=File/Pathname');
     writeln('(Ex: port=%1 baud=%2 R %3)  Be sure to remember WHICH protocol');
     writeln('list you are editing and have the command line reflect that.');
     writeln('(Ex: If you are adding an UPLOAD, you may have to type "R" or');
     writeln('"RZ" on the command line.  A seperate entry must be made for');
     writeln('other operations.');
     getparm('command line format for the',60);
     protlist[count].comm:=' '+copy(work,1,60);
     textcolor (11);
     writeln; writeln(protlist[count].desc,' added.  [S]ave to make permanent.');
writeln('Be sure that ',protlist[count].progname,' exists in your FAQ directory.');
     writeln;
end;

{procedure Changeprot;
begin
     write ('Protocol # to Change: ');
     readln(count2);
     if valu (count2)=0 then exit;
     textcolor (9);
     write (^M'[');
     textcolor (11);
     write ('A');
     textcolor (9);
     write (']');
     textcolor (15);
     write (' Letter     : ');
     textcolor (11);
     writeln (protlist[count].letter);
     textcolor (9);
     write ('[');
     textcolor (11);
     write ('B');
     textcolor (9);
     write (']');
     textcolor (15);
     write (' Description: ');
     textcolor (11);
     writeln (protlist[count].desc);
     write ('[');
     textcolor (11);
     write ('C');
     textcolor (9);
     write (']');
     textcolor (15);
     write (' Program Name: ');
     textcolor (11);
     writeln (protlist[count].progname);
     write ('[');
     textcolor (11);
     write ('D');
     textcolor (9);
     write (']');
     textcolor (15);
     write (' Command Line: ');
     textcolor (11);
     writeln (protlist[count].progname);
     writeln (^M'Change Protocol Command [Q/Quit]: ');
     getparm('letter to respresent this',1); writeln;
     protlist[count].letter:=upcase(work[1]);
     getparm('description of the',30);
     protlist[count].desc:=copy(work,1,30);
     getparm('program name (i.e. DSZ.COM, LYNX.EXE) of this',12);
     protlist[count].progname:=copy(work,1,12); writeln; writeln;
     textcolor (11);
     writeln('Below show the PARAMETER-ONLY portion of the command line');
     writeln('Use : %1=Port   %2=Speed   %3=File/Pathname');
     writeln('(Ex: port=%1 baud=%2 R %3)  Be sure to remember WHICH protocol');
     writeln('list you are editing and have the command line reflect that.');
     writeln('(Ex: If you are adding an UPLOAD, you may have to type "R" or');
     writeln('"RZ" on the command line.  A seperate entry must be made for');
     writeln('other operations.');
     getparm('command line format for the',60);
     protlist[count].comm:=' '+copy(work,1,60);
     textcolor (11);
     writeln; writeln(protlist[count].desc,' added.  [S]ave to make permanent.');
writeln('Be sure that ',protlist[count].progname,' exists in your FAQ directory.');
     writeln;
end;}

procedure deleteprotocol;
var delnum:integer; resp:char; lp:integer;
begin
     textcolor (15);
     writeln;
     write('Delete which protocol? [#]: '); textcolor(12); readln(delnum);
     textcolor (15);
     if (delnum > count) or (delnum <= 0) then
                writeln('Invalid... must be between 1-',count,'!');
     if (delnum > count) or (delnum <= 0) then exit;
     writeln;textcolor(11);
     write('Remove "',protlist[delnum].desc,'" from list? ');
     textcolor(12);
     resp:=upcase(readkey);
     if resp='N' then
     begin
          writeln('No');
          exit;
     end else writeln('Yes');
     for lp:=delnum to count do begin;
         protlist[lp].letter:=protlist[lp+1].letter;
         protlist[lp].desc  :=protlist[lp+1].desc;
         protlist[lp].comm  :=protlist[lp+1].comm;
       protlist[lp].progname:=protlist[lp+1].progname;
       end;
     writeln;
     textcolor (11);
     write('Protocol Deleted');
     textcolor (9);
     write('.  [');
     textcolor (15);
     write('S');
     textcolor (9);
     write(']');
     textcolor (11);
     write('ave to make permanent');
     textcolor (9);
     write('.');
     writeln; count:=count-1;
end;

function getyn(s: string):boolean;
var ch: char;
begin
     getyn:=false;
     textcolor(11);
     write(s+' ');
     textcolor(12);
     ch:=upcase(readkey);
     if ch='Y' then
     begin
          writeln('Yes');
          getyn:=true;
     end else
     begin
          writeln('No');
          getyn:=false;
     end;
end;

procedure savelist;
var ct:integer;
begin
     rewrite(pro);
     for ct:=1 to count do write(pro,protlist[ct]);
end;


begin;
      updated:=false;
      readconfig;
      if not exist (bbsdatadir+'con') then
      mkdir (copy(bbsdatadir,1,length(bbsdatadir)-1));
      if exist (faqdir+'protr.cfg') and not (exist(bbsdatadir+'protr.cfg')) then begin
      exec (getenv('COMSPEC'),'/C copy '+faqdir+'protr.cfg '+bbsdatadir+'protr.cfg >nul');
      exec (getenv('COMSPEC'),'/C del '+faqdir+'protr.cfg >nul'); end;
      if exist (faqdir+'prots.cfg') and not (exist(bbsdatadir+'prots.cfg')) then begin
      exec (getenv('COMSPEC'),'/C copy '+faqdir+'prots.cfg '+bbsdatadir+'prots.cfg >nul');
      exec (getenv('COMSPEC'),'/C del '+faqdir+'prots.cfg >nul'); end;
      if exist (faqdir+'protu.cfg') and not (exist(bbsdatadir+'protu.cfg')) then begin
      exec (getenv('COMSPEC'),'/C copy '+faqdir+'protu.cfg '+bbsdatadir+'protu.cfg >nul');
      exec (getenv('COMSPEC'),'/C del '+faqdir+'protu.cfg >nul'); end;
      if exist (faqdir+'protd.cfg') and not (exist(bbsdatadir+'protd.cfg')) then begin
      exec (getenv('COMSPEC'),'/C copy '+faqdir+'protd.cfg '+bbsdatadir+'protd.cfg >nul');
      exec (getenv('COMSPEC'),'/C del '+faqdir+'protd.cfg >nul'); end;
      if not exist(bbsdatadir+'PROTR.CFG') then makefile(bbsdatadir+'PROTR.CFG');
      if not exist(bbsdatadir+'PROTS.CFG') then makefile(bbsdatadir+'PROTS.CFG');
      if not exist(bbsdatadir+'PROTU.CFG') then makefile(bbsdatadir+'PROTU.CFG');
      if not exist(bbsdatadir+'PROTD.CFG') then makefile(bbsdatadir+'PROTD.CFG');
      clrscr;
      textcolor (9);
      write('[');
      textcolor (11);
      write('FAQ Protocol Editor - v'+protver+' / '+date+'  (C)Copyright FAQ Staff, 1991');
      textcolor (9);
      writeln(']');
      writeln;
      textcolor (9);
      writeln('Ŀ');
      write  (' [');
      textcolor (15);
      write ('R');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Upload/Send Protocols      ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('S');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Download/Receive Protocols ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('U');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Batch Upload Protocols     ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('D');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Batch Download Protocols   ');
      textcolor (9);
      writeln('');
      writeln('');
      writeln;
      textcolor (9); write ('Protocol or '); textcolor (15); write ('Q');
      textcolor (9); write ('/Quit: '); textcolor (12);
      repeat
      which:=upcase(readkey);
      until (which='U') or (which='D') or (which='R') or (which='S') or (which='Q');
      if (which='Q') then
      begin
           textcolor (12);
           writeln; writeln('Terminated.');
           textcolor (7);
           halt(1);
      end;
      writeln(which);
      which:=upcase(which);
      filenm:='PROT'+which+'.CFG';
      assign(pro,bbsdatadir+filenm);

      readyfile;
      writeln; writeln;
      textcolor (9);
      write('[');
      textcolor (11);
      write('Protocol File: ',filenm,' with ',count,' entries');
      textcolor (9);
      writeln(']');
      which:='X'; writeln;

      while (which<>'Q') do begin
      textcolor (15); write ('C'); textcolor (9); write (',');
      textcolor (15); write ('L'); textcolor (9); write (',');
      textcolor (15); write ('S'); textcolor (9); write (',');
      textcolor (15); write ('A'); textcolor (9); write (',');
      textcolor (15); write ('D'); textcolor (9); write (',');
      textcolor (15); write ('Q'); textcolor (9); write (',');
      textcolor (15); write ('?');
      textcolor (9); write ('-Enter Command, '); textcolor (15); write ('Q');
      textcolor (9); write ('/Quit, or '); textcolor (15); write ('?');
      textcolor (9); write ('/Help: '); textcolor (12);
      repeat
      which:=upcase(readkey);
      until (which='C') or (which='L') or (which='S') or (which='A') or (which='D') or (which='Q') or (which='?');
            writeln(which);
            case which of
                       'C'   : edit;
                       'L'   : dolonglist;
                       'S'   : savelist;
                       'A'   : newprotocol;
                       'D'   : deleteprotocol;
                       '?'   : begin
      writeln;
      textcolor (9);
      writeln('Ŀ');
      write  (' [');
      textcolor (15);
      write ('C');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Change Protocol Entry      ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('L');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' List Protocol Entries      ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('S');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Save Protocol Entries      ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('A');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Add Protocol Entry         ');
      textcolor (9);
      writeln('');
      write  (' [');
      textcolor (15);
      write ('D');
      textcolor (9);
      write  (']');
      textcolor (11);
      write  (' Delete Protocol Entry      ');
      textcolor (9);
      writeln('');
      writeln('');
      writeln; end;
                       else writeln;
                       end;
      end;
      textcolor (12);
      if updated and getyn('Save Changes? [y/n]:') then savelist;
      writeln('Done: Returning to DOS'); textcolor (7); close(pro);
end.
