UNIT PibAsync;

INTERFACE
                                   (* Uncomment PibMTask if the    *)
                                   (* multitasking interface is to *)
                                   (* be used.                     *)
USES
   Dos, Crt, GlobType, PibTimer{, PibMTask};

(*$I PIBASYNC.GLO *)

PROCEDURE BIOS_RS232_Init( ComPort : INTEGER; ComParm : WORD );
PROCEDURE Async_Close( Drop_DTR: BOOLEAN );
PROCEDURE Async_Clear_Errors;
PROCEDURE Async_Reset_Port( ComPort       : INTEGER;
                            BaudRate      : WORD;
                            Parity        : CHAR;
                            WordSize      : INTEGER;
                            StopBits      : INTEGER  );
FUNCTION  Async_Open( ComPort       : INTEGER;
                      BaudRate      : WORD;
                      Parity        : CHAR;
                      WordSize      : INTEGER;
                      StopBits      : INTEGER  ) : BOOLEAN;
PROCEDURE Async_Send( C : Char );
FUNCTION Async_Receive( VAR C : Char ) : BOOLEAN;
PROCEDURE Async_Receive_With_Timeout( Secs : INTEGER; VAR C : INTEGER );
PROCEDURE Async_Stuff( Ch: CHAR );
PROCEDURE Async_Find_Delay( VAR One_MS_Delay : INTEGER );
PROCEDURE Async_Init( Async_Buffer_Max  : INTEGER;
                      Async_OBuffer_Max : INTEGER;
                      Async_High_Lev1   : INTEGER;
                      Async_High_Lev2   : INTEGER;
                      Async_Low_Lev     : INTEGER );
FUNCTION  Async_Carrier_Detect : BOOLEAN;
FUNCTION  Async_Carrier_Drop : BOOLEAN;
PROCEDURE Async_Term_Ready( Ready_Status : BOOLEAN );
FUNCTION  Async_Buffer_Check : BOOLEAN;
FUNCTION  Async_Line_Error( VAR Error_Flags: BYTE ) : BOOLEAN;
FUNCTION  Async_Ring_Detect : BOOLEAN;
PROCEDURE Async_Send_Break;
PROCEDURE Async_Send_String( S : AnyStr );
PROCEDURE Async_Send_String_With_Delays( S          : AnyStr;
                                         Char_Delay : INTEGER;
                                         EOS_Delay  : INTEGER  );
FUNCTION  Async_Percentage_Used : REAL;
PROCEDURE Async_Purge_Buffer;
FUNCTION  Async_Peek( Nchars : INTEGER ) : CHAR;
PROCEDURE Async_Setup_Port( ComPort       : INTEGER;
                            Base_Address  : INTEGER;
                            IRQ_Line      : INTEGER;
                            Int_Numb      : INTEGER );
PROCEDURE Async_Release_Buffers;
PROCEDURE Async_Flush_Output_Buffer;
PROCEDURE Async_Drain_Output_Buffer( Max_Wait_Time : INTEGER );
FUNCTION  Async_Port_Address_Given( Com_Port : INTEGER ) : BOOLEAN;
PROCEDURE Async_Send_Now( C : Char );
FUNCTION  Async_Wait_For_Quiet( Max_Wait : LONGINT;
                                Wait_Time: LONGINT  ) : BOOLEAN;
PROCEDURE Async_Set_Rejection( Reject_Bad : BOOLEAN; Reject_Char : CHAR );

IMPLEMENTATION
                                   (* Remove blank before $ in next *)
                                   (* statement to get multitasking *)
                                   (* defined.                      *)
{ $DEFINE MTASK }

(*$I PIBASYN1.MOD *)
(*$I PIBASYN2.MOD *)
(*$I PIBASYN3.MOD *)

BEGIN (* PibAsync *)
                                   (* Default communications parameters *)
   Async_Do_CTS         := FALSE;
   Async_Do_DSR         := FALSE;
   Async_Hard_Wired_On  := FALSE;
   Async_Break_Length   := 500;
   Async_Do_XonXoff     := TRUE;
   Async_OV_XonXoff     := TRUE;
   Async_Buffer_Length  := 4096;
   Async_OBuffer_Length := 1132;
   Async_Reject_Noise   := FALSE;
   Async_Noise_Char     := CHR( 0 );

                                   (* Port addresses of each com port *)

   Default_Com_Base[1]  := COM1_Base;
   Default_Com_Base[2]  := COM2_Base;
   Default_Com_Base[3]  := COM3_Base;
   Default_Com_Base[4]  := COM4_Base;

                                   (* IRQ line for each port *)

   Default_Com_Irq [1]  := COM1_Irq;
   Default_Com_Irq [2]  := COM2_Irq;
   Default_Com_Irq [3]  := COM3_Irq;
   Default_Com_Irq [4]  := COM4_Irq;

                                   (* Pick up address of send-a-character *)
                                   (* routine, which is used by INLINE    *)
                                   (* code.                               *)

   Async_Send_Addr := ADDR( Async_Send );

END   (* PibAsync *).
