{ Turbo Mouse Version 2.1 }
{ Microsoft Mouse function access routines }
{ (C) Copyright 1986,1987 John Vedral.  All Rights Reserved. }

{ This program is supplied to assist with the development of programs in
  Turbo Pascal using the Microsoft Mouse.  If you find it useful or would
  like to encourage further development of programming tools feel free to
  send a donation ($5 or more is recommended) to :

       Vedco Computer
       P.O. Box 236
       Hillsdale, NJ 07642
       (201) 664-2459

  This is one way for all of us to fight back at overpriced software. But, if
  you do happen to go commercial with a package that uses these routines feel
  free to send a larger donation and mention us in your documentation. }




type cursor_array = array[0..31] of integer;

function button_pressed(button : integer) : boolean;
  { returns true if button is down.  Button = 0 for left button and 1 
    for right button } 
Begin
  Inline
    ($B8/$03/$00/         {     MOV AX,3                                      }
     $CD/$33/             {     INT 33H                                       }
     $8B/$4E/$04/         {     MOV CX,[BP+4]                                 }
     $E3/$02/             {     JCXZ B0                                       }
     $D1/$EB/             {     SHR BX,1                                      }
     $89/$5E/$06);        { B0:MOV [BP+6],BX                                  }
End;


procedure show_cursor; 
  { makes the cursor visible } 
Begin
  Inline
    ($B8/$01/$00/         {     MOV AX,1                                      }
     $CD/$33);            {     INT 33H                                       }
End;


procedure hide_cursor; 
  { makes cursor invisible } 
Begin
  Inline
    ($B8/$02/$00/         {     MOV AX,2                                      }
     $CD/$33);            {     INT 33H                                       }
End;


function mouse_installed : boolean; 
  { return true if the mouse driver and hardware are installed.  Also 
    resets mouse to default settings. } 
Begin
  Inline
    ($B8/$00/$00/         {     MOV AX,0                                      }
     $CD/$33/             {     INT 33H                                       }
     $89/$46/$04);        {     MOV [BP+4],AX                                 }
End;


procedure get_cursor_position (var horizontal, vertical : integer); 
  { get the position of the cursor on the screen }
Begin
  Inline
    ($B8/$03/$00/         {     MOV AX,3                                      }
     $CD/$33/             {     INT 33H                                       }
     $8B/$46/$0A/         {     MOV AX,[BP+10]                                }
     $8E/$C0/             {     MOV ES,AX                                     }
     $8B/$7E/$08/         {     MOV DI,[BP+8]                                 }
     $26/$89/$0D/         {     MOV ES:[DI],CX                                }
     $8B/$46/$06/         {     MOV AX,[BP+6]                                 }
     $8E/$C0/             {     MOV ES,AX                                     }
     $8B/$7E/$04/         {     MOV DI,[BP+4]                                 }
     $26/$89/$15);        {     MOV ES:[DI],DX                                }
End;


procedure set_cursor_position (horizontal, vertical : integer); 
  { move the cursor to the specified position }
Begin
  Inline
    ($B8/$04/$00/         {     MOV AX,4                                      }
     $8B/$4E/$06/         {     MOV CX,[BP+6]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $CD/$33);            {     INT 33H                                       }
End;


procedure set_min_max_horiz(minimum, maximum : integer);
  { set the minimum and maximum horizontal position of the cursor }
Begin
  Inline
    ($B8/$07/$00/         {     MOV AX,7                                      }
     $8B/$4E/$06/         {     MOV CX,[BP+6]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $CD/$33);            {     INT 33H                                       }
End;


procedure set_min_max_vert(minimum, maximum : integer);
  { set the minimum and maximum vertical position of the cursor }
Begin
  Inline
    ($B8/$08/$00/         {     MOV AX,8                                      }
     $8B/$4E/$06/         {     MOV CX,[BP+6]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $CD/$33);            {     INT 33H                                       }
End;


procedure set_graphics_cursor (hot_spot_x, hot_spot_y : integer; 
                               var cursor : cursor_array); 
  { Pass a custom cursor to the mouse hardware.  Cursor information contained 
    in type cursor_array = array[0..31] of integer.  See examples in Microsoft
    mouse manual.  Concatenate the two arrays shown in the manual into one 
    array. } 
Begin
  Inline
    ($8B/$5E/$0A/         {     MOV BX,[BP+10]                                }
     $8B/$4E/$08/         {     MOV CX,[BP+8]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $8B/$46/$06/         {     MOV AX,[BP+6]                                 }
     $8E/$C0/             {     MOV ES,AX                                     }
     $B8/$09/$00/         {     MOV AX,9                                      }
     $CD/$33);            {     INT 33H                                       }
End;


procedure read_counters(var horizontal, vertical : integer); 
  { read the the horizontal and vertical mickey count since the last call to 
    this procedure } 
Begin
  Inline
    ($B8/$0B/$00/         {     MOV AX,11                                     }
     $CD/$33/             {     INT 33H                                       }
     $8B/$46/$0A/         {     MOV AX,[BP+10]                                }
     $8E/$C0/             {     MOV ES,AX                                     }
     $8B/$7E/$08/         {     MOV DI,[BP+8]                                 }
     $26/$89/$0D/         {     MOV ES:[DI],CX                                }
     $8B/$46/$06/         {     MOV AX,[BP+6]                                 }
     $8E/$C0/             {     MOV ES,AX                                     }
     $8B/$7E/$04/         {     MOV DI,[BP+4]                                 }
     $26/$89/$15);        {     MOV ES:[DI],DX                                }
End;


procedure user_subroutine(mask,subroutine_segment,subroutine_offset : integer); 
  { allows a branch to the specified subroutine according to the conditions
    specified in the call mask.  See the Microsoft mouse manual for details } 
Begin
  Inline
    ($8B/$4E/$08/         {     MOV CX,[BP+8]                                 }
     $8B/$46/$06/         {     MOV AX,[BP+6]                                 }
     $8E/$C0/             {     MOV ES,AX                                     }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $B8/$0C/$00/         {     MOV AX,12                                     }
     $CD/$33);            {     INT 33H                                       }
End;


procedure light_pen_on; 
  { enables light pen emulation by the mouse. }
Begin
  Inline
    ($B8/$0D/$00/         {     MOV AX,13                                     }
     $CD/$33);            {     INT 33H                                       }
End;


procedure light_pen_off; 
  { disables light pen emulation by the mouse. }
Begin
  Inline
    ($B8/$0E/$00/         {     MOV AX,14                                     }
     $CD/$33);            {     INT 33H                                       }
End;


procedure set_pixel_ratio (horizontal_ratio, vertical_ratio : integer);
  { Sets the sensitivity of the mouse.  The values entered for the ratios 
    determine the number of mickeys per eight pixels.
    for example: horizontal_ratio = 8, vertical_ratio = 16 -> 8 mickeys for 8
    pixels horizontally and 16 mickeys for 8 pixels vertically. } 
Begin
  Inline
    ($B8/$0F/$00/         {     MOV AX,15                                     }
     $8B/$4E/$06/         {     MOV CX,[BP+6]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $CD/$33);            {     INT 33H                                       }
End;


function number_of_presses (button : integer) : integer; 
  { returns number of times the button has been pressed since the last call 
    to this function.  Button = 0 for left button and 1 for right button } 
Begin
  Inline
    ($B8/$05/$00/         {     MOV AX,5                                      }
     $8B/$5E/$04/         {     MOV BX,[BP+4]                                 }
     $CD/$33/             {     INT 33H                                       }
     $89/$5E/$06);        {     MOV [BP+6],BX                                 }
End;


function number_of_releases (button : integer) : integer; 
  { returns number of times the button has been released since the last call 
    to this function.  Button = 0 for left button and 1 for right button } 
Begin
  Inline
    ($B8/$06/$00/         {     MOV AX,6                                      }
     $8B/$5E/$04/         {     MOV BX,[BP+4]                                 }
     $CD/$33/             {     INT 33H                                       }
     $89/$5E/$06);        {     MOV [BP+6],BX                                 }
End;


procedure set_text_cursor (bottom_line, top_line : integer); 
  { select the text cursor and the scan lines used.  On the CGA the cursor 
    can be up to 8 scan lines high, numbered 0-7.  On the MDA, 0-11. } 
Begin
  Inline
    ($B8/$0A/$00/         {     MOV AX,10                                     }
     $BB/$01/$00/         {     MOV BX,1                                      }
     $8B/$4E/$06/         {     MOV CX,[BP+6]                                 }
     $8B/$56/$04/         {     MOV DX,[BP+4]                                 }
     $CD/$33);            {     INT 33H                                       }
End;
