{$R-,S+,I+,D+,F-,V-,B-,N-,L-}
{$M 7000,0,0 }

program convert;

uses crt,gentypes,configrt,gensubs,statret;

type ouserrec=record
       handle:mstr;
       realname:string[41];
       note:lstr;
       macro1,macro2,macro3:lstr;
       yesvote,novote,abstain:integer;
       password:sstr;
       sex:string[1];
       age:integer;
       citystate:string[34];
       country:string[20];
       zipcode:string[10];
       phonenum:string[10];
       laston:longint;
       numon,timetoday,nup,ndn,nbu,uploads,downloads:integer;
       totaltime:real;
       voted:voteset;
       udlevel,udpoints,level,emailannounce,beepedpwd,infoform1,infoform2,
       infoform3,infoform4,infoform5:integer;
       bstatuscolor,
       bordercolor,regularcolor,promptcolor,statcolor,inputcolor,displaylen:byte;
       lastmessages,lastups,lastgfiles,lastdbases,integer1:integer;
       downk,upk:longint;
       gflevel,gfuploads,gfdownloads:integer;
       menutype,byte1:byte;
       defproto,char1:char;
       hack:byte;
       config:set of configtype;
       filelister:set of filelisttype;
       newscanconfig,access1,access2:set of byte;
       timeinstorage:word;
       averagecps:integer;
       lastread:array [0..255] of word;
       newvoteyes,newvoteno:integer;
       newvoteit:array [1..255] of integer;
       defcon:array [0..5] of boolean;
     end;

type newuserrec=record
       handle:mstr;
       realname:string[41];
       note:lstr;
       macro1,macro2,macro3:lstr;
       yesvote,novote,abstain:integer;
       password:sstr;
       sex:string[1];
       age:integer;
       citystate:string[34];
       country:string[20];
       zipcode:string[10];
       phonenum:string[10];
       laston:longint;
       numon,timetoday,nup,ndn,nbu,uploads,downloads:integer;
       totaltime:real;
       voted:voteset;
       udlevel,udpoints,level,emailannounce,beepedpwd,infoform1,infoform2,
       infoform3,infoform4,infoform5:integer;
       bstatuscolor,
       bordercolor,regularcolor,promptcolor,statcolor,inputcolor,displaylen:byte;
       lastmessages,lastups,lastgfiles,lastdbases,integer1:integer;
       downk,upk:longint;
       gflevel,gfuploads,gfdownloads:integer;
       menutype,byte1:byte;
       defproto,char1:char;
       hack:byte;
       config:set of configtype;
       filelister:set of filelisttype;
       newscanconfig,access1,access2:set of byte;
       timeinstorage:word;
       averagecps:integer;
       lastread:array [0..255] of word;
       newvoteyes,newvoteno:integer;
       newvoteit:array [1..255] of integer;
       defcon:array [0..maxconf] of boolean;
     end;

var windowx1,windowy1,windowx2,windowy2,scrnwidth,midpoint:integer;
    when,shoulderase:boolean;

procedure killfile (newname:string);
var f2:file;
    x:integer;
begin
  assign (f2,newname);
  {$I-} erase (f2); {$I+}
  x:=ioresult
end;

procedure window (x1,y1,x2,y2:integer);
begin
  windowx1:=x1;
  windowy1:=y1;
  windowx2:=x2;
  windowy2:=y2;
  scrnwidth:=x2-x1+1;
  midpoint:=scrnwidth div 2;
  crt.window (x1,y1,x2,y2)
end;

procedure center (y:integer; l:string);
begin
  gotoxy (1,y);
  clreol;
  gotoxy (midpoint-length(l) div 2,y);
  write (l)
end;

procedure returntodos;
begin
  window (1,1,80,25);
  textcolor (7);
  textbackground (0);
  gotoxy (1,25);
  clreol;
  gotoxy (1,24);
  clreol;
  halt
end;

procedure topmessage (x:string; printalso:boolean);
var xx,yy:integer;
begin
  xx:=wherex;
  yy:=wherey;
  window (1,1,80,25);
  gotoxy (1,6);
  textcolor (15);
  textbackground (1);
  clreol;
  window (3,1,78,25);
  textcolor (14);
  textbackground (0);
  center (4,x);
  window (3,8,78,21);
  gotoxy (xx,yy);
  textcolor (12);
  textbackground (0);
  if printalso then writeln (^M^J,x,^M^J);
end;

procedure divider;
begin
  writeln;
  writeln ('');
end;

procedure init;
var cnt:integer;
begin
  checksnow:=true;
  textmode (CO80);
  textcolor (15);
  textbackground (1);
  window (1,1,80,25);
  for cnt:=1 to 46 do begin
    gotoxy (1,cnt div 2);         write (' ');
    gotoxy (80,cnt div 2);        write (' ');
    gotoxy (cnt,1);               write ('  ');
    gotoxy (79-cnt,1);            write ('  ');
    gotoxy (cnt,23);              write ('  ');
    gotoxy (79-cnt,23);           write ('  ');
    delay (10);
  end;
  center (1,'FAQ User Conversion Utility');
  center (2,'Version 1.01 to Version 1.02');
  gotoxy (1,1);
  textcolor (15);
  textbackground (0);
  topmessage ('',false);
  clrscr;
end;

procedure ensureconfigexists;
var f:file;
begin
  topmessage ('Searching for SETUP.CFG',false);
  assign (f,'SETUP.CFG');
  {$I-} reset (f); {$I+}
  if ioresult<>0 then begin
    writeln ('Sorry!  I can''t seem to locate your SETUP.CFG file.');
    writeln ('This means that either:');
    writeln ('  1. You aren''t running CONVERT from your FAQ directory');
    writeln ('  2. You haven''t been using an old version and you don''t need to convert');
    writeln;
    writeln ('If you have been running an old version, please change to your');
    writeln ('FAQ directory and run this program again.');
    writeln;
    writeln ('If you haven''t been using an old version, then you don''t need this program!');
    returntodos
  end;
  close (f)
end;

procedure readconfig;        { Shouldn't check version code }
var q:file of configsettype;
begin
  topmessage ('Reading SETUP.CFG',false);
  assign (q,'SETUP.CFG');
  reset (q);
  read (q,configset);
  close (q)
end;

procedure writeconfig;
var q:file of configsettype;
begin
  assign (q,'SETUP.CFG');
  rewrite (q);
  write (q,configset);
  close (q)
end;

procedure ensurenotsecondtime;
begin
  if versioncode=thisversioncode then begin
    topmessage ('WARNING!  You may have already converted',false);
    writeln ('It appears that you may have already converted.');
    writeln ('It is important that you do not try to convert twice!');
    writeln;
    write ('Are you sure you wish to convert [y/n]: ');
    if upcase(readkey)='Y'
      then writeln ('Yes')
      else returntodos
  end;
  divider
end;

procedure shouldierase;
var k:char;
begin
  topmessage ('Keep old disk files?',false);
  writeln ('In the conversion process, I ordinarily simply remove the old USERS File');
  writeln ('of FAQ various data files.  However, if you wish, I will keep');
  writeln ('the old data files, with an extension of ".OLD".');
  writeln;
  write ('Should I KEEP the old data files [y/n]: ');
  repeat
    k:=upcase(readkey)
  until k in ['Y','N'];
  shoulderase:=k='N';
  if shoulderase
    then write ('No, erase')
    else write ('Yes, keep');
  writeln (' old disk files');
  divider
end;

procedure convertuserfile;
var uf:file of userrec;
    ouf:file of ouserrec;
    ou:ouserrec;
    u:userrec;
    k:char;
    cnt,i,ii:integer;
begin
  topmessage ('Converting user list',true);
  assign (ouf,bbsdatadir+'users.dat');
  killfile (bbsdatadir+'users.old');
  {$I-} rename (ouf,bbsdatadir+'users.old'); {$I+}
  if ioresult<>0 then begin
    writeln ('I can''t find the user list!');
    writeln ('Press any key to continue...');
    k:=readkey;
    divider;
    exit
  end;
  reset (ouf);
  assign (uf,bbsdatadir+'users.dat');
  rewrite (uf);
  cnt:=0;
  while not eof(ouf) do begin
    read (ouf,ou);
    with u do begin
       handle:=ou.handle;
       realname:=ou.realname;
       note:=ou.note;
       macro1:=ou.macro1;
       macro2:=ou.macro2;
       macro3:=ou.macro3;
       yesvote:=ou.yesvote;
       novote:=ou.novote;
       abstain:=ou.abstain;
       password:=ou.password;
       sex:=ou.sex;
       age:=ou.age;
       citystate:=ou.citystate;
       country:=ou.country;
       zipcode:=ou.zipcode;
       phonenum:=ou.phonenum;
       laston:=ou.laston;
       numon:=ou.numon;
       timetoday:=ou.timetoday;
       nup:=ou.nup;
       ndn:=ou.ndn;
       nbu:=ou.nbu;
       uploads:=ou.uploads;
       downloads:=ou.downloads;
       totaltime:=ou.totaltime;
       voted:=ou.voted;
       udlevel:=ou.udlevel;
       udpoints:=ou.udpoints;
       level:=ou.level;
       emailannounce:=ou.emailannounce;
       beepedpwd:=ou.beepedpwd;
       infoform1:=ou.infoform1;
       infoform2:=ou.infoform2;
       infoform3:=ou.infoform3;
       infoform4:=ou.infoform4;
       infoform5:=ou.infoform5;
       bstatuscolor:=ou.bstatuscolor;
       bordercolor:=ou.bordercolor;
       regularcolor:=ou.regularcolor;
       promptcolor:=ou.promptcolor;
       statcolor:=ou.statcolor;
       inputcolor:=ou.inputcolor;
       displaylen:=ou.displaylen;
       lastmessages:=ou.lastmessages;
       lastups:=ou.lastups;
       lastgfiles:=ou.lastgfiles;
       lastdbases:=ou.lastdbases;
       integer1:=ou.integer1;
       downk:=ou.downk;
       upk:=ou.upk;
       gflevel:=ou.gflevel;
       gfuploads:=ou.gfuploads;
       gfdownloads:=ou.gfdownloads;
       menutype:=ou.menutype;
       byte1:=ou.byte1;
       defproto:=ou.defproto;
       char1:=ou.char1;
       hack:=ou.hack;
       config:=ou.config;
       filelister:=ou.filelister;
       newscanconfig:=ou.newscanconfig;
       access1:=ou.access1;
       access2:=ou.access2;
       timeinstorage:=ou.timeinstorage;
       averagecps:=ou.averagecps;
       for i:=1 to 255 do
       lastread[i]:=ou.lastread[i];
       newvoteyes:=ou.newvoteyes;
       newvoteno:=ou.newvoteno;
       for ii:=1 to 255 do
       newvoteit[ii]:=ou.newvoteit[ii];
       for i:=1 to 5 do begin
       defcon[i]:=ou.defcon[i];
       defcon[i+5]:=false;
       end;
    end;
    write (uf,u);
    cnt:=cnt+1;
    if (cnt mod 10)=0 then write (cnt,'...  ')
  end;
  writeln ('Done!');
  close (uf);
  close (ouf);
  if shoulderase then erase (ouf);
  divider
end;

procedure alldone;
begin
  topmessage ('Conversion is complete!',true);
  returntodos
end;

begin
  {init;
  readstatus;}
  clrscr;
  readconfig;
  ensurenotsecondtime;
  shouldierase;
  convertuserfile;
  alldone
end.
