
#include <ezylib.h>
#include <ezycom.h>
#include <string.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <share.h>
#include <dir.h>

char *SystemPath = NULL;
char *MsgPath = NULL;
char *UserBasePath = NULL;
char *MaintLog = NULL;
int  Node;
ConfigRecord   Config;
ConstantRecord Constant;

char *GetSystemPath()
{
  char SPath[MAXDIR];
  char *SysPath;
  SysPath = getenv("EZY");
  if (SysPath) {
    strcpy(SPath,SysPath);
  } else {
    getcwd(SPath,MAXDIR);
  }
  AppendBackslash(SPath);
  SystemPath = strdup(SPath);
  return(SystemPath);
}

char *GetMinusSlashParam(char *StrToFind,char *Result)
{
	char TempString[80];
	sprintf(TempString,"-%s",StrToFind);
	if (!*GetParam(TempString,Result)) {
		sprintf(TempString,"/%s",StrToFind);
		GetParam(TempString,Result);
	}
	return(Result);
}

int FindMinusSlashParam(char *StrToFind)
{
  int Found = 1;
  char TempString[80];
	sprintf(TempString,"-%s",StrToFind);
	if (!FindParam(TempString)) {
		sprintf(TempString,"/%s",StrToFind);
		Found = FindParam(TempString);
	}
	return(Found);
}

char *FindDataFilePath(char *Filename,char *Result)
{
	sprintf(Result,"%s%s.%d",SystemPath,Filename,Node);
	if (!ExistFile(Result)) {
  	sprintf(Result,"%s.EZY",Filename);
    if (!ExistFile(Result)) {
			sprintf(Result,"%s%s.EZY",SystemPath,Filename,Node);
			if (!ExistFile(Result)) {
    		*Result = '\0';
			};
    }
  };
	return(Result);
}

int InitEzycom(char *FailReason,char *ExeCode)
{
  *FailReason = '\0';
  GetSystemPath();

  // Get the Node
  {
    Node = 1;
    char NodeNumber[80];
    char *TaskNumber;
    TaskNumber = getenv("TASK");
    if (TaskNumber) {
      Node = atoi(TaskNumber);
    }
    if (*GetMinusSlashParam("NODE",NodeNumber)) {
      Node = atoi(NodeNumber);
    }
    if ((Node < 1) || (Node > 999))
      Node = 1;
  }
  {
    char ConfigPath[MAXPATH];
    FindDataFilePath("CONFIG",ConfigPath);
    if (*ConfigPath) {
      FILE *hConfig;
      if ((hConfig = _fsopen(ConfigPath,"rb",SH_DENYNO)) != NULL) {
        int NumRead = fread(&Config,sizeof(Config),1,hConfig);
        if (NumRead != 1) {
          sprintf(FailReason,"%s reading %s",sys_errlist[errno],ConfigPath);
        } else {
          pPasToC(Config.MsgPath,MsgPath);
          pPasToC(Config.UserBasePath,UserBasePath);
          char Maint[MAXPATH], NodeS[4];
          sprintf(NodeS,"%d",Node);
          PasToC(Config.FileMaint,Maint);
          if (ExeCode)
            ReplaceStr(Maint,"*T",ExeCode);
          MaintLog = strdup(ReplaceStr(Maint,"*N",NodeS));
        }
        fclose(hConfig);
      } else {
        sprintf(FailReason,"%s opening %s",sys_errlist[errno],ConfigPath);
      }
    } else {
      strcpy(FailReason,"CONFIG.EZY not found");
    }
  }
  {
    char ConstantPath[MAXPATH];
    sprintf(ConstantPath,"%sCONSTANT.EZY",SystemPath);
    if (*ConstantPath) {
      FILE *hConstant;
      if ((hConstant = _fsopen(ConstantPath,"rb",SH_DENYNO)) != NULL) {
        int NumRead = fread(&Constant,sizeof(Constant),1,hConstant);
        if (NumRead != 1) {
		      sprintf(FailReason,"%s reading %s",sys_errlist[errno],ConstantPath);
        }
	   	  fclose(hConstant);
  		} else {
	  		sprintf(FailReason,"%s opening %s",sys_errlist[errno],ConstantPath);
  		}
		} else {
  		strcpy(FailReason,"CONSTANT.EZY not found");
  	}
  }
  return(!(*FailReason));
}

