#include <ezycom.h>
#include <ezylib.h>

/**********************************************************
 * Convert a Date and Time to a Long (DOS Packed DateTime)
 *
 * Returns the converted date on success or 0 on failure.
 *
 * eg: longdate = date2word(1992,1,1,12,53,50);
 **********************************************************/
unsigned long Date2Long(word year, word month, word day,
                        word hour, word min,   word sec)
{
    unsigned long  todatefield,totimefield;

    if (!CheckDate(year,month,day) || year < 1980 || year > 2107) return(0);

    todatefield = day;
	 todatefield = todatefield + ((month) << 5);
	 todatefield = todatefield + ((year-1980) << 9);

	 totimefield = (sec >> 1) + (min << 5) + (hour << 12);

	 totimefield = totimefield + (todatefield << 16);

	 return(totimefield);
}
